/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.graphicsDescription.yoGraphics;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.yoGraphics.RemoteYoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicCoordinateSystem;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicCylinder;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicLineSegment;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPolygon;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPolynomial3D;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPosition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicReferenceFrame;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicTriangle;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicVector;
import us.ihmc.graphicsDescription.yoGraphics.plotting.YoArtifactLineSegment2d;
import us.ihmc.graphicsDescription.yoGraphics.plotting.YoArtifactOval;
import us.ihmc.graphicsDescription.yoGraphics.plotting.YoArtifactPolygon;
import us.ihmc.graphicsDescription.yoGraphics.plotting.YoArtifactPosition;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameConvexPolygon2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameLineSegment2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint2D;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;
import us.ihmc.yoVariables.variable.YoVariable;

public class RemoteYoGraphicFactory {
    private final List<Class<? extends RemoteYoGraphic>> classList = new ArrayList<Class<? extends RemoteYoGraphic>>();
    private final TObjectIntMap<Class<? extends RemoteYoGraphic>> registrationIDs = new TObjectIntHashMap();
    private final TIntObjectMap<Class<? extends RemoteYoGraphic>> registrationClasses = new TIntObjectHashMap();
    private final TIntObjectMap<YoGraphicFromMessageBuilder<?>> registrationBuilders = new TIntObjectHashMap();

    public RemoteYoGraphicFactory() {
        this.registerBuilder(YoGraphicCylinder.class, (name, vars, consts, appearance) -> RemoteYoGraphicFactory.yoGraphicCylinderFromMessage(name, vars, consts, appearance), new int[0]);
        this.registerBuilder(YoGraphicTriangle.class, (name, vars, consts, appearance) -> RemoteYoGraphicFactory.yoGraphicTriangleFromMessage(name, vars, consts, appearance), new int[0]);
        this.registerBuilder(YoGraphicVector.class, (name, vars, consts, appearance) -> RemoteYoGraphicFactory.yoGraphicVectorFromMessage(name, vars, consts, appearance), new int[0]);
        this.registerBuilder(YoGraphicPosition.class, (name, vars, consts, appearance) -> RemoteYoGraphicFactory.yoGraphicPositionFromMessage(name, vars, consts, appearance), new int[0]);
        this.registerBuilder(YoGraphicCoordinateSystem.class, (name, vars, consts, appearance) -> RemoteYoGraphicFactory.yoGraphicCoordinateSystemFromMessage(name, vars, consts, appearance), new int[0]);
        this.registerBuilder(YoGraphicLineSegment.class, (name, vars, consts, appearance) -> RemoteYoGraphicFactory.yoGraphicLineSegmentFromMessage(name, vars, consts, appearance), new int[0]);
        this.registerBuilder(YoGraphicPolygon.class, (name, vars, consts, appearance) -> RemoteYoGraphicFactory.yoGraphicPolygonFromMessage(name, vars, consts, appearance), new int[0]);
        this.registerBuilder(YoArtifactPosition.class, (name, vars, consts, appearance) -> RemoteYoGraphicFactory.yoArtifactPositionFromMessage(name, vars, consts, appearance), new int[0]);
        this.registerBuilder(YoArtifactOval.class, (name, vars, consts, appearance) -> RemoteYoGraphicFactory.yoArtifactOvalFromMessage(name, vars, consts, appearance), new int[0]);
        this.registerBuilder(YoArtifactLineSegment2d.class, (name, vars, consts, appearance) -> RemoteYoGraphicFactory.yoArtifactLineSegment2DFromMessage(name, vars, consts, appearance), new int[0]);
        this.registerBuilder(YoArtifactPolygon.class, (name, vars, consts, appearance) -> RemoteYoGraphicFactory.yoArtifactPolygonFromMessage(name, vars, consts, appearance), new int[0]);
        this.registerBuilder(YoGraphicReferenceFrame.class, (name, vars, consts, appearance) -> RemoteYoGraphicFactory.yoGraphicReferenceFrameFromMessage(name, vars, consts, appearance), new int[0]);
        this.registerBuilder(YoGraphicPolynomial3D.class, (name, vars, consts, appearance) -> YoGraphicPolynomial3D.createAsRemoteYoGraphic(name, vars, consts), 1430416970);
    }

    public <T extends RemoteYoGraphic> void registerBuilder(Class<T> clazz, YoGraphicFromMessageBuilder<T> builder, int ... customIDs) {
        int id = clazz.getName().hashCode();
        if (this.registrationIDs.containsKey(clazz)) {
            throw new RuntimeException("The class: " + clazz.getSimpleName() + " has already been registered.");
        }
        this.classList.add(clazz);
        this.registrationIDs.put(clazz, id);
        this.registrationClasses.put(id, clazz);
        this.registrationBuilders.put(id, builder);
        if (customIDs != null) {
            for (int customID : customIDs) {
                if (this.registrationClasses.containsKey(customID) && this.registrationClasses.get(customID) != clazz) {
                    throw new RuntimeException("The ID " + customID + " is already used for another class.");
                }
                this.registrationClasses.put(customID, clazz);
                this.registrationBuilders.put(customID, builder);
            }
        }
    }

    public int getRegistrationID(Class<? extends RemoteYoGraphic> clazz) {
        if (!this.registrationIDs.containsKey(clazz)) {
            throw new RuntimeException("The class: " + clazz.getSimpleName() + " is not registered.");
        }
        return this.registrationIDs.get(clazz);
    }

    public RemoteYoGraphic yoGraphicFromMessage(int registrationID, String name, YoVariable[] vars, double[] consts, AppearanceDefinition appearance) {
        YoGraphicFromMessageBuilder builder = (YoGraphicFromMessageBuilder)this.registrationBuilders.get(registrationID);
        if (builder == null) {
            throw new RuntimeException("Unhandled registrion ID: " + registrationID + ", yoGraphic name: " + name);
        }
        return builder.yoGraphicFromMessage(name, vars, consts, appearance);
    }

    private static YoArtifactPolygon yoArtifactPolygonFromMessage(String name, YoVariable[] vars, double[] consts, AppearanceDefinition appearance) {
        ReferenceFrame referenceFrame = ReferenceFrame.getWorldFrame();
        int i = 0;
        YoInteger yoNumVertices = (YoInteger)vars[i++];
        ArrayList<YoFramePoint2D> yoFramePoints = new ArrayList<YoFramePoint2D>();
        while (i < vars.length) {
            yoFramePoints.add(new YoFramePoint2D((YoDouble)vars[i++], (YoDouble)vars[i++], referenceFrame));
        }
        YoFrameConvexPolygon2D convexPolygon2d = new YoFrameConvexPolygon2D(yoFramePoints, yoNumVertices, referenceFrame);
        return new YoArtifactPolygon(name, convexPolygon2d, appearance.getColor().get(), consts[0] > 0.0);
    }

    private static YoArtifactLineSegment2d yoArtifactLineSegment2DFromMessage(String name, YoVariable[] vars, double[] consts, AppearanceDefinition appearance) {
        YoFrameLineSegment2D segment = new YoFrameLineSegment2D((YoDouble)vars[0], (YoDouble)vars[1], (YoDouble)vars[2], (YoDouble)vars[3], ReferenceFrame.getWorldFrame());
        return new YoArtifactLineSegment2d(name, segment, appearance.getColor().get());
    }

    private static YoArtifactOval yoArtifactOvalFromMessage(String name, YoVariable[] vars, double[] consts, AppearanceDefinition appearance) {
        return new YoArtifactOval(name, (YoDouble)vars[0], (YoDouble)vars[1], (YoDouble)vars[2], appearance.getColor().get());
    }

    private static YoArtifactPosition yoArtifactPositionFromMessage(String name, YoVariable[] vars, double[] consts, AppearanceDefinition appearance) {
        return new YoArtifactPosition(name, (YoDouble)vars[0], (YoDouble)vars[1], YoGraphicPosition.GraphicType.values()[(int)consts[1]], appearance.getColor().get(), consts[0]);
    }

    private static YoGraphicPolygon yoGraphicPolygonFromMessage(String name, YoVariable[] vars, double[] consts, AppearanceDefinition appearance) {
        return YoGraphicPolygon.createAsRemoteYoGraphic(name, vars, consts, appearance);
    }

    private static YoGraphicLineSegment yoGraphicLineSegmentFromMessage(String name, YoVariable[] vars, double[] consts, AppearanceDefinition appearance) {
        return new YoGraphicLineSegment(name, (YoDouble)vars[0], (YoDouble)vars[1], (YoDouble)vars[2], (YoDouble)vars[3], (YoDouble)vars[4], (YoDouble)vars[5], consts[0], appearance);
    }

    private static YoGraphicCoordinateSystem yoGraphicCoordinateSystemFromMessage(String name, YoVariable[] vars, double[] consts, AppearanceDefinition appearance) {
        return YoGraphicCoordinateSystem.createAsRemoteYoGraphic(name, vars, consts);
    }

    private static YoGraphicReferenceFrame yoGraphicReferenceFrameFromMessage(String name, YoVariable[] vars, double[] consts, AppearanceDefinition appearance) {
        return YoGraphicReferenceFrame.createAsRemoteYoGraphic(name, vars, consts);
    }

    private static YoGraphicPosition yoGraphicPositionFromMessage(String name, YoVariable[] vars, double[] consts, AppearanceDefinition appearance) {
        return new YoGraphicPosition(name, (YoDouble)vars[0], (YoDouble)vars[1], (YoDouble)RemoteYoGraphicFactory.getVariableOrNull(vars, 2), consts[0], appearance, YoGraphicPosition.GraphicType.values()[(int)consts[1]]);
    }

    private static YoGraphicVector yoGraphicVectorFromMessage(String name, YoVariable[] vars, double[] consts, AppearanceDefinition appearance) {
        return new YoGraphicVector(name, (YoDouble)vars[0], (YoDouble)vars[1], (YoDouble)vars[2], (YoDouble)vars[3], (YoDouble)vars[4], (YoDouble)vars[5], consts[0], appearance, true);
    }

    private static YoGraphicTriangle yoGraphicTriangleFromMessage(String name, YoVariable[] vars, double[] consts, AppearanceDefinition appearance) {
        return new YoGraphicTriangle(name, (YoDouble)vars[0], (YoDouble)vars[1], (YoDouble)vars[2], (YoDouble)vars[3], (YoDouble)vars[4], (YoDouble)vars[5], (YoDouble)vars[6], (YoDouble)vars[7], (YoDouble)vars[8], appearance);
    }

    private static YoGraphicCylinder yoGraphicCylinderFromMessage(String name, YoVariable[] vars, double[] consts, AppearanceDefinition appearance) {
        return new YoGraphicCylinder(name, (YoDouble)vars[0], (YoDouble)vars[1], (YoDouble)vars[2], (YoDouble)vars[3], (YoDouble)vars[4], (YoDouble)vars[5], appearance, consts[0]);
    }

    private static YoVariable getVariableOrNull(YoVariable[] vars, int i) {
        if (i < vars.length) {
            return vars[i];
        }
        return null;
    }

    public static interface YoGraphicFromMessageBuilder<T extends RemoteYoGraphic> {
        public T yoGraphicFromMessage(String var1, YoVariable[] var2, double[] var3, AppearanceDefinition var4);
    }
}

