/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.graphicsDescription.plotting.artifact;

import java.awt.BasicStroke;
import java.awt.Color;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.graphicsDescription.plotting.Graphics2DAdapter;
import us.ihmc.graphicsDescription.plotting.Plotter2DAdapter;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;

public class ArcArtifact
extends Artifact {
    private static final BasicStroke STROKE = new BasicStroke(1.0f);
    private double x;
    private double y;
    private double diameter;
    private double startAngle;
    private double arcAngle;
    private final Point2D tempPoint = new Point2D();
    private final Vector2D tempRadii = new Vector2D();

    public ArcArtifact(String id, double x, double y, double diameter, double startAngle, double arcAngle) {
        super(id);
        this.setLevel(1);
        this.x = x;
        this.y = y;
        this.diameter = diameter;
        this.startAngle = startAngle;
        this.arcAngle = arcAngle;
    }

    public ArcArtifact(String string, double x2, double y2, double diameter, double startAngle, double arcAngle, Color color) {
        this(string, x2, y2, diameter, startAngle, arcAngle);
        this.setColor(color);
    }

    public void setPosition(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public void setDiameter(double diameter) {
        this.diameter = diameter;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    @Override
    public void draw(Graphics2DAdapter graphics) {
        graphics.setColor(this.color);
        graphics.setStroke(STROKE);
        this.tempPoint.set(this.x, this.y);
        this.tempRadii.set(this.diameter / 2.0, this.diameter / 2.0);
        graphics.drawArc((Point2DReadOnly)this.tempPoint, (Vector2DReadOnly)this.tempRadii, this.startAngle, this.arcAngle);
    }

    @Override
    public void drawLegend(Plotter2DAdapter graphics, Point2D origin) {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public void drawHistory(Graphics2DAdapter graphics) {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public void takeHistorySnapshot() {
        throw new RuntimeException("Not implemented!");
    }
}

