/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.graphicsDescription.plotting;

import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.Map;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Line2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.LineSegment2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.graphicsDescription.plotting.PlotterPoint2d;
import us.ihmc.graphicsDescription.plotting.PlotterVector2d;
import us.ihmc.graphicsDescription.plotting.frames.MetersReferenceFrame;
import us.ihmc.graphicsDescription.plotting.frames.PixelsReferenceFrame;
import us.ihmc.graphicsDescription.plotting.frames.PlotterReferenceFrame;
import us.ihmc.log.LogTools;

public class Plotter2DAdapter {
    private final MetersReferenceFrame metersFrame;
    private final PixelsReferenceFrame pixelsFrame;
    private final PixelsReferenceFrame screenFrame;
    private final PlotterPoint2d[] pointBin = new PlotterPoint2d[50];
    private final PlotterVector2d[] vectorBin = new PlotterVector2d[this.pointBin.length];
    private final int[][] tempPoints = new int[2][this.pointBin.length];
    private Graphics2D graphics2d;

    public Plotter2DAdapter(MetersReferenceFrame metersFrame, PixelsReferenceFrame screenFrame, PixelsReferenceFrame pixelsFrame) {
        this.metersFrame = metersFrame;
        this.screenFrame = screenFrame;
        this.pixelsFrame = pixelsFrame;
        for (int i = 0; i < this.pointBin.length; ++i) {
            this.pointBin[i] = new PlotterPoint2d(metersFrame);
            this.vectorBin[i] = new PlotterVector2d(metersFrame);
        }
    }

    public void setGraphics2d(Graphics2D graphics2d) {
        this.graphics2d = graphics2d;
        this.graphics2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    public Graphics getGraphicsContext() {
        return this.graphics2d;
    }

    private int pixelate(double continuous) {
        return (int)Math.round(continuous);
    }

    public void drawCross(PlotterReferenceFrame frame, Point2DReadOnly center, Vector2DReadOnly radii) {
        this.drawLineSegment(frame, center.getX() - radii.getX(), center.getY(), center.getX() + radii.getX(), center.getY());
        this.drawLineSegment(frame, center.getX(), center.getY() - radii.getY(), center.getX(), center.getY() + radii.getY());
    }

    public void drawCircleWithCross(PlotterReferenceFrame frame, Point2DReadOnly center, Vector2DReadOnly radii) {
        this.drawOval(frame, center, radii);
        this.drawLineSegment(frame, center.getX() - radii.getX(), center.getY(), center.getX() + radii.getX(), center.getY());
        this.drawLineSegment(frame, center.getX(), center.getY() - radii.getY(), center.getX(), center.getY() + radii.getY());
    }

    public void drawRotatedCross(PlotterReferenceFrame frame, Point2DReadOnly center, Vector2DReadOnly radii) {
        double distanceX = 0.707 * radii.getX();
        double distanceY = 0.707 * radii.getY();
        this.drawLineSegment(frame, center.getX() - distanceX, center.getY() - distanceY, center.getX() + distanceX, center.getY() + distanceY);
        this.drawLineSegment(frame, center.getX() - distanceX, center.getY() + distanceY, center.getX() + distanceX, center.getY() - distanceY);
    }

    public void drawCircleWithRotatedCross(PlotterReferenceFrame frame, Point2DReadOnly center, Vector2DReadOnly radii) {
        double distanceX = 0.707 * radii.getX();
        double distanceY = 0.707 * radii.getY();
        this.drawOval(frame, center, radii);
        this.drawLineSegment(frame, center.getX() - distanceX, center.getY() - distanceY, center.getX() + distanceX, center.getY() + distanceY);
        this.drawLineSegment(frame, center.getX() - distanceX, center.getY() + distanceY, center.getX() + distanceX, center.getY() - distanceY);
    }

    public void drawDiamond(PlotterReferenceFrame frame, Point2DReadOnly center, Vector2DReadOnly radii) {
        this.drawLineSegment(frame, center.getX() - radii.getX(), center.getY(), center.getX(), center.getY() + radii.getY());
        this.drawLineSegment(frame, center.getX() - radii.getX(), center.getY(), center.getX(), center.getY() - radii.getY());
        this.drawLineSegment(frame, center.getX(), center.getY() + radii.getY(), center.getX() + radii.getX(), center.getY());
        this.drawLineSegment(frame, center.getX(), center.getY() - radii.getY(), center.getX() + radii.getX(), center.getY());
    }

    public void drawDiamondWithCross(PlotterReferenceFrame frame, Point2DReadOnly center, Vector2DReadOnly radii) {
        this.drawLineSegment(frame, center.getX() - radii.getX(), center.getY(), center.getX(), center.getY() + radii.getY());
        this.drawLineSegment(frame, center.getX() - radii.getX(), center.getY(), center.getX(), center.getY() - radii.getY());
        this.drawLineSegment(frame, center.getX(), center.getY() + radii.getY(), center.getX() + radii.getX(), center.getY());
        this.drawLineSegment(frame, center.getX(), center.getY() - radii.getY(), center.getX() + radii.getX(), center.getY());
        this.drawLineSegment(frame, center.getX() - radii.getX(), center.getY(), center.getX() + radii.getX(), center.getY());
        this.drawLineSegment(frame, center.getX(), center.getY() - radii.getY(), center.getX(), center.getY() + radii.getY());
    }

    public void drawSquareWithCross(PlotterReferenceFrame frame, Point2DReadOnly center, Vector2DReadOnly radii) {
        this.drawRectangle(frame, center, radii);
        this.drawLineSegment(frame, center.getX() - radii.getX(), center.getY(), center.getX() + radii.getX(), center.getY());
        this.drawLineSegment(frame, center.getX(), center.getY() - radii.getY(), center.getX(), center.getY() + radii.getY());
    }

    public void drawRectangle(PlotterReferenceFrame frame, Point2DReadOnly center, Vector2DReadOnly radii) {
        PlotterPoint2d centerFramePoint = this.pointBin[0];
        PlotterVector2d radiiFrameVector = this.vectorBin[0];
        centerFramePoint.setIncludingFrame(frame, (Tuple2DReadOnly)center);
        radiiFrameVector.setIncludingFrame(frame, radii.getX(), radii.getY());
        centerFramePoint.changeFrame(this.screenFrame);
        radiiFrameVector.changeFrame(this.screenFrame);
        radiiFrameVector.set(Math.abs(radiiFrameVector.getX()), Math.abs(radiiFrameVector.getY()));
        centerFramePoint.sub((FrameTuple2DReadOnly)radiiFrameVector);
        this.drawRectangle(this.pixelate(centerFramePoint.getX()), this.pixelate(centerFramePoint.getY()), this.pixelate(2.0 * radiiFrameVector.getX()), this.pixelate(2.0 * radiiFrameVector.getY()));
    }

    public void drawRectangle(PlotterReferenceFrame frame, double x, double y, double width, double height) {
        PlotterPoint2d position = this.pointBin[0];
        PlotterVector2d dimensions = this.vectorBin[0];
        position.setIncludingFrame(frame, x, y);
        dimensions.setIncludingFrame(frame, Math.abs(width), Math.abs(height));
        position.changeFrame(this.screenFrame);
        dimensions.changeFrame(this.screenFrame);
        this.drawRectangle(this.pixelate(position.getX()), this.pixelate(position.getY()), this.pixelate(dimensions.getX()), this.pixelate(dimensions.getY()));
    }

    public void drawSquareFilled(PlotterReferenceFrame frame, Point2DReadOnly center, Vector2DReadOnly radii) {
        PlotterPoint2d centerFramePoint = this.pointBin[0];
        PlotterVector2d radiiFrameVector = this.vectorBin[0];
        centerFramePoint.setIncludingFrame(frame, (Tuple2DReadOnly)center);
        radiiFrameVector.setIncludingFrame(frame, radii.getX(), radii.getY());
        centerFramePoint.changeFrame(this.screenFrame);
        radiiFrameVector.changeFrame(this.screenFrame);
        radiiFrameVector.set(Math.abs(radiiFrameVector.getX()), Math.abs(radiiFrameVector.getY()));
        centerFramePoint.sub((FrameTuple2DReadOnly)radiiFrameVector);
        this.drawRectangleFilled(this.pixelate(centerFramePoint.getX()), this.pixelate(centerFramePoint.getY()), this.pixelate(2.0 * radiiFrameVector.getX()), this.pixelate(2.0 * radiiFrameVector.getY()));
    }

    public void drawOval(PlotterReferenceFrame frame, Point2DReadOnly center, Vector2DReadOnly radii) {
        PlotterPoint2d centerFramePoint = this.pointBin[0];
        PlotterVector2d radiiFrameVector = this.vectorBin[0];
        centerFramePoint.setIncludingFrame(frame, (Tuple2DReadOnly)center);
        radiiFrameVector.setIncludingFrame(frame, radii.getX(), radii.getY());
        centerFramePoint.changeFrame(this.screenFrame);
        radiiFrameVector.changeFrame(this.screenFrame);
        radiiFrameVector.set(Math.abs(radiiFrameVector.getX()), Math.abs(radiiFrameVector.getY()));
        centerFramePoint.sub((FrameTuple2DReadOnly)radiiFrameVector);
        this.drawOval(this.pixelate(centerFramePoint.getX()), this.pixelate(centerFramePoint.getY()), this.pixelate(2.0 * radiiFrameVector.getX()), this.pixelate(2.0 * radiiFrameVector.getY()));
    }

    public void drawOvalFilled(PlotterReferenceFrame frame, Point2DReadOnly center, Vector2DReadOnly radii) {
        PlotterPoint2d centerFramePoint = this.pointBin[0];
        PlotterVector2d radiiFrameVector = this.vectorBin[0];
        centerFramePoint.setIncludingFrame(frame, (Tuple2DReadOnly)center);
        radiiFrameVector.setIncludingFrame(frame, radii.getX(), radii.getY());
        centerFramePoint.changeFrame(this.screenFrame);
        radiiFrameVector.changeFrame(this.screenFrame);
        radiiFrameVector.set(Math.abs(radiiFrameVector.getX()), Math.abs(radiiFrameVector.getY()));
        centerFramePoint.sub((FrameTuple2DReadOnly)radiiFrameVector);
        this.drawOvalFilled(this.pixelate(centerFramePoint.getX()), this.pixelate(centerFramePoint.getY()), this.pixelate(2.0 * radiiFrameVector.getX()), this.pixelate(2.0 * radiiFrameVector.getY()));
    }

    public void drawLineSegment(PlotterReferenceFrame frame, LineSegment2DReadOnly lineSegment) {
        PlotterPoint2d firstEndpoint = this.pointBin[0];
        PlotterPoint2d secondEndpoint = this.pointBin[1];
        firstEndpoint.setIncludingFrame(frame, (Tuple2DReadOnly)lineSegment.getFirstEndpoint());
        secondEndpoint.setIncludingFrame(frame, (Tuple2DReadOnly)lineSegment.getSecondEndpoint());
        firstEndpoint.changeFrame(this.screenFrame);
        secondEndpoint.changeFrame(this.screenFrame);
        this.drawLineSegment(this.pixelate(firstEndpoint.getX()), this.pixelate(firstEndpoint.getY()), this.pixelate(secondEndpoint.getX()), this.pixelate(secondEndpoint.getY()));
    }

    public void drawLineSegment(PlotterReferenceFrame frame, double firstPointX, double firstPointY, double secondPointX, double secondPointY) {
        PlotterPoint2d firstEndpoint = this.pointBin[0];
        PlotterPoint2d secondEndpoint = this.pointBin[1];
        firstEndpoint.setIncludingFrame(frame, firstPointX, firstPointY);
        secondEndpoint.setIncludingFrame(frame, secondPointX, secondPointY);
        firstEndpoint.changeFrame(this.screenFrame);
        secondEndpoint.changeFrame(this.screenFrame);
        this.drawLineSegment(this.pixelate(firstEndpoint.getX()), this.pixelate(firstEndpoint.getY()), this.pixelate(secondEndpoint.getX()), this.pixelate(secondEndpoint.getY()));
    }

    public void drawPoint(PlotterReferenceFrame frame, Point2DReadOnly point) {
        PlotterPoint2d plotterPoint = this.pointBin[0];
        plotterPoint.setIncludingFrame(frame, (Tuple2DReadOnly)point);
        plotterPoint.changeFrame(this.screenFrame);
        this.drawLineSegment(this.pixelate(plotterPoint.getX()), this.pixelate(plotterPoint.getY()), this.pixelate(plotterPoint.getX()), this.pixelate(plotterPoint.getY()));
    }

    public void drawLine(PlotterReferenceFrame frame, Line2DReadOnly line) {
        PlotterPoint2d start = this.pointBin[0];
        PlotterVector2d direction = this.vectorBin[0];
        start.setIncludingFrame(frame, (Tuple2DReadOnly)line.getPoint());
        direction.setIncludingFrame(frame, (Tuple2DReadOnly)line.getDirection());
        start.changeFrame(this.screenFrame);
        direction.changeFrame(this.screenFrame);
        direction.normalize();
        PlotterPoint2d farPointPositive = this.pointBin[1];
        PlotterPoint2d farPointNegative = this.pointBin[2];
        PlotterVector2d far = this.vectorBin[1];
        far.setIncludingFrame((FrameTuple2DReadOnly)direction);
        far.scale(10000.0);
        farPointPositive.setIncludingFrame((FrameTuple2DReadOnly)start);
        farPointNegative.setIncludingFrame((FrameTuple2DReadOnly)start);
        farPointPositive.add((FrameTuple2DReadOnly)far);
        farPointNegative.sub((FrameTuple2DReadOnly)far);
        this.drawLineSegment(this.pixelate(farPointNegative.getX()), this.pixelate(farPointNegative.getY()), this.pixelate(farPointPositive.getX()), this.pixelate(farPointPositive.getY()));
    }

    public void drawPolygonFilled(PlotterReferenceFrame frame, ConvexPolygon2DReadOnly convexPolygon2d) {
        if (this.setupForDrawPolygon(frame, convexPolygon2d)) {
            this.drawPolygonFilled(this.tempPoints[0], this.tempPoints[1], convexPolygon2d.getNumberOfVertices());
        }
    }

    public void drawPolygon(PlotterReferenceFrame frame, ConvexPolygon2DReadOnly convexPolygon2d) {
        if (this.setupForDrawPolygon(frame, convexPolygon2d)) {
            this.drawPolygon(this.tempPoints[0], this.tempPoints[1], convexPolygon2d.getNumberOfVertices());
        }
    }

    public void drawArc(PlotterReferenceFrame frame, Point2DReadOnly center, Vector2DReadOnly radii, double startAngle, double arcAngle) {
        PlotterPoint2d plotCenter = this.pointBin[0];
        PlotterVector2d plotRadii = this.vectorBin[0];
        plotCenter.setIncludingFrame(frame, (Tuple2DReadOnly)center);
        plotRadii.setIncludingFrame(frame, (Tuple2DReadOnly)radii);
        plotCenter.changeFrame(this.screenFrame);
        plotRadii.changeFrame(this.screenFrame);
        this.graphics2d.drawArc(this.pixelate(plotCenter.getX()), this.pixelate(plotCenter.getY()), this.pixelate(2.0 * plotRadii.getX()), this.pixelate(2.0 * plotRadii.getY()), this.pixelate(Math.toDegrees(startAngle)), this.pixelate(Math.toDegrees(arcAngle)));
    }

    public void drawString(PlotterReferenceFrame frame, String string, Point2DReadOnly startPoint) {
        PlotterPoint2d plotStart = this.pointBin[0];
        plotStart.setIncludingFrame(frame, (Tuple2DReadOnly)startPoint);
        plotStart.changeFrame(this.screenFrame);
        this.drawString(string, this.pixelate(plotStart.getX()), this.pixelate(plotStart.getY()));
    }

    private boolean setupForDrawPolygon(PlotterReferenceFrame frame, ConvexPolygon2DReadOnly convexPolygon2d) {
        for (int i = 0; i < convexPolygon2d.getNumberOfVertices(); ++i) {
            if (i == this.pointBin.length) {
                LogTools.warn((String)("You are attempting to draw a polygon with too many points: " + convexPolygon2d.getNumberOfVertices() + " points but graphics only allows " + this.pointBin.length));
                return false;
            }
            this.pointBin[i].setIncludingFrame(frame, (Tuple2DReadOnly)convexPolygon2d.getVertex(i));
            this.pointBin[i].changeFrame(this.screenFrame);
            this.tempPoints[0][i] = this.pixelate(this.pointBin[i].getX());
            this.tempPoints[1][i] = this.pixelate(this.pointBin[i].getY());
        }
        return true;
    }

    public void drawString(String string, PlotterPoint2d startPoint) {
        startPoint.changeFrame(this.screenFrame);
        this.drawString(string, this.pixelate(startPoint.getX()), this.pixelate(startPoint.getY()));
    }

    public void drawImage(Image image, PlotterPoint2d firstCornerDestination, PlotterPoint2d secondCornerDesination, PlotterPoint2d firstCornerSource, PlotterPoint2d secondCornerSource, ImageObserver observer) {
        firstCornerDestination.changeFrame(this.screenFrame);
        secondCornerDesination.changeFrame(this.screenFrame);
        firstCornerSource.changeFrame(this.screenFrame);
        secondCornerSource.changeFrame(this.screenFrame);
        this.drawImage(image, this.pixelate(firstCornerDestination.getX()), this.pixelate(firstCornerDestination.getY()), this.pixelate(secondCornerDesination.getX()), this.pixelate(secondCornerDesination.getY()), this.pixelate(firstCornerSource.getX()), this.pixelate(firstCornerSource.getY()), this.pixelate(secondCornerSource.getX()), this.pixelate(secondCornerSource.getY()), observer);
    }

    private void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        this.graphics2d.drawPolyline(xPoints, yPoints, nPoints);
    }

    private void drawLineSegment(int x1, int y1, int x2, int y2) {
        this.graphics2d.drawLine(x1, y1, x2, y2);
    }

    private void drawOval(int x, int y, int width, int height) {
        this.graphics2d.drawOval(x, y, width, height);
    }

    private void drawOvalFilled(int x, int y, int width, int height) {
        this.graphics2d.fillOval(x, y, width, height);
    }

    private void drawRectangle(int x, int y, int width, int height) {
        this.graphics2d.drawRect(x, y, width, height);
    }

    private void drawRectangleFilled(int x, int y, int width, int height) {
        this.graphics2d.fillRect(x, y, width, height);
    }

    private void drawRectangle3D(int x, int y, int width, int height, boolean raised) {
        this.graphics2d.draw3DRect(x, y, width, height, raised);
    }

    private void drawRectangle3DFilled(int x, int y, int width, int height, boolean raised) {
        this.graphics2d.fill3DRect(x, y, width, height, raised);
    }

    private void drawRectangleRounded(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.graphics2d.drawRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    private void drawRectangleRoundedFilled(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.graphics2d.fillRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    private void drawPolygonFilled(int[] xPoints, int[] yPoints, int nPoints) {
        this.graphics2d.fillPolygon(xPoints, yPoints, nPoints);
    }

    private void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.graphics2d.drawPolygon(xPoints, yPoints, nPoints);
    }

    private void drawPolygonFilled(Polygon p) {
        this.graphics2d.fillPolygon(p);
    }

    private void drawPolygon(Polygon p) {
        this.graphics2d.drawPolygon(p);
    }

    private void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.graphics2d.drawArc(x, y, width, height, startAngle, arcAngle);
    }

    private void drawArcFilled(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.graphics2d.fillArc(x, y, width, height, startAngle, arcAngle);
    }

    private void drawString(String str, int x, int y) {
        this.graphics2d.drawString(str, x, y);
    }

    private void drawString(String str, float x, float y) {
        this.graphics2d.drawString(str, x, y);
    }

    private void drawString(AttributedCharacterIterator iterator, int x, int y) {
        this.graphics2d.drawString(iterator, x, y);
    }

    private void drawString(AttributedCharacterIterator iterator, float x, float y) {
        this.graphics2d.drawString(iterator, x, y);
    }

    private void drawGlyphVector(GlyphVector g, float x, float y) {
        this.graphics2d.drawGlyphVector(g, x, y);
    }

    private void drawBytes(byte[] data, int offset, int length, int x, int y) {
        this.graphics2d.drawBytes(data, offset, length, x, y);
    }

    private void drawChars(char[] data, int offset, int length, int x, int y) {
        this.graphics2d.drawChars(data, offset, length, x, y);
    }

    private void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        this.graphics2d.drawRenderedImage(img, xform);
    }

    private void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        this.graphics2d.drawRenderableImage(img, xform);
    }

    private boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        return this.graphics2d.drawImage(img, xform, obs);
    }

    private void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        this.graphics2d.drawImage(img, op, x, y);
    }

    private boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return this.graphics2d.drawImage(img, x, y, observer);
    }

    private boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        return this.graphics2d.drawImage(img, x, y, bgcolor, observer);
    }

    private boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        return this.graphics2d.drawImage(img, x, y, width, height, observer);
    }

    private boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        return this.graphics2d.drawImage(img, x, y, width, height, bgcolor, observer);
    }

    private boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return this.graphics2d.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
    }

    private boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        return this.graphics2d.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, bgcolor, observer);
    }

    public Graphics create() {
        return this.graphics2d.create();
    }

    public Color getColor() {
        return this.graphics2d.getColor();
    }

    public void setColor(Color c) {
        this.graphics2d.setColor(c);
    }

    public void setPaintMode() {
        this.graphics2d.setPaintMode();
    }

    public void setXORMode(Color c1) {
        this.graphics2d.setXORMode(c1);
    }

    public Font getFont() {
        return this.graphics2d.getFont();
    }

    public void setFont(Font font) {
        this.graphics2d.setFont(font);
    }

    public FontMetrics getFontMetrics() {
        return this.graphics2d.getFontMetrics();
    }

    public FontMetrics getFontMetrics(Font f) {
        return this.graphics2d.getFontMetrics(f);
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return this.graphics2d.getDeviceConfiguration();
    }

    public void setComposite(Composite comp) {
        this.graphics2d.setComposite(comp);
    }

    public void setPaint(Paint paint) {
        this.graphics2d.setPaint(paint);
    }

    public void setStroke(Stroke s) {
        this.graphics2d.setStroke(s);
    }

    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        this.graphics2d.setRenderingHint(hintKey, hintValue);
    }

    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return this.graphics2d.getRenderingHint(hintKey);
    }

    public void setRenderingHints(Map<?, ?> hints) {
        this.graphics2d.setRenderingHints(hints);
    }

    public void addRenderingHints(Map<?, ?> hints) {
        this.graphics2d.addRenderingHints(hints);
    }

    public RenderingHints getRenderingHints() {
        return this.graphics2d.getRenderingHints();
    }

    public Paint getPaint() {
        return this.graphics2d.getPaint();
    }

    public Composite getComposite() {
        return this.graphics2d.getComposite();
    }

    public void setBackground(Color color) {
        this.graphics2d.setBackground(color);
    }

    public Color getBackground() {
        return this.graphics2d.getBackground();
    }

    public Stroke getStroke() {
        return this.graphics2d.getStroke();
    }

    public FontRenderContext getFontRenderContext() {
        return this.graphics2d.getFontRenderContext();
    }

    public void dispose() {
        this.graphics2d.dispose();
    }

    public PlotterReferenceFrame getMetersFrame() {
        return this.metersFrame;
    }

    public PlotterReferenceFrame getPixelsFrame() {
        return this.pixelsFrame;
    }

    public PlotterReferenceFrame getScreenFrame() {
        return this.screenFrame;
    }
}

