/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.graphicsDescription;

import java.util.List;
import java.util.stream.Collectors;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.graphicsDescription.MeshDataGenerator;
import us.ihmc.graphicsDescription.MeshDataHolder;
import us.ihmc.graphicsDescription.ModifiableMeshDataHolder;

public class MeshDataBuilder {
    private static final int DEFAULT_RES = 32;
    private final ModifiableMeshDataHolder meshDataHolder = new ModifiableMeshDataHolder();

    public MeshDataBuilder() {
        this.clear();
    }

    public void addBox(double lx, double ly, double lz, Tuple3DReadOnly offset) {
        this.addMesh(MeshDataGenerator.Cube(lx, ly, lz, true, null), offset);
    }

    public void addBox(float lx, float ly, float lz) {
        this.addMesh(MeshDataGenerator.Cube(lx, ly, lz, true, null));
    }

    public void addBox(float lx, float ly, float lz, Tuple3DReadOnly offset) {
        this.addMesh(MeshDataGenerator.Cube(lx, ly, lz, true, null), offset);
    }

    public void addCone(double height, double radius, Tuple3DReadOnly offset) {
        this.addMesh(MeshDataGenerator.Cone(height, radius, 32), offset);
    }

    public void addCone(double height, double radius, Tuple3DReadOnly offset, Orientation3DReadOnly orientation) {
        this.addMesh(MeshDataGenerator.Cone(height, radius, 32), offset, orientation);
    }

    public void addCone(float height, float radius, Tuple3DReadOnly offset) {
        this.addMesh(MeshDataGenerator.Cone(radius, height, 32), offset);
    }

    public void addCube(double size, double xOffset, double yOffset, double zOffset) {
        this.addBox(size, size, size, (Tuple3DReadOnly)new Point3D(xOffset, yOffset, zOffset));
    }

    public void addCube(double size, Tuple3DReadOnly cubeOffset) {
        this.addBox(size, size, size, cubeOffset);
    }

    public void addCube(float size, Tuple3DReadOnly cubeOffset) {
        this.addBox(size, size, size, cubeOffset);
    }

    public void addCylinder(double height, double radius, Tuple3DReadOnly offset) {
        this.addMesh(MeshDataGenerator.Cylinder(radius, height, 32), offset);
    }

    public void addCylinder(double height, double radius, Tuple3DReadOnly offset, Orientation3DReadOnly orientation) {
        this.addMesh(MeshDataGenerator.Cylinder(radius, height, 32), offset, orientation);
    }

    public void addCylinder(float height, float radius, Tuple3DReadOnly offset) {
        this.addMesh(MeshDataGenerator.Cylinder(radius, height, 32), offset);
    }

    public void addLine(double x0, double y0, double z0, double xf, double yf, double zf, double lineWidth) {
        this.addMesh(MeshDataGenerator.Line(x0, y0, z0, xf, yf, zf, lineWidth));
    }

    public void addLine(float x0, float y0, float z0, float xf, float yf, float zf, float lineWidth) {
        this.addMesh(MeshDataGenerator.Line(x0, y0, z0, xf, yf, zf, lineWidth));
    }

    public void addLine(Tuple3DReadOnly start, Tuple3DReadOnly end, double lineWidth) {
        this.addLine(start.getX(), start.getY(), start.getZ(), end.getX(), end.getY(), end.getZ(), lineWidth);
    }

    public void addLine(Tuple3DReadOnly start, Tuple3DReadOnly end, float lineWidth) {
        this.addLine(start.getX(), start.getY(), start.getZ(), end.getX(), end.getY(), end.getZ(), (double)lineWidth);
    }

    public void addMesh(MeshDataBuilder other) {
        this.meshDataHolder.add(other.meshDataHolder, true);
    }

    public void addMesh(MeshDataHolder meshDataHolder) {
        this.meshDataHolder.add(meshDataHolder, true);
    }

    public void addMesh(MeshDataHolder meshDataHolder, Tuple3DReadOnly offset) {
        this.addMesh(MeshDataHolder.translate(meshDataHolder, offset));
    }

    public void addMesh(MeshDataHolder meshDataHolder, Tuple3DReadOnly offset, Orientation3DReadOnly orientation) {
        this.addMesh(MeshDataHolder.rotate(meshDataHolder, orientation), offset);
    }

    public void addMultiLine(RigidBodyTransformReadOnly transform, List<? extends Point2DReadOnly> points, double lineWidth, boolean close) {
        List<Point3D> point3Ds = points.stream().map(Point3D::new).collect(Collectors.toList());
        point3Ds.forEach(arg_0 -> ((RigidBodyTransformReadOnly)transform).transform(arg_0));
        this.addMultiLine(point3Ds, lineWidth, close);
    }

    public void addMultiLine(List<? extends Point3DReadOnly> points, double lineWidth, boolean close) {
        if (points.size() < 2) {
            return;
        }
        for (int i = 1; i < points.size(); ++i) {
            Point3DReadOnly start = points.get(i - 1);
            Point3DReadOnly end = points.get(i);
            this.addLine((Tuple3DReadOnly)start, (Tuple3DReadOnly)end, lineWidth);
        }
        if (close) {
            Point3DReadOnly start = points.get(points.size() - 1);
            Point3DReadOnly end = points.get(0);
            this.addLine((Tuple3DReadOnly)start, (Tuple3DReadOnly)end, lineWidth);
        }
    }

    public void addMultiLine(Point3DReadOnly[] points, double lineWidth, boolean close) {
        if (points.length < 2) {
            return;
        }
        for (int i = 1; i < points.length; ++i) {
            Point3DReadOnly start = points[i - 1];
            Point3DReadOnly end = points[i];
            this.addLine((Tuple3DReadOnly)start, (Tuple3DReadOnly)end, lineWidth);
        }
        if (close) {
            Point3DReadOnly start = points[points.length - 1];
            Point3DReadOnly end = points[0];
            this.addLine((Tuple3DReadOnly)start, (Tuple3DReadOnly)end, lineWidth);
        }
    }

    public void addPolygon(RigidBodyTransformReadOnly transformToWorld, List<? extends Point2DReadOnly> polygon) {
        this.addMesh(MeshDataGenerator.Polygon(transformToWorld, polygon));
    }

    public void addPolygon(RigidBodyTransformReadOnly transformToWorld, ConvexPolygon2DReadOnly polygon) {
        this.addMesh(MeshDataGenerator.Polygon(transformToWorld, polygon));
    }

    public void addSphere(double radius, Tuple3DReadOnly offset) {
        this.addMesh(MeshDataGenerator.Sphere(radius, 32, 32), offset);
    }

    public void addSphere(float radius) {
        this.addMesh(MeshDataGenerator.Sphere(radius, 32, 32));
    }

    public void addSphere(float radius, Tuple3DReadOnly offset) {
        this.addMesh(MeshDataGenerator.Sphere(radius, 32, 32), offset);
    }

    public void addSpheres(float radius, Point3DReadOnly[] offsets) {
        for (Point3DReadOnly point : offsets) {
            this.addSphere(radius, (Tuple3DReadOnly)point);
        }
    }

    public void addTetrahedron(double edgeLength, Tuple3DReadOnly offset) {
        this.addMesh(MeshDataGenerator.Tetrahedron(edgeLength), offset);
    }

    public void addTetrahedron(float edgeLength, Tuple3DReadOnly offset) {
        this.addMesh(MeshDataGenerator.Tetrahedron(edgeLength), offset);
    }

    public void clear() {
        this.meshDataHolder.clear();
    }

    public MeshDataHolder generateMeshDataHolder() {
        return this.meshDataHolder.createMeshDataHolder();
    }
}

