/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.convexOptimization.quadraticProgram;

import gnu.trove.list.array.TIntArrayList;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.factory.LinearSolverFactory_DDRM;
import org.ejml.interfaces.linsol.LinearSolverDense;
import us.ihmc.convexOptimization.quadraticProgram.SimpleEfficientActiveSetQPSolver;
import us.ihmc.matrixlib.DiagonalMatrixTools;
import us.ihmc.matrixlib.NativeCommonOps;

public class SimpleDiagonalActiveSetQPSolver
extends SimpleEfficientActiveSetQPSolver {
    private static final double epsilon = 1.0E-10;
    private int maxNumberOfIterations = 10;
    private final DMatrixRMaj quadraticCostQMatrix = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj quadraticCostQVector = new DMatrixRMaj(0, 0);
    private double quadraticCostScalar;
    private final DMatrixRMaj linearEqualityConstraintsAMatrix = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj linearEqualityConstraintsBVector = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj linearInequalityConstraintsCMatrixO = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj linearInequalityConstraintsDVectorO = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj variableLowerBounds = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj variableUpperBounds = new DMatrixRMaj(0, 0);
    private final TIntArrayList activeInequalityIndices = new TIntArrayList();
    private final TIntArrayList activeUpperBoundIndices = new TIntArrayList();
    private final TIntArrayList activeLowerBoundIndices = new TIntArrayList();
    private final DMatrixRMaj negativeQuadraticCostQVector = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj linearInequalityConstraintsCheck = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj CBar = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj DBar = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj CHat = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj DHat = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj ATranspose = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj CBarTranspose = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj CHatTranspose = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj QInverse = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj AQInverse = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj QInverseATranspose = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj CBarQInverse = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj CHatQInverse = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj AQInverseATranspose = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj AQInverseCBarTranspose = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj AQInverseCHatTranspose = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj CBarQInverseATranspose = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj CHatQInverseATranspose = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj QInverseCBarTranspose = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj QInverseCHatTranspose = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj CBarQInverseCBarTranspose = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj CHatQInverseCHatTranspose = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj CBarQInverseCHatTranspose = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj CHatQInverseCBarTranspose = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj ATransposeAndCTranspose = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj ATransposeMuAndCTransposeLambda = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj bigMatrixForLagrangeMultiplierSolution = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj bigVectorForLagrangeMultiplierSolution = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj tempVector = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj augmentedLagrangeMultipliers = new DMatrixRMaj(0, 0);
    private final TIntArrayList inequalityIndicesToAddToActiveSet = new TIntArrayList();
    private final TIntArrayList inequalityIndicesToRemoveFromActiveSet = new TIntArrayList();
    private final TIntArrayList upperBoundIndicesToAddToActiveSet = new TIntArrayList();
    private final TIntArrayList upperBoundIndicesToRemoveFromActiveSet = new TIntArrayList();
    private final TIntArrayList lowerBoundIndicesToAddToActiveSet = new TIntArrayList();
    private final TIntArrayList lowerBoundIndicesToRemoveFromActiveSet = new TIntArrayList();
    private final DMatrixRMaj computedObjectiveFunctionValue = new DMatrixRMaj(1, 1);
    private final LinearSolverDense<DMatrixRMaj> solver = LinearSolverFactory_DDRM.linear((int)0);
    private boolean useWarmStart = false;
    private int previousNumberOfVariables = 0;
    private int previousNumberOfEqualityConstraints = 0;
    private int previousNumberOfInequalityConstraints = 0;
    private int previousNumberOfLowerBoundConstraints = 0;
    private int previousNumberOfUpperBoundConstraints = 0;
    private final DMatrixRMaj lagrangeEqualityConstraintMultipliers = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj lagrangeInequalityConstraintMultipliers = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj lagrangeLowerBoundMultipliers = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj lagrangeUpperBoundMultipliers = new DMatrixRMaj(0, 0);

    @Override
    public void setMaxNumberOfIterations(int maxNumberOfIterations) {
        this.maxNumberOfIterations = maxNumberOfIterations;
    }

    @Override
    public void clear() {
        this.quadraticCostQMatrix.reshape(0, 0);
        this.quadraticCostQVector.reshape(0, 0);
        this.linearEqualityConstraintsAMatrix.reshape(0, 0);
        this.linearEqualityConstraintsBVector.reshape(0, 0);
        this.linearInequalityConstraintsCMatrixO.reshape(0, 0);
        this.linearInequalityConstraintsDVectorO.reshape(0, 0);
        this.variableLowerBounds.reshape(0, 0);
        this.variableUpperBounds.reshape(0, 0);
    }

    @Override
    public void setVariableBounds(DMatrixRMaj variableLowerBounds, DMatrixRMaj variableUpperBounds) {
        if (variableLowerBounds.getNumRows() != this.quadraticCostQMatrix.getNumRows()) {
            throw new RuntimeException("variableLowerBounds.getNumRows() != quadraticCostQMatrix.getNumRows()");
        }
        if (variableUpperBounds.getNumRows() != this.quadraticCostQMatrix.getNumRows()) {
            throw new RuntimeException("variableUpperBounds.getNumRows() != quadraticCostQMatrix.getNumRows()");
        }
        this.variableLowerBounds.set((DMatrixD1)variableLowerBounds);
        this.variableUpperBounds.set((DMatrixD1)variableUpperBounds);
    }

    @Override
    public void setQuadraticCostFunction(DMatrixRMaj costQuadraticMatrix, DMatrixRMaj costLinearVector, double quadraticCostScalar) {
        if (costLinearVector.getNumCols() != 1) {
            throw new RuntimeException("costLinearVector.getNumCols() != 1");
        }
        if (costQuadraticMatrix.getNumRows() != costLinearVector.getNumRows()) {
            throw new RuntimeException("costQuadraticMatrix.getNumRows() != costLinearVector.getNumRows()");
        }
        if (costQuadraticMatrix.getNumRows() != costQuadraticMatrix.getNumCols()) {
            throw new RuntimeException("costQuadraticMatrix.getNumRows() != costQuadraticMatrix.getNumCols()");
        }
        this.quadraticCostQMatrix.set((DMatrixD1)costQuadraticMatrix);
        this.quadraticCostQVector.set((DMatrixD1)costLinearVector);
        this.quadraticCostScalar = quadraticCostScalar;
    }

    @Override
    public double getObjectiveCost(DMatrixRMaj x) {
        NativeCommonOps.multQuad((DMatrix1Row)x, (DMatrix1Row)this.quadraticCostQMatrix, (DMatrix1Row)this.computedObjectiveFunctionValue);
        CommonOps_DDRM.scale((double)0.5, (DMatrixD1)this.computedObjectiveFunctionValue);
        CommonOps_DDRM.multAddTransA((DMatrix1Row)this.quadraticCostQVector, (DMatrix1Row)x, (DMatrix1Row)this.computedObjectiveFunctionValue);
        return this.computedObjectiveFunctionValue.get(0, 0) + this.quadraticCostScalar;
    }

    @Override
    public void setLinearEqualityConstraints(DMatrixRMaj linearEqualityConstraintsAMatrix, DMatrixRMaj linearEqualityConstraintsBVector) {
        if (linearEqualityConstraintsBVector.getNumCols() != 1) {
            throw new RuntimeException("linearEqualityConstraintsBVector.getNumCols() != 1");
        }
        if (linearEqualityConstraintsAMatrix.getNumRows() != linearEqualityConstraintsBVector.getNumRows()) {
            throw new RuntimeException("linearEqualityConstraintsAMatrix.getNumRows() != linearEqualityConstraintsBVector.getNumRows()");
        }
        if (linearEqualityConstraintsAMatrix.getNumCols() != this.quadraticCostQMatrix.getNumCols()) {
            throw new RuntimeException("linearEqualityConstraintsAMatrix.getNumCols() != quadraticCostQMatrix.getNumCols()");
        }
        this.linearEqualityConstraintsBVector.set((DMatrixD1)linearEqualityConstraintsBVector);
        this.linearEqualityConstraintsAMatrix.set((DMatrixD1)linearEqualityConstraintsAMatrix);
    }

    @Override
    public void setLinearInequalityConstraints(DMatrixRMaj linearInequalityConstraintCMatrix, DMatrixRMaj linearInequalityConstraintDVector) {
        if (linearInequalityConstraintDVector.getNumCols() != 1) {
            throw new RuntimeException("linearInequalityConstraintDVector.getNumCols() != 1");
        }
        if (linearInequalityConstraintCMatrix.getNumRows() != linearInequalityConstraintDVector.getNumRows()) {
            throw new RuntimeException("linearInequalityConstraintCMatrix.getNumRows() != linearInequalityConstraintDVector.getNumRows()");
        }
        if (linearInequalityConstraintCMatrix.getNumCols() != this.quadraticCostQMatrix.getNumCols()) {
            throw new RuntimeException("linearInequalityConstraintCMatrix.getNumCols() != quadraticCostQMatrix.getNumCols()");
        }
        this.linearInequalityConstraintsDVectorO.set((DMatrixD1)linearInequalityConstraintDVector);
        this.linearInequalityConstraintsCMatrixO.set((DMatrixD1)linearInequalityConstraintCMatrix);
    }

    @Override
    public void setUseWarmStart(boolean useWarmStart) {
        this.useWarmStart = useWarmStart;
    }

    @Override
    public void resetActiveSet() {
        this.CBar.reshape(0, 0);
        this.CHat.reshape(0, 0);
        this.DBar.reshape(0, 0);
        this.DHat.reshape(0, 0);
        this.activeInequalityIndices.reset();
        this.activeUpperBoundIndices.reset();
        this.activeLowerBoundIndices.reset();
    }

    @Override
    public int solve(DMatrixRMaj solutionToPack) {
        int i;
        if (!this.useWarmStart || this.problemSizeChanged()) {
            this.resetActiveSet();
        }
        int numberOfIterations = 0;
        int numberOfVariables = this.quadraticCostQMatrix.getNumRows();
        int numberOfEqualityConstraints = this.linearEqualityConstraintsAMatrix.getNumRows();
        int numberOfInequalityConstraints = this.linearInequalityConstraintsCMatrixO.getNumRows();
        int numberOfLowerBoundConstraints = this.variableLowerBounds.getNumRows();
        int numberOfUpperBoundConstraints = this.variableUpperBounds.getNumRows();
        solutionToPack.reshape(numberOfVariables, 1);
        this.lagrangeEqualityConstraintMultipliers.reshape(numberOfEqualityConstraints, 1);
        this.lagrangeEqualityConstraintMultipliers.zero();
        this.lagrangeInequalityConstraintMultipliers.reshape(numberOfInequalityConstraints, 1);
        this.lagrangeInequalityConstraintMultipliers.zero();
        this.lagrangeLowerBoundMultipliers.reshape(numberOfLowerBoundConstraints, 1);
        this.lagrangeLowerBoundMultipliers.zero();
        this.lagrangeUpperBoundMultipliers.reshape(numberOfUpperBoundConstraints, 1);
        this.lagrangeUpperBoundMultipliers.zero();
        this.computeQInverseAndAQInverse();
        this.solveEqualityConstrainedSubproblemEfficiently(solutionToPack, this.lagrangeEqualityConstraintMultipliers, this.lagrangeInequalityConstraintMultipliers, this.lagrangeLowerBoundMultipliers, this.lagrangeUpperBoundMultipliers);
        if (numberOfInequalityConstraints == 0 && numberOfLowerBoundConstraints == 0 && numberOfUpperBoundConstraints == 0) {
            return numberOfIterations;
        }
        for (i = 0; i < this.maxNumberOfIterations; ++i) {
            boolean activeSetWasModified = this.modifyActiveSetAndTryAgain(solutionToPack, this.lagrangeEqualityConstraintMultipliers, this.lagrangeInequalityConstraintMultipliers, this.lagrangeLowerBoundMultipliers, this.lagrangeUpperBoundMultipliers);
            ++numberOfIterations;
            if (activeSetWasModified) continue;
            return numberOfIterations;
        }
        for (i = 0; i < numberOfVariables; ++i) {
            solutionToPack.set(i, 0, Double.NaN);
        }
        return numberOfIterations;
    }

    private boolean problemSizeChanged() {
        boolean sizeChanged = this.checkProblemSize();
        this.previousNumberOfVariables = this.quadraticCostQMatrix.getNumRows();
        this.previousNumberOfEqualityConstraints = this.linearEqualityConstraintsAMatrix.getNumRows();
        this.previousNumberOfInequalityConstraints = this.linearInequalityConstraintsCMatrixO.getNumRows();
        this.previousNumberOfLowerBoundConstraints = this.variableLowerBounds.getNumRows();
        this.previousNumberOfUpperBoundConstraints = this.variableUpperBounds.getNumRows();
        return sizeChanged;
    }

    private boolean checkProblemSize() {
        if (this.previousNumberOfVariables != this.quadraticCostQMatrix.getNumRows()) {
            return true;
        }
        if (this.previousNumberOfEqualityConstraints != this.linearEqualityConstraintsAMatrix.getNumRows()) {
            return true;
        }
        if (this.previousNumberOfInequalityConstraints != this.linearInequalityConstraintsCMatrixO.getNumRows()) {
            return true;
        }
        if (this.previousNumberOfLowerBoundConstraints != this.variableLowerBounds.getNumRows()) {
            return true;
        }
        return this.previousNumberOfUpperBoundConstraints != this.variableUpperBounds.getNumRows();
    }

    private void computeQInverseAndAQInverse() {
        int numberOfVariables = this.quadraticCostQMatrix.getNumRows();
        int numberOfEqualityConstraints = this.linearEqualityConstraintsAMatrix.getNumRows();
        this.ATranspose.reshape(this.linearEqualityConstraintsAMatrix.getNumCols(), this.linearEqualityConstraintsAMatrix.getNumRows());
        CommonOps_DDRM.transpose((DMatrixRMaj)this.linearEqualityConstraintsAMatrix, (DMatrixRMaj)this.ATranspose);
        this.QInverse.reshape(numberOfVariables, numberOfVariables);
        this.AQInverse.reshape(numberOfEqualityConstraints, numberOfVariables);
        this.QInverseATranspose.reshape(numberOfVariables, numberOfEqualityConstraints);
        this.AQInverseATranspose.reshape(numberOfEqualityConstraints, numberOfEqualityConstraints);
        DiagonalMatrixTools.invertDiagonalMatrix((DMatrix1Row)this.quadraticCostQMatrix, (DMatrix1Row)this.QInverse);
        if (numberOfEqualityConstraints > 0) {
            DiagonalMatrixTools.postMult((DMatrix1Row)this.linearEqualityConstraintsAMatrix, (DMatrix1Row)this.QInverse, (DMatrix1Row)this.AQInverse);
            DiagonalMatrixTools.preMult((DMatrix1Row)this.QInverse, (DMatrix1Row)this.ATranspose, (DMatrix1Row)this.QInverseATranspose);
            CommonOps_DDRM.mult((DMatrix1Row)this.AQInverse, (DMatrix1Row)this.ATranspose, (DMatrix1Row)this.AQInverseATranspose);
        }
    }

    private void computeCBarTempMatrices() {
        if (this.CBar.getNumRows() > 0) {
            this.CBarTranspose.reshape(this.CBar.getNumCols(), this.CBar.getNumRows());
            CommonOps_DDRM.transpose((DMatrixRMaj)this.CBar, (DMatrixRMaj)this.CBarTranspose);
            this.AQInverseCBarTranspose.reshape(this.AQInverse.getNumRows(), this.CBarTranspose.getNumCols());
            CommonOps_DDRM.mult((DMatrix1Row)this.AQInverse, (DMatrix1Row)this.CBarTranspose, (DMatrix1Row)this.AQInverseCBarTranspose);
            this.CBarQInverseATranspose.reshape(this.CBar.getNumRows(), this.QInverseATranspose.getNumCols());
            CommonOps_DDRM.mult((DMatrix1Row)this.CBar, (DMatrix1Row)this.QInverseATranspose, (DMatrix1Row)this.CBarQInverseATranspose);
            this.CBarQInverse.reshape(this.CBar.getNumRows(), this.QInverse.getNumCols());
            DiagonalMatrixTools.postMult((DMatrix1Row)this.CBar, (DMatrix1Row)this.QInverse, (DMatrix1Row)this.CBarQInverse);
            this.QInverseCBarTranspose.reshape(this.QInverse.getNumRows(), this.CBarTranspose.getNumCols());
            DiagonalMatrixTools.preMult((DMatrix1Row)this.QInverse, (DMatrix1Row)this.CBarTranspose, (DMatrix1Row)this.QInverseCBarTranspose);
            this.CBarQInverseCBarTranspose.reshape(this.CBar.getNumRows(), this.QInverseCBarTranspose.getNumCols());
            CommonOps_DDRM.mult((DMatrix1Row)this.CBar, (DMatrix1Row)this.QInverseCBarTranspose, (DMatrix1Row)this.CBarQInverseCBarTranspose);
        } else {
            this.CBarTranspose.reshape(0, 0);
            this.AQInverseCBarTranspose.reshape(0, 0);
            this.CBarQInverseATranspose.reshape(0, 0);
            this.CBarQInverse.reshape(0, 0);
            this.QInverseCBarTranspose.reshape(0, 0);
            this.CBarQInverseCBarTranspose.reshape(0, 0);
        }
    }

    private void computeCHatTempMatrices() {
        if (this.CHat.getNumRows() > 0) {
            this.CHatTranspose.reshape(this.CHat.getNumCols(), this.CHat.getNumRows());
            CommonOps_DDRM.transpose((DMatrixRMaj)this.CHat, (DMatrixRMaj)this.CHatTranspose);
            this.AQInverseCHatTranspose.reshape(this.AQInverse.getNumRows(), this.CHatTranspose.getNumCols());
            CommonOps_DDRM.mult((DMatrix1Row)this.AQInverse, (DMatrix1Row)this.CHatTranspose, (DMatrix1Row)this.AQInverseCHatTranspose);
            this.CHatQInverseATranspose.reshape(this.CHat.getNumRows(), this.QInverseATranspose.getNumCols());
            CommonOps_DDRM.mult((DMatrix1Row)this.CHat, (DMatrix1Row)this.QInverseATranspose, (DMatrix1Row)this.CHatQInverseATranspose);
            this.CHatQInverse.reshape(this.CHat.getNumRows(), this.QInverse.getNumCols());
            DiagonalMatrixTools.postMult((DMatrix1Row)this.CHat, (DMatrix1Row)this.QInverse, (DMatrix1Row)this.CHatQInverse);
            this.QInverseCHatTranspose.reshape(this.QInverse.getNumRows(), this.CHatTranspose.getNumCols());
            DiagonalMatrixTools.preMult((DMatrix1Row)this.QInverse, (DMatrix1Row)this.CHatTranspose, (DMatrix1Row)this.QInverseCHatTranspose);
            this.CHatQInverseCHatTranspose.reshape(this.CHat.getNumRows(), this.QInverseCHatTranspose.getNumCols());
            CommonOps_DDRM.mult((DMatrix1Row)this.CHat, (DMatrix1Row)this.QInverseCHatTranspose, (DMatrix1Row)this.CHatQInverseCHatTranspose);
            this.CBarQInverseCHatTranspose.reshape(this.CBar.getNumRows(), this.CHat.getNumRows());
            this.CHatQInverseCBarTranspose.reshape(this.CHat.getNumRows(), this.CBar.getNumRows());
            if (this.CBar.getNumRows() > 0) {
                CommonOps_DDRM.mult((DMatrix1Row)this.CBar, (DMatrix1Row)this.QInverseCHatTranspose, (DMatrix1Row)this.CBarQInverseCHatTranspose);
                CommonOps_DDRM.mult((DMatrix1Row)this.CHat, (DMatrix1Row)this.QInverseCBarTranspose, (DMatrix1Row)this.CHatQInverseCBarTranspose);
            }
        } else {
            this.CHatTranspose.reshape(0, 0);
            this.AQInverseCHatTranspose.reshape(0, 0);
            this.CHatQInverseATranspose.reshape(0, 0);
            this.CHatQInverse.reshape(0, 0);
            this.QInverseCHatTranspose.reshape(0, 0);
            this.CHatQInverseCHatTranspose.reshape(0, 0);
            this.CBarQInverseCHatTranspose.reshape(0, 0);
            this.CHatQInverseCBarTranspose.reshape(0, 0);
        }
    }

    private boolean modifyActiveSetAndTryAgain(DMatrixRMaj solutionToPack, DMatrixRMaj lagrangeEqualityConstraintMultipliersToPack, DMatrixRMaj lagrangeInequalityConstraintMultipliersToPack, DMatrixRMaj lagrangeLowerBoundConstraintMultipliersToPack, DMatrixRMaj lagrangeUpperBoundConstraintMultipliersToPack) {
        int i;
        double lagrangeMultiplier;
        int i2;
        if (this.containsNaN(solutionToPack)) {
            return false;
        }
        boolean activeSetWasModified = false;
        int numberOfVariables = this.quadraticCostQMatrix.getNumRows();
        int numberOfInequalityConstraints = this.linearInequalityConstraintsCMatrixO.getNumRows();
        int numberOfLowerBoundConstraints = this.variableLowerBounds.getNumRows();
        int numberOfUpperBoundConstraints = this.variableUpperBounds.getNumRows();
        this.inequalityIndicesToAddToActiveSet.reset();
        this.inequalityIndicesToRemoveFromActiveSet.reset();
        if (numberOfInequalityConstraints != 0) {
            this.linearInequalityConstraintsCheck.reshape(numberOfInequalityConstraints, 1);
            CommonOps_DDRM.mult((DMatrix1Row)this.linearInequalityConstraintsCMatrixO, (DMatrix1Row)solutionToPack, (DMatrix1Row)this.linearInequalityConstraintsCheck);
            CommonOps_DDRM.subtractEquals((DMatrixD1)this.linearInequalityConstraintsCheck, (DMatrixD1)this.linearInequalityConstraintsDVectorO);
            for (i2 = 0; i2 < numberOfInequalityConstraints; ++i2) {
                if (this.activeInequalityIndices.contains(i2) || !(this.linearInequalityConstraintsCheck.get(i2, 0) > 1.0E-10)) continue;
                activeSetWasModified = true;
                this.inequalityIndicesToAddToActiveSet.add(i2);
            }
            for (i2 = 0; i2 < this.activeInequalityIndices.size(); ++i2) {
                int indexToCheck = this.activeInequalityIndices.get(i2);
                lagrangeMultiplier = lagrangeInequalityConstraintMultipliersToPack.get(indexToCheck);
                if (!(lagrangeMultiplier < 0.0)) continue;
                activeSetWasModified = true;
                this.inequalityIndicesToRemoveFromActiveSet.add(indexToCheck);
            }
        }
        this.lowerBoundIndicesToAddToActiveSet.reset();
        for (i2 = 0; i2 < numberOfLowerBoundConstraints; ++i2) {
            double lowerBound;
            double solutionVariable;
            if (this.activeLowerBoundIndices.contains(i2) || !((solutionVariable = solutionToPack.get(i2, 0)) < (lowerBound = this.variableLowerBounds.get(i2, 0)) - 1.0E-10)) continue;
            activeSetWasModified = true;
            this.lowerBoundIndicesToAddToActiveSet.add(i2);
        }
        this.upperBoundIndicesToAddToActiveSet.reset();
        for (i2 = 0; i2 < numberOfUpperBoundConstraints; ++i2) {
            double upperBound;
            double solutionVariable;
            if (this.activeUpperBoundIndices.contains(i2) || !((solutionVariable = solutionToPack.get(i2, 0)) > (upperBound = this.variableUpperBounds.get(i2, 0)) + 1.0E-10)) continue;
            activeSetWasModified = true;
            this.upperBoundIndicesToAddToActiveSet.add(i2);
        }
        this.lowerBoundIndicesToRemoveFromActiveSet.reset();
        for (i2 = 0; i2 < this.activeLowerBoundIndices.size(); ++i2) {
            int indexToCheck = this.activeLowerBoundIndices.get(i2);
            lagrangeMultiplier = lagrangeLowerBoundConstraintMultipliersToPack.get(indexToCheck);
            if (!(lagrangeMultiplier < 0.0)) continue;
            activeSetWasModified = true;
            this.lowerBoundIndicesToRemoveFromActiveSet.add(indexToCheck);
        }
        this.upperBoundIndicesToRemoveFromActiveSet.reset();
        for (i2 = 0; i2 < this.activeUpperBoundIndices.size(); ++i2) {
            int indexToCheck = this.activeUpperBoundIndices.get(i2);
            lagrangeMultiplier = lagrangeUpperBoundConstraintMultipliersToPack.get(indexToCheck);
            if (!(lagrangeMultiplier < 0.0)) continue;
            activeSetWasModified = true;
            this.upperBoundIndicesToRemoveFromActiveSet.add(indexToCheck);
        }
        if (!activeSetWasModified) {
            return false;
        }
        for (i2 = 0; i2 < this.inequalityIndicesToAddToActiveSet.size(); ++i2) {
            this.activeInequalityIndices.add(this.inequalityIndicesToAddToActiveSet.get(i2));
        }
        for (i2 = 0; i2 < this.inequalityIndicesToRemoveFromActiveSet.size(); ++i2) {
            this.activeInequalityIndices.remove(this.inequalityIndicesToRemoveFromActiveSet.get(i2));
        }
        for (i2 = 0; i2 < this.lowerBoundIndicesToAddToActiveSet.size(); ++i2) {
            this.activeLowerBoundIndices.add(this.lowerBoundIndicesToAddToActiveSet.get(i2));
        }
        for (i2 = 0; i2 < this.lowerBoundIndicesToRemoveFromActiveSet.size(); ++i2) {
            this.activeLowerBoundIndices.remove(this.lowerBoundIndicesToRemoveFromActiveSet.get(i2));
        }
        for (i2 = 0; i2 < this.upperBoundIndicesToAddToActiveSet.size(); ++i2) {
            this.activeUpperBoundIndices.add(this.upperBoundIndicesToAddToActiveSet.get(i2));
        }
        for (i2 = 0; i2 < this.upperBoundIndicesToRemoveFromActiveSet.size(); ++i2) {
            this.activeUpperBoundIndices.remove(this.upperBoundIndicesToRemoveFromActiveSet.get(i2));
        }
        int sizeOfActiveSet = this.activeInequalityIndices.size();
        this.CBar.reshape(sizeOfActiveSet, numberOfVariables);
        this.DBar.reshape(sizeOfActiveSet, 1);
        for (int i3 = 0; i3 < sizeOfActiveSet; ++i3) {
            int inequalityConstraintIndex = this.activeInequalityIndices.get(i3);
            CommonOps_DDRM.extract((DMatrix)this.linearInequalityConstraintsCMatrixO, (int)inequalityConstraintIndex, (int)(inequalityConstraintIndex + 1), (int)0, (int)numberOfVariables, (DMatrix)this.CBar, (int)i3, (int)0);
            CommonOps_DDRM.extract((DMatrix)this.linearInequalityConstraintsDVectorO, (int)inequalityConstraintIndex, (int)(inequalityConstraintIndex + 1), (int)0, (int)1, (DMatrix)this.DBar, (int)i3, (int)0);
        }
        int sizeOfLowerBoundsActiveSet = this.activeLowerBoundIndices.size();
        int sizeOfUpperBoundsActiveSet = this.activeUpperBoundIndices.size();
        int sizeOfBoundsActiveSet = sizeOfLowerBoundsActiveSet + sizeOfUpperBoundsActiveSet;
        this.CHat.reshape(sizeOfBoundsActiveSet, numberOfVariables);
        this.DHat.reshape(sizeOfBoundsActiveSet, 1);
        this.CHat.zero();
        this.DHat.zero();
        int row = 0;
        for (i = 0; i < sizeOfLowerBoundsActiveSet; ++i) {
            int lowerBoundsConstraintIndex = this.activeLowerBoundIndices.get(i);
            this.CHat.set(row, lowerBoundsConstraintIndex, -1.0);
            this.DHat.set(row, 0, -this.variableLowerBounds.get(lowerBoundsConstraintIndex));
            ++row;
        }
        for (i = 0; i < sizeOfUpperBoundsActiveSet; ++i) {
            int upperBoundsConstraintIndex = this.activeUpperBoundIndices.get(i);
            this.CHat.set(row, upperBoundsConstraintIndex, 1.0);
            this.DHat.set(row, 0, this.variableUpperBounds.get(upperBoundsConstraintIndex));
            ++row;
        }
        this.solveEqualityConstrainedSubproblemEfficiently(solutionToPack, lagrangeEqualityConstraintMultipliersToPack, lagrangeInequalityConstraintMultipliersToPack, lagrangeLowerBoundConstraintMultipliersToPack, lagrangeUpperBoundConstraintMultipliersToPack);
        return true;
    }

    private boolean containsNaN(DMatrixRMaj solution) {
        for (int i = 0; i < solution.getNumRows(); ++i) {
            if (!Double.isNaN(solution.get(i, 0))) continue;
            return true;
        }
        return false;
    }

    private void solveEqualityConstrainedSubproblemEfficiently(DMatrixRMaj xSolutionToPack, DMatrixRMaj lagrangeEqualityConstraintMultipliersToPack, DMatrixRMaj lagrangeInequalityConstraintMultipliersToPack, DMatrixRMaj lagrangeLowerBoundConstraintMultipliersToPack, DMatrixRMaj lagrangeUpperBoundConstraintMultipliersToPack) {
        int i;
        int numberOfVariables = this.quadraticCostQMatrix.getNumRows();
        int numberOfOriginalEqualityConstraints = this.linearEqualityConstraintsAMatrix.getNumRows();
        int numberOfActiveInequalityConstraints = this.activeInequalityIndices.size();
        int numberOfActiveLowerBoundConstraints = this.activeLowerBoundIndices.size();
        int numberOfActiveUpperBoundConstraints = this.activeUpperBoundIndices.size();
        int numberOfAugmentedEqualityConstraints = numberOfOriginalEqualityConstraints + numberOfActiveInequalityConstraints + numberOfActiveLowerBoundConstraints + numberOfActiveUpperBoundConstraints;
        this.negativeQuadraticCostQVector.set((DMatrixD1)this.quadraticCostQVector);
        CommonOps_DDRM.scale((double)-1.0, (DMatrixD1)this.negativeQuadraticCostQVector);
        if (numberOfAugmentedEqualityConstraints == 0) {
            DiagonalMatrixTools.preMult((DMatrix1Row)this.QInverse, (DMatrix1Row)this.negativeQuadraticCostQVector, (DMatrix1Row)xSolutionToPack);
            return;
        }
        this.computeCBarTempMatrices();
        this.computeCHatTempMatrices();
        this.bigMatrixForLagrangeMultiplierSolution.reshape(numberOfAugmentedEqualityConstraints, numberOfAugmentedEqualityConstraints);
        this.bigVectorForLagrangeMultiplierSolution.reshape(numberOfAugmentedEqualityConstraints, 1);
        CommonOps_DDRM.insert((DMatrix)this.AQInverseATranspose, (DMatrix)this.bigMatrixForLagrangeMultiplierSolution, (int)0, (int)0);
        CommonOps_DDRM.insert((DMatrix)this.AQInverseCBarTranspose, (DMatrix)this.bigMatrixForLagrangeMultiplierSolution, (int)0, (int)numberOfOriginalEqualityConstraints);
        CommonOps_DDRM.insert((DMatrix)this.AQInverseCHatTranspose, (DMatrix)this.bigMatrixForLagrangeMultiplierSolution, (int)0, (int)(numberOfOriginalEqualityConstraints + numberOfActiveInequalityConstraints));
        CommonOps_DDRM.insert((DMatrix)this.CBarQInverseATranspose, (DMatrix)this.bigMatrixForLagrangeMultiplierSolution, (int)numberOfOriginalEqualityConstraints, (int)0);
        CommonOps_DDRM.insert((DMatrix)this.CBarQInverseCBarTranspose, (DMatrix)this.bigMatrixForLagrangeMultiplierSolution, (int)numberOfOriginalEqualityConstraints, (int)numberOfOriginalEqualityConstraints);
        CommonOps_DDRM.insert((DMatrix)this.CBarQInverseCHatTranspose, (DMatrix)this.bigMatrixForLagrangeMultiplierSolution, (int)numberOfOriginalEqualityConstraints, (int)(numberOfOriginalEqualityConstraints + numberOfActiveInequalityConstraints));
        CommonOps_DDRM.insert((DMatrix)this.CHatQInverseATranspose, (DMatrix)this.bigMatrixForLagrangeMultiplierSolution, (int)(numberOfOriginalEqualityConstraints + numberOfActiveInequalityConstraints), (int)0);
        CommonOps_DDRM.insert((DMatrix)this.CHatQInverseCBarTranspose, (DMatrix)this.bigMatrixForLagrangeMultiplierSolution, (int)(numberOfOriginalEqualityConstraints + numberOfActiveInequalityConstraints), (int)numberOfOriginalEqualityConstraints);
        CommonOps_DDRM.insert((DMatrix)this.CHatQInverseCHatTranspose, (DMatrix)this.bigMatrixForLagrangeMultiplierSolution, (int)(numberOfOriginalEqualityConstraints + numberOfActiveInequalityConstraints), (int)(numberOfOriginalEqualityConstraints + numberOfActiveInequalityConstraints));
        if (numberOfOriginalEqualityConstraints > 0) {
            this.tempVector.reshape(numberOfOriginalEqualityConstraints, 1);
            CommonOps_DDRM.mult((DMatrix1Row)this.AQInverse, (DMatrix1Row)this.quadraticCostQVector, (DMatrix1Row)this.tempVector);
            CommonOps_DDRM.addEquals((DMatrixD1)this.tempVector, (DMatrixD1)this.linearEqualityConstraintsBVector);
            CommonOps_DDRM.scale((double)-1.0, (DMatrixD1)this.tempVector);
            CommonOps_DDRM.insert((DMatrix)this.tempVector, (DMatrix)this.bigVectorForLagrangeMultiplierSolution, (int)0, (int)0);
        }
        if (numberOfActiveInequalityConstraints > 0) {
            this.tempVector.reshape(numberOfActiveInequalityConstraints, 1);
            CommonOps_DDRM.mult((DMatrix1Row)this.CBarQInverse, (DMatrix1Row)this.quadraticCostQVector, (DMatrix1Row)this.tempVector);
            CommonOps_DDRM.addEquals((DMatrixD1)this.tempVector, (DMatrixD1)this.DBar);
            CommonOps_DDRM.scale((double)-1.0, (DMatrixD1)this.tempVector);
            CommonOps_DDRM.insert((DMatrix)this.tempVector, (DMatrix)this.bigVectorForLagrangeMultiplierSolution, (int)numberOfOriginalEqualityConstraints, (int)0);
        }
        if (numberOfActiveLowerBoundConstraints + numberOfActiveUpperBoundConstraints > 0) {
            this.tempVector.reshape(numberOfActiveLowerBoundConstraints + numberOfActiveUpperBoundConstraints, 1);
            CommonOps_DDRM.mult((DMatrix1Row)this.CHatQInverse, (DMatrix1Row)this.quadraticCostQVector, (DMatrix1Row)this.tempVector);
            CommonOps_DDRM.addEquals((DMatrixD1)this.tempVector, (DMatrixD1)this.DHat);
            CommonOps_DDRM.scale((double)-1.0, (DMatrixD1)this.tempVector);
            CommonOps_DDRM.insert((DMatrix)this.tempVector, (DMatrix)this.bigVectorForLagrangeMultiplierSolution, (int)(numberOfOriginalEqualityConstraints + numberOfActiveInequalityConstraints), (int)0);
        }
        this.augmentedLagrangeMultipliers.reshape(numberOfAugmentedEqualityConstraints, 1);
        this.solver.setA((Matrix)this.bigMatrixForLagrangeMultiplierSolution);
        this.solver.solve((Matrix)this.bigVectorForLagrangeMultiplierSolution, (Matrix)this.augmentedLagrangeMultipliers);
        this.ATransposeAndCTranspose.reshape(numberOfVariables, numberOfAugmentedEqualityConstraints);
        CommonOps_DDRM.insert((DMatrix)this.ATranspose, (DMatrix)this.ATransposeAndCTranspose, (int)0, (int)0);
        CommonOps_DDRM.insert((DMatrix)this.CBarTranspose, (DMatrix)this.ATransposeAndCTranspose, (int)0, (int)numberOfOriginalEqualityConstraints);
        CommonOps_DDRM.insert((DMatrix)this.CHatTranspose, (DMatrix)this.ATransposeAndCTranspose, (int)0, (int)(numberOfOriginalEqualityConstraints + numberOfActiveInequalityConstraints));
        this.ATransposeMuAndCTransposeLambda.reshape(numberOfVariables, 1);
        CommonOps_DDRM.mult((DMatrix1Row)this.ATransposeAndCTranspose, (DMatrix1Row)this.augmentedLagrangeMultipliers, (DMatrix1Row)this.ATransposeMuAndCTransposeLambda);
        this.tempVector.set((DMatrixD1)this.quadraticCostQVector);
        CommonOps_DDRM.scale((double)-1.0, (DMatrixD1)this.tempVector);
        CommonOps_DDRM.subtractEquals((DMatrixD1)this.tempVector, (DMatrixD1)this.ATransposeMuAndCTransposeLambda);
        DiagonalMatrixTools.preMult((DMatrix1Row)this.QInverse, (DMatrix1Row)this.tempVector, (DMatrix1Row)xSolutionToPack);
        int startRow = 0;
        int numberOfRows = numberOfOriginalEqualityConstraints;
        CommonOps_DDRM.extract((DMatrix)this.augmentedLagrangeMultipliers, (int)startRow, (int)(startRow + numberOfRows), (int)0, (int)1, (DMatrix)lagrangeEqualityConstraintMultipliersToPack, (int)0, (int)0);
        startRow += numberOfRows;
        lagrangeInequalityConstraintMultipliersToPack.zero();
        for (i = 0; i < numberOfActiveInequalityConstraints; ++i) {
            int inequalityConstraintIndex = this.activeInequalityIndices.get(i);
            CommonOps_DDRM.extract((DMatrix)this.augmentedLagrangeMultipliers, (int)(startRow + i), (int)(startRow + i + 1), (int)0, (int)1, (DMatrix)lagrangeInequalityConstraintMultipliersToPack, (int)inequalityConstraintIndex, (int)0);
        }
        startRow += numberOfActiveInequalityConstraints;
        lagrangeLowerBoundConstraintMultipliersToPack.zero();
        for (i = 0; i < numberOfActiveLowerBoundConstraints; ++i) {
            int lowerBoundConstraintIndex = this.activeLowerBoundIndices.get(i);
            CommonOps_DDRM.extract((DMatrix)this.augmentedLagrangeMultipliers, (int)(startRow + i), (int)(startRow + i + 1), (int)0, (int)1, (DMatrix)lagrangeLowerBoundConstraintMultipliersToPack, (int)lowerBoundConstraintIndex, (int)0);
        }
        startRow += numberOfActiveLowerBoundConstraints;
        lagrangeUpperBoundConstraintMultipliersToPack.zero();
        for (i = 0; i < numberOfActiveUpperBoundConstraints; ++i) {
            int upperBoundConstraintIndex = this.activeUpperBoundIndices.get(i);
            CommonOps_DDRM.extract((DMatrix)this.augmentedLagrangeMultipliers, (int)(startRow + i), (int)(startRow + i + 1), (int)0, (int)1, (DMatrix)lagrangeUpperBoundConstraintMultipliersToPack, (int)upperBoundConstraintIndex, (int)0);
        }
    }

    @Override
    public void getLagrangeEqualityConstraintMultipliers(DMatrixRMaj multipliersMatrixToPack) {
        multipliersMatrixToPack.set((DMatrixD1)this.lagrangeEqualityConstraintMultipliers);
    }

    @Override
    public void getLagrangeInequalityConstraintMultipliers(DMatrixRMaj multipliersMatrixToPack) {
        multipliersMatrixToPack.set((DMatrixD1)this.lagrangeInequalityConstraintMultipliers);
    }

    @Override
    public void getLagrangeLowerBoundsMultipliers(DMatrixRMaj multipliersMatrixToPack) {
        multipliersMatrixToPack.set((DMatrixD1)this.lagrangeLowerBoundMultipliers);
    }

    @Override
    public void getLagrangeUpperBoundsMultipliers(DMatrixRMaj multipliersMatrixToPack) {
        multipliersMatrixToPack.set((DMatrixD1)this.lagrangeUpperBoundMultipliers);
    }
}

