/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.convexOptimization.jOptimizer;

import com.joptimizer.functions.BarrierFunction;
import com.joptimizer.functions.ConvexMultivariateRealFunction;
import com.joptimizer.functions.LinearMultivariateRealFunction;
import com.joptimizer.functions.SOCPLogarithmicBarrier;
import com.joptimizer.optimizers.BarrierMethod;
import com.joptimizer.optimizers.JOptimizer;
import com.joptimizer.optimizers.OptimizationRequest;
import com.joptimizer.optimizers.OptimizationResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.RRQRDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.optim.MaxIter;
import org.apache.commons.math3.optim.OptimizationData;
import org.apache.commons.math3.optim.PointValuePair;
import org.apache.commons.math3.optim.linear.LinearConstraint;
import org.apache.commons.math3.optim.linear.LinearConstraintSet;
import org.apache.commons.math3.optim.linear.LinearObjectiveFunction;
import org.apache.commons.math3.optim.linear.Relationship;
import org.apache.commons.math3.optim.linear.SimplexSolver;
import us.ihmc.convexOptimization.ConvexOptimizationAdapter;

public class JOptimizerConvexOptimizationAdapter
implements ConvexOptimizationAdapter {
    private double[] linearCostFunctionFVector;
    private double[][] quadraticCostFunctionPMatrix;
    private double[] quadraticCostFunctionQVector;
    private double quadraticCostFunctionR;
    private double[][] linearEqualityConstraintsAMatrix;
    private double[] linearEqualityConstraintsBVector;
    private double[][] linearInequalityConstraintCVectors;
    private double[] linearInequalityConstraintBs;
    private List<SOCPLogarithmicBarrier.SOCPConstraintParameters> socpConstraintParameterList = new ArrayList<SOCPLogarithmicBarrier.SOCPConstraintParameters>();
    private int variableDimension;

    public JOptimizerConvexOptimizationAdapter() {
        this.variableDimension = -1;
    }

    public JOptimizerConvexOptimizationAdapter(int variableDimension) {
        assert (variableDimension > 0);
        this.variableDimension = variableDimension;
    }

    private void checkDimension(int variableDimension) {
        if (this.variableDimension < 0) {
            this.variableDimension = variableDimension;
        } else if (this.variableDimension != variableDimension) {
            new Exception("Incorrect constraint dimension, problem variableDimension was previosly inferred as" + this.variableDimension);
        }
    }

    @Override
    public void setLinearCostFunctionVector(double[] linearCostFunctionFVector) {
        this.checkDimension(linearCostFunctionFVector.length);
        this.linearCostFunctionFVector = linearCostFunctionFVector;
    }

    @Override
    public void setQuadraticCostFunction(double[][] quadraticCostFunctionPMatrix, double[] quadraticCostFunctionQVector, double quadraticCostFunctionR) {
        this.quadraticCostFunctionPMatrix = quadraticCostFunctionPMatrix;
        this.quadraticCostFunctionQVector = quadraticCostFunctionQVector;
        this.quadraticCostFunctionR = quadraticCostFunctionR;
        throw new RuntimeException("Not implemented yet!");
    }

    @Override
    public void setLinearEqualityConstraintsAMatrix(double[][] linearEqualityConstraintsAMatrix) {
        if (linearEqualityConstraintsAMatrix.length == 0) {
            System.err.println("Warning: adding linearEqualityConstraintsMatrix with zero row");
            return;
        }
        this.checkDimension(linearEqualityConstraintsAMatrix[0].length);
        this.linearEqualityConstraintsAMatrix = linearEqualityConstraintsAMatrix;
    }

    @Override
    public void setLinearEqualityConstraintsBVector(double[] linearEqualityConstraintsBVector) {
        this.checkDimension(linearEqualityConstraintsBVector.length);
        this.linearEqualityConstraintsBVector = linearEqualityConstraintsBVector;
    }

    @Override
    public void setLinearInequalityConstraints(double[][] linearInequalityConstraintCVectors, double[] linearInequalityConstraintBs) {
        for (int i = 0; i < linearInequalityConstraintCVectors.length; ++i) {
            this.checkDimension(linearInequalityConstraintCVectors[i].length);
        }
        this.linearInequalityConstraintCVectors = linearInequalityConstraintCVectors;
        this.linearInequalityConstraintBs = linearInequalityConstraintBs;
    }

    private double[] findFeasiblePointUsingApacheSimplexSolver() {
        LinearObjectiveFunction f = new LinearObjectiveFunction(new double[this.linearCostFunctionFVector.length], 0.0);
        ArrayList<LinearConstraint> constraints = new ArrayList<LinearConstraint>();
        if (this.linearEqualityConstraintsAMatrix != null) {
            for (int i = 0; i < this.linearEqualityConstraintsBVector.length; ++i) {
                constraints.add(new LinearConstraint(this.linearEqualityConstraintsAMatrix[i], Relationship.EQ, this.linearEqualityConstraintsBVector[i]));
            }
        }
        double eps = 1.0E-10;
        if (this.linearInequalityConstraintCVectors != null) {
            for (int i = 0; i < this.linearInequalityConstraintBs.length; ++i) {
                constraints.add(new LinearConstraint(this.linearInequalityConstraintCVectors[i], Relationship.LEQ, this.linearInequalityConstraintBs[i] - 1.0E-10));
            }
        }
        PointValuePair solution = new SimplexSolver().optimize(new OptimizationData[]{f, new LinearConstraintSet(constraints), new MaxIter(Integer.MAX_VALUE)});
        return solution.getPoint();
    }

    private static int[] firstNonZeroValueEachRow(RealMatrix m) {
        int[] nonZeroIndexes = new int[m.getRowDimension()];
        block0: for (int rowIndex = 0; rowIndex < m.getRowDimension(); ++rowIndex) {
            nonZeroIndexes[rowIndex] = -1;
            for (int colIndex = 0; colIndex < m.getColumnDimension(); ++colIndex) {
                if (!(m.getEntry(rowIndex, colIndex) > 0.0)) continue;
                nonZeroIndexes[rowIndex] = colIndex;
                continue block0;
            }
        }
        return nonZeroIndexes;
    }

    public void removeRedundantLinearEqualityConstraint() {
        int rank;
        if (this.linearEqualityConstraintsAMatrix == null) {
            return;
        }
        Array2DRowRealMatrix equalityConstraintMatrix = new Array2DRowRealMatrix(this.linearEqualityConstraintsAMatrix);
        RRQRDecomposition equalityConstraintQRDecomposition = new RRQRDecomposition((RealMatrix)equalityConstraintMatrix);
        RRQRDecomposition equalityConstraintTransposeQRDecomposition = new RRQRDecomposition(equalityConstraintMatrix.transpose());
        int[] nonZeroIndexPerRow = JOptimizerConvexOptimizationAdapter.firstNonZeroValueEachRow(equalityConstraintTransposeQRDecomposition.getP());
        for (int i = rank = equalityConstraintTransposeQRDecomposition.getRank(1.0E-10); i < this.linearEqualityConstraintsAMatrix.length; ++i) {
            double residual = equalityConstraintQRDecomposition.getQ().getColumnVector(i).dotProduct((RealVector)new ArrayRealVector(this.linearEqualityConstraintsBVector));
            if (Math.abs(residual) < 1.0E-10) {
                System.out.println("Redundant Constraints " + nonZeroIndexPerRow[i] + " residual=" + residual);
                continue;
            }
            System.err.println("Inconsistent Constraints " + nonZeroIndexPerRow[i] + " residual=" + residual + "proceed without them");
        }
        double[][] newLinearEqualityConstraintsAMatrix = new double[rank][];
        double[] newLinearEqualityConstraintsBVector = new double[rank];
        for (int i = 0; i < rank; ++i) {
            newLinearEqualityConstraintsAMatrix[i] = this.linearEqualityConstraintsAMatrix[nonZeroIndexPerRow[i]];
            newLinearEqualityConstraintsBVector[i] = this.linearEqualityConstraintsBVector[nonZeroIndexPerRow[i]];
        }
        this.setLinearEqualityConstraintsAMatrix(newLinearEqualityConstraintsAMatrix);
        this.setLinearEqualityConstraintsBVector(newLinearEqualityConstraintsBVector);
    }

    @Override
    public double[] solve() {
        OptimizationResponse optimizationResponse;
        this.removeRedundantLinearEqualityConstraint();
        OptimizationRequest optimizationRequest = new OptimizationRequest();
        double objectiveFunctionRScalar = 0.0;
        LinearMultivariateRealFunction objectiveFunction = new LinearMultivariateRealFunction(this.linearCostFunctionFVector, objectiveFunctionRScalar);
        optimizationRequest.setF0((ConvexMultivariateRealFunction)objectiveFunction);
        if (this.linearEqualityConstraintsAMatrix != null) {
            optimizationRequest.setA(this.linearEqualityConstraintsAMatrix);
            optimizationRequest.setB(this.linearEqualityConstraintsBVector);
        }
        try {
            optimizationResponse = this.socpConstraintParameterList.size() > 0 ? this.solveSOCP(optimizationRequest) : this.solveQP(optimizationRequest);
        }
        catch (Exception e) {
            System.out.println("unable to solve problem");
            return null;
        }
        return optimizationResponse.getSolution();
    }

    private void convertLinearInequalityConstraintsToSecondOrderConeConstraints() {
        double[][] negLinearInequalityConstraintCVectors = new double[this.linearInequalityConstraintCVectors.length][];
        for (int i = 0; i < this.linearInequalityConstraintCVectors.length; ++i) {
            negLinearInequalityConstraintCVectors[i] = new double[this.linearInequalityConstraintCVectors[i].length];
            for (int j = 0; j < this.linearInequalityConstraintCVectors[i].length; ++j) {
                negLinearInequalityConstraintCVectors[i][j] = -this.linearInequalityConstraintCVectors[i][j];
            }
            this.addSecondOrderConeConstraints(new double[1][this.variableDimension], new double[1], negLinearInequalityConstraintCVectors[i], this.linearInequalityConstraintBs[i]);
        }
    }

    private OptimizationResponse solveSOCP(OptimizationRequest optimizationRequest) throws Exception {
        List<SOCPLogarithmicBarrier.SOCPConstraintParameters> socpConstraintParametersList = this.socpConstraintParameterList;
        SOCPLogarithmicBarrier barrierFunction = new SOCPLogarithmicBarrier(socpConstraintParametersList, 3);
        this.convertLinearInequalityConstraintsToSecondOrderConeConstraints();
        BarrierMethod jOptimizer = new BarrierMethod((BarrierFunction)barrierFunction);
        jOptimizer.setOptimizationRequest(optimizationRequest);
        int returnCode = jOptimizer.optimize();
        return jOptimizer.getOptimizationResponse();
    }

    private OptimizationResponse solveQP(OptimizationRequest optimizationRequest) throws Exception {
        ConvexMultivariateRealFunction[] inequalities = JOptimizerConvexOptimizationAdapter.convertAllInequalityVectorsToJOptimizerConstraints(this.linearInequalityConstraintCVectors, this.linearInequalityConstraintBs);
        if (inequalities != null && inequalities.length != 0) {
            optimizationRequest.setFi(inequalities);
        }
        optimizationRequest.setToleranceFeas(1.0E-8);
        optimizationRequest.setTolerance(2.0E-8);
        optimizationRequest.setMaxIteration(500);
        optimizationRequest.setInitialPoint(this.findFeasiblePointUsingApacheSimplexSolver());
        JOptimizer jOptimizer = new JOptimizer();
        jOptimizer.setOptimizationRequest(optimizationRequest);
        int returnCode = jOptimizer.optimize();
        return jOptimizer.getOptimizationResponse();
    }

    private static ConvexMultivariateRealFunction[] convertAllInequalityVectorsToJOptimizerConstraints(double[][] linearInequalityConstraintCVectors, double[] linearInequalityConstraintBs) {
        if (linearInequalityConstraintCVectors == null) {
            return new ConvexMultivariateRealFunction[0];
        }
        ConvexMultivariateRealFunction[] ret = new ConvexMultivariateRealFunction[linearInequalityConstraintCVectors.length];
        for (int i = 0; i < linearInequalityConstraintCVectors.length; ++i) {
            ret[i] = new LinearMultivariateRealFunction(linearInequalityConstraintCVectors[i], -linearInequalityConstraintBs[i]);
        }
        return ret;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void addQuadraticInequalities(double[][] pMatrix, double[] qVector, double r) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public void addSecondOrderConeConstraints(double[][] secondOrderConeAMatrix, double[] secondOrderConeBVector, double[] secondOrderConeCVector, double secondOrderConeDScalar) {
        SOCPLogarithmicBarrier barrierFunction;
        for (int i = 0; i < secondOrderConeAMatrix.length; ++i) {
            this.checkDimension(secondOrderConeAMatrix[i].length);
        }
        this.checkDimension(secondOrderConeCVector.length);
        List<SOCPLogarithmicBarrier.SOCPConstraintParameters> socpConstraintParametersList = this.socpConstraintParameterList;
        SOCPLogarithmicBarrier sOCPLogarithmicBarrier = barrierFunction = new SOCPLogarithmicBarrier(socpConstraintParametersList, this.variableDimension);
        Objects.requireNonNull(sOCPLogarithmicBarrier);
        SOCPLogarithmicBarrier.SOCPConstraintParameters constraintParams = new SOCPLogarithmicBarrier.SOCPConstraintParameters(sOCPLogarithmicBarrier, secondOrderConeAMatrix, secondOrderConeBVector, secondOrderConeCVector, secondOrderConeDScalar);
        this.socpConstraintParameterList.add(socpConstraintParametersList.size(), constraintParams);
    }
}

