/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.convexOptimization.linearProgram;

import gnu.trove.list.array.TIntArrayList;
import java.util.Arrays;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.convexOptimization.linearProgram.SolverMethod;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.matrixlib.MatrixTools;

public class LinearProgramDictionary {
    private static final int nullMatrixIndex = -1;
    private static final int rhsVariableLexicalIndex = 0;
    private static final int objectiveLexicalIndex = -1;
    private static final int auxObjectiveLexicalIndex = -2;
    private DMatrixRMaj dictionary = new DMatrixRMaj(201, 201);
    private DMatrixRMaj tempDictionary = new DMatrixRMaj(201, 201);
    private DMatrixRMaj startingDictionary;
    private final TIntArrayList basisIndices = new TIntArrayList(200);
    private final TIntArrayList nonBasisIndices = new TIntArrayList(200);
    private final TIntArrayList auxiliaryIndices = new TIntArrayList(200);
    private final TIntArrayList initialNegativeBasisIndices = new TIntArrayList(200);
    private static final String entryFormat = EuclidCoreIOTools.getStringFormat((int)6, (int)3);
    private static final String entrySeparator = "\t\t";

    public boolean initialize(DMatrixRMaj startingDictionary, SolverMethod solverMethod) {
        this.startingDictionary = startingDictionary;
        if (solverMethod == SolverMethod.SIMPLEX) {
            this.setupIndexLists(startingDictionary);
            if (this.populateNegativeBasisIndices(startingDictionary) > 0) {
                int i;
                int auxiliaryVariables = this.initialNegativeBasisIndices.size();
                this.dictionary.reshape(startingDictionary.getNumRows() + 1, startingDictionary.getNumCols() + auxiliaryVariables);
                this.tempDictionary.reshape(startingDictionary.getNumRows() + 1, startingDictionary.getNumCols() + auxiliaryVariables);
                Arrays.fill(this.dictionary.getData(), 0.0);
                MatrixTools.setMatrixBlock((DMatrix)this.dictionary, (int)1, (int)0, (DMatrix)startingDictionary, (int)0, (int)0, (int)startingDictionary.getNumRows(), (int)startingDictionary.getNumCols(), (double)1.0);
                this.basisIndices.insert(0, -2);
                this.auxiliaryIndices.reset();
                int maximumNonAuxiliaryLexicalIndex = this.basisIndices.get(this.basisIndices.size() - 1);
                for (i = 0; i < this.initialNegativeBasisIndices.size(); ++i) {
                    int auxiliaryLexicalIndex = maximumNonAuxiliaryLexicalIndex + i + 1;
                    this.auxiliaryIndices.add(auxiliaryLexicalIndex);
                    this.nonBasisIndices.add(auxiliaryLexicalIndex);
                    this.dictionary.set(0, startingDictionary.getNumCols() + i, -1.0);
                    this.dictionary.set(this.initialNegativeBasisIndices.get(i) + 1, startingDictionary.getNumCols() + i, 1.0);
                }
                for (i = 0; i < this.initialNegativeBasisIndices.size(); ++i) {
                    this.performPivot(this.initialNegativeBasisIndices.get(i) + 1, startingDictionary.getNumCols() + i);
                }
                return true;
            }
            this.dictionary.set((DMatrixD1)startingDictionary);
            this.tempDictionary.set((DMatrixD1)startingDictionary);
            this.setupIndexLists(startingDictionary);
            return false;
        }
        this.dictionary.set((DMatrixD1)startingDictionary);
        this.tempDictionary.set((DMatrixD1)startingDictionary);
        this.setupIndexLists(startingDictionary);
        return false;
    }

    public boolean dropPhaseIVariables() {
        int i;
        for (int i2 = 0; i2 < this.auxiliaryIndices.size(); ++i2) {
            if (!this.basisIndices.contains(this.auxiliaryIndices.get(i2))) continue;
            int pivotRow = this.basisIndices.indexOf(this.auxiliaryIndices.get(i2));
            int pivotColumn = this.findLargestMagnitudeNonAuxiliaryRowEntry(pivotRow);
            this.performPivot(pivotRow, pivotColumn);
        }
        this.tempDictionary.reshape(this.startingDictionary.getNumRows(), this.startingDictionary.getNumCols());
        Arrays.fill(this.tempDictionary.getData(), 0.0);
        int column = 0;
        for (i = 0; i < this.dictionary.getNumCols(); ++i) {
            int index = this.nonBasisIndices.get(i);
            if (this.auxiliaryIndices.contains(index)) continue;
            MatrixTools.setMatrixBlock((DMatrix)this.tempDictionary, (int)0, (int)column, (DMatrix)this.dictionary, (int)1, (int)i, (int)this.tempDictionary.getNumRows(), (int)1, (double)1.0);
            ++column;
        }
        this.dictionary.set((DMatrixD1)this.tempDictionary);
        for (i = this.nonBasisIndices.size() - 1; i >= 0; --i) {
            if (!this.auxiliaryIndices.contains(this.nonBasisIndices.get(i))) continue;
            this.nonBasisIndices.removeAt(i);
        }
        this.basisIndices.remove(-2);
        return true;
    }

    private int findLargestMagnitudeNonAuxiliaryRowEntry(int row) {
        double largestMagnitudeValue = 0.0;
        int column = -1;
        for (int j = 1; j < this.dictionary.getNumCols(); ++j) {
            double value;
            int index = this.nonBasisIndices.get(j);
            if (this.auxiliaryIndices.contains(index) || !((value = Math.abs(this.dictionary.get(row, j))) > largestMagnitudeValue)) continue;
            largestMagnitudeValue = value;
            column = j;
        }
        return column;
    }

    public void performPivot(int r, int s) {
        for (int i = 0; i < this.dictionary.getNumRows(); ++i) {
            for (int j = 0; j < this.dictionary.getNumCols(); ++j) {
                if (i == r && j == s) {
                    this.tempDictionary.set(i, j, 1.0 / this.dictionary.get(r, s));
                    continue;
                }
                if (i == r) {
                    this.tempDictionary.set(i, j, -this.dictionary.get(r, j) / this.dictionary.get(r, s));
                    continue;
                }
                if (j == s) {
                    this.tempDictionary.set(i, j, this.dictionary.get(i, s) / this.dictionary.get(r, s));
                    continue;
                }
                this.tempDictionary.set(i, j, this.dictionary.get(i, j) - this.dictionary.get(i, s) * this.dictionary.get(r, j) / this.dictionary.get(r, s));
            }
        }
        int originalBasisIndex = this.basisIndices.get(r);
        int originalNonBasisIndex = this.nonBasisIndices.get(s);
        this.basisIndices.set(r, originalNonBasisIndex);
        this.nonBasisIndices.set(s, originalBasisIndex);
        DMatrixRMaj previousDictionary = this.dictionary;
        this.dictionary = this.tempDictionary;
        this.tempDictionary = previousDictionary;
    }

    private int populateNegativeBasisIndices(DMatrixRMaj dictionary) {
        this.initialNegativeBasisIndices.reset();
        for (int i = 1; i < dictionary.getNumRows(); ++i) {
            if (!(dictionary.get(i, 0) < -1.0E-10)) continue;
            this.initialNegativeBasisIndices.add(i);
        }
        return this.initialNegativeBasisIndices.size();
    }

    private void setupIndexLists(DMatrixRMaj dictionary) {
        int i;
        this.basisIndices.reset();
        this.nonBasisIndices.reset();
        this.nonBasisIndices.add(0);
        this.basisIndices.add(-1);
        int lexicalIndex = 1;
        for (i = 1; i < dictionary.getNumCols(); ++i) {
            this.nonBasisIndices.add(lexicalIndex++);
        }
        for (i = 1; i < dictionary.getNumRows(); ++i) {
            this.basisIndices.add(lexicalIndex++);
        }
    }

    public int getBasisSize() {
        return this.basisIndices.size();
    }

    public int getNonBasisSize() {
        return this.nonBasisIndices.size();
    }

    public int getNumberOfColumns() {
        return this.dictionary.getNumCols();
    }

    public int getNumberOfRows() {
        return this.dictionary.getNumRows();
    }

    public double getEntry(int row, int column) {
        return this.dictionary.get(row, column);
    }

    public int getBasisIndex(int dictionaryRow) {
        return this.basisIndices.get(dictionaryRow);
    }

    public int getNonBasisIndex(int dictionaryColumn) {
        return this.nonBasisIndices.get(dictionaryColumn);
    }

    void printDictionary(String label) {
        System.out.println(label);
        for (int row = -1; row < this.dictionary.getNumRows(); ++row) {
            for (int column = -1; column < this.dictionary.getNumCols(); ++column) {
                Object entry = "";
                if (row != -1 || column != -1) {
                    entry = row == -1 ? LinearProgramDictionary.formatIndex(this.nonBasisIndices.get(column)) + "\t" : (column == -1 ? LinearProgramDictionary.formatIndex(this.basisIndices.get(row)) : String.format(entryFormat, this.dictionary.get(row, column)));
                }
                System.out.print((String)entry + entrySeparator);
            }
            System.out.println();
        }
    }

    private static String formatIndex(int index) {
        if (index == 0) {
            return "g";
        }
        if (index == -1) {
            return "f";
        }
        if (index == -2) {
            return "f'";
        }
        return Integer.toString(index);
    }

    public TIntArrayList getBasisIndices() {
        return this.basisIndices;
    }

    public TIntArrayList getNonBasisIndices() {
        return this.nonBasisIndices;
    }
}

