/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.convexOptimization.quadraticProgram;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.factory.LinearSolverFactory_DDRM;
import org.ejml.interfaces.linsol.LinearSolverDense;
import us.ihmc.convexOptimization.quadraticProgram.BlockDiagSquareMatrix;
import us.ihmc.matrixlib.MatrixTools;

public class SimpleActiveSetQPStandaloneSolver {
    DMatrixRMaj wInverse = new DMatrixRMaj(0);
    DMatrixRMaj minusWInverseG = new DMatrixRMaj(0);
    DMatrixRMaj gVector = new DMatrixRMaj(0);
    DMatrixRMaj alphaAndGamma = new DMatrixRMaj(0);
    DMatrixRMaj rMatrix = new DMatrixRMaj(0);
    DMatrixRMaj wInverseRTranspose = new DMatrixRMaj(0);
    DMatrixRMaj leftSide = new DMatrixRMaj(0);
    DMatrixRMaj rightSide = new DMatrixRMaj(0);
    DMatrixRMaj eVector = new DMatrixRMaj(0);
    LinearSolverDense<DMatrixRMaj> linearSolver = LinearSolverFactory_DDRM.linear((int)0);
    int maxIterations;

    public SimpleActiveSetQPStandaloneSolver() {
        this(1000);
    }

    public SimpleActiveSetQPStandaloneSolver(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    public int solve(DMatrixRMaj quadraticCostGMatrix, DMatrixRMaj quadraticCostFVector, DMatrixRMaj linearEqualityConstraintA, DMatrixRMaj linearEqualityConstraintB, DMatrixRMaj linearInequalityConstraintA, DMatrixRMaj linearInequalityConstraintB, boolean[] linearInequalityActiveSet, DMatrixRMaj solutionVector) {
        int numberOfVariablesToSolve = quadraticCostGMatrix.numCols;
        int iterations = 0;
        if (quadraticCostGMatrix instanceof BlockDiagSquareMatrix) {
            if (!(this.wInverse instanceof BlockDiagSquareMatrix)) {
                this.wInverse = new BlockDiagSquareMatrix(((BlockDiagSquareMatrix)quadraticCostGMatrix).blockSizes);
            }
            ((BlockDiagSquareMatrix)quadraticCostGMatrix).packInverse(this.linearSolver, (BlockDiagSquareMatrix)this.wInverse);
        } else {
            this.wInverse.reshape(quadraticCostGMatrix.numRows, quadraticCostGMatrix.numCols);
            this.linearSolver.setA((Matrix)quadraticCostGMatrix);
            this.linearSolver.invert((Matrix)this.wInverse);
        }
        this.gVector.reshape(quadraticCostFVector.numRows, quadraticCostFVector.numCols);
        this.gVector.set((DMatrixD1)quadraticCostFVector);
        this.minusWInverseG.reshape(this.wInverse.numRows, 1);
        if (this.wInverse instanceof BlockDiagSquareMatrix) {
            ((BlockDiagSquareMatrix)this.wInverse).mult(-1.0, this.gVector, this.minusWInverseG);
        } else {
            CommonOps_DDRM.mult((double)-1.0, (DMatrix1Row)this.wInverse, (DMatrix1Row)this.gVector, (DMatrix1Row)this.minusWInverseG);
        }
        int linearEqualityConstraintsSize = 0;
        if (linearEqualityConstraintA != null) {
            linearEqualityConstraintsSize = linearEqualityConstraintA.numRows;
            this.rMatrix.reshape(linearEqualityConstraintsSize, numberOfVariablesToSolve);
            CommonOps_DDRM.insert((DMatrix)linearEqualityConstraintA, (DMatrix)this.rMatrix, (int)0, (int)0);
            this.eVector.reshape(linearEqualityConstraintsSize, 1);
            CommonOps_DDRM.insert((DMatrix)linearEqualityConstraintB, (DMatrix)this.eVector, (int)0, (int)0);
        }
        solutionVector.reshape(numberOfVariablesToSolve, 1);
        boolean done = false;
        while (!done) {
            int activeInequalityConstraintSize = this.getNumOfTrue(linearInequalityActiveSet);
            int activeConstraintSize = linearEqualityConstraintsSize + activeInequalityConstraintSize;
            this.alphaAndGamma.reshape(activeConstraintSize, 1);
            if (linearEqualityConstraintsSize > 0 || activeInequalityConstraintSize > 0) {
                this.rMatrix.reshape(activeConstraintSize, numberOfVariablesToSolve, true);
                if (activeInequalityConstraintSize > 0) {
                    SimpleActiveSetQPStandaloneSolver.setPartialMatrixForInequalityConstraints(linearInequalityConstraintA, linearInequalityActiveSet, linearEqualityConstraintsSize, 0, this.rMatrix);
                }
                this.eVector.reshape(activeConstraintSize, 1, true);
                if (activeInequalityConstraintSize > 0) {
                    this.setPartialVectorForInequalityConstraints(linearInequalityConstraintB, linearInequalityActiveSet, linearEqualityConstraintsSize, this.eVector);
                }
                this.wInverseRTranspose.reshape(numberOfVariablesToSolve, activeConstraintSize);
                if (this.wInverse instanceof BlockDiagSquareMatrix) {
                    ((BlockDiagSquareMatrix)this.wInverse).multTransB(this.rMatrix, this.wInverseRTranspose);
                } else {
                    CommonOps_DDRM.multTransB((DMatrix1Row)this.wInverse, (DMatrix1Row)this.rMatrix, (DMatrix1Row)this.wInverseRTranspose);
                }
                this.leftSide.reshape(activeConstraintSize, activeConstraintSize);
                CommonOps_DDRM.mult((double)-1.0, (DMatrix1Row)this.rMatrix, (DMatrix1Row)this.wInverseRTranspose, (DMatrix1Row)this.leftSide);
                this.rightSide.reshape(activeConstraintSize, 1);
                this.rightSide.set((DMatrixD1)this.eVector);
                CommonOps_DDRM.multAddTransA((DMatrix1Row)this.wInverseRTranspose, (DMatrix1Row)this.gVector, (DMatrix1Row)this.rightSide);
                this.linearSolver.setA((Matrix)this.leftSide);
                this.linearSolver.solve((Matrix)this.rightSide, (Matrix)this.alphaAndGamma);
                solutionVector.set((DMatrixD1)this.minusWInverseG);
                CommonOps_DDRM.multAdd((double)-1.0, (DMatrix1Row)this.wInverseRTranspose, (DMatrix1Row)this.alphaAndGamma, (DMatrix1Row)solutionVector);
            } else {
                CommonOps_DDRM.mult((double)-1.0, (DMatrix1Row)this.wInverse, (DMatrix1Row)this.gVector, (DMatrix1Row)solutionVector);
            }
            if (++iterations > this.maxIterations) {
                done = true;
                continue;
            }
            if (linearInequalityActiveSet == null) continue;
            done = true;
            int activeLinearInequalityCount = 0;
            for (int i = 0; i < linearInequalityActiveSet.length; ++i) {
                if (!linearInequalityActiveSet[i]) {
                    double pz = MatrixTools.multMatrixRowVector((DMatrix1Row)linearInequalityConstraintA, (int)i, (DMatrix1Row)solutionVector);
                    if (!(pz > linearInequalityConstraintB.get(i, 0))) continue;
                    linearInequalityActiveSet[i] = true;
                    done = false;
                    continue;
                }
                int n = activeLinearInequalityCount++;
                double gamma = this.alphaAndGamma.get(linearEqualityConstraintsSize + n, 0);
                if (!(gamma < 0.0)) continue;
                linearInequalityActiveSet[i] = false;
                done = false;
            }
        }
        if (iterations > this.maxIterations) {
            return -1;
        }
        return iterations;
    }

    private int getNumOfTrue(boolean[] linearInequalityActiveSet) {
        if (linearInequalityActiveSet == null) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < linearInequalityActiveSet.length; ++i) {
            count += linearInequalityActiveSet[i] ? 1 : 0;
        }
        return count;
    }

    protected static void setPartialMatrixForInequalityConstraints(DMatrixRMaj fromMatrix, boolean[] isActiveRowInMatrix, int startRow, int startColumn, DMatrixRMaj toMatrix) {
        int activeRow = 0;
        for (int i = 0; i < fromMatrix.numRows; ++i) {
            if (!isActiveRowInMatrix[i]) continue;
            CommonOps_DDRM.extract((DMatrix)fromMatrix, (int)i, (int)(i + 1), (int)0, (int)fromMatrix.numCols, (DMatrix)toMatrix, (int)(startRow + activeRow), (int)startColumn);
            ++activeRow;
        }
    }

    protected void setPartialVectorForInequalityConstraints(DMatrixRMaj fromVector, boolean[] isActiveRowInVector, int startRow, DMatrixRMaj toVector) {
        int activeRow = 0;
        for (int i = 0; i < fromVector.numRows; ++i) {
            if (!isActiveRowInVector[i]) continue;
            toVector.set(startRow + activeRow, 0, fromVector.get(i, 0));
            ++activeRow;
        }
    }
}

