/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.convexOptimization.quadraticProgram;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.matrixlib.MatrixTools;

public class SimpleInefficientEqualityConstrainedQPSolver {
    private final DMatrixRMaj quadraticCostQMatrix = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj quadraticCostQVector = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj linearEqualityConstraintsAMatrix = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj linearEqualityConstraintsAMatrixTranspose = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj linearEqualityConstraintsBVector = new DMatrixRMaj(0, 0);
    private double quadraticCostScalar;
    private int numberOfVariablesToSolve = -1;
    private final DMatrixRMaj computedObjectiveFunctionValue = new DMatrixRMaj(1, 1);

    public void clear() {
        this.numberOfVariablesToSolve = -1;
        this.linearEqualityConstraintsAMatrix.reshape(0, 0);
        this.linearEqualityConstraintsAMatrixTranspose.reshape(0, 0);
        this.linearEqualityConstraintsBVector.reshape(0, 0);
        this.quadraticCostQMatrix.reshape(0, 0);
        this.quadraticCostQVector.reshape(0, 0);
    }

    public void setQuadraticCostFunction(double[][] quadraticCostFunctionWMatrix, double[] quadraticCostFunctionGVector, double quadraticCostScalar) {
        this.assertCorrectSize(quadraticCostFunctionWMatrix);
        this.assertCorrectSize(quadraticCostFunctionGVector);
        this.setQuadraticCostFunction(new DMatrixRMaj(quadraticCostFunctionWMatrix), MatrixTools.createVector((double[])quadraticCostFunctionGVector), quadraticCostScalar);
    }

    public void setQuadraticCostFunction(DMatrixRMaj quadraticCostQMatrix, DMatrixRMaj quadraticCostQVector, double quadraticCostScalar) {
        this.setAndAssertCorrectNumberOfVariablesToSolve(quadraticCostQMatrix.numCols);
        this.setAndAssertCorrectNumberOfVariablesToSolve(quadraticCostQMatrix.numRows);
        this.setAndAssertCorrectNumberOfVariablesToSolve(quadraticCostQVector.numRows);
        DMatrixRMaj symCostQuadraticMatrix = new DMatrixRMaj(quadraticCostQMatrix);
        CommonOps_DDRM.transpose((DMatrixRMaj)symCostQuadraticMatrix);
        CommonOps_DDRM.add((DMatrixD1)quadraticCostQMatrix, (DMatrixD1)symCostQuadraticMatrix, (DMatrixD1)symCostQuadraticMatrix);
        CommonOps_DDRM.scale((double)0.5, (DMatrixD1)symCostQuadraticMatrix);
        this.quadraticCostQMatrix.set((DMatrixD1)symCostQuadraticMatrix);
        this.quadraticCostQVector.set((DMatrixD1)quadraticCostQVector);
        this.quadraticCostScalar = quadraticCostScalar;
    }

    public void setLinearEqualityConstraints(double[][] linearEqualityConstraintsAMatrix, double[] linearEqualityConstraintsBVector) {
        this.assertCorrectColumnSize(linearEqualityConstraintsAMatrix);
        if (linearEqualityConstraintsAMatrix.length != linearEqualityConstraintsBVector.length) {
            throw new RuntimeException();
        }
        this.setLinearEqualityConstraints(new DMatrixRMaj(linearEqualityConstraintsAMatrix), MatrixTools.createVector((double[])linearEqualityConstraintsBVector));
    }

    public void setLinearEqualityConstraints(DMatrixRMaj linearEqualityConstraintsAMatrix, DMatrixRMaj linearEqualityConstraintsBVector) {
        this.setAndAssertCorrectNumberOfVariablesToSolve(linearEqualityConstraintsAMatrix.numCols);
        this.linearEqualityConstraintsBVector.set((DMatrixD1)linearEqualityConstraintsBVector);
        this.linearEqualityConstraintsAMatrix.set((DMatrixD1)linearEqualityConstraintsAMatrix);
        this.linearEqualityConstraintsAMatrixTranspose.set((DMatrixD1)CommonOps_DDRM.transpose((DMatrixRMaj)linearEqualityConstraintsAMatrix, null));
    }

    private void assertCorrectSize(double[][] matrix) {
        if (this.numberOfVariablesToSolve == -1) {
            this.numberOfVariablesToSolve = matrix.length;
        }
        if (matrix.length != this.numberOfVariablesToSolve) {
            throw new RuntimeException("matrix.length = " + matrix.length + " != numberOfVariablesToSolve = " + this.numberOfVariablesToSolve);
        }
        if (matrix[0].length != this.numberOfVariablesToSolve) {
            throw new RuntimeException("matrix[0].length = " + matrix[0].length + " != numberOfVariablesToSolve = " + this.numberOfVariablesToSolve);
        }
    }

    private void assertCorrectColumnSize(double[][] matrix) {
        if (this.numberOfVariablesToSolve == -1) {
            this.numberOfVariablesToSolve = matrix[0].length;
        }
        if (matrix[0].length != this.numberOfVariablesToSolve) {
            throw new RuntimeException("matrix[0].length = " + matrix[0].length + " != numberOfVariablesToSolve = " + this.numberOfVariablesToSolve);
        }
    }

    protected void setAndAssertCorrectNumberOfVariablesToSolve(int n) {
        if (this.numberOfVariablesToSolve == -1) {
            this.numberOfVariablesToSolve = n;
        }
        if (n != this.numberOfVariablesToSolve) {
            throw new RuntimeException("incorrect NumberOfVariables size");
        }
    }

    private void assertCorrectSize(double[] vector) {
        if (this.numberOfVariablesToSolve == -1) {
            this.numberOfVariablesToSolve = vector.length;
        }
        if (vector.length != this.numberOfVariablesToSolve) {
            throw new RuntimeException("vector.length = " + vector.length + " != numberOfVariablesToSolve = " + this.numberOfVariablesToSolve);
        }
    }

    public void solve(double[] xSolutionToPack, double[] lagrangeMultipliersToPack) {
        int numberOfVariables = this.quadraticCostQMatrix.getNumCols();
        int numberOfEqualityConstraints = this.linearEqualityConstraintsAMatrix.getNumRows();
        if (xSolutionToPack.length != numberOfVariables) {
            throw new RuntimeException("xSolutionToPack.length != numberOfVariables");
        }
        if (lagrangeMultipliersToPack.length != numberOfEqualityConstraints) {
            throw new RuntimeException("lagrangeMultipliersToPack.length != numberOfEqualityConstraints");
        }
        DMatrixRMaj solution = new DMatrixRMaj(numberOfVariables, 1);
        DMatrixRMaj lagrangeMultipliers = new DMatrixRMaj(numberOfEqualityConstraints, 1);
        this.solve(solution, lagrangeMultipliers);
        double[] solutionData = solution.getData();
        for (int i = 0; i < numberOfVariables; ++i) {
            xSolutionToPack[i] = solutionData[i];
        }
        double[] lagrangeMultipliersData = lagrangeMultipliers.getData();
        for (int i = 0; i < numberOfEqualityConstraints; ++i) {
            lagrangeMultipliersToPack[i] = lagrangeMultipliersData[i];
        }
    }

    public void solve(DMatrixRMaj xSolutionToPack, DMatrixRMaj lagrangeMultipliersToPack) {
        int i;
        int numberOfVariables = this.quadraticCostQMatrix.getNumCols();
        if (numberOfVariables != this.quadraticCostQMatrix.getNumRows()) {
            throw new RuntimeException("numCols != numRows");
        }
        int numberOfEqualityConstraints = this.linearEqualityConstraintsAMatrix.getNumRows();
        if (numberOfEqualityConstraints > 0 && this.linearEqualityConstraintsAMatrix.getNumCols() != numberOfVariables) {
            throw new RuntimeException("linearEqualityConstraintA.getNumCols() != numberOfVariables");
        }
        if (this.quadraticCostQVector.getNumRows() != numberOfVariables) {
            throw new RuntimeException("quadraticCostQVector.getNumRows() != numRows");
        }
        if (this.quadraticCostQVector.getNumCols() != 1) {
            throw new RuntimeException("quadraticCostQVector.getNumCols() != 1");
        }
        DMatrixRMaj negativeQuadraticCostQVector = new DMatrixRMaj(this.quadraticCostQVector);
        CommonOps_DDRM.scale((double)-1.0, (DMatrixD1)negativeQuadraticCostQVector);
        if (numberOfEqualityConstraints == 0) {
            xSolutionToPack.reshape(numberOfVariables, 1);
            CommonOps_DDRM.solve((DMatrixRMaj)this.quadraticCostQMatrix, (DMatrixRMaj)negativeQuadraticCostQVector, (DMatrixRMaj)xSolutionToPack);
            return;
        }
        CommonOps_DDRM.transpose((DMatrixRMaj)this.linearEqualityConstraintsAMatrix, (DMatrixRMaj)this.linearEqualityConstraintsAMatrixTranspose);
        DMatrixRMaj bigMatrix = new DMatrixRMaj(numberOfVariables + numberOfEqualityConstraints, numberOfVariables + numberOfEqualityConstraints);
        DMatrixRMaj bigVector = new DMatrixRMaj(numberOfVariables + numberOfEqualityConstraints, 1);
        CommonOps_DDRM.insert((DMatrix)this.quadraticCostQMatrix, (DMatrix)bigMatrix, (int)0, (int)0);
        CommonOps_DDRM.insert((DMatrix)this.linearEqualityConstraintsAMatrix, (DMatrix)bigMatrix, (int)numberOfVariables, (int)0);
        CommonOps_DDRM.insert((DMatrix)this.linearEqualityConstraintsAMatrixTranspose, (DMatrix)bigMatrix, (int)0, (int)numberOfVariables);
        CommonOps_DDRM.insert((DMatrix)negativeQuadraticCostQVector, (DMatrix)bigVector, (int)0, (int)0);
        CommonOps_DDRM.insert((DMatrix)this.linearEqualityConstraintsBVector, (DMatrix)bigVector, (int)numberOfVariables, (int)0);
        DMatrixRMaj xAndLagrangeMultiplierSolution = new DMatrixRMaj(numberOfVariables + numberOfEqualityConstraints, 1);
        CommonOps_DDRM.solve((DMatrixRMaj)bigMatrix, (DMatrixRMaj)bigVector, (DMatrixRMaj)xAndLagrangeMultiplierSolution);
        for (i = 0; i < numberOfVariables; ++i) {
            xSolutionToPack.set(i, 0, xAndLagrangeMultiplierSolution.get(i, 0));
        }
        for (i = 0; i < numberOfEqualityConstraints; ++i) {
            lagrangeMultipliersToPack.set(i, 0, xAndLagrangeMultiplierSolution.get(numberOfVariables + i, 0));
        }
    }

    public double getObjectiveCost(DMatrixRMaj x) {
        MatrixTools.multQuad((DMatrix1Row)x, (DMatrix1Row)this.quadraticCostQMatrix, (DMatrixRMaj)this.computedObjectiveFunctionValue);
        CommonOps_DDRM.scale((double)0.5, (DMatrixD1)this.computedObjectiveFunctionValue);
        CommonOps_DDRM.multAddTransA((DMatrix1Row)this.quadraticCostQVector, (DMatrix1Row)x, (DMatrix1Row)this.computedObjectiveFunctionValue);
        return this.computedObjectiveFunctionValue.get(0, 0) + this.quadraticCostScalar;
    }

    public void displayProblem() {
        System.out.println("----------------------------------------------------------------------------------------------------");
        System.out.println("equalityA:" + this.linearEqualityConstraintsAMatrix);
        System.out.println("equalityB:" + this.linearEqualityConstraintsBVector);
        System.out.println("costQuadQ:" + this.quadraticCostQMatrix);
        System.out.println("costLinearF:" + this.quadraticCostQVector);
        System.out.println("costLinearScalar:" + this.quadraticCostScalar);
        System.out.println("----------------------------------------------------------------------------------------------------");
    }
}

