/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.convexOptimization.linearProgram;

import gnu.trove.list.array.TIntArrayList;
import java.util.Arrays;
import org.apache.commons.math3.util.Precision;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.commons.time.Stopwatch;
import us.ihmc.convexOptimization.linearProgram.LinearProgramDictionary;
import us.ihmc.convexOptimization.linearProgram.SolverMethod;
import us.ihmc.convexOptimization.linearProgram.SolverStatistics;

public class DictionaryFormLinearProgramSolver {
    static final boolean debug = false;
    static final int maxVariables = 200;
    static final int maxCrissCrossIterations = 50000;
    static final int maxSimplexIterations = 1000;
    static final int nullMatrixIndex = -1;
    static final double epsilon = 1.0E-6;
    static final double zeroCutoff = 1.0E-10;
    private final LinearProgramDictionary dictionary = new LinearProgramDictionary();
    private final DMatrixRMaj solution = new DMatrixRMaj(200);
    private final Stopwatch timer = new Stopwatch();
    private final SolverStatistics phase1Statistics = new SolverStatistics();
    private final SolverStatistics phase2Statistics = new SolverStatistics();
    private final SolverStatistics crissCrossStatistics = new SolverStatistics();
    private final TIntArrayList minRatioIndices = new TIntArrayList(201);

    public void solveSimplex(DMatrixRMaj startingDictionary) {
        if (startingDictionary.getNumCols() > 200) {
            throw new IllegalArgumentException("Simplex method has a maximum of 200 decision variables, " + startingDictionary.getNumCols() + " provided.");
        }
        this.phase1Statistics.clear();
        this.phase2Statistics.clear();
        if (this.dictionary.initialize(startingDictionary, SolverMethod.SIMPLEX)) {
            this.performSimplexPhase(SimplexPhase.PHASE_I);
            if (!this.phase1Statistics.foundSolution() || this.dictionary.getEntry(0, 0) < -1.0E-6) {
                this.phase1Statistics.setFoundSolution(false);
                return;
            }
            this.dictionary.dropPhaseIVariables();
        }
        this.performSimplexPhase(SimplexPhase.PHASE_II);
        this.packSolution();
    }

    void performSimplexPhase(SimplexPhase phase) {
        SolverStatistics statistics = phase == SimplexPhase.PHASE_I ? this.phase1Statistics : this.phase2Statistics;
        this.timer.reset();
        while (true) {
            if (statistics.getAndIncrementIterations() > 1000) {
                statistics.setFoundSolution(false);
                break;
            }
            if (this.isSimplexOptimal()) {
                statistics.setFoundSolution(true);
                break;
            }
            int s = this.computeSimplexPivotColumn();
            int r = this.computeSimplexPivotRow(s, phase);
            if (r == -1) {
                statistics.setFoundSolution(false);
                break;
            }
            this.dictionary.performPivot(r, s);
        }
        statistics.setSolveTime(this.timer.lapElapsed());
    }

    private void packSolution() {
        this.solution.reshape(this.dictionary.getNumberOfColumns() - 1, 1);
        Arrays.fill(this.solution.getData(), 0.0);
        for (int i = 1; i < this.dictionary.getBasisSize(); ++i) {
            int variableIndex = this.dictionary.getBasisIndex(i) - 1;
            if (variableIndex >= this.solution.getNumRows()) continue;
            this.solution.set(variableIndex, this.dictionary.getEntry(i, 0));
        }
    }

    private boolean isSimplexOptimal() {
        for (int j = 1; j < this.dictionary.getNumberOfColumns(); ++j) {
            if (!(this.dictionary.getEntry(0, j) > 1.0E-6)) continue;
            return false;
        }
        return true;
    }

    private int computeSimplexPivotColumn() {
        int minimumEntryIndex = Integer.MAX_VALUE;
        int column = -1;
        for (int j = 1; j < this.dictionary.getNumberOfColumns(); ++j) {
            int index;
            double entry = this.dictionary.getEntry(0, j);
            if (entry < 1.0E-6 || (index = this.dictionary.getNonBasisIndex(j)) >= minimumEntryIndex) continue;
            minimumEntryIndex = index;
            column = j;
        }
        return column;
    }

    private int computeSimplexPivotRow(int column, SimplexPhase phase) {
        double minRatio = Double.MAX_VALUE;
        this.minRatioIndices.reset();
        for (int i = phase.objectiveSize(); i < this.dictionary.getNumberOfRows(); ++i) {
            double d_ig = this.dictionary.getEntry(i, 0);
            double d_is = this.dictionary.getEntry(i, column);
            if (d_is > -1.0E-6) continue;
            double ratio = Math.abs(d_ig / d_is);
            int cmp = Precision.compareTo((double)ratio, (double)minRatio, (double)1.0E-6);
            if (cmp == 0) {
                this.minRatioIndices.add(i);
                continue;
            }
            if (cmp >= 0) continue;
            this.minRatioIndices.reset();
            this.minRatioIndices.add(i);
            minRatio = ratio;
        }
        if (this.minRatioIndices.isEmpty()) {
            return -1;
        }
        if (this.minRatioIndices.size() > 1) {
            int minRowIndex = Integer.MAX_VALUE;
            int minRow = -1;
            for (int i = 0; i < this.minRatioIndices.size(); ++i) {
                int variableIndex = this.dictionary.getBasisIndex(this.minRatioIndices.get(i));
                if (variableIndex >= minRowIndex) continue;
                minRowIndex = variableIndex;
                minRow = this.minRatioIndices.get(i);
            }
            return minRow;
        }
        return this.minRatioIndices.get(0);
    }

    public DMatrixRMaj getSolution() {
        return this.solution;
    }

    public void printSolution() {
        System.out.println("Solution:");
        for (int i = 0; i < this.solution.getNumRows(); ++i) {
            System.out.println("\t " + this.solution.get(i));
        }
    }

    public void solveCrissCross(DMatrixRMaj startingDictionary) {
        this.crissCrossStatistics.clear();
        this.timer.reset();
        this.dictionary.initialize(startingDictionary, SolverMethod.CRISS_CROSS);
        while (true) {
            int basisPivot;
            int nonBasisPivot;
            if (this.crissCrossStatistics.getAndIncrementIterations() > 50000) {
                this.crissCrossStatistics.setFoundSolution(false);
                break;
            }
            int candidateBasisPivot = this.findNegativeColumnEntryWithBlandRule(0);
            int candidateNonBasisPivot = this.findPositiveRowEntryWithBlandRule(0);
            if (candidateBasisPivot == -1 && candidateNonBasisPivot == -1) {
                this.crissCrossStatistics.setFoundSolution(true);
                break;
            }
            if (candidateBasisPivot != -1 && (candidateNonBasisPivot == -1 || this.dictionary.getBasisIndex(candidateBasisPivot) < this.dictionary.getNonBasisIndex(candidateNonBasisPivot)) ? (nonBasisPivot = this.findPositiveRowEntryWithBlandRule(basisPivot = candidateBasisPivot)) == -1 : (basisPivot = this.findNegativeColumnEntryWithBlandRule(nonBasisPivot = candidateNonBasisPivot)) == -1) break;
            this.dictionary.performPivot(basisPivot, nonBasisPivot);
        }
        this.crissCrossStatistics.setSolveTime(this.timer.totalElapsed());
        this.packSolution();
    }

    private int findNegativeColumnEntryWithBlandRule(int column) {
        int minLexicalIndex = Integer.MAX_VALUE;
        int row = -1;
        for (int i = 1; i < this.dictionary.getNumberOfRows(); ++i) {
            double d_ig = this.dictionary.getEntry(i, column);
            int lexicalIndex = this.dictionary.getBasisIndex(i);
            if (!(d_ig < -1.0E-6) || lexicalIndex >= minLexicalIndex) continue;
            minLexicalIndex = lexicalIndex;
            row = i;
        }
        return row;
    }

    private int findPositiveRowEntryWithBlandRule(int row) {
        int minLexicalIndex = Integer.MAX_VALUE;
        int column = -1;
        for (int j = 1; j < this.dictionary.getNumberOfColumns(); ++j) {
            double d_fj = this.dictionary.getEntry(row, j);
            int lexicalIndex = this.dictionary.getNonBasisIndex(j);
            if (!(d_fj > 1.0E-6) || lexicalIndex >= minLexicalIndex) continue;
            minLexicalIndex = lexicalIndex;
            column = j;
        }
        return column;
    }

    public SolverStatistics getPhase1Statistics() {
        return this.phase1Statistics;
    }

    public SolverStatistics getPhase2Statistics() {
        return this.phase2Statistics;
    }

    public SolverStatistics getCrissCrossStatistics() {
        return this.crissCrossStatistics;
    }

    private static enum SimplexPhase {
        PHASE_I,
        PHASE_II;


        int objectiveSize() {
            return this == PHASE_I ? 2 : 1;
        }
    }
}

