/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.convexOptimization.quadraticProgram;

import org.ejml.data.DMatrixRMaj;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import us.ihmc.convexOptimization.exceptions.NoConvergenceException;
import us.ihmc.convexOptimization.quadraticProgram.AbstractSimpleActiveSetQPSolverWithInactiveVariablesTest;
import us.ihmc.convexOptimization.quadraticProgram.ActiveSetQPSolverWithInactiveVariablesInterface;
import us.ihmc.convexOptimization.quadraticProgram.JavaQuadProgSolverWithInactiveVariables;
import us.ihmc.matrixlib.MatrixTools;

public class JavaQuadProgSolverWithInactiveVariablesTest
extends AbstractSimpleActiveSetQPSolverWithInactiveVariablesTest {
    private static final double epsilon = 1.0E-4;

    @Override
    public ActiveSetQPSolverWithInactiveVariablesInterface createSolverToTest() {
        JavaQuadProgSolverWithInactiveVariables solver = new JavaQuadProgSolverWithInactiveVariables();
        solver.setUseWarmStart(false);
        return solver;
    }

    @Override
    @Test
    public void testSolutionMethodsAreAllConsistent() throws NoConvergenceException {
        this.testSolutionMethodsAreAllConsistent(1);
    }

    @Override
    @Test
    public void testSimpleCasesWithInequalityConstraints() {
        this.testSimpleCasesWithInequalityConstraints(0);
    }

    @Override
    @Test
    public void testSimpleCasesWithBoundsConstraints() {
        this.testSimpleCasesWithBoundsConstraints(0, 1, 6, 2, true);
    }

    @Override
    @Test
    public void testClear() {
        this.testClear(6, 1, true);
    }

    @Override
    @Test
    public void testMaxIterations() {
        this.testMaxIterations(6, false);
    }

    @Override
    @Test
    public void test2DCasesWithPolygonConstraints() {
        this.test2DCasesWithPolygonConstraints(2, 1);
    }

    @Override
    @Disabled
    @Test
    public void testChallengingCasesWithPolygonConstraints() {
        this.testChallengingCasesWithPolygonConstraints(1, 5);
    }

    @Override
    @Test
    public void testSimpleCasesWithInequalityConstraintsAndInactiveVariables() {
        this.testSimpleCasesWithInequalityConstraintsAndInactiveVariables(0);
    }

    @Override
    @Test
    public void testSimpleCasesWithBoundsConstraintsAndInactiveVariables() {
        this.testSimpleCasesWithBoundsConstraintsAndInactiveVariables(0, 1, 2, 0, false);
    }

    @Override
    @Test
    public void testChallengingCasesWithPolygonConstraintsCheckFailsWithSimpleSolver() {
        ActiveSetQPSolverWithInactiveVariablesInterface solver = this.createSolverToTest();
        solver.setMaxNumberOfIterations(10);
        DMatrixRMaj costQuadraticMatrix = new DMatrixRMaj((double[][])new double[][]{{2.0, 0.0}, {0.0, 2.0}});
        DMatrixRMaj costLinearVector = MatrixTools.createVector((double[])new double[]{0.0, 0.0});
        double quadraticCostScalar = 0.0;
        solver.setQuadraticCostFunction(costQuadraticMatrix, costLinearVector, quadraticCostScalar);
        DMatrixRMaj linearInequalityConstraintsCMatrix = new DMatrixRMaj((double[][])new double[][]{{-1.0, -1.0}, {-10.0, 1.0}, {1.0, -10.0}});
        DMatrixRMaj linearInqualityConstraintsDVector = MatrixTools.createVector((double[])new double[]{-2.0, -2.0, -2.0});
        solver.setLinearInequalityConstraints(linearInequalityConstraintsCMatrix, linearInqualityConstraintsDVector);
        DMatrixRMaj solution = new DMatrixRMaj(2, 1);
        DMatrixRMaj lagrangeEqualityMultipliers = new DMatrixRMaj(0, 1);
        DMatrixRMaj lagrangeInequalityMultipliers = new DMatrixRMaj(3, 1);
        solver.solve(solution);
        solver.getLagrangeEqualityConstraintMultipliers(lagrangeEqualityMultipliers);
        solver.getLagrangeInequalityConstraintMultipliers(lagrangeInequalityMultipliers);
        Assertions.assertEquals((int)2, (int)solution.getNumRows());
        Assertions.assertEquals((double)solution.get(0), (double)1.0, (double)1.0E-4);
        Assertions.assertEquals((double)solution.get(1), (double)1.0, (double)1.0E-4);
        Assertions.assertEquals((double)lagrangeInequalityMultipliers.get(0), (double)2.0, (double)1.0E-4);
        Assertions.assertEquals((double)lagrangeInequalityMultipliers.get(1), (double)0.0, (double)1.0E-4);
        Assertions.assertEquals((double)lagrangeInequalityMultipliers.get(2), (double)0.0, (double)1.0E-4);
    }
}

