/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.convexOptimization.quadraticProgram;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.convexOptimization.quadraticProgram.AbstractSimpleActiveSetQPSolverTest;
import us.ihmc.convexOptimization.quadraticProgram.ActiveSetQPSolverWithInactiveVariablesInterface;
import us.ihmc.matrixlib.MatrixTools;

public abstract class AbstractSimpleActiveSetQPSolverWithInactiveVariablesTest
extends AbstractSimpleActiveSetQPSolverTest {
    public abstract ActiveSetQPSolverWithInactiveVariablesInterface createSolverToTest();

    @Test
    public void testSimpleCasesWithInequalityConstraintsAndInactiveVariables() {
        this.testSimpleCasesWithInequalityConstraintsAndInactiveVariables(1);
    }

    public void testSimpleCasesWithInequalityConstraintsAndInactiveVariables(int expectedNumberOfIterations) {
        ActiveSetQPSolverWithInactiveVariablesInterface solver = this.createSolverToTest();
        DMatrixRMaj costQuadraticMatrix = new DMatrixRMaj((double[][])new double[][]{{2.0}});
        DMatrixRMaj costLinearVector = MatrixTools.createVector((double[])new double[]{0.0});
        double quadraticCostScalar = 0.0;
        solver.setQuadraticCostFunction((DMatrix)costQuadraticMatrix, (DMatrix)costLinearVector, quadraticCostScalar);
        DMatrixRMaj linearInequalityConstraintsCMatrix = new DMatrixRMaj((double[][])new double[][]{{1.0}});
        DMatrixRMaj linearInqualityConstraintsDVector = MatrixTools.createVector((double[])new double[]{1.0});
        solver.setLinearInequalityConstraints((DMatrix)linearInequalityConstraintsCMatrix, (DMatrix)linearInqualityConstraintsDVector);
        DMatrixRMaj solution = new DMatrixRMaj(1, 1);
        DMatrixRMaj lagrangeEqualityMultipliers = new DMatrixRMaj(0, 1);
        DMatrixRMaj lagrangeInequalityMultipliers = new DMatrixRMaj(1, 1);
        int numberOfIterations = solver.solve((DMatrix)solution);
        solver.getLagrangeEqualityConstraintMultipliers(lagrangeEqualityMultipliers);
        solver.getLagrangeInequalityConstraintMultipliers(lagrangeInequalityMultipliers);
        numberOfIterations = solver.solve((DMatrix)solution);
        solver.getLagrangeEqualityConstraintMultipliers(lagrangeEqualityMultipliers);
        solver.getLagrangeInequalityConstraintMultipliers(lagrangeInequalityMultipliers);
        Assertions.assertEquals((int)expectedNumberOfIterations, (int)numberOfIterations);
        Assertions.assertEquals((int)1, (int)solution.getNumRows());
        Assertions.assertEquals((double)0.0, (double)solution.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)0.0, (double)lagrangeInequalityMultipliers.get(0), (double)1.0E-7);
        solver.clear();
        costQuadraticMatrix = new DMatrixRMaj((double[][])new double[][]{{2.0, 0.0}, {0.0, 2.0}});
        costLinearVector = MatrixTools.createVector((double[])new double[]{-10.0, -6.0});
        quadraticCostScalar = 34.0;
        solver.setQuadraticCostFunction((DMatrix)costQuadraticMatrix, (DMatrix)costLinearVector, quadraticCostScalar);
        DMatrixRMaj activeVariables = MatrixTools.createVector((double[])new double[]{1.0, 0.0});
        solver.setActiveVariables((DMatrix)activeVariables);
        linearInequalityConstraintsCMatrix = new DMatrixRMaj((double[][])new double[][]{{1.0, 0.0}, {0.0, 1.0}});
        linearInqualityConstraintsDVector = MatrixTools.createVector((double[])new double[]{7.0, 1.0});
        solver.setLinearInequalityConstraints((DMatrix)linearInequalityConstraintsCMatrix, (DMatrix)linearInqualityConstraintsDVector);
        solution = new DMatrixRMaj(2, 1);
        lagrangeEqualityMultipliers = new DMatrixRMaj(0, 1);
        lagrangeInequalityMultipliers = new DMatrixRMaj(2, 1);
        numberOfIterations = solver.solve((DMatrix)solution);
        solver.getLagrangeEqualityConstraintMultipliers(lagrangeEqualityMultipliers);
        solver.getLagrangeInequalityConstraintMultipliers(lagrangeInequalityMultipliers);
        Assertions.assertEquals((int)expectedNumberOfIterations, (int)numberOfIterations);
        Assertions.assertEquals((int)2, (int)solution.getNumRows());
        Assertions.assertEquals((double)5.0, (double)solution.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)0.0, (double)solution.get(1), (double)1.0E-7);
        Assertions.assertEquals((double)0.0, (double)lagrangeInequalityMultipliers.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)0.0, (double)lagrangeInequalityMultipliers.get(1), (double)1.0E-7);
        DMatrixRMaj solutionMatrix = new DMatrixRMaj(costQuadraticMatrix.getNumRows(), 1);
        solutionMatrix.set((DMatrixD1)solution);
        double objectiveCost = solver.getObjectiveCost(solutionMatrix);
        Assertions.assertEquals((double)9.0, (double)objectiveCost, (double)1.0E-7);
        solver.clear();
        costQuadraticMatrix = new DMatrixRMaj((double[][])new double[][]{{2.0, 0.0}, {0.0, 2.0}});
        costLinearVector = MatrixTools.createVector((double[])new double[]{-10.0, -6.0});
        quadraticCostScalar = 34.0;
        solver.setQuadraticCostFunction((DMatrix)costQuadraticMatrix, (DMatrix)costLinearVector, quadraticCostScalar);
        activeVariables = MatrixTools.createVector((double[])new double[]{0.0, 1.0});
        solver.setActiveVariables((DMatrix)activeVariables);
        linearInequalityConstraintsCMatrix = new DMatrixRMaj((double[][])new double[][]{{1.0, 0.0}, {0.0, 1.0}});
        linearInqualityConstraintsDVector = MatrixTools.createVector((double[])new double[]{7.0, 1.0});
        solver.setLinearInequalityConstraints((DMatrix)linearInequalityConstraintsCMatrix, (DMatrix)linearInqualityConstraintsDVector);
        solution = new DMatrixRMaj(2, 1);
        lagrangeEqualityMultipliers = new DMatrixRMaj(0, 1);
        lagrangeInequalityMultipliers = new DMatrixRMaj(2, 1);
        numberOfIterations = solver.solve((DMatrix)solution);
        solver.getLagrangeEqualityConstraintMultipliers(lagrangeEqualityMultipliers);
        solver.getLagrangeInequalityConstraintMultipliers(lagrangeInequalityMultipliers);
        Assertions.assertEquals((int)(expectedNumberOfIterations + 1), (int)numberOfIterations);
        Assertions.assertEquals((int)2, (int)solution.getNumRows());
        Assertions.assertEquals((double)0.0, (double)solution.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)1.0, (double)solution.get(1), (double)1.0E-7);
        Assertions.assertEquals((double)4.0, (double)lagrangeInequalityMultipliers.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)0.0, (double)lagrangeInequalityMultipliers.get(1), (double)1.0E-7);
        solutionMatrix = new DMatrixRMaj(costQuadraticMatrix.getNumRows(), 1);
        solutionMatrix.set((DMatrixD1)solution);
        objectiveCost = solver.getObjectiveCost(solutionMatrix);
        Assertions.assertEquals((double)29.0, (double)objectiveCost, (double)1.0E-7);
        solver.clear();
        costQuadraticMatrix = new DMatrixRMaj((double[][])new double[][]{{2.0, 0.0}, {0.0, 2.0}});
        costLinearVector = MatrixTools.createVector((double[])new double[]{0.0, 0.0});
        quadraticCostScalar = 0.0;
        solver.setQuadraticCostFunction((DMatrix)costQuadraticMatrix, (DMatrix)costLinearVector, quadraticCostScalar);
        DMatrixRMaj linearEqualityConstraintsAMatrix = new DMatrixRMaj((double[][])new double[][]{{1.0, 1.0}});
        DMatrixRMaj linearEqualityConstraintsBVector = MatrixTools.createVector((double[])new double[]{1.0});
        solver.setLinearEqualityConstraints((DMatrix)linearEqualityConstraintsAMatrix, (DMatrix)linearEqualityConstraintsBVector);
        linearInequalityConstraintsCMatrix = new DMatrixRMaj((double[][])new double[][]{{1.0, -1.0}});
        linearInqualityConstraintsDVector = MatrixTools.createVector((double[])new double[]{-1.0});
        solver.setLinearInequalityConstraints((DMatrix)linearInequalityConstraintsCMatrix, (DMatrix)linearInqualityConstraintsDVector);
        activeVariables = MatrixTools.createVector((double[])new double[]{1.0, 0.0});
        solver.setActiveVariables((DMatrix)activeVariables);
        solution = new DMatrixRMaj(2, 1);
        lagrangeEqualityMultipliers = new DMatrixRMaj(1, 1);
        lagrangeInequalityMultipliers = new DMatrixRMaj(1, 1);
        numberOfIterations = solver.solve((DMatrix)solution);
        solver.getLagrangeEqualityConstraintMultipliers(lagrangeEqualityMultipliers);
        solver.getLagrangeInequalityConstraintMultipliers(lagrangeInequalityMultipliers);
        Assertions.assertEquals((int)2, (int)solution.getNumRows());
        Assertions.assertTrue((boolean)Double.isNaN(solution.get(0)));
        Assertions.assertTrue((boolean)Double.isNaN(solution.get(1)));
        solver.clear();
        costQuadraticMatrix = new DMatrixRMaj((double[][])new double[][]{{2.0, 0.0}, {0.0, 2.0}});
        costLinearVector = MatrixTools.createVector((double[])new double[]{0.0, 0.0});
        quadraticCostScalar = 0.0;
        solver.setQuadraticCostFunction((DMatrix)costQuadraticMatrix, (DMatrix)costLinearVector, quadraticCostScalar);
        linearEqualityConstraintsAMatrix = new DMatrixRMaj((double[][])new double[][]{{1.0, 1.0}});
        linearEqualityConstraintsBVector = MatrixTools.createVector((double[])new double[]{1.0});
        solver.setLinearEqualityConstraints((DMatrix)linearEqualityConstraintsAMatrix, (DMatrix)linearEqualityConstraintsBVector);
        linearInequalityConstraintsCMatrix = new DMatrixRMaj((double[][])new double[][]{{1.0, -1.0}});
        linearInqualityConstraintsDVector = MatrixTools.createVector((double[])new double[]{-1.0});
        solver.setLinearInequalityConstraints((DMatrix)linearInequalityConstraintsCMatrix, (DMatrix)linearInqualityConstraintsDVector);
        activeVariables = MatrixTools.createVector((double[])new double[]{0.0, 1.0});
        solver.setActiveVariables((DMatrix)activeVariables);
        solution = new DMatrixRMaj(2, 1);
        lagrangeEqualityMultipliers = new DMatrixRMaj(1, 1);
        lagrangeInequalityMultipliers = new DMatrixRMaj(1, 1);
        numberOfIterations = solver.solve((DMatrix)solution);
        solver.getLagrangeEqualityConstraintMultipliers(lagrangeEqualityMultipliers);
        solver.getLagrangeInequalityConstraintMultipliers(lagrangeInequalityMultipliers);
        Assertions.assertEquals((int)expectedNumberOfIterations, (int)numberOfIterations);
        Assertions.assertEquals((int)2, (int)solution.getNumRows());
        Assertions.assertEquals((double)0.0, (double)solution.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)1.0, (double)solution.get(1), (double)1.0E-7);
        Assertions.assertEquals((double)-2.0, (double)lagrangeEqualityMultipliers.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)0.0, (double)lagrangeInequalityMultipliers.get(0), (double)1.0E-7);
        solver.clear();
        costQuadraticMatrix = new DMatrixRMaj((double[][])new double[][]{{2.0, 0.0}, {0.0, 2.0}});
        costLinearVector = MatrixTools.createVector((double[])new double[]{0.0, 0.0});
        quadraticCostScalar = 0.0;
        solver.setQuadraticCostFunction((DMatrix)costQuadraticMatrix, (DMatrix)costLinearVector, quadraticCostScalar);
        linearEqualityConstraintsAMatrix = new DMatrixRMaj((double[][])new double[][]{{1.0, 1.0}, {3.0, -3.0}});
        linearEqualityConstraintsBVector = MatrixTools.createVector((double[])new double[]{2.0, 0.0});
        solver.setLinearEqualityConstraints((DMatrix)linearEqualityConstraintsAMatrix, (DMatrix)linearEqualityConstraintsBVector);
        linearInequalityConstraintsCMatrix = new DMatrixRMaj((double[][])new double[][]{{1.0, 0.0}, {1.0, 0.0}, {0.0, 1.0}});
        linearInqualityConstraintsDVector = MatrixTools.createVector((double[])new double[]{2.0, 10.0, 3.0});
        solver.setLinearInequalityConstraints((DMatrix)linearInequalityConstraintsCMatrix, (DMatrix)linearInqualityConstraintsDVector);
        activeVariables = MatrixTools.createVector((double[])new double[]{1.0, 0.0});
        solver.setActiveVariables((DMatrix)activeVariables);
        solution = new DMatrixRMaj(2, 1);
        lagrangeEqualityMultipliers = new DMatrixRMaj(2, 1);
        lagrangeInequalityMultipliers = new DMatrixRMaj(3, 1);
        numberOfIterations = solver.solve((DMatrix)solution);
        solver.getLagrangeEqualityConstraintMultipliers(lagrangeEqualityMultipliers);
        solver.getLagrangeInequalityConstraintMultipliers(lagrangeInequalityMultipliers);
        Assertions.assertTrue((numberOfIterations <= 1 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)solution.getNumRows());
        Assertions.assertTrue((boolean)Double.isNaN(solution.get(0)));
        Assertions.assertTrue((boolean)Double.isNaN(solution.get(1)));
    }

    @Test
    public void testSimpleCasesWithBoundsConstraintsAndInactiveVariables() {
        this.testSimpleCasesWithBoundsConstraintsAndInactiveVariables(1, 2, 3, 2, false);
    }

    public void testSimpleCasesWithBoundsConstraintsAndInactiveVariables(int expectedNumberOfIterations, int expectedNumberOfIterations2, int expectedNubmerOfIterations3, int expectedNumberOfIterations4, boolean ignoreLagrangeMultipliers) {
        ActiveSetQPSolverWithInactiveVariablesInterface solver = this.createSolverToTest();
        DMatrixRMaj costQuadraticMatrix = new DMatrixRMaj((double[][])new double[][]{{2.0}});
        DMatrixRMaj costLinearVector = MatrixTools.createVector((double[])new double[]{0.0});
        double quadraticCostScalar = 0.0;
        solver.setQuadraticCostFunction((DMatrix)costQuadraticMatrix, (DMatrix)costLinearVector, quadraticCostScalar);
        DMatrixRMaj variableLowerBounds = MatrixTools.createVector((double[])new double[]{Double.NEGATIVE_INFINITY});
        DMatrixRMaj variableUpperBounds = MatrixTools.createVector((double[])new double[]{Double.POSITIVE_INFINITY});
        solver.setVariableBounds((DMatrix)variableLowerBounds, (DMatrix)variableUpperBounds);
        DMatrixRMaj solution = new DMatrixRMaj(1, 1);
        DMatrixRMaj lagrangeEqualityMultipliers = new DMatrixRMaj(0, 1);
        DMatrixRMaj lagrangeInequalityMultipliers = new DMatrixRMaj(0, 1);
        DMatrixRMaj lagrangeLowerBoundMultipliers = new DMatrixRMaj(1, 1);
        DMatrixRMaj lagrangeUpperBoundMultipliers = new DMatrixRMaj(1, 1);
        int numberOfIterations = solver.solve((DMatrix)solution);
        numberOfIterations = solver.solve((DMatrix)solution);
        solver.getLagrangeEqualityConstraintMultipliers(lagrangeEqualityMultipliers);
        solver.getLagrangeInequalityConstraintMultipliers(lagrangeInequalityMultipliers);
        solver.getLagrangeLowerBoundsMultipliers(lagrangeLowerBoundMultipliers);
        solver.getLagrangeUpperBoundsMultipliers(lagrangeUpperBoundMultipliers);
        Assertions.assertEquals((int)expectedNumberOfIterations, (int)numberOfIterations);
        Assertions.assertEquals((int)1, (int)solution.getNumRows());
        Assertions.assertEquals((double)0.0, (double)solution.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)0.0, (double)lagrangeLowerBoundMultipliers.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)0.0, (double)lagrangeUpperBoundMultipliers.get(0), (double)1.0E-7);
        solver.clear();
        costQuadraticMatrix = new DMatrixRMaj((double[][])new double[][]{{2.0, 0.0, 0.0}, {0.0, 2.0, 0.0}, {0.0, 0.0, 2.0}});
        costLinearVector = MatrixTools.createVector((double[])new double[]{0.0, 0.0, 0.0});
        quadraticCostScalar = 0.0;
        solver.setQuadraticCostFunction((DMatrix)costQuadraticMatrix, (DMatrix)costLinearVector, quadraticCostScalar);
        DMatrixRMaj linearEqualityConstraintsAMatrix = new DMatrixRMaj((double[][])new double[][]{{1.0, 1.0, 0.0}});
        DMatrixRMaj linearEqualityConstraintsBVector = MatrixTools.createVector((double[])new double[]{2.0});
        solver.setLinearEqualityConstraints((DMatrix)linearEqualityConstraintsAMatrix, (DMatrix)linearEqualityConstraintsBVector);
        DMatrixRMaj linearInequalityConstraintsCMatrix = new DMatrixRMaj((double[][])new double[][]{{0.0, 1.0, -1.0}});
        DMatrixRMaj linearInqualityConstraintsDVector = MatrixTools.createVector((double[])new double[]{-8.0});
        solver.setLinearInequalityConstraints((DMatrix)linearInequalityConstraintsCMatrix, (DMatrix)linearInqualityConstraintsDVector);
        solver.setVariableBounds((DMatrix)MatrixTools.createVector((double[])new double[]{-5.0, 1.0, -2.0}), (DMatrix)MatrixTools.createVector((double[])new double[]{5.0, 10.0, Double.POSITIVE_INFINITY}));
        DMatrixRMaj activeVariables = MatrixTools.createVector((double[])new double[]{0.0, 1.0, 1.0});
        solver.setActiveVariables((DMatrix)activeVariables);
        solution = new DMatrixRMaj(3, 1);
        lagrangeEqualityMultipliers = new DMatrixRMaj(1, 1);
        lagrangeInequalityMultipliers = new DMatrixRMaj(1, 1);
        lagrangeLowerBoundMultipliers = new DMatrixRMaj(3, 1);
        lagrangeUpperBoundMultipliers = new DMatrixRMaj(3, 1);
        numberOfIterations = solver.solve((DMatrix)solution);
        numberOfIterations = solver.solve((DMatrix)solution);
        solver.getLagrangeEqualityConstraintMultipliers(lagrangeEqualityMultipliers);
        solver.getLagrangeInequalityConstraintMultipliers(lagrangeInequalityMultipliers);
        solver.getLagrangeLowerBoundsMultipliers(lagrangeLowerBoundMultipliers);
        solver.getLagrangeUpperBoundsMultipliers(lagrangeUpperBoundMultipliers);
        Assertions.assertEquals((int)expectedNumberOfIterations2, (int)numberOfIterations);
        Assertions.assertEquals((int)3, (int)solution.getNumRows());
        Assertions.assertEquals((double)0.0, (double)solution.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)2.0, (double)solution.get(1), (double)1.0E-7);
        Assertions.assertEquals((double)10.0, (double)solution.get(2), (double)1.0E-7);
        if (!ignoreLagrangeMultipliers) {
            Assertions.assertEquals((double)-24.0, (double)lagrangeEqualityMultipliers.get(0), (double)1.0E-7);
            Assertions.assertEquals((double)20.0, (double)lagrangeInequalityMultipliers.get(0), (double)1.0E-7);
            Assertions.assertEquals((double)0.0, (double)lagrangeLowerBoundMultipliers.get(0), (double)1.0E-7);
            Assertions.assertEquals((double)0.0, (double)lagrangeLowerBoundMultipliers.get(1), (double)1.0E-7);
            Assertions.assertEquals((double)0.0, (double)lagrangeLowerBoundMultipliers.get(2), (double)1.0E-7);
            Assertions.assertEquals((double)0.0, (double)lagrangeUpperBoundMultipliers.get(0), (double)1.0E-7);
            Assertions.assertEquals((double)0.0, (double)lagrangeUpperBoundMultipliers.get(1), (double)1.0E-7);
            Assertions.assertEquals((double)0.0, (double)lagrangeUpperBoundMultipliers.get(2), (double)1.0E-7);
        }
        DMatrixRMaj solutionMatrix = new DMatrixRMaj(costQuadraticMatrix.getNumRows(), 1);
        solutionMatrix.set((DMatrixD1)solution);
        double objectiveCost = solver.getObjectiveCost(solutionMatrix);
        Assertions.assertEquals((double)104.0, (double)objectiveCost, (double)1.0E-7);
        solver.clear();
        costQuadraticMatrix = new DMatrixRMaj((double[][])new double[][]{{2.0, 0.0, 0.0}, {0.0, 2.0, 0.0}, {0.0, 0.0, 2.0}});
        costLinearVector = MatrixTools.createVector((double[])new double[]{0.0, 0.0, 0.0});
        quadraticCostScalar = 0.0;
        solver.setQuadraticCostFunction((DMatrix)costQuadraticMatrix, (DMatrix)costLinearVector, quadraticCostScalar);
        linearEqualityConstraintsAMatrix = new DMatrixRMaj((double[][])new double[][]{{1.0, 1.0, 0.0}});
        linearEqualityConstraintsBVector = MatrixTools.createVector((double[])new double[]{2.0});
        solver.setLinearEqualityConstraints((DMatrix)linearEqualityConstraintsAMatrix, (DMatrix)linearEqualityConstraintsBVector);
        linearInequalityConstraintsCMatrix = new DMatrixRMaj((double[][])new double[][]{{0.0, 1.0, -1.0}});
        linearInqualityConstraintsDVector = MatrixTools.createVector((double[])new double[]{-8.0});
        solver.setLinearInequalityConstraints((DMatrix)linearInequalityConstraintsCMatrix, (DMatrix)linearInqualityConstraintsDVector);
        solver.setVariableBounds((DMatrix)MatrixTools.createVector((double[])new double[]{-5.0, 6.0, -2.0}), (DMatrix)MatrixTools.createVector((double[])new double[]{5.0, 10.0, Double.POSITIVE_INFINITY}));
        activeVariables = MatrixTools.createVector((double[])new double[]{1.0, 0.0, 1.0});
        solver.setActiveVariables((DMatrix)activeVariables);
        solution = new DMatrixRMaj(3, 1);
        lagrangeEqualityMultipliers = new DMatrixRMaj(1, 1);
        lagrangeInequalityMultipliers = new DMatrixRMaj(1, 1);
        lagrangeLowerBoundMultipliers = new DMatrixRMaj(3, 1);
        lagrangeUpperBoundMultipliers = new DMatrixRMaj(3, 1);
        numberOfIterations = solver.solve((DMatrix)solution);
        numberOfIterations = solver.solve((DMatrix)solution);
        solver.getLagrangeEqualityConstraintMultipliers(lagrangeEqualityMultipliers);
        solver.getLagrangeInequalityConstraintMultipliers(lagrangeInequalityMultipliers);
        solver.getLagrangeLowerBoundsMultipliers(lagrangeLowerBoundMultipliers);
        solver.getLagrangeUpperBoundsMultipliers(lagrangeUpperBoundMultipliers);
        Assertions.assertEquals((int)expectedNumberOfIterations2, (int)numberOfIterations);
        Assertions.assertEquals((int)3, (int)solution.getNumRows());
        Assertions.assertEquals((double)2.0, (double)solution.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)0.0, (double)solution.get(1), (double)1.0E-7);
        Assertions.assertEquals((double)8.0, (double)solution.get(2), (double)1.0E-7);
        if (!ignoreLagrangeMultipliers) {
            Assertions.assertEquals((double)-4.0, (double)lagrangeEqualityMultipliers.get(0), (double)1.0E-7);
            Assertions.assertEquals((double)16.0, (double)lagrangeInequalityMultipliers.get(0), (double)1.0E-7);
            Assertions.assertEquals((double)0.0, (double)lagrangeLowerBoundMultipliers.get(0), (double)1.0E-7);
            Assertions.assertEquals((double)0.0, (double)lagrangeLowerBoundMultipliers.get(1), (double)1.0E-7);
            Assertions.assertEquals((double)0.0, (double)lagrangeLowerBoundMultipliers.get(2), (double)1.0E-7);
            Assertions.assertEquals((double)0.0, (double)lagrangeUpperBoundMultipliers.get(0), (double)1.0E-7);
            Assertions.assertEquals((double)0.0, (double)lagrangeUpperBoundMultipliers.get(1), (double)1.0E-7);
            Assertions.assertEquals((double)0.0, (double)lagrangeUpperBoundMultipliers.get(2), (double)1.0E-7);
        }
        solutionMatrix = new DMatrixRMaj(costQuadraticMatrix.getNumRows(), 1);
        solutionMatrix.set((DMatrixD1)solution);
        objectiveCost = solver.getObjectiveCost(solutionMatrix);
        Assertions.assertEquals((double)68.0, (double)objectiveCost, (double)1.0E-7);
        solver.clear();
        costQuadraticMatrix = new DMatrixRMaj((double[][])new double[][]{{2.0, 0.0, 0.0}, {0.0, 2.0, 0.0}, {0.0, 0.0, 2.0}});
        costLinearVector = MatrixTools.createVector((double[])new double[]{0.0, 0.0, 0.0});
        quadraticCostScalar = 0.0;
        solver.setQuadraticCostFunction((DMatrix)costQuadraticMatrix, (DMatrix)costLinearVector, quadraticCostScalar);
        linearEqualityConstraintsAMatrix = new DMatrixRMaj((double[][])new double[][]{{1.0, 1.0, 0.0}});
        linearEqualityConstraintsBVector = MatrixTools.createVector((double[])new double[]{2.0});
        solver.setLinearEqualityConstraints((DMatrix)linearEqualityConstraintsAMatrix, (DMatrix)linearEqualityConstraintsBVector);
        linearInequalityConstraintsCMatrix = new DMatrixRMaj((double[][])new double[][]{{0.0, 1.0, -1.0}});
        linearInqualityConstraintsDVector = MatrixTools.createVector((double[])new double[]{-8.0});
        solver.setLinearInequalityConstraints((DMatrix)linearInequalityConstraintsCMatrix, (DMatrix)linearInqualityConstraintsDVector);
        solver.setVariableBounds((DMatrix)MatrixTools.createVector((double[])new double[]{-5.0, 6.0, -2.0}), (DMatrix)MatrixTools.createVector((double[])new double[]{5.0, 10.0, Double.POSITIVE_INFINITY}));
        activeVariables = MatrixTools.createVector((double[])new double[]{1.0, 1.0, 0.0});
        solver.setActiveVariables((DMatrix)activeVariables);
        solution = new DMatrixRMaj(3, 1);
        lagrangeEqualityMultipliers = new DMatrixRMaj(1, 1);
        lagrangeInequalityMultipliers = new DMatrixRMaj(1, 1);
        lagrangeLowerBoundMultipliers = new DMatrixRMaj(3, 1);
        lagrangeUpperBoundMultipliers = new DMatrixRMaj(3, 1);
        numberOfIterations = solver.solve((DMatrix)solution);
        numberOfIterations = solver.solve((DMatrix)solution);
        solver.getLagrangeEqualityConstraintMultipliers(lagrangeEqualityMultipliers);
        solver.getLagrangeInequalityConstraintMultipliers(lagrangeInequalityMultipliers);
        solver.getLagrangeLowerBoundsMultipliers(lagrangeLowerBoundMultipliers);
        solver.getLagrangeUpperBoundsMultipliers(lagrangeUpperBoundMultipliers);
        Assertions.assertEquals((int)expectedNumberOfIterations2, (int)numberOfIterations);
        Assertions.assertEquals((int)3, (int)solution.getNumRows());
        Assertions.assertTrue((boolean)Double.isNaN(solution.get(0)));
        Assertions.assertTrue((boolean)Double.isNaN(solution.get(1)));
        Assertions.assertTrue((boolean)Double.isNaN(solution.get(2)));
        solver.clear();
        costQuadraticMatrix = new DMatrixRMaj((double[][])new double[][]{{2.0, 0.0, 0.0}, {0.0, 2.0, 0.0}, {0.0, 0.0, 2.0}});
        costLinearVector = MatrixTools.createVector((double[])new double[]{0.0, 0.0, 0.0});
        quadraticCostScalar = 0.0;
        solver.setQuadraticCostFunction((DMatrix)costQuadraticMatrix, (DMatrix)costLinearVector, quadraticCostScalar);
        linearEqualityConstraintsAMatrix = new DMatrixRMaj((double[][])new double[][]{{1.0, 1.0, 0.0}});
        linearEqualityConstraintsBVector = MatrixTools.createVector((double[])new double[]{2.0});
        solver.setLinearEqualityConstraints((DMatrix)linearEqualityConstraintsAMatrix, (DMatrix)linearEqualityConstraintsBVector);
        linearInequalityConstraintsCMatrix = new DMatrixRMaj((double[][])new double[][]{{0.0, 1.0, -1.0}});
        linearInqualityConstraintsDVector = MatrixTools.createVector((double[])new double[]{-8.0});
        solver.setLinearInequalityConstraints((DMatrix)linearInequalityConstraintsCMatrix, (DMatrix)linearInqualityConstraintsDVector);
        solver.setVariableBounds((DMatrix)MatrixTools.createVector((double[])new double[]{-5.0, 6.0, -2.0}), (DMatrix)MatrixTools.createVector((double[])new double[]{5.0, 10.0, Double.POSITIVE_INFINITY}));
        activeVariables = MatrixTools.createVector((double[])new double[]{1.0, 0.0, 0.0});
        solver.setActiveVariables((DMatrix)activeVariables);
        solution = new DMatrixRMaj(3, 1);
        lagrangeEqualityMultipliers = new DMatrixRMaj(1, 1);
        lagrangeInequalityMultipliers = new DMatrixRMaj(1, 1);
        lagrangeLowerBoundMultipliers = new DMatrixRMaj(3, 1);
        lagrangeUpperBoundMultipliers = new DMatrixRMaj(3, 1);
        numberOfIterations = solver.solve((DMatrix)solution);
        numberOfIterations = solver.solve((DMatrix)solution);
        solver.getLagrangeEqualityConstraintMultipliers(lagrangeEqualityMultipliers);
        solver.getLagrangeInequalityConstraintMultipliers(lagrangeInequalityMultipliers);
        solver.getLagrangeLowerBoundsMultipliers(lagrangeLowerBoundMultipliers);
        solver.getLagrangeUpperBoundsMultipliers(lagrangeUpperBoundMultipliers);
        Assertions.assertEquals((int)expectedNumberOfIterations, (int)numberOfIterations);
        Assertions.assertEquals((int)3, (int)solution.getNumRows());
        Assertions.assertEquals((double)2.0, (double)solution.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)0.0, (double)solution.get(1), (double)1.0E-7);
        Assertions.assertEquals((double)0.0, (double)solution.get(2), (double)1.0E-7);
        if (!ignoreLagrangeMultipliers) {
            Assertions.assertEquals((double)-4.0, (double)lagrangeEqualityMultipliers.get(0), (double)1.0E-7);
            Assertions.assertEquals((double)0.0, (double)lagrangeInequalityMultipliers.get(0), (double)1.0E-7);
            Assertions.assertEquals((double)0.0, (double)lagrangeLowerBoundMultipliers.get(0), (double)1.0E-7);
            Assertions.assertEquals((double)0.0, (double)lagrangeLowerBoundMultipliers.get(1), (double)1.0E-7);
            Assertions.assertEquals((double)0.0, (double)lagrangeLowerBoundMultipliers.get(2), (double)1.0E-7);
            Assertions.assertEquals((double)0.0, (double)lagrangeUpperBoundMultipliers.get(0), (double)1.0E-7);
            Assertions.assertEquals((double)0.0, (double)lagrangeUpperBoundMultipliers.get(1), (double)1.0E-7);
            Assertions.assertEquals((double)0.0, (double)lagrangeUpperBoundMultipliers.get(2), (double)1.0E-7);
        }
        solutionMatrix = new DMatrixRMaj(costQuadraticMatrix.getNumRows(), 1);
        solutionMatrix.set((DMatrixD1)solution);
        objectiveCost = solver.getObjectiveCost(solutionMatrix);
        Assertions.assertEquals((double)4.0, (double)objectiveCost, (double)1.0E-7);
        solver.clear();
        costQuadraticMatrix = new DMatrixRMaj((double[][])new double[][]{{2.0, 0.0, 0.0}, {0.0, 2.0, 0.0}, {0.0, 0.0, 2.0}});
        costLinearVector = MatrixTools.createVector((double[])new double[]{0.0, 0.0, 0.0});
        quadraticCostScalar = 0.0;
        solver.setQuadraticCostFunction((DMatrix)costQuadraticMatrix, (DMatrix)costLinearVector, quadraticCostScalar);
        linearEqualityConstraintsAMatrix = new DMatrixRMaj((double[][])new double[][]{{1.0, 1.0, 0.0}});
        linearEqualityConstraintsBVector = MatrixTools.createVector((double[])new double[]{2.0});
        solver.setLinearEqualityConstraints((DMatrix)linearEqualityConstraintsAMatrix, (DMatrix)linearEqualityConstraintsBVector);
        linearInequalityConstraintsCMatrix = new DMatrixRMaj((double[][])new double[][]{{0.0, 1.0, -1.0}});
        linearInqualityConstraintsDVector = MatrixTools.createVector((double[])new double[]{-8.0});
        solver.setLinearInequalityConstraints((DMatrix)linearInequalityConstraintsCMatrix, (DMatrix)linearInqualityConstraintsDVector);
        solver.setVariableBounds((DMatrix)MatrixTools.createVector((double[])new double[]{-5.0, 6.0, -2.0}), (DMatrix)MatrixTools.createVector((double[])new double[]{5.0, 10.0, Double.POSITIVE_INFINITY}));
        activeVariables = MatrixTools.createVector((double[])new double[]{0.0, 1.0, 0.0});
        solver.setActiveVariables((DMatrix)activeVariables);
        solution = new DMatrixRMaj(3, 1);
        lagrangeEqualityMultipliers = new DMatrixRMaj(1, 1);
        lagrangeInequalityMultipliers = new DMatrixRMaj(1, 1);
        lagrangeLowerBoundMultipliers = new DMatrixRMaj(3, 1);
        lagrangeUpperBoundMultipliers = new DMatrixRMaj(3, 1);
        numberOfIterations = solver.solve((DMatrix)solution);
        numberOfIterations = solver.solve((DMatrix)solution);
        solver.getLagrangeEqualityConstraintMultipliers(lagrangeEqualityMultipliers);
        solver.getLagrangeInequalityConstraintMultipliers(lagrangeInequalityMultipliers);
        solver.getLagrangeLowerBoundsMultipliers(lagrangeLowerBoundMultipliers);
        solver.getLagrangeUpperBoundsMultipliers(lagrangeUpperBoundMultipliers);
        Assertions.assertEquals((int)expectedNumberOfIterations4, (int)numberOfIterations);
        Assertions.assertEquals((int)3, (int)solution.getNumRows());
        Assertions.assertTrue((boolean)Double.isNaN(solution.get(0)));
        Assertions.assertTrue((boolean)Double.isNaN(solution.get(1)));
        Assertions.assertTrue((boolean)Double.isNaN(solution.get(2)));
        solver.clear();
        costQuadraticMatrix = new DMatrixRMaj((double[][])new double[][]{{2.0, 0.0, 0.0}, {0.0, 2.0, 0.0}, {0.0, 0.0, 2.0}});
        costLinearVector = MatrixTools.createVector((double[])new double[]{0.0, 0.0, 0.0});
        quadraticCostScalar = 0.0;
        solver.setQuadraticCostFunction((DMatrix)costQuadraticMatrix, (DMatrix)costLinearVector, quadraticCostScalar);
        linearEqualityConstraintsAMatrix = new DMatrixRMaj((double[][])new double[][]{{1.0, 1.0, 0.0}});
        linearEqualityConstraintsBVector = MatrixTools.createVector((double[])new double[]{2.0});
        solver.setLinearEqualityConstraints((DMatrix)linearEqualityConstraintsAMatrix, (DMatrix)linearEqualityConstraintsBVector);
        linearInequalityConstraintsCMatrix = new DMatrixRMaj((double[][])new double[][]{{0.0, 1.0, -1.0}});
        linearInqualityConstraintsDVector = MatrixTools.createVector((double[])new double[]{-8.0});
        solver.setLinearInequalityConstraints((DMatrix)linearInequalityConstraintsCMatrix, (DMatrix)linearInqualityConstraintsDVector);
        solver.setVariableBounds((DMatrix)MatrixTools.createVector((double[])new double[]{-5.0, 6.0, -2.0}), (DMatrix)MatrixTools.createVector((double[])new double[]{5.0, 10.0, Double.POSITIVE_INFINITY}));
        activeVariables = MatrixTools.createVector((double[])new double[]{0.0, 0.0, 1.0});
        solver.setActiveVariables((DMatrix)activeVariables);
        solution = new DMatrixRMaj(3, 1);
        lagrangeEqualityMultipliers = new DMatrixRMaj(1, 1);
        lagrangeInequalityMultipliers = new DMatrixRMaj(1, 1);
        lagrangeLowerBoundMultipliers = new DMatrixRMaj(3, 1);
        lagrangeUpperBoundMultipliers = new DMatrixRMaj(3, 1);
        numberOfIterations = solver.solve((DMatrix)solution);
        numberOfIterations = solver.solve((DMatrix)solution);
        solver.getLagrangeEqualityConstraintMultipliers(lagrangeEqualityMultipliers);
        solver.getLagrangeInequalityConstraintMultipliers(lagrangeInequalityMultipliers);
        solver.getLagrangeLowerBoundsMultipliers(lagrangeLowerBoundMultipliers);
        solver.getLagrangeUpperBoundsMultipliers(lagrangeUpperBoundMultipliers);
        Assertions.assertEquals((int)expectedNumberOfIterations2, (int)numberOfIterations);
        Assertions.assertEquals((int)3, (int)solution.getNumRows());
        Assertions.assertEquals((double)0.0, (double)solution.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)0.0, (double)solution.get(1), (double)1.0E-7);
        Assertions.assertEquals((double)8.0, (double)solution.get(2), (double)1.0E-7);
        if (!ignoreLagrangeMultipliers) {
            Assertions.assertEquals((double)0.0, (double)lagrangeEqualityMultipliers.get(0), (double)1.0E-7);
            Assertions.assertEquals((double)16.0, (double)lagrangeInequalityMultipliers.get(0), (double)1.0E-7);
            Assertions.assertEquals((double)0.0, (double)lagrangeLowerBoundMultipliers.get(0), (double)1.0E-7);
            Assertions.assertEquals((double)0.0, (double)lagrangeLowerBoundMultipliers.get(1), (double)1.0E-7);
            Assertions.assertEquals((double)0.0, (double)lagrangeLowerBoundMultipliers.get(2), (double)1.0E-7);
            Assertions.assertEquals((double)0.0, (double)lagrangeUpperBoundMultipliers.get(0), (double)1.0E-7);
            Assertions.assertEquals((double)0.0, (double)lagrangeUpperBoundMultipliers.get(1), (double)1.0E-7);
            Assertions.assertEquals((double)0.0, (double)lagrangeUpperBoundMultipliers.get(2), (double)1.0E-7);
        }
        solutionMatrix = new DMatrixRMaj(costQuadraticMatrix.getNumRows(), 1);
        solutionMatrix.set((DMatrixD1)solution);
        objectiveCost = solver.getObjectiveCost(solutionMatrix);
        Assertions.assertEquals((double)64.0, (double)objectiveCost, (double)1.0E-7);
        solver.clear();
        costQuadraticMatrix = new DMatrixRMaj((double[][])new double[][]{{2.0, 0.0, 0.0}, {0.0, 2.0, 0.0}, {0.0, 0.0, 2.0}});
        costLinearVector = MatrixTools.createVector((double[])new double[]{0.0, 0.0, 0.0});
        quadraticCostScalar = 0.0;
        solver.setQuadraticCostFunction((DMatrix)costQuadraticMatrix, (DMatrix)costLinearVector, quadraticCostScalar);
        linearEqualityConstraintsAMatrix = new DMatrixRMaj((double[][])new double[][]{{1.0, 1.0, 0.0}});
        linearEqualityConstraintsBVector = MatrixTools.createVector((double[])new double[]{2.0});
        solver.setLinearEqualityConstraints((DMatrix)linearEqualityConstraintsAMatrix, (DMatrix)linearEqualityConstraintsBVector);
        linearInequalityConstraintsCMatrix = new DMatrixRMaj((double[][])new double[][]{{0.0, 1.0, -1.0}});
        linearInqualityConstraintsDVector = MatrixTools.createVector((double[])new double[]{-8.0});
        solver.setLinearInequalityConstraints((DMatrix)linearInequalityConstraintsCMatrix, (DMatrix)linearInqualityConstraintsDVector);
        solver.setVariableBounds((DMatrix)MatrixTools.createVector((double[])new double[]{3.0, 6.0, 11.0}), (DMatrix)MatrixTools.createVector((double[])new double[]{5.0, 10.0, Double.POSITIVE_INFINITY}));
        solution = new DMatrixRMaj(3, 1);
        lagrangeEqualityMultipliers = new DMatrixRMaj(1, 1);
        lagrangeInequalityMultipliers = new DMatrixRMaj(1, 1);
        lagrangeLowerBoundMultipliers = new DMatrixRMaj(3, 1);
        lagrangeUpperBoundMultipliers = new DMatrixRMaj(3, 1);
        numberOfIterations = solver.solve((DMatrix)solution);
        numberOfIterations = solver.solve((DMatrix)solution);
        solver.getLagrangeEqualityConstraintMultipliers(lagrangeEqualityMultipliers);
        solver.getLagrangeInequalityConstraintMultipliers(lagrangeInequalityMultipliers);
        solver.getLagrangeLowerBoundsMultipliers(lagrangeLowerBoundMultipliers);
        solver.getLagrangeUpperBoundsMultipliers(lagrangeUpperBoundMultipliers);
        Assertions.assertEquals((int)expectedNubmerOfIterations3, (int)numberOfIterations);
        Assertions.assertEquals((int)3, (int)solution.getNumRows());
        Assertions.assertTrue((boolean)Double.isNaN(solution.get(0)));
        Assertions.assertTrue((boolean)Double.isNaN(solution.get(1)));
        Assertions.assertTrue((boolean)Double.isNaN(solution.get(2)));
        solutionMatrix = new DMatrixRMaj(costQuadraticMatrix.getNumRows(), 1);
        solutionMatrix.set((DMatrixD1)solution);
        objectiveCost = solver.getObjectiveCost(solutionMatrix);
        Assertions.assertTrue((boolean)Double.isNaN(objectiveCost));
    }

    private void verifyEqualityConstraintsHold(int numberOfEqualityConstraints, DMatrixRMaj linearEqualityConstraintsAMatrix, DMatrixRMaj linearEqualityConstraintsBVector, DMatrixRMaj solutionMatrix) {
        double maxAbsoluteError = this.getMaxEqualityConstraintError(numberOfEqualityConstraints, linearEqualityConstraintsAMatrix, linearEqualityConstraintsBVector, solutionMatrix);
        Assertions.assertEquals((double)0.0, (double)maxAbsoluteError, (double)1.0E-5);
    }

    private void verifyInequalityConstraintsHold(int numberOfEqualityConstraints, DMatrixRMaj linearInequalityConstraintsCMatrix, DMatrixRMaj linearInequalityConstraintsDVector, DMatrixRMaj solutionMatrix) {
        double maxSignedError = this.getMaxInequalityConstraintError(numberOfEqualityConstraints, linearInequalityConstraintsCMatrix, linearInequalityConstraintsDVector, solutionMatrix);
        Assertions.assertTrue((maxSignedError < 1.0E-10 ? 1 : 0) != 0);
    }

    private void verifyEqualityConstraintsDoNotHold(int numberOfEqualityConstraints, DMatrixRMaj linearEqualityConstraintsAMatrix, DMatrixRMaj linearEqualityConstraintsBVector, DMatrixRMaj solutionMatrix) {
        double maxAbsoluteError = this.getMaxEqualityConstraintError(numberOfEqualityConstraints, linearEqualityConstraintsAMatrix, linearEqualityConstraintsBVector, solutionMatrix);
        Assertions.assertTrue((maxAbsoluteError > 1.0E-5 ? 1 : 0) != 0);
    }

    private void verifyInequalityConstraintsDoNotHold(int numberOfInequalityConstraints, DMatrixRMaj linearInequalityConstraintsCMatrix, DMatrixRMaj linearInequalityConstraintsDVector, DMatrixRMaj solutionMatrix) {
        double maxError = this.getMaxInequalityConstraintError(numberOfInequalityConstraints, linearInequalityConstraintsCMatrix, linearInequalityConstraintsDVector, solutionMatrix);
        Assertions.assertTrue((maxError > 1.0E-5 ? 1 : 0) != 0);
    }

    private void verifyVariableBoundsHold(int testNumber, DMatrixRMaj variableLowerBounds, DMatrixRMaj variableUpperBounds, DMatrixRMaj solution) {
        int i;
        for (i = 0; i < variableLowerBounds.getNumRows(); ++i) {
            Assertions.assertTrue((solution.get(i, 0) >= variableLowerBounds.get(i, 0) - 1.0E-7 ? 1 : 0) != 0, (String)("In test number " + testNumber + " the solution " + solution.get(i, 0) + " is less than the lower bound " + variableLowerBounds.get(i, 0)));
        }
        for (i = 0; i < variableUpperBounds.getNumRows(); ++i) {
            Assertions.assertTrue((solution.get(i, 0) <= variableUpperBounds.get(i, 0) + 1.0E-7 ? 1 : 0) != 0);
        }
    }

    private double getMaxEqualityConstraintError(int numberOfEqualityConstraints, DMatrixRMaj linearEqualityConstraintsAMatrix, DMatrixRMaj linearEqualityConstraintsBVector, DMatrixRMaj solutionMatrix) {
        DMatrixRMaj checkMatrix = new DMatrixRMaj(numberOfEqualityConstraints, 1);
        CommonOps_DDRM.mult((DMatrix1Row)linearEqualityConstraintsAMatrix, (DMatrix1Row)solutionMatrix, (DMatrix1Row)checkMatrix);
        CommonOps_DDRM.subtractEquals((DMatrixD1)checkMatrix, (DMatrixD1)linearEqualityConstraintsBVector);
        return this.getMaxAbsoluteDataEntry(checkMatrix);
    }

    private double getMaxInequalityConstraintError(int numberOfInequalityConstraints, DMatrixRMaj linearInequalityConstraintsCMatrix, DMatrixRMaj linearInequalityConstraintsDVector, DMatrixRMaj solutionMatrix) {
        DMatrixRMaj checkMatrix = new DMatrixRMaj(numberOfInequalityConstraints, 1);
        CommonOps_DDRM.mult((DMatrix1Row)linearInequalityConstraintsCMatrix, (DMatrix1Row)solutionMatrix, (DMatrix1Row)checkMatrix);
        CommonOps_DDRM.subtractEquals((DMatrixD1)checkMatrix, (DMatrixD1)linearInequalityConstraintsDVector);
        return this.getMaxSignedDataEntry(checkMatrix);
    }

    private DMatrixRMaj projectOntoEqualityConstraints(DMatrixRMaj solutionMatrix, DMatrixRMaj linearEqualityConstraintsAMatrix, DMatrixRMaj linearEqualityConstraintsBVector) {
        int numberOfVariables = solutionMatrix.getNumRows();
        if (linearEqualityConstraintsAMatrix.getNumCols() != numberOfVariables) {
            throw new RuntimeException();
        }
        int numberOfConstraints = linearEqualityConstraintsAMatrix.getNumRows();
        if (linearEqualityConstraintsBVector.getNumRows() != numberOfConstraints) {
            throw new RuntimeException();
        }
        DMatrixRMaj AZMinusB = new DMatrixRMaj(numberOfConstraints, 1);
        CommonOps_DDRM.mult((DMatrix1Row)linearEqualityConstraintsAMatrix, (DMatrix1Row)solutionMatrix, (DMatrix1Row)AZMinusB);
        CommonOps_DDRM.subtractEquals((DMatrixD1)AZMinusB, (DMatrixD1)linearEqualityConstraintsBVector);
        DMatrixRMaj AATransposeInverse = new DMatrixRMaj(numberOfConstraints, numberOfConstraints);
        DMatrixRMaj linearEqualityConstraintsAMatrixTranspose = new DMatrixRMaj(linearEqualityConstraintsAMatrix);
        CommonOps_DDRM.transpose((DMatrixRMaj)linearEqualityConstraintsAMatrixTranspose);
        CommonOps_DDRM.mult((DMatrix1Row)linearEqualityConstraintsAMatrix, (DMatrix1Row)linearEqualityConstraintsAMatrixTranspose, (DMatrix1Row)AATransposeInverse);
        CommonOps_DDRM.invert((DMatrixRMaj)AATransposeInverse);
        DMatrixRMaj ATransposeAATransposeInverse = new DMatrixRMaj(numberOfVariables, numberOfConstraints);
        CommonOps_DDRM.mult((DMatrix1Row)linearEqualityConstraintsAMatrixTranspose, (DMatrix1Row)AATransposeInverse, (DMatrix1Row)ATransposeAATransposeInverse);
        DMatrixRMaj vectorToSubtract = new DMatrixRMaj(numberOfVariables, 1);
        CommonOps_DDRM.mult((DMatrix1Row)ATransposeAATransposeInverse, (DMatrix1Row)AZMinusB, (DMatrix1Row)vectorToSubtract);
        DMatrixRMaj projectedSolutionMatrix = new DMatrixRMaj(solutionMatrix);
        CommonOps_DDRM.subtractEquals((DMatrixD1)projectedSolutionMatrix, (DMatrixD1)vectorToSubtract);
        return projectedSolutionMatrix;
    }

    private double getMaxAbsoluteDataEntry(DMatrixRMaj matrix) {
        int numberOfRows = matrix.getNumRows();
        int numberOfColumns = matrix.getNumCols();
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < numberOfRows; ++i) {
            for (int j = 0; j < numberOfColumns; ++j) {
                double absoluteValue = Math.abs(matrix.get(i, j));
                if (!(absoluteValue > max)) continue;
                max = absoluteValue;
            }
        }
        return max;
    }

    private double getMaxSignedDataEntry(DMatrixRMaj matrix) {
        int numberOfRows = matrix.getNumRows();
        int numberOfColumns = matrix.getNumCols();
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < numberOfRows; ++i) {
            for (int j = 0; j < numberOfColumns; ++j) {
                double value = matrix.get(i, j);
                if (!(value > max)) continue;
                max = value;
            }
        }
        return max;
    }
}

