/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.convexOptimization.linearProgram;

import gnu.trove.TIntCollection;
import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.list.array.TIntArrayList;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.convexOptimization.linearProgram.DictionaryFormLinearProgramSolver;
import us.ihmc.convexOptimization.linearProgram.LinearProgramSolver;
import us.ihmc.euclid.tools.EuclidCoreTools;

public class DictionaryFormLinearProgramSolverTest {
    private static final double epsilon = 1.0E-5;

    @Test
    public void testDictionary0() {
        DMatrixRMaj dictionary = new DMatrixRMaj(new double[]{0.0, 3.0, 4.0, 2.0, 4.0, -2.0, 0.0, 0.0, 8.0, -1.0, 0.0, -2.0, 6.0, 0.0, -3.0, -1.0});
        dictionary.reshape(4, 4);
        TDoubleArrayList expectedSolution = new TDoubleArrayList(new double[]{2.0, 1.0, 3.0});
        DictionaryFormLinearProgramSolverTest.runTest(dictionary, expectedSolution);
    }

    @Test
    public void testDictionary1() {
        DMatrixRMaj dictionary = new DMatrixRMaj(new double[]{0.0, 1.0, -2.0, 1.0, 0.0, -2.0, 1.0, -1.0, 0.0, -3.0, -1.0, -1.0, 0.0, 5.0, -3.0, 2.0});
        dictionary.reshape(4, 4);
        TDoubleArrayList expectedSolution = new TDoubleArrayList(new double[]{0.0, 0.0, 0.0});
        DictionaryFormLinearProgramSolverTest.runTest(dictionary, expectedSolution);
    }

    @Test
    public void testDictionary2() {
        DMatrixRMaj dictionary = new DMatrixRMaj(new double[]{0.0, 1.0, 2.01, 4.0, -1.0, 0.0, 2.0, 0.0, -1.0, 6.0, -1.0, -2.0});
        dictionary.reshape(4, 3);
        TDoubleArrayList expectedSolution = new TDoubleArrayList(new double[]{2.0, 2.0});
        DictionaryFormLinearProgramSolverTest.runTest(dictionary, expectedSolution);
    }

    @Test
    public void testDictionary3() {
        DMatrixRMaj dictionary = new DMatrixRMaj(new double[]{0.0, 1.0, 1.99, 4.0, -1.0, 0.0, 2.0, 0.0, -1.0, 6.0, -1.0, -2.0});
        dictionary.reshape(4, 3);
        TDoubleArrayList expectedSolution = new TDoubleArrayList(new double[]{4.0, 1.0});
        DictionaryFormLinearProgramSolverTest.runTest(dictionary, expectedSolution);
    }

    @Test
    public void testDictionary4() {
        DMatrixRMaj dictionary = new DMatrixRMaj(new double[]{0.0, 1.0, -0.01, 4.0, -1.0, 0.0, 2.0, 0.0, -1.0, 6.0, -1.0, -2.0});
        dictionary.reshape(4, 3);
        TDoubleArrayList expectedSolution = new TDoubleArrayList(new double[]{4.0, 0.0});
        DictionaryFormLinearProgramSolverTest.runTest(dictionary, expectedSolution);
    }

    @Test
    public void testDictionary5() {
        DMatrixRMaj dictionary = new DMatrixRMaj(new double[]{0.0, -0.01, 1.0, 4.0, -1.0, 0.0, 2.0, 0.0, -1.0, 6.0, -1.0, -2.0});
        dictionary.reshape(4, 3);
        TDoubleArrayList expectedSolution = new TDoubleArrayList(new double[]{0.0, 2.0});
        DictionaryFormLinearProgramSolverTest.runTest(dictionary, expectedSolution);
    }

    @Test
    public void testDictionary6() {
        DMatrixRMaj dictionary = new DMatrixRMaj(new double[]{0.0, 2.1, 1.0, 2.0, -1.0, -1.0, -1.0, 1.0, 1.0});
        dictionary.reshape(3, 3);
        TDoubleArrayList expectedSolution = new TDoubleArrayList(new double[]{2.0, 0.0});
        DictionaryFormLinearProgramSolverTest.runTest(dictionary, expectedSolution);
    }

    @Test
    public void testFixedBasisToyProblem() {
        DMatrixRMaj Ain = new DMatrixRMaj(3, 2);
        Ain.set(0, 0, 1.0);
        Ain.set(1, 1, 1.0);
        Ain.set(2, 0, 1.0);
        Ain.set(2, 1, 1.0);
        DMatrixRMaj b = new DMatrixRMaj(3, 1);
        b.set(0, 0, 2.0);
        b.set(1, 0, 2.0);
        b.set(2, 0, 3.0);
        DMatrixRMaj c = new DMatrixRMaj(2, 1);
        c.set(0, 0, 2.0);
        c.set(1, 0, 1.0);
        DMatrixRMaj solution = new DMatrixRMaj(0);
        LinearProgramSolver solver = new LinearProgramSolver();
        solver.solve(c, Ain, b, solution);
        System.out.println(solution);
        TIntArrayList basisIndices = new TIntArrayList((TIntCollection)solver.getBasisIndices());
        double alpha1 = 0.1;
        double alpha2 = -0.1;
        DMatrixRMaj AinModified = new DMatrixRMaj(Ain);
        AinModified.set(2, 0, 1.0 + alpha1);
        AinModified.set(2, 1, 1.0 + alpha2);
        DMatrixRMaj solutionModified = new DMatrixRMaj(0);
        solver.solveForFixedBasis(AinModified, b, basisIndices, solutionModified);
    }

    private static void solveFixedBasisToyProblemDirectly() {
        DMatrixRMaj dictionary0 = new DMatrixRMaj(new double[]{0.0, 2.0, 1.0, 2.0, -1.0, 0.0, 2.0, 0.0, -1.0, 3.0, -1.0, -1.0});
        dictionary0.reshape(4, 3);
        TDoubleArrayList solution0 = new TDoubleArrayList(new double[]{2.0, 1.0});
        DictionaryFormLinearProgramSolverTest.runTest(dictionary0, solution0);
        double alpha1 = 0.1;
        double alpha2 = -0.1;
        DMatrixRMaj A_basis = new DMatrixRMaj(new double[]{1.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0 + alpha1, 1.0 + alpha2, 0.0});
        A_basis.reshape(3, 3);
        DMatrixRMaj A_basis_inv = new DMatrixRMaj(0);
        CommonOps_DDRM.invert((DMatrixRMaj)A_basis, (DMatrixRMaj)A_basis_inv);
        DMatrixRMaj b = new DMatrixRMaj(3, 1);
        b.setData(new double[]{2.0, 2.0, 3.0});
        DMatrixRMaj x_basis = new DMatrixRMaj(3, 1);
        CommonOps_DDRM.mult((DMatrix1Row)A_basis_inv, (DMatrix1Row)b, (DMatrix1Row)x_basis);
        System.out.println("x_basis:");
        System.out.println(x_basis);
        DMatrixRMaj dictionary1 = new DMatrixRMaj(dictionary0);
        dictionary1.set(3, 1, -1.0 - alpha1);
        dictionary1.set(3, 2, -1.0 - alpha2);
        DictionaryFormLinearProgramSolver solver = new DictionaryFormLinearProgramSolver();
        solver.solveSimplex(dictionary1);
        System.out.println("with solver:");
        System.out.println(solver.getSolution());
    }

    private static void runTest(DMatrixRMaj dictionary, TDoubleArrayList expectedSolution) {
        boolean equal;
        int i;
        DictionaryFormLinearProgramSolver solver = new DictionaryFormLinearProgramSolver();
        solver.solveCrissCross(dictionary);
        Assertions.assertTrue((boolean)solver.getCrissCrossStatistics().foundSolution());
        for (i = 0; i < expectedSolution.size(); ++i) {
            equal = EuclidCoreTools.epsilonEquals((double)solver.getSolution().get(i), (double)expectedSolution.get(i), (double)1.0E-5);
            Assertions.assertTrue((boolean)equal, (String)"Criss-cross has invalid solution");
        }
        solver.solveSimplex(dictionary);
        Assertions.assertTrue((boolean)solver.getSimplexStatistics().foundSolution());
        for (i = 0; i < expectedSolution.size(); ++i) {
            equal = EuclidCoreTools.epsilonEquals((double)solver.getSolution().get(i), (double)expectedSolution.get(i), (double)1.0E-5);
            Assertions.assertTrue((boolean)equal, (String)"Simplex has invalid solution");
        }
    }

    public static void main(String[] args) {
        DictionaryFormLinearProgramSolverTest.solveFixedBasisToyProblemDirectly();
    }
}

