/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.convexOptimization.quadraticProgram;

import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.RandomMatrices_DDRM;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.convexOptimization.exceptions.NoConvergenceException;
import us.ihmc.convexOptimization.quadraticProgram.ActiveSetQPSolver;
import us.ihmc.convexOptimization.quadraticProgram.ActualDatasetFrom20160319;
import us.ihmc.convexOptimization.quadraticProgram.ActualDatasetFromKiwi20170712;
import us.ihmc.convexOptimization.quadraticProgram.ActualDatasetFromKiwi20171013;
import us.ihmc.matrixlib.MatrixTools;

public abstract class AbstractSimpleActiveSetQPSolverTest {
    private static final boolean VERBOSE = false;

    public abstract ActiveSetQPSolver createSolverToTest();

    @Test
    public void testSimpleCasesWithNoInequalityConstraints() {
        ActiveSetQPSolver solver = this.createSolverToTest();
        DMatrixRMaj costQuadraticMatrix = new DMatrixRMaj((double[][])new double[][]{{2.0}});
        DMatrixRMaj costLinearVector = MatrixTools.createVector((double[])new double[]{0.0});
        double quadraticCostScalar = 0.0;
        solver.setQuadraticCostFunction((DMatrix)costQuadraticMatrix, (DMatrix)costLinearVector, quadraticCostScalar);
        DMatrixRMaj solution = new DMatrixRMaj(1, 1);
        DMatrixRMaj lagrangeEqualityMultipliers = new DMatrixRMaj(0, 1);
        DMatrixRMaj lagrangeInequalityMultipliers = new DMatrixRMaj(0, 1);
        int numberOfIterations = solver.solve((DMatrix)solution);
        numberOfIterations = solver.solve((DMatrix)solution);
        solver.getLagrangeEqualityConstraintMultipliers(lagrangeEqualityMultipliers);
        solver.getLagrangeInequalityConstraintMultipliers(lagrangeInequalityMultipliers);
        Assertions.assertEquals((int)0, (int)numberOfIterations);
        Assertions.assertEquals((int)1, (int)solution.getNumRows());
        Assertions.assertEquals((double)0.0, (double)solution.get(0), (double)1.0E-7);
        solver.clear();
        costQuadraticMatrix = new DMatrixRMaj((double[][])new double[][]{{2.0}});
        costLinearVector = MatrixTools.createVector((double[])new double[]{-10.0});
        quadraticCostScalar = 25.0;
        solver.setQuadraticCostFunction((DMatrix)costQuadraticMatrix, (DMatrix)costLinearVector, quadraticCostScalar);
        solution = new DMatrixRMaj(1, 1);
        lagrangeEqualityMultipliers = new DMatrixRMaj(0, 1);
        numberOfIterations = solver.solve((DMatrix)solution);
        solver.getLagrangeEqualityConstraintMultipliers(lagrangeEqualityMultipliers);
        solver.getLagrangeInequalityConstraintMultipliers(lagrangeInequalityMultipliers);
        Assertions.assertEquals((int)0, (int)numberOfIterations);
        Assertions.assertEquals((int)1, (int)solution.getNumRows());
        Assertions.assertEquals((double)5.0, (double)solution.get(0), (double)1.0E-7);
        DMatrixRMaj solutionMatrix = new DMatrixRMaj(costQuadraticMatrix.getNumRows(), 1);
        solutionMatrix.set((DMatrixD1)solution);
        double objectiveCost = solver.getObjectiveCost(solutionMatrix);
        Assertions.assertEquals((double)0.0, (double)objectiveCost, (double)1.0E-7);
        solver.clear();
        costQuadraticMatrix = new DMatrixRMaj((double[][])new double[][]{{2.0, 0.0}, {0.0, 2.0}});
        costLinearVector = MatrixTools.createVector((double[])new double[]{-10.0, -6.0});
        quadraticCostScalar = 34.0;
        solver.setQuadraticCostFunction((DMatrix)costQuadraticMatrix, (DMatrix)costLinearVector, quadraticCostScalar);
        solution = new DMatrixRMaj(2, 1);
        lagrangeEqualityMultipliers = new DMatrixRMaj(0, 1);
        numberOfIterations = solver.solve((DMatrix)solution);
        solver.getLagrangeEqualityConstraintMultipliers(lagrangeEqualityMultipliers);
        solver.getLagrangeInequalityConstraintMultipliers(lagrangeInequalityMultipliers);
        Assertions.assertEquals((int)0, (int)numberOfIterations);
        Assertions.assertEquals((int)2, (int)solution.getNumRows());
        Assertions.assertEquals((double)5.0, (double)solution.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)3.0, (double)solution.get(1), (double)1.0E-7);
        solutionMatrix = new DMatrixRMaj(costQuadraticMatrix.getNumRows(), 1);
        solutionMatrix.set((DMatrixD1)solution);
        objectiveCost = solver.getObjectiveCost(solutionMatrix);
        Assertions.assertEquals((double)0.0, (double)objectiveCost, (double)1.0E-7);
        solver.clear();
        costQuadraticMatrix = new DMatrixRMaj((double[][])new double[][]{{2.0, 0.0}, {0.0, 2.0}});
        costLinearVector = MatrixTools.createVector((double[])new double[]{0.0, 0.0});
        quadraticCostScalar = 0.0;
        solver.setQuadraticCostFunction((DMatrix)costQuadraticMatrix, (DMatrix)costLinearVector, quadraticCostScalar);
        DMatrixRMaj linearEqualityConstraintsAMatrix = new DMatrixRMaj((double[][])new double[][]{{1.0, 1.0}});
        DMatrixRMaj linearEqualityConstraintsBVector = MatrixTools.createVector((double[])new double[]{1.0});
        solver.setLinearEqualityConstraints((DMatrix)linearEqualityConstraintsAMatrix, (DMatrix)linearEqualityConstraintsBVector);
        solution = new DMatrixRMaj(2, 1);
        lagrangeEqualityMultipliers = new DMatrixRMaj(1, 1);
        numberOfIterations = solver.solve((DMatrix)solution);
        solver.getLagrangeEqualityConstraintMultipliers(lagrangeEqualityMultipliers);
        solver.getLagrangeInequalityConstraintMultipliers(lagrangeInequalityMultipliers);
        Assertions.assertEquals((int)0, (int)numberOfIterations);
        Assertions.assertEquals((double)0.5, (double)solution.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)0.5, (double)solution.get(1), (double)1.0E-7);
        Assertions.assertEquals((double)-1.0, (double)lagrangeEqualityMultipliers.get(0), (double)1.0E-7);
        solutionMatrix = new DMatrixRMaj(costQuadraticMatrix.getNumRows(), 1);
        solutionMatrix.set((DMatrixD1)solution);
        objectiveCost = solver.getObjectiveCost(solutionMatrix);
        Assertions.assertEquals((double)0.5, (double)objectiveCost, (double)1.0E-7);
        solver.clear();
        costQuadraticMatrix = new DMatrixRMaj((double[][])new double[][]{{2.0, 0.0}, {0.0, 2.0}});
        costLinearVector = MatrixTools.createVector((double[])new double[]{0.0, 0.0});
        quadraticCostScalar = 0.0;
        solver.setQuadraticCostFunction((DMatrix)costQuadraticMatrix, (DMatrix)costLinearVector, quadraticCostScalar);
        linearEqualityConstraintsAMatrix = new DMatrixRMaj((double[][])new double[][]{{1.0, 1.0}, {3.0, -3.0}});
        linearEqualityConstraintsBVector = MatrixTools.createVector((double[])new double[]{2.0, 0.0});
        solver.setLinearEqualityConstraints((DMatrix)linearEqualityConstraintsAMatrix, (DMatrix)linearEqualityConstraintsBVector);
        solution = new DMatrixRMaj(2, 1);
        lagrangeEqualityMultipliers = new DMatrixRMaj(2, 1);
        numberOfIterations = solver.solve((DMatrix)solution);
        solver.getLagrangeEqualityConstraintMultipliers(lagrangeEqualityMultipliers);
        solver.getLagrangeInequalityConstraintMultipliers(lagrangeInequalityMultipliers);
        Assertions.assertEquals((int)0, (int)numberOfIterations);
        Assertions.assertEquals((int)2, (int)solution.getNumRows());
        Assertions.assertEquals((double)1.0, (double)solution.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)1.0, (double)solution.get(1), (double)1.0E-7);
        Assertions.assertEquals((double)-2.0, (double)lagrangeEqualityMultipliers.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)0.0, (double)lagrangeEqualityMultipliers.get(1), (double)1.0E-7);
        solutionMatrix = new DMatrixRMaj(costQuadraticMatrix.getNumRows(), 1);
        solutionMatrix.set((DMatrixD1)solution);
        objectiveCost = solver.getObjectiveCost(solutionMatrix);
        Assertions.assertEquals((double)2.0, (double)objectiveCost, (double)1.0E-7);
    }

    @Test
    public void testSimpleCasesWithInequalityConstraints() {
        this.testSimpleCasesWithInequalityConstraints(1);
    }

    public void testSimpleCasesWithInequalityConstraints(int expectedNumberOfIterations) {
        ActiveSetQPSolver solver = this.createSolverToTest();
        DMatrixRMaj costQuadraticMatrix = new DMatrixRMaj((double[][])new double[][]{{2.0}});
        DMatrixRMaj costLinearVector = MatrixTools.createVector((double[])new double[]{0.0});
        double quadraticCostScalar = 0.0;
        solver.setQuadraticCostFunction((DMatrix)costQuadraticMatrix, (DMatrix)costLinearVector, quadraticCostScalar);
        DMatrixRMaj linearInequalityConstraintsCMatrix = new DMatrixRMaj((double[][])new double[][]{{1.0}});
        DMatrixRMaj linearInqualityConstraintsDVector = MatrixTools.createVector((double[])new double[]{1.0});
        solver.setLinearInequalityConstraints((DMatrix)linearInequalityConstraintsCMatrix, (DMatrix)linearInqualityConstraintsDVector);
        DMatrixRMaj solution = new DMatrixRMaj(1, 1);
        DMatrixRMaj lagrangeEqualityMultipliers = new DMatrixRMaj(0, 1);
        DMatrixRMaj lagrangeInequalityMultipliers = new DMatrixRMaj(1, 1);
        int numberOfIterations = solver.solve((DMatrix)solution);
        numberOfIterations = solver.solve((DMatrix)solution);
        solver.getLagrangeEqualityConstraintMultipliers(lagrangeEqualityMultipliers);
        solver.getLagrangeInequalityConstraintMultipliers(lagrangeInequalityMultipliers);
        Assertions.assertEquals((int)expectedNumberOfIterations, (int)numberOfIterations);
        Assertions.assertEquals((int)1, (int)solution.getNumRows());
        Assertions.assertEquals((double)0.0, (double)solution.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)0.0, (double)lagrangeInequalityMultipliers.get(0), (double)1.0E-7);
        solver.clear();
        costQuadraticMatrix = new DMatrixRMaj((double[][])new double[][]{{2.0}});
        costLinearVector = MatrixTools.createVector((double[])new double[]{0.0});
        quadraticCostScalar = 0.0;
        solver.setQuadraticCostFunction((DMatrix)costQuadraticMatrix, (DMatrix)costLinearVector, quadraticCostScalar);
        linearInequalityConstraintsCMatrix = new DMatrixRMaj((double[][])new double[][]{{-1.0}});
        linearInqualityConstraintsDVector = MatrixTools.createVector((double[])new double[]{-1.0});
        solver.setLinearInequalityConstraints((DMatrix)linearInequalityConstraintsCMatrix, (DMatrix)linearInqualityConstraintsDVector);
        solution = new DMatrixRMaj(1, 1);
        lagrangeEqualityMultipliers = new DMatrixRMaj(0, 1);
        lagrangeInequalityMultipliers = new DMatrixRMaj(1, 1);
        numberOfIterations = solver.solve((DMatrix)solution);
        solver.getLagrangeEqualityConstraintMultipliers(lagrangeEqualityMultipliers);
        solver.getLagrangeInequalityConstraintMultipliers(lagrangeInequalityMultipliers);
        Assertions.assertEquals((int)(expectedNumberOfIterations + 1), (int)numberOfIterations);
        Assertions.assertEquals((int)1, (int)solution.getNumRows());
        Assertions.assertEquals((double)1.0, (double)solution.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)2.0, (double)lagrangeInequalityMultipliers.get(0), (double)1.0E-7);
        solver.clear();
        costQuadraticMatrix = new DMatrixRMaj((double[][])new double[][]{{2.0}});
        costLinearVector = MatrixTools.createVector((double[])new double[]{-10.0});
        quadraticCostScalar = 25.0;
        solver.setQuadraticCostFunction((DMatrix)costQuadraticMatrix, (DMatrix)costLinearVector, quadraticCostScalar);
        linearInequalityConstraintsCMatrix = new DMatrixRMaj((double[][])new double[][]{{1.0}});
        linearInqualityConstraintsDVector = MatrixTools.createVector((double[])new double[]{3.0});
        solver.setLinearInequalityConstraints((DMatrix)linearInequalityConstraintsCMatrix, (DMatrix)linearInqualityConstraintsDVector);
        solution = new DMatrixRMaj(1, 1);
        lagrangeEqualityMultipliers = new DMatrixRMaj(0, 1);
        lagrangeInequalityMultipliers = new DMatrixRMaj(1, 1);
        numberOfIterations = solver.solve((DMatrix)solution);
        solver.getLagrangeEqualityConstraintMultipliers(lagrangeEqualityMultipliers);
        solver.getLagrangeInequalityConstraintMultipliers(lagrangeInequalityMultipliers);
        Assertions.assertEquals((int)(expectedNumberOfIterations + 1), (int)numberOfIterations);
        Assertions.assertEquals((int)1, (int)solution.getNumRows());
        Assertions.assertEquals((double)3.0, (double)solution.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)4.0, (double)lagrangeInequalityMultipliers.get(0), (double)1.0E-7);
        DMatrixRMaj solutionMatrix = new DMatrixRMaj(costQuadraticMatrix.getNumRows(), 1);
        solutionMatrix.set((DMatrixD1)solution);
        double objectiveCost = solver.getObjectiveCost(solutionMatrix);
        Assertions.assertEquals((double)4.0, (double)objectiveCost, (double)1.0E-7);
        solver.clear();
        costQuadraticMatrix = new DMatrixRMaj((double[][])new double[][]{{2.0, 0.0}, {0.0, 2.0}});
        costLinearVector = MatrixTools.createVector((double[])new double[]{-10.0, -6.0});
        quadraticCostScalar = 34.0;
        solver.setQuadraticCostFunction((DMatrix)costQuadraticMatrix, (DMatrix)costLinearVector, quadraticCostScalar);
        linearInequalityConstraintsCMatrix = new DMatrixRMaj((double[][])new double[][]{{1.0, 0.0}, {0.0, 1.0}});
        linearInqualityConstraintsDVector = MatrixTools.createVector((double[])new double[]{7.0, 1.0});
        solver.setLinearInequalityConstraints((DMatrix)linearInequalityConstraintsCMatrix, (DMatrix)linearInqualityConstraintsDVector);
        solution = new DMatrixRMaj(2, 1);
        lagrangeEqualityMultipliers = new DMatrixRMaj(0, 1);
        lagrangeInequalityMultipliers = new DMatrixRMaj(2, 1);
        numberOfIterations = solver.solve((DMatrix)solution);
        solver.getLagrangeEqualityConstraintMultipliers(lagrangeEqualityMultipliers);
        solver.getLagrangeInequalityConstraintMultipliers(lagrangeInequalityMultipliers);
        Assertions.assertEquals((int)(expectedNumberOfIterations + 1), (int)numberOfIterations);
        Assertions.assertEquals((int)2, (int)solution.getNumRows());
        Assertions.assertEquals((double)5.0, (double)solution.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)1.0, (double)solution.get(1), (double)1.0E-7);
        Assertions.assertEquals((double)0.0, (double)lagrangeInequalityMultipliers.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)4.0, (double)lagrangeInequalityMultipliers.get(1), (double)1.0E-7);
        solutionMatrix = new DMatrixRMaj(costQuadraticMatrix.getNumRows(), 1);
        solutionMatrix.set((DMatrixD1)solution);
        objectiveCost = solver.getObjectiveCost(solutionMatrix);
        Assertions.assertEquals((double)4.0, (double)objectiveCost, (double)1.0E-7);
        solver.clear();
        costQuadraticMatrix = new DMatrixRMaj((double[][])new double[][]{{2.0, 0.0}, {0.0, 2.0}});
        costLinearVector = MatrixTools.createVector((double[])new double[]{0.0, 0.0});
        quadraticCostScalar = 0.0;
        solver.setQuadraticCostFunction((DMatrix)costQuadraticMatrix, (DMatrix)costLinearVector, quadraticCostScalar);
        DMatrixRMaj linearEqualityConstraintsAMatrix = new DMatrixRMaj((double[][])new double[][]{{1.0, 1.0}});
        DMatrixRMaj linearEqualityConstraintsBVector = MatrixTools.createVector((double[])new double[]{1.0});
        solver.setLinearEqualityConstraints((DMatrix)linearEqualityConstraintsAMatrix, (DMatrix)linearEqualityConstraintsBVector);
        linearInequalityConstraintsCMatrix = new DMatrixRMaj((double[][])new double[][]{{1.0, -1.0}});
        linearInqualityConstraintsDVector = MatrixTools.createVector((double[])new double[]{-1.0});
        solver.setLinearInequalityConstraints((DMatrix)linearInequalityConstraintsCMatrix, (DMatrix)linearInqualityConstraintsDVector);
        solution = new DMatrixRMaj(2, 1);
        lagrangeEqualityMultipliers = new DMatrixRMaj(1, 1);
        lagrangeInequalityMultipliers = new DMatrixRMaj(1, 1);
        numberOfIterations = solver.solve((DMatrix)solution);
        solver.getLagrangeEqualityConstraintMultipliers(lagrangeEqualityMultipliers);
        solver.getLagrangeInequalityConstraintMultipliers(lagrangeInequalityMultipliers);
        Assertions.assertEquals((int)(expectedNumberOfIterations + 1), (int)numberOfIterations);
        Assertions.assertEquals((int)2, (int)solution.getNumRows());
        Assertions.assertEquals((double)0.0, (double)solution.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)1.0, (double)solution.get(1), (double)1.0E-7);
        Assertions.assertEquals((double)-1.0, (double)lagrangeEqualityMultipliers.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)1.0, (double)lagrangeInequalityMultipliers.get(0), (double)1.0E-7);
        solutionMatrix = new DMatrixRMaj(costQuadraticMatrix.getNumRows(), 1);
        solutionMatrix.set((DMatrixD1)solution);
        objectiveCost = solver.getObjectiveCost(solutionMatrix);
        Assertions.assertEquals((double)1.0, (double)objectiveCost, (double)1.0E-7);
        solver.clear();
        costQuadraticMatrix = new DMatrixRMaj((double[][])new double[][]{{2.0, 0.0}, {0.0, 2.0}});
        costLinearVector = MatrixTools.createVector((double[])new double[]{0.0, 0.0});
        quadraticCostScalar = 0.0;
        solver.setQuadraticCostFunction((DMatrix)costQuadraticMatrix, (DMatrix)costLinearVector, quadraticCostScalar);
        linearEqualityConstraintsAMatrix = new DMatrixRMaj((double[][])new double[][]{{1.0, 1.0}, {3.0, -3.0}});
        linearEqualityConstraintsBVector = MatrixTools.createVector((double[])new double[]{2.0, 0.0});
        solver.setLinearEqualityConstraints((DMatrix)linearEqualityConstraintsAMatrix, (DMatrix)linearEqualityConstraintsBVector);
        linearInequalityConstraintsCMatrix = new DMatrixRMaj((double[][])new double[][]{{1.0, 0.0}, {1.0, 0.0}, {0.0, 1.0}});
        linearInqualityConstraintsDVector = MatrixTools.createVector((double[])new double[]{2.0, 10.0, 3.0});
        solver.setLinearInequalityConstraints((DMatrix)linearInequalityConstraintsCMatrix, (DMatrix)linearInqualityConstraintsDVector);
        solution = new DMatrixRMaj(2, 1);
        lagrangeEqualityMultipliers = new DMatrixRMaj(2, 1);
        lagrangeInequalityMultipliers = new DMatrixRMaj(3, 1);
        numberOfIterations = solver.solve((DMatrix)solution);
        solver.getLagrangeEqualityConstraintMultipliers(lagrangeEqualityMultipliers);
        solver.getLagrangeInequalityConstraintMultipliers(lagrangeInequalityMultipliers);
        Assertions.assertEquals((int)expectedNumberOfIterations, (int)numberOfIterations);
        Assertions.assertEquals((int)2, (int)solution.getNumRows());
        Assertions.assertEquals((double)1.0, (double)solution.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)1.0, (double)solution.get(1), (double)1.0E-7);
        Assertions.assertEquals((double)-2.0, (double)lagrangeEqualityMultipliers.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)0.0, (double)lagrangeEqualityMultipliers.get(1), (double)1.0E-7);
        Assertions.assertEquals((double)0.0, (double)lagrangeInequalityMultipliers.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)0.0, (double)lagrangeInequalityMultipliers.get(1), (double)1.0E-7);
        Assertions.assertEquals((double)0.0, (double)lagrangeInequalityMultipliers.get(2), (double)1.0E-7);
        solutionMatrix = new DMatrixRMaj(costQuadraticMatrix.getNumRows(), 1);
        solutionMatrix.set((DMatrixD1)solution);
        objectiveCost = solver.getObjectiveCost(solutionMatrix);
        Assertions.assertEquals((double)2.0, (double)objectiveCost, (double)1.0E-7);
    }

    @Test
    public void testSimpleCasesWithBoundsConstraints() {
        this.testSimpleCasesWithBoundsConstraints(1, 3, 3, 3, false);
    }

    public void testSimpleCasesWithBoundsConstraints(int expectedNumberOfIterations, int expectedNumberOfIterations2, int expectedNumberOfIterations3, int expectedNumberOfIterations4, boolean ignoreLagrangeMultipliers) {
        ActiveSetQPSolver solver = this.createSolverToTest();
        DMatrixRMaj costQuadraticMatrix = new DMatrixRMaj((double[][])new double[][]{{2.0}});
        DMatrixRMaj costLinearVector = MatrixTools.createVector((double[])new double[]{0.0});
        double quadraticCostScalar = 0.0;
        solver.setQuadraticCostFunction((DMatrix)costQuadraticMatrix, (DMatrix)costLinearVector, quadraticCostScalar);
        DMatrixRMaj variableLowerBounds = MatrixTools.createVector((double[])new double[]{Double.NEGATIVE_INFINITY});
        DMatrixRMaj variableUpperBounds = MatrixTools.createVector((double[])new double[]{Double.POSITIVE_INFINITY});
        solver.setVariableBounds((DMatrix)variableLowerBounds, (DMatrix)variableUpperBounds);
        DMatrixRMaj solution = new DMatrixRMaj(1, 1);
        DMatrixRMaj lagrangeEqualityMultipliers = new DMatrixRMaj(0, 1);
        DMatrixRMaj lagrangeInequalityMultipliers = new DMatrixRMaj(0, 1);
        DMatrixRMaj lagrangeLowerBoundMultipliers = new DMatrixRMaj(1, 1);
        DMatrixRMaj lagrangeUpperBoundMultipliers = new DMatrixRMaj(1, 1);
        int numberOfIterations = solver.solve((DMatrix)solution);
        numberOfIterations = solver.solve((DMatrix)solution);
        solver.getLagrangeEqualityConstraintMultipliers(lagrangeEqualityMultipliers);
        solver.getLagrangeInequalityConstraintMultipliers(lagrangeInequalityMultipliers);
        solver.getLagrangeLowerBoundsMultipliers(lagrangeLowerBoundMultipliers);
        solver.getLagrangeUpperBoundsMultipliers(lagrangeUpperBoundMultipliers);
        Assertions.assertEquals((int)expectedNumberOfIterations, (int)numberOfIterations);
        Assertions.assertEquals((int)1, (int)solution.getNumRows());
        Assertions.assertEquals((double)0.0, (double)solution.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)0.0, (double)lagrangeLowerBoundMultipliers.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)0.0, (double)lagrangeUpperBoundMultipliers.get(0), (double)1.0E-7);
        solver.clear();
        costQuadraticMatrix = new DMatrixRMaj((double[][])new double[][]{{2.0}});
        costLinearVector = MatrixTools.createVector((double[])new double[]{0.0});
        quadraticCostScalar = 0.0;
        solver.setQuadraticCostFunction((DMatrix)costQuadraticMatrix, (DMatrix)costLinearVector, quadraticCostScalar);
        variableLowerBounds = MatrixTools.createVector((double[])new double[]{1.0});
        variableUpperBounds = MatrixTools.createVector((double[])new double[]{Double.POSITIVE_INFINITY});
        solver.setVariableBounds((DMatrix)variableLowerBounds, (DMatrix)variableUpperBounds);
        solution = new DMatrixRMaj(1, 1);
        lagrangeEqualityMultipliers = new DMatrixRMaj(0, 1);
        lagrangeInequalityMultipliers = new DMatrixRMaj(0, 1);
        lagrangeLowerBoundMultipliers = new DMatrixRMaj(1, 1);
        lagrangeUpperBoundMultipliers = new DMatrixRMaj(1, 1);
        numberOfIterations = solver.solve((DMatrix)solution);
        solver.getLagrangeEqualityConstraintMultipliers(lagrangeEqualityMultipliers);
        solver.getLagrangeInequalityConstraintMultipliers(lagrangeInequalityMultipliers);
        solver.getLagrangeLowerBoundsMultipliers(lagrangeLowerBoundMultipliers);
        solver.getLagrangeUpperBoundsMultipliers(lagrangeUpperBoundMultipliers);
        Assertions.assertEquals((int)(expectedNumberOfIterations + 1), (int)numberOfIterations);
        Assertions.assertEquals((int)1, (int)solution.getNumRows());
        Assertions.assertEquals((double)1.0, (double)solution.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)2.0, (double)lagrangeLowerBoundMultipliers.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)0.0, (double)lagrangeUpperBoundMultipliers.get(0), (double)1.0E-7);
        solver.clear();
        costQuadraticMatrix = new DMatrixRMaj((double[][])new double[][]{{2.0}});
        costLinearVector = MatrixTools.createVector((double[])new double[]{0.0});
        quadraticCostScalar = 0.0;
        solver.setQuadraticCostFunction((DMatrix)costQuadraticMatrix, (DMatrix)costLinearVector, quadraticCostScalar);
        variableLowerBounds = MatrixTools.createVector((double[])new double[]{Double.NEGATIVE_INFINITY});
        variableUpperBounds = MatrixTools.createVector((double[])new double[]{-1.0});
        solver.setVariableBounds((DMatrix)variableLowerBounds, (DMatrix)variableUpperBounds);
        solution = new DMatrixRMaj(1, 1);
        lagrangeEqualityMultipliers = new DMatrixRMaj(0, 1);
        lagrangeInequalityMultipliers = new DMatrixRMaj(0, 1);
        lagrangeLowerBoundMultipliers = new DMatrixRMaj(1, 1);
        lagrangeUpperBoundMultipliers = new DMatrixRMaj(1, 1);
        numberOfIterations = solver.solve((DMatrix)solution);
        solver.getLagrangeEqualityConstraintMultipliers(lagrangeEqualityMultipliers);
        solver.getLagrangeInequalityConstraintMultipliers(lagrangeInequalityMultipliers);
        solver.getLagrangeLowerBoundsMultipliers(lagrangeLowerBoundMultipliers);
        solver.getLagrangeUpperBoundsMultipliers(lagrangeUpperBoundMultipliers);
        Assertions.assertEquals((int)(expectedNumberOfIterations + 1), (int)numberOfIterations);
        Assertions.assertEquals((int)1, (int)solution.getNumRows());
        Assertions.assertEquals((double)-1.0, (double)solution.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)0.0, (double)lagrangeLowerBoundMultipliers.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)2.0, (double)lagrangeUpperBoundMultipliers.get(0), (double)1.0E-7);
        solver.clear();
        costQuadraticMatrix = new DMatrixRMaj((double[][])new double[][]{{2.0}});
        costLinearVector = MatrixTools.createVector((double[])new double[]{0.0});
        quadraticCostScalar = 0.0;
        solver.setQuadraticCostFunction((DMatrix)costQuadraticMatrix, (DMatrix)costLinearVector, quadraticCostScalar);
        variableLowerBounds = MatrixTools.createVector((double[])new double[]{1.000000000001});
        variableUpperBounds = MatrixTools.createVector((double[])new double[]{0.999999999999});
        solver.setVariableBounds((DMatrix)variableLowerBounds, (DMatrix)variableUpperBounds);
        solution = new DMatrixRMaj(1, 1);
        lagrangeEqualityMultipliers = new DMatrixRMaj(0, 1);
        lagrangeInequalityMultipliers = new DMatrixRMaj(0, 1);
        lagrangeLowerBoundMultipliers = new DMatrixRMaj(1, 1);
        lagrangeUpperBoundMultipliers = new DMatrixRMaj(1, 1);
        numberOfIterations = solver.solve((DMatrix)solution);
        solver.getLagrangeEqualityConstraintMultipliers(lagrangeEqualityMultipliers);
        solver.getLagrangeInequalityConstraintMultipliers(lagrangeInequalityMultipliers);
        solver.getLagrangeLowerBoundsMultipliers(lagrangeLowerBoundMultipliers);
        solver.getLagrangeUpperBoundsMultipliers(lagrangeUpperBoundMultipliers);
        Assertions.assertEquals((int)(expectedNumberOfIterations + 1), (int)numberOfIterations);
        Assertions.assertEquals((int)1, (int)solution.getNumRows());
        Assertions.assertEquals((double)1.0, (double)solution.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)2.0, (double)lagrangeLowerBoundMultipliers.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)0.0, (double)lagrangeUpperBoundMultipliers.get(0), (double)1.0E-7);
        solver.clear();
        costQuadraticMatrix = new DMatrixRMaj((double[][])new double[][]{{2.0}});
        costLinearVector = MatrixTools.createVector((double[])new double[]{0.0});
        quadraticCostScalar = 0.0;
        solver.setQuadraticCostFunction((DMatrix)costQuadraticMatrix, (DMatrix)costLinearVector, quadraticCostScalar);
        variableLowerBounds = MatrixTools.createVector((double[])new double[]{-0.999999999999});
        variableUpperBounds = MatrixTools.createVector((double[])new double[]{-1.000000000001});
        solver.setVariableBounds((DMatrix)variableLowerBounds, (DMatrix)variableUpperBounds);
        solution = new DMatrixRMaj(1, 1);
        lagrangeEqualityMultipliers = new DMatrixRMaj(0, 1);
        lagrangeInequalityMultipliers = new DMatrixRMaj(0, 1);
        lagrangeLowerBoundMultipliers = new DMatrixRMaj(1, 1);
        lagrangeUpperBoundMultipliers = new DMatrixRMaj(1, 1);
        numberOfIterations = solver.solve((DMatrix)solution);
        solver.getLagrangeEqualityConstraintMultipliers(lagrangeEqualityMultipliers);
        solver.getLagrangeInequalityConstraintMultipliers(lagrangeInequalityMultipliers);
        solver.getLagrangeLowerBoundsMultipliers(lagrangeLowerBoundMultipliers);
        solver.getLagrangeUpperBoundsMultipliers(lagrangeUpperBoundMultipliers);
        Assertions.assertEquals((int)(expectedNumberOfIterations + 1), (int)numberOfIterations);
        Assertions.assertEquals((int)1, (int)solution.getNumRows());
        Assertions.assertEquals((double)-1.0, (double)solution.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)0.0, (double)lagrangeLowerBoundMultipliers.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)2.0, (double)lagrangeUpperBoundMultipliers.get(0), (double)1.0E-7);
        solver.clear();
        costQuadraticMatrix = new DMatrixRMaj((double[][])new double[][]{{2.0}});
        costLinearVector = MatrixTools.createVector((double[])new double[]{0.0});
        quadraticCostScalar = 0.0;
        solver.setQuadraticCostFunction((DMatrix)costQuadraticMatrix, (DMatrix)costLinearVector, quadraticCostScalar);
        variableLowerBounds = MatrixTools.createVector((double[])new double[]{1.0000001});
        variableUpperBounds = MatrixTools.createVector((double[])new double[]{0.9999999});
        solver.setVariableBounds((DMatrix)variableLowerBounds, (DMatrix)variableUpperBounds);
        solution = new DMatrixRMaj(1, 1);
        lagrangeEqualityMultipliers = new DMatrixRMaj(0, 1);
        lagrangeInequalityMultipliers = new DMatrixRMaj(0, 1);
        lagrangeLowerBoundMultipliers = new DMatrixRMaj(1, 1);
        lagrangeUpperBoundMultipliers = new DMatrixRMaj(1, 1);
        numberOfIterations = solver.solve((DMatrix)solution);
        solver.getLagrangeEqualityConstraintMultipliers(lagrangeEqualityMultipliers);
        solver.getLagrangeInequalityConstraintMultipliers(lagrangeInequalityMultipliers);
        solver.getLagrangeLowerBoundsMultipliers(lagrangeLowerBoundMultipliers);
        solver.getLagrangeUpperBoundsMultipliers(lagrangeUpperBoundMultipliers);
        Assertions.assertEquals((int)expectedNumberOfIterations2, (int)numberOfIterations);
        Assertions.assertEquals((int)1, (int)solution.getNumRows());
        Assertions.assertTrue((boolean)Double.isNaN(solution.get(0)));
        Assertions.assertFalse((boolean)Double.isFinite(lagrangeLowerBoundMultipliers.get(0)));
        Assertions.assertFalse((boolean)Double.isFinite(lagrangeUpperBoundMultipliers.get(0)));
        solver.clear();
        costQuadraticMatrix = new DMatrixRMaj((double[][])new double[][]{{2.0, 0.0, 0.0}, {0.0, 2.0, 0.0}, {0.0, 0.0, 2.0}});
        costLinearVector = MatrixTools.createVector((double[])new double[]{0.0, 0.0, 0.0});
        quadraticCostScalar = 0.0;
        solver.setQuadraticCostFunction((DMatrix)costQuadraticMatrix, (DMatrix)costLinearVector, quadraticCostScalar);
        DMatrixRMaj linearEqualityConstraintsAMatrix = new DMatrixRMaj((double[][])new double[][]{{1.0, 1.0, 0.0}});
        DMatrixRMaj linearEqualityConstraintsBVector = MatrixTools.createVector((double[])new double[]{2.0});
        solver.setLinearEqualityConstraints((DMatrix)linearEqualityConstraintsAMatrix, (DMatrix)linearEqualityConstraintsBVector);
        DMatrixRMaj linearInequalityConstraintsCMatrix = new DMatrixRMaj((double[][])new double[][]{{0.0, 1.0, -1.0}});
        DMatrixRMaj linearInqualityConstraintsDVector = MatrixTools.createVector((double[])new double[]{-8.0});
        solver.setLinearInequalityConstraints((DMatrix)linearInequalityConstraintsCMatrix, (DMatrix)linearInqualityConstraintsDVector);
        solver.setVariableBounds((DMatrix)this.getLowerBounds(), (DMatrix)this.getUpperBounds());
        solution = new DMatrixRMaj(3, 1);
        lagrangeEqualityMultipliers = new DMatrixRMaj(1, 1);
        lagrangeInequalityMultipliers = new DMatrixRMaj(1, 1);
        lagrangeLowerBoundMultipliers = new DMatrixRMaj(3, 1);
        lagrangeUpperBoundMultipliers = new DMatrixRMaj(3, 1);
        numberOfIterations = solver.solve((DMatrix)solution);
        numberOfIterations = solver.solve((DMatrix)solution);
        solver.getLagrangeEqualityConstraintMultipliers(lagrangeEqualityMultipliers);
        solver.getLagrangeInequalityConstraintMultipliers(lagrangeInequalityMultipliers);
        solver.getLagrangeLowerBoundsMultipliers(lagrangeLowerBoundMultipliers);
        solver.getLagrangeUpperBoundsMultipliers(lagrangeUpperBoundMultipliers);
        Assertions.assertEquals((int)expectedNumberOfIterations3, (int)numberOfIterations);
        Assertions.assertEquals((int)3, (int)solution.getNumRows());
        Assertions.assertEquals((double)-4.0, (double)solution.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)6.0, (double)solution.get(1), (double)1.0E-7);
        Assertions.assertEquals((double)14.0, (double)solution.get(2), (double)1.0E-7);
        if (!ignoreLagrangeMultipliers) {
            Assertions.assertEquals((double)8.0, (double)lagrangeEqualityMultipliers.get(0), (double)1.0E-7);
            Assertions.assertEquals((double)28.0, (double)lagrangeInequalityMultipliers.get(0), (double)1.0E-7);
            Assertions.assertEquals((double)0.0, (double)lagrangeLowerBoundMultipliers.get(0), (double)1.0E-7);
            Assertions.assertEquals((double)48.0, (double)lagrangeLowerBoundMultipliers.get(1), (double)1.0E-7);
            Assertions.assertEquals((double)0.0, (double)lagrangeLowerBoundMultipliers.get(2), (double)1.0E-7);
            Assertions.assertEquals((double)0.0, (double)lagrangeUpperBoundMultipliers.get(0), (double)1.0E-7);
            Assertions.assertEquals((double)0.0, (double)lagrangeUpperBoundMultipliers.get(1), (double)1.0E-7);
            Assertions.assertEquals((double)0.0, (double)lagrangeUpperBoundMultipliers.get(2), (double)1.0E-7);
        }
        DMatrixRMaj solutionMatrix = new DMatrixRMaj(costQuadraticMatrix.getNumRows(), 1);
        solutionMatrix.set((DMatrixD1)solution);
        double objectiveCost = solver.getObjectiveCost(solutionMatrix);
        Assertions.assertEquals((double)248.0, (double)objectiveCost, (double)1.0E-7);
        solver.clear();
        costQuadraticMatrix = new DMatrixRMaj((double[][])new double[][]{{2.0, 0.0, 0.0}, {0.0, 2.0, 0.0}, {0.0, 0.0, 2.0}});
        costLinearVector = MatrixTools.createVector((double[])new double[]{0.0, 0.0, 0.0});
        quadraticCostScalar = 0.0;
        solver.setQuadraticCostFunction((DMatrix)costQuadraticMatrix, (DMatrix)costLinearVector, quadraticCostScalar);
        linearEqualityConstraintsAMatrix = new DMatrixRMaj((double[][])new double[][]{{1.0, 1.0, 0.0}});
        linearEqualityConstraintsBVector = MatrixTools.createVector((double[])new double[]{2.0});
        solver.setLinearEqualityConstraints((DMatrix)linearEqualityConstraintsAMatrix, (DMatrix)linearEqualityConstraintsBVector);
        linearInequalityConstraintsCMatrix = new DMatrixRMaj((double[][])new double[][]{{0.0, 1.0, -1.0}});
        linearInqualityConstraintsDVector = MatrixTools.createVector((double[])new double[]{-8.0});
        solver.setLinearInequalityConstraints((DMatrix)linearInequalityConstraintsCMatrix, (DMatrix)linearInqualityConstraintsDVector);
        solver.setVariableBounds((DMatrix)MatrixTools.createVector((double[])new double[]{3.0, 6.0, 11.0}), (DMatrix)this.getUpperBounds());
        solution = new DMatrixRMaj(3, 1);
        lagrangeEqualityMultipliers = new DMatrixRMaj(1, 1);
        lagrangeInequalityMultipliers = new DMatrixRMaj(1, 1);
        lagrangeLowerBoundMultipliers = new DMatrixRMaj(3, 1);
        lagrangeUpperBoundMultipliers = new DMatrixRMaj(3, 1);
        numberOfIterations = solver.solve((DMatrix)solution);
        numberOfIterations = solver.solve((DMatrix)solution);
        solver.getLagrangeEqualityConstraintMultipliers(lagrangeEqualityMultipliers);
        solver.getLagrangeInequalityConstraintMultipliers(lagrangeInequalityMultipliers);
        solver.getLagrangeLowerBoundsMultipliers(lagrangeLowerBoundMultipliers);
        solver.getLagrangeUpperBoundsMultipliers(lagrangeUpperBoundMultipliers);
        Assertions.assertEquals((int)expectedNumberOfIterations4, (int)numberOfIterations);
        Assertions.assertEquals((int)3, (int)solution.getNumRows());
        Assertions.assertTrue((boolean)Double.isNaN(solution.get(0)));
        Assertions.assertTrue((boolean)Double.isNaN(solution.get(1)));
        Assertions.assertTrue((boolean)Double.isNaN(solution.get(2)));
        solutionMatrix = new DMatrixRMaj(costQuadraticMatrix.getNumRows(), 1);
        solutionMatrix.set((DMatrixD1)solution);
        objectiveCost = solver.getObjectiveCost(solutionMatrix);
        Assertions.assertTrue((boolean)Double.isNaN(objectiveCost));
    }

    @Test
    public void testClear() {
        this.testClear(3, 2, false);
    }

    public void testClear(int expectedNumberOfIterations1, int expectedNumberOfIterations2, boolean avoidProblematicLagrangeMultipliers) {
        ActiveSetQPSolver solver = this.createSolverToTest();
        solver.clear();
        DMatrixRMaj costQuadraticMatrix = new DMatrixRMaj((double[][])new double[][]{{2.0, 0.0, 0.0}, {0.0, 2.0, 0.0}, {0.0, 0.0, 2.0}});
        DMatrixRMaj costLinearVector = MatrixTools.createVector((double[])new double[]{0.0, 0.0, 0.0});
        double quadraticCostScalar = 0.0;
        solver.setQuadraticCostFunction((DMatrix)costQuadraticMatrix, (DMatrix)costLinearVector, quadraticCostScalar);
        DMatrixRMaj linearEqualityConstraintsAMatrix = new DMatrixRMaj((double[][])new double[][]{{1.0, 1.0, 0.0}});
        DMatrixRMaj linearEqualityConstraintsBVector = MatrixTools.createVector((double[])new double[]{2.0});
        solver.setLinearEqualityConstraints((DMatrix)linearEqualityConstraintsAMatrix, (DMatrix)linearEqualityConstraintsBVector);
        DMatrixRMaj linearInequalityConstraintsCMatrix = new DMatrixRMaj((double[][])new double[][]{{0.0, 1.0, -1.0}});
        DMatrixRMaj linearInqualityConstraintsDVector = MatrixTools.createVector((double[])new double[]{-8.0});
        solver.setLinearInequalityConstraints((DMatrix)linearInequalityConstraintsCMatrix, (DMatrix)linearInqualityConstraintsDVector);
        solver.setVariableBounds((DMatrix)this.getLowerBounds(), (DMatrix)this.getUpperBounds());
        DMatrixRMaj solution1 = new DMatrixRMaj(3, 1);
        DMatrixRMaj solution2 = new DMatrixRMaj(3, 1);
        DMatrixRMaj lagrangeEqualityMultipliers = new DMatrixRMaj(1, 1);
        DMatrixRMaj lagrangeInequalityMultipliers = new DMatrixRMaj(1, 1);
        DMatrixRMaj lagrangeLowerBoundMultipliers = new DMatrixRMaj(3, 1);
        DMatrixRMaj lagrangeUpperBoundMultipliers = new DMatrixRMaj(3, 1);
        int numberOfIterations = solver.solve((DMatrix)solution1);
        numberOfIterations = solver.solve((DMatrix)solution2);
        solver.getLagrangeEqualityConstraintMultipliers(lagrangeEqualityMultipliers);
        solver.getLagrangeInequalityConstraintMultipliers(lagrangeInequalityMultipliers);
        solver.getLagrangeLowerBoundsMultipliers(lagrangeLowerBoundMultipliers);
        solver.getLagrangeUpperBoundsMultipliers(lagrangeUpperBoundMultipliers);
        Assertions.assertEquals((double)solution1.get(0), (double)solution2.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)solution1.get(1), (double)solution2.get(1), (double)1.0E-7);
        Assertions.assertEquals((double)solution1.get(2), (double)solution2.get(2), (double)1.0E-7);
        Assertions.assertEquals((int)3, (int)solution2.getNumRows());
        Assertions.assertEquals((double)-4.0, (double)solution2.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)6.0, (double)solution2.get(1), (double)1.0E-7);
        Assertions.assertEquals((double)14.0, (double)solution2.get(2), (double)1.0E-7);
        if (!avoidProblematicLagrangeMultipliers) {
            Assertions.assertEquals((double)8.0, (double)lagrangeEqualityMultipliers.get(0), (double)1.0E-7);
            Assertions.assertEquals((double)28.0, (double)lagrangeInequalityMultipliers.get(0), (double)1.0E-7);
            Assertions.assertEquals((double)0.0, (double)lagrangeLowerBoundMultipliers.get(0), (double)1.0E-7);
            Assertions.assertEquals((double)48.0, (double)lagrangeLowerBoundMultipliers.get(1), (double)1.0E-7);
            Assertions.assertEquals((double)0.0, (double)lagrangeLowerBoundMultipliers.get(2), (double)1.0E-7);
            Assertions.assertEquals((double)0.0, (double)lagrangeUpperBoundMultipliers.get(0), (double)1.0E-7);
            Assertions.assertEquals((double)0.0, (double)lagrangeUpperBoundMultipliers.get(1), (double)1.0E-7);
            Assertions.assertEquals((double)0.0, (double)lagrangeUpperBoundMultipliers.get(2), (double)1.0E-7);
        }
        DMatrixRMaj solutionMatrix = new DMatrixRMaj(costQuadraticMatrix.getNumRows(), 1);
        solutionMatrix.set((DMatrixD1)solution1);
        double objectiveCost = solver.getObjectiveCost(solutionMatrix);
        Assertions.assertEquals((double)248.0, (double)objectiveCost, (double)1.0E-7);
        solver.clear();
        costQuadraticMatrix = new DMatrixRMaj((double[][])new double[][]{{2.0, 0.0, 0.0}, {0.0, 2.0, 0.0}, {0.0, 0.0, 2.0}});
        costLinearVector = MatrixTools.createVector((double[])new double[]{0.0, 0.0, 0.0});
        quadraticCostScalar = 0.0;
        solver.setQuadraticCostFunction((DMatrix)costQuadraticMatrix, (DMatrix)costLinearVector, quadraticCostScalar);
        linearEqualityConstraintsAMatrix = new DMatrixRMaj((double[][])new double[][]{{1.0, 1.0, 0.0}});
        linearEqualityConstraintsBVector = MatrixTools.createVector((double[])new double[]{2.0});
        solver.setLinearEqualityConstraints((DMatrix)linearEqualityConstraintsAMatrix, (DMatrix)linearEqualityConstraintsBVector);
        linearInequalityConstraintsCMatrix = new DMatrixRMaj((double[][])new double[][]{{0.0, 1.0, -1.0}});
        linearInqualityConstraintsDVector = MatrixTools.createVector((double[])new double[]{-8.0});
        solver.setLinearInequalityConstraints((DMatrix)linearInequalityConstraintsCMatrix, (DMatrix)linearInqualityConstraintsDVector);
        solution1 = new DMatrixRMaj(3, 1);
        solution2 = new DMatrixRMaj(3, 1);
        lagrangeEqualityMultipliers = new DMatrixRMaj(1, 1);
        lagrangeInequalityMultipliers = new DMatrixRMaj(1, 1);
        lagrangeLowerBoundMultipliers = new DMatrixRMaj(0, 1);
        lagrangeUpperBoundMultipliers = new DMatrixRMaj(0, 1);
        numberOfIterations = solver.solve((DMatrix)solution1);
        numberOfIterations = solver.solve((DMatrix)solution2);
        solver.getLagrangeEqualityConstraintMultipliers(lagrangeEqualityMultipliers);
        solver.getLagrangeInequalityConstraintMultipliers(lagrangeInequalityMultipliers);
        solver.getLagrangeLowerBoundsMultipliers(lagrangeLowerBoundMultipliers);
        solver.getLagrangeUpperBoundsMultipliers(lagrangeUpperBoundMultipliers);
        Assertions.assertEquals((int)expectedNumberOfIterations2, (int)numberOfIterations);
        Assertions.assertEquals((int)3, (int)solution1.getNumRows());
        Assertions.assertEquals((double)solution1.get(0), (double)solution2.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)solution1.get(1), (double)solution2.get(1), (double)1.0E-7);
        Assertions.assertEquals((double)solution1.get(2), (double)solution2.get(2), (double)1.0E-7);
        Assertions.assertEquals((double)4.0, (double)solution1.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)-2.0, (double)solution1.get(1), (double)1.0E-7);
        Assertions.assertEquals((double)6.0, (double)solution1.get(2), (double)1.0E-7);
        Assertions.assertEquals((double)-8.0, (double)lagrangeEqualityMultipliers.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)12.0, (double)lagrangeInequalityMultipliers.get(0), (double)1.0E-7);
        solutionMatrix = new DMatrixRMaj(costQuadraticMatrix.getNumRows(), 1);
        solutionMatrix.set((DMatrixD1)solution1);
        objectiveCost = solver.getObjectiveCost(solutionMatrix);
        Assertions.assertEquals((double)56.0, (double)objectiveCost, (double)1.0E-7);
        solver.clear();
        costQuadraticMatrix = new DMatrixRMaj((double[][])new double[][]{{2.0, 0.0, 0.0}, {0.0, 2.0, 0.0}, {0.0, 0.0, 2.0}});
        costLinearVector = MatrixTools.createVector((double[])new double[]{0.0, 0.0, 0.0});
        quadraticCostScalar = 0.0;
        solver.setQuadraticCostFunction((DMatrix)costQuadraticMatrix, (DMatrix)costLinearVector, quadraticCostScalar);
        linearEqualityConstraintsAMatrix = new DMatrixRMaj((double[][])new double[][]{{1.0, 1.0, 0.0}});
        linearEqualityConstraintsBVector = MatrixTools.createVector((double[])new double[]{2.0});
        solver.setLinearEqualityConstraints((DMatrix)linearEqualityConstraintsAMatrix, (DMatrix)linearEqualityConstraintsBVector);
        solution1 = new DMatrixRMaj(3, 1);
        solution2 = new DMatrixRMaj(3, 1);
        lagrangeEqualityMultipliers = new DMatrixRMaj(1, 1);
        lagrangeInequalityMultipliers = new DMatrixRMaj(0, 1);
        lagrangeLowerBoundMultipliers = new DMatrixRMaj(0, 1);
        lagrangeUpperBoundMultipliers = new DMatrixRMaj(0, 1);
        numberOfIterations = solver.solve((DMatrix)solution1);
        numberOfIterations = solver.solve((DMatrix)solution2);
        solver.getLagrangeEqualityConstraintMultipliers(lagrangeEqualityMultipliers);
        solver.getLagrangeInequalityConstraintMultipliers(lagrangeInequalityMultipliers);
        solver.getLagrangeLowerBoundsMultipliers(lagrangeLowerBoundMultipliers);
        solver.getLagrangeUpperBoundsMultipliers(lagrangeUpperBoundMultipliers);
        Assertions.assertEquals((int)0, (int)numberOfIterations);
        Assertions.assertEquals((int)3, (int)solution1.getNumRows());
        Assertions.assertEquals((double)solution1.get(0), (double)solution2.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)solution1.get(1), (double)solution2.get(1), (double)1.0E-7);
        Assertions.assertEquals((double)solution1.get(2), (double)solution2.get(2), (double)1.0E-7);
        Assertions.assertEquals((double)1.0, (double)solution1.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)1.0, (double)solution1.get(1), (double)1.0E-7);
        Assertions.assertEquals((double)0.0, (double)solution1.get(2), (double)1.0E-7);
        Assertions.assertEquals((double)-2.0, (double)lagrangeEqualityMultipliers.get(0), (double)1.0E-7);
        solutionMatrix = new DMatrixRMaj(costQuadraticMatrix.getNumRows(), 1);
        solutionMatrix.set((DMatrixD1)solution1);
        objectiveCost = solver.getObjectiveCost(solutionMatrix);
        Assertions.assertEquals((double)2.0, (double)objectiveCost, (double)1.0E-7);
        solver.clear();
        costQuadraticMatrix = new DMatrixRMaj((double[][])new double[][]{{2.0, 0.0, 0.0}, {0.0, 2.0, 0.0}, {0.0, 0.0, 2.0}});
        costLinearVector = MatrixTools.createVector((double[])new double[]{0.0, 0.0, 0.0});
        quadraticCostScalar = 0.0;
        solver.setQuadraticCostFunction((DMatrix)costQuadraticMatrix, (DMatrix)costLinearVector, quadraticCostScalar);
        solution1 = new DMatrixRMaj(3, 1);
        solution2 = new DMatrixRMaj(3, 1);
        lagrangeEqualityMultipliers = new DMatrixRMaj(0, 1);
        lagrangeInequalityMultipliers = new DMatrixRMaj(0, 1);
        lagrangeLowerBoundMultipliers = new DMatrixRMaj(0, 1);
        lagrangeUpperBoundMultipliers = new DMatrixRMaj(0, 1);
        numberOfIterations = solver.solve((DMatrix)solution1);
        numberOfIterations = solver.solve((DMatrix)solution2);
        solver.getLagrangeEqualityConstraintMultipliers(lagrangeEqualityMultipliers);
        solver.getLagrangeInequalityConstraintMultipliers(lagrangeInequalityMultipliers);
        solver.getLagrangeLowerBoundsMultipliers(lagrangeLowerBoundMultipliers);
        solver.getLagrangeUpperBoundsMultipliers(lagrangeUpperBoundMultipliers);
        Assertions.assertEquals((int)0, (int)numberOfIterations);
        Assertions.assertEquals((int)3, (int)solution1.getNumRows());
        Assertions.assertEquals((double)solution1.get(0), (double)solution2.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)solution1.get(1), (double)solution2.get(1), (double)1.0E-7);
        Assertions.assertEquals((double)solution1.get(2), (double)solution2.get(2), (double)1.0E-7);
        Assertions.assertEquals((double)0.0, (double)solution1.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)0.0, (double)solution1.get(1), (double)1.0E-7);
        Assertions.assertEquals((double)0.0, (double)solution1.get(2), (double)1.0E-7);
        solutionMatrix = new DMatrixRMaj(costQuadraticMatrix.getNumRows(), 1);
        solutionMatrix.set((DMatrixD1)solution1);
        objectiveCost = solver.getObjectiveCost(solutionMatrix);
        Assertions.assertEquals((double)0.0, (double)objectiveCost, (double)1.0E-7);
        linearEqualityConstraintsAMatrix = new DMatrixRMaj((double[][])new double[][]{{1.0, 1.0, 0.0}});
        linearEqualityConstraintsBVector = MatrixTools.createVector((double[])new double[]{2.0});
        solver.setLinearEqualityConstraints((DMatrix)linearEqualityConstraintsAMatrix, (DMatrix)linearEqualityConstraintsBVector);
        solution1 = new DMatrixRMaj(3, 1);
        solution2 = new DMatrixRMaj(3, 1);
        lagrangeEqualityMultipliers = new DMatrixRMaj(1, 1);
        lagrangeInequalityMultipliers = new DMatrixRMaj(0, 1);
        lagrangeLowerBoundMultipliers = new DMatrixRMaj(0, 1);
        lagrangeUpperBoundMultipliers = new DMatrixRMaj(0, 1);
        numberOfIterations = solver.solve((DMatrix)solution1);
        numberOfIterations = solver.solve((DMatrix)solution2);
        solver.getLagrangeEqualityConstraintMultipliers(lagrangeEqualityMultipliers);
        solver.getLagrangeInequalityConstraintMultipliers(lagrangeInequalityMultipliers);
        solver.getLagrangeLowerBoundsMultipliers(lagrangeLowerBoundMultipliers);
        solver.getLagrangeUpperBoundsMultipliers(lagrangeUpperBoundMultipliers);
        Assertions.assertEquals((int)0, (int)numberOfIterations);
        Assertions.assertEquals((int)3, (int)solution1.getNumRows());
        Assertions.assertEquals((double)solution1.get(0), (double)solution2.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)solution1.get(1), (double)solution2.get(1), (double)1.0E-7);
        Assertions.assertEquals((double)solution1.get(2), (double)solution2.get(2), (double)1.0E-7);
        Assertions.assertEquals((double)1.0, (double)solution1.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)1.0, (double)solution1.get(1), (double)1.0E-7);
        Assertions.assertEquals((double)0.0, (double)solution1.get(2), (double)1.0E-7);
        Assertions.assertEquals((double)-2.0, (double)lagrangeEqualityMultipliers.get(0), (double)1.0E-7);
        solutionMatrix = new DMatrixRMaj(costQuadraticMatrix.getNumRows(), 1);
        solutionMatrix.set((DMatrixD1)solution1);
        objectiveCost = solver.getObjectiveCost(solutionMatrix);
        Assertions.assertEquals((double)2.0, (double)objectiveCost, (double)1.0E-7);
        linearInequalityConstraintsCMatrix = new DMatrixRMaj((double[][])new double[][]{{0.0, 1.0, -1.0}});
        linearInqualityConstraintsDVector = MatrixTools.createVector((double[])new double[]{-8.0});
        solver.setLinearInequalityConstraints((DMatrix)linearInequalityConstraintsCMatrix, (DMatrix)linearInqualityConstraintsDVector);
        solution1 = new DMatrixRMaj(3, 1);
        solution2 = new DMatrixRMaj(3, 1);
        lagrangeEqualityMultipliers = new DMatrixRMaj(1, 1);
        lagrangeInequalityMultipliers = new DMatrixRMaj(1, 1);
        lagrangeLowerBoundMultipliers = new DMatrixRMaj(0, 1);
        lagrangeUpperBoundMultipliers = new DMatrixRMaj(0, 1);
        numberOfIterations = solver.solve((DMatrix)solution1);
        numberOfIterations = solver.solve((DMatrix)solution2);
        solver.getLagrangeEqualityConstraintMultipliers(lagrangeEqualityMultipliers);
        solver.getLagrangeInequalityConstraintMultipliers(lagrangeInequalityMultipliers);
        solver.getLagrangeLowerBoundsMultipliers(lagrangeLowerBoundMultipliers);
        solver.getLagrangeUpperBoundsMultipliers(lagrangeUpperBoundMultipliers);
        Assertions.assertEquals((int)expectedNumberOfIterations2, (int)numberOfIterations);
        Assertions.assertEquals((int)3, (int)solution1.getNumRows());
        Assertions.assertEquals((double)solution1.get(0), (double)solution2.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)solution1.get(1), (double)solution2.get(1), (double)1.0E-7);
        Assertions.assertEquals((double)solution1.get(2), (double)solution2.get(2), (double)1.0E-7);
        Assertions.assertEquals((double)4.0, (double)solution1.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)-2.0, (double)solution1.get(1), (double)1.0E-7);
        Assertions.assertEquals((double)6.0, (double)solution1.get(2), (double)1.0E-7);
        Assertions.assertEquals((double)-8.0, (double)lagrangeEqualityMultipliers.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)12.0, (double)lagrangeInequalityMultipliers.get(0), (double)1.0E-7);
        solutionMatrix = new DMatrixRMaj(costQuadraticMatrix.getNumRows(), 1);
        solutionMatrix.set((DMatrixD1)solution1);
        objectiveCost = solver.getObjectiveCost(solutionMatrix);
        Assertions.assertEquals((double)56.0, (double)objectiveCost, (double)1.0E-7);
        solver.setVariableBounds((DMatrix)this.getLowerBounds(), (DMatrix)this.getUpperBounds());
        solution1 = new DMatrixRMaj(3, 1);
        solution2 = new DMatrixRMaj(3, 1);
        lagrangeEqualityMultipliers = new DMatrixRMaj(1, 1);
        lagrangeInequalityMultipliers = new DMatrixRMaj(1, 1);
        lagrangeLowerBoundMultipliers = new DMatrixRMaj(3, 1);
        lagrangeUpperBoundMultipliers = new DMatrixRMaj(3, 1);
        numberOfIterations = solver.solve((DMatrix)solution1);
        numberOfIterations = solver.solve((DMatrix)solution2);
        solver.getLagrangeEqualityConstraintMultipliers(lagrangeEqualityMultipliers);
        solver.getLagrangeInequalityConstraintMultipliers(lagrangeInequalityMultipliers);
        solver.getLagrangeLowerBoundsMultipliers(lagrangeLowerBoundMultipliers);
        solver.getLagrangeUpperBoundsMultipliers(lagrangeUpperBoundMultipliers);
        Assertions.assertEquals((int)expectedNumberOfIterations1, (int)numberOfIterations);
        Assertions.assertEquals((int)3, (int)solution1.getNumRows());
        Assertions.assertEquals((double)solution1.get(0), (double)solution2.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)solution1.get(1), (double)solution2.get(1), (double)1.0E-7);
        Assertions.assertEquals((double)solution1.get(2), (double)solution2.get(2), (double)1.0E-7);
        Assertions.assertEquals((double)-4.0, (double)solution1.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)6.0, (double)solution1.get(1), (double)1.0E-7);
        Assertions.assertEquals((double)14.0, (double)solution1.get(2), (double)1.0E-7);
        if (!avoidProblematicLagrangeMultipliers) {
            Assertions.assertEquals((double)8.0, (double)lagrangeEqualityMultipliers.get(0), (double)1.0E-7);
            Assertions.assertEquals((double)28.0, (double)lagrangeInequalityMultipliers.get(0), (double)1.0E-7);
            Assertions.assertEquals((double)0.0, (double)lagrangeLowerBoundMultipliers.get(0), (double)1.0E-7);
            Assertions.assertEquals((double)48.0, (double)lagrangeLowerBoundMultipliers.get(1), (double)1.0E-7);
            Assertions.assertEquals((double)0.0, (double)lagrangeLowerBoundMultipliers.get(2), (double)1.0E-7);
            Assertions.assertEquals((double)0.0, (double)lagrangeUpperBoundMultipliers.get(0), (double)1.0E-7);
            Assertions.assertEquals((double)0.0, (double)lagrangeUpperBoundMultipliers.get(1), (double)1.0E-7);
            Assertions.assertEquals((double)0.0, (double)lagrangeUpperBoundMultipliers.get(2), (double)1.0E-7);
        }
        solutionMatrix = new DMatrixRMaj(costQuadraticMatrix.getNumRows(), 1);
        solutionMatrix.set((DMatrixD1)solution1);
        objectiveCost = solver.getObjectiveCost(solutionMatrix);
        Assertions.assertEquals((double)248.0, (double)objectiveCost, (double)1.0E-7);
    }

    @Test
    public void testSolutionMethodsAreAllConsistent() throws NoConvergenceException {
        this.testSolutionMethodsAreAllConsistent(2);
    }

    public void testSolutionMethodsAreAllConsistent(int expectedNumberOfIterations) throws NoConvergenceException {
        ActiveSetQPSolver solver = this.createSolverToTest();
        solver.clear();
        DMatrixRMaj costQuadraticMatrix = new DMatrixRMaj((double[][])new double[][]{{2.0, 0.0}, {0.0, 2.0}});
        DMatrixRMaj costLinearVector = MatrixTools.createVector((double[])new double[]{0.0, 0.0});
        double quadraticCostScalar = 0.0;
        solver.setQuadraticCostFunction((DMatrix)costQuadraticMatrix, (DMatrix)costLinearVector, quadraticCostScalar);
        DMatrixRMaj linearEqualityConstraintsAMatrix = new DMatrixRMaj((double[][])new double[][]{{1.0, 1.0}});
        DMatrixRMaj linearEqualityConstraintsBVector = MatrixTools.createVector((double[])new double[]{2.0});
        solver.setLinearEqualityConstraints((DMatrix)linearEqualityConstraintsAMatrix, (DMatrix)linearEqualityConstraintsBVector);
        DMatrixRMaj linearInequalityConstraintsCMatrix = new DMatrixRMaj((double[][])new double[][]{{0.0, -1.0}, {0.0, -1.0}, {1.0, -1.0}});
        DMatrixRMaj linearInqualityConstraintsDVector = MatrixTools.createVector((double[])new double[]{-0.5, -3.0, 3.0});
        solver.setLinearInequalityConstraints((DMatrix)linearInequalityConstraintsCMatrix, (DMatrix)linearInqualityConstraintsDVector);
        DMatrixRMaj solution = new DMatrixRMaj(2, 1);
        DMatrixRMaj lagrangeEqualityMultipliers = new DMatrixRMaj(1, 1);
        DMatrixRMaj lagrangeInequalityMultipliers = new DMatrixRMaj(3, 1);
        int numberOfIterations = solver.solve((DMatrix)solution);
        solver.getLagrangeEqualityConstraintMultipliers(lagrangeEqualityMultipliers);
        solver.getLagrangeInequalityConstraintMultipliers(lagrangeInequalityMultipliers);
        Assertions.assertEquals((int)expectedNumberOfIterations, (int)numberOfIterations);
        Assertions.assertEquals((int)2, (int)solution.getNumRows());
        Assertions.assertEquals((double)-1.0, (double)solution.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)3.0, (double)solution.get(1), (double)1.0E-7);
        Assertions.assertEquals((double)2.0, (double)lagrangeEqualityMultipliers.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)0.0, (double)lagrangeInequalityMultipliers.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)8.0, (double)lagrangeInequalityMultipliers.get(1), (double)1.0E-7);
        Assertions.assertEquals((double)0.0, (double)lagrangeInequalityMultipliers.get(2), (double)1.0E-7);
        DMatrixRMaj solutionMatrix = new DMatrixRMaj(costQuadraticMatrix.getNumRows(), 1);
        solutionMatrix.set((DMatrixD1)solution);
        double objectiveCost = solver.getObjectiveCost(solutionMatrix);
        Assertions.assertEquals((double)10.0, (double)objectiveCost, (double)1.0E-7);
        solver.clear();
        solver.setQuadraticCostFunction((DMatrix)costQuadraticMatrix, (DMatrix)costLinearVector, quadraticCostScalar);
        solver.setLinearEqualityConstraints((DMatrix)linearEqualityConstraintsAMatrix, (DMatrix)linearEqualityConstraintsBVector);
        solver.setLinearInequalityConstraints((DMatrix)linearInequalityConstraintsCMatrix, (DMatrix)linearInqualityConstraintsDVector);
        numberOfIterations = solver.solve((DMatrix)solution);
        Assertions.assertEquals((int)expectedNumberOfIterations, (int)numberOfIterations);
        Assertions.assertEquals((int)2, (int)solution.getNumRows());
        Assertions.assertEquals((double)-1.0, (double)solution.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)3.0, (double)solution.get(1), (double)1.0E-7);
        Assertions.assertEquals((double)2.0, (double)lagrangeEqualityMultipliers.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)0.0, (double)lagrangeInequalityMultipliers.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)8.0, (double)lagrangeInequalityMultipliers.get(1), (double)1.0E-7);
        Assertions.assertEquals((double)0.0, (double)lagrangeInequalityMultipliers.get(2), (double)1.0E-7);
        solutionMatrix.set((DMatrixD1)solution);
        objectiveCost = solver.getObjectiveCost(solutionMatrix);
        Assertions.assertEquals((double)10.0, (double)objectiveCost, (double)1.0E-7);
        solver.clear();
        DMatrixRMaj quadraticCostMatrix64F = new DMatrixRMaj(costQuadraticMatrix);
        DMatrixRMaj linearCostVector64F = new DMatrixRMaj(costLinearVector.getNumRows(), 1);
        linearCostVector64F.set((DMatrixD1)costLinearVector);
        solver.setQuadraticCostFunction((DMatrix)quadraticCostMatrix64F, (DMatrix)linearCostVector64F, quadraticCostScalar);
        solver.setLinearEqualityConstraints((DMatrix)linearEqualityConstraintsAMatrix, (DMatrix)linearEqualityConstraintsBVector);
        solver.setLinearInequalityConstraints((DMatrix)linearInequalityConstraintsCMatrix, (DMatrix)linearInqualityConstraintsDVector);
        DMatrixRMaj solutionMatrix64F = new DMatrixRMaj(quadraticCostMatrix64F.getNumRows(), 1);
        DMatrixRMaj lagrangeEqualityMultipliers64F = new DMatrixRMaj(linearEqualityConstraintsAMatrix.getNumRows(), 1);
        DMatrixRMaj lagrangeInequalityMultipliers64F = new DMatrixRMaj(linearInequalityConstraintsCMatrix.getNumRows(), 1);
        numberOfIterations = solver.solve((DMatrix)solutionMatrix64F);
        solver.getLagrangeEqualityConstraintMultipliers(lagrangeEqualityMultipliers64F);
        solver.getLagrangeInequalityConstraintMultipliers(lagrangeInequalityMultipliers64F);
        Assertions.assertEquals((int)expectedNumberOfIterations, (int)numberOfIterations);
        Assertions.assertEquals((int)2, (int)solutionMatrix64F.getNumRows());
        Assertions.assertEquals((double)-1.0, (double)solutionMatrix64F.get(0, 0), (double)1.0E-7);
        Assertions.assertEquals((double)3.0, (double)solutionMatrix64F.get(1, 0), (double)1.0E-7);
        Assertions.assertEquals((double)2.0, (double)lagrangeEqualityMultipliers64F.get(0, 0), (double)1.0E-7);
        Assertions.assertEquals((double)0.0, (double)lagrangeInequalityMultipliers64F.get(0, 0), (double)1.0E-7);
        Assertions.assertEquals((double)8.0, (double)lagrangeInequalityMultipliers64F.get(1, 0), (double)1.0E-7);
        Assertions.assertEquals((double)0.0, (double)lagrangeInequalityMultipliers64F.get(2, 0), (double)1.0E-7);
        objectiveCost = solver.getObjectiveCost(solutionMatrix64F);
        Assertions.assertEquals((double)10.0, (double)objectiveCost, (double)1.0E-7);
        solver = this.createSolverToTest();
        solver.setQuadraticCostFunction((DMatrix)quadraticCostMatrix64F, (DMatrix)linearCostVector64F, quadraticCostScalar);
        solver.setLinearEqualityConstraints((DMatrix)linearEqualityConstraintsAMatrix, (DMatrix)linearEqualityConstraintsBVector);
        DMatrixRMaj linearInequalityConstraintsCMatrix64F = new DMatrixRMaj(linearInequalityConstraintsCMatrix);
        DMatrixRMaj linearInqualityConstraintsDVector64F = new DMatrixRMaj(linearInqualityConstraintsDVector.getNumRows(), 1);
        linearInqualityConstraintsDVector64F.set((DMatrixD1)linearInqualityConstraintsDVector);
        solver.setLinearInequalityConstraints((DMatrix)linearInequalityConstraintsCMatrix64F, (DMatrix)linearInqualityConstraintsDVector64F);
        solutionMatrix64F.zero();
        numberOfIterations = solver.solve((DMatrix)solutionMatrix64F);
        Assertions.assertEquals((int)expectedNumberOfIterations, (int)numberOfIterations);
        Assertions.assertEquals((int)2, (int)solutionMatrix64F.getNumRows());
        Assertions.assertEquals((double)-1.0, (double)solutionMatrix64F.get(0, 0), (double)1.0E-7);
        Assertions.assertEquals((double)3.0, (double)solutionMatrix64F.get(1, 0), (double)1.0E-7);
        objectiveCost = solver.getObjectiveCost(solutionMatrix64F);
        Assertions.assertEquals((double)10.0, (double)objectiveCost, (double)1.0E-7);
    }

    @Test
    public void test2DCasesWithPolygonConstraints() {
        this.test2DCasesWithPolygonConstraints(2, 3);
    }

    public void test2DCasesWithPolygonConstraints(int firstExpectedNumberOfIterations, int secondExpectedNumberOfIterations) {
        ActiveSetQPSolver solver = this.createSolverToTest();
        DMatrixRMaj costQuadraticMatrix = new DMatrixRMaj((double[][])new double[][]{{2.0, 0.0}, {0.0, 2.0}});
        DMatrixRMaj costLinearVector = MatrixTools.createVector((double[])new double[]{0.0, 0.0});
        double quadraticCostScalar = 0.0;
        solver.setQuadraticCostFunction((DMatrix)costQuadraticMatrix, (DMatrix)costLinearVector, quadraticCostScalar);
        DMatrixRMaj linearInequalityConstraintsCMatrix = new DMatrixRMaj((double[][])new double[][]{{1.0, 0.0}, {-1.0, 0.0}, {0.0, 1.0}, {0.0, -1.0}});
        DMatrixRMaj linearInqualityConstraintsDVector = MatrixTools.createVector((double[])new double[]{5.0, -3.0, 4.0, -2.0});
        solver.setLinearInequalityConstraints((DMatrix)linearInequalityConstraintsCMatrix, (DMatrix)linearInqualityConstraintsDVector);
        DMatrixRMaj solution = new DMatrixRMaj(2, 1);
        DMatrixRMaj lagrangeEqualityMultipliers = new DMatrixRMaj(0, 1);
        DMatrixRMaj lagrangeInequalityMultipliers = new DMatrixRMaj(4, 1);
        int numberOfIterations = solver.solve((DMatrix)solution);
        solver.getLagrangeEqualityConstraintMultipliers(lagrangeEqualityMultipliers);
        solver.getLagrangeInequalityConstraintMultipliers(lagrangeInequalityMultipliers);
        Assertions.assertEquals((int)firstExpectedNumberOfIterations, (int)numberOfIterations);
        Assertions.assertEquals((int)2, (int)solution.getNumRows());
        Assertions.assertEquals((double)3.0, (double)solution.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)2.0, (double)solution.get(1), (double)1.0E-7);
        Assertions.assertEquals((double)0.0, (double)lagrangeInequalityMultipliers.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)6.0, (double)lagrangeInequalityMultipliers.get(1), (double)1.0E-7);
        Assertions.assertEquals((double)0.0, (double)lagrangeInequalityMultipliers.get(2), (double)1.0E-7);
        Assertions.assertEquals((double)4.0, (double)lagrangeInequalityMultipliers.get(3), (double)1.0E-7);
        solver.clear();
        costQuadraticMatrix = new DMatrixRMaj((double[][])new double[][]{{2.0, 0.0}, {0.0, 2.0}});
        costLinearVector = MatrixTools.createVector((double[])new double[]{0.0, 0.0});
        quadraticCostScalar = 0.0;
        solver.setQuadraticCostFunction((DMatrix)costQuadraticMatrix, (DMatrix)costLinearVector, quadraticCostScalar);
        linearInequalityConstraintsCMatrix = new DMatrixRMaj((double[][])new double[][]{{-1.0, -1.0}, {-10.0, 1.0}});
        linearInqualityConstraintsDVector = MatrixTools.createVector((double[])new double[]{-2.0, -2.0});
        solver.setLinearInequalityConstraints((DMatrix)linearInequalityConstraintsCMatrix, (DMatrix)linearInqualityConstraintsDVector);
        solution = new DMatrixRMaj(2, 1);
        lagrangeEqualityMultipliers = new DMatrixRMaj(0, 1);
        lagrangeInequalityMultipliers = new DMatrixRMaj(2, 1);
        numberOfIterations = solver.solve((DMatrix)solution);
        solver.getLagrangeEqualityConstraintMultipliers(lagrangeEqualityMultipliers);
        solver.getLagrangeInequalityConstraintMultipliers(lagrangeInequalityMultipliers);
        Assertions.assertEquals((int)secondExpectedNumberOfIterations, (int)numberOfIterations);
        Assertions.assertEquals((int)2, (int)solution.getNumRows());
        Assertions.assertEquals((double)1.0, (double)solution.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)1.0, (double)solution.get(1), (double)1.0E-7);
        Assertions.assertEquals((double)2.0, (double)lagrangeInequalityMultipliers.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)0.0, (double)lagrangeInequalityMultipliers.get(1), (double)1.0E-7);
    }

    @Disabled
    @Test
    public void testChallengingCasesWithPolygonConstraints() {
        this.testChallengingCasesWithPolygonConstraints(3, 3);
    }

    public void testChallengingCasesWithPolygonConstraints(int expectedNumberOfIterations1, int expectedNumberOfIterations2) {
        ActiveSetQPSolver solver = this.createSolverToTest();
        solver.setMaxNumberOfIterations(10);
        DMatrixRMaj costQuadraticMatrix = new DMatrixRMaj((double[][])new double[][]{{2.0, 0.0}, {0.0, 2.0}});
        DMatrixRMaj costLinearVector = MatrixTools.createVector((double[])new double[]{0.0, 0.0});
        double quadraticCostScalar = 0.0;
        solver.setQuadraticCostFunction((DMatrix)costQuadraticMatrix, (DMatrix)costLinearVector, quadraticCostScalar);
        DMatrixRMaj linearInequalityConstraintsCMatrix = new DMatrixRMaj((double[][])new double[][]{{-1.0, -1.0}, {-10.0, 1.0}, {1.0, -10.0}});
        DMatrixRMaj linearInqualityConstraintsDVector = MatrixTools.createVector((double[])new double[]{-2.0, -2.0, -2.0});
        solver.setLinearInequalityConstraints((DMatrix)linearInequalityConstraintsCMatrix, (DMatrix)linearInqualityConstraintsDVector);
        DMatrixRMaj solution = new DMatrixRMaj(2, 1);
        DMatrixRMaj lagrangeEqualityMultipliers = new DMatrixRMaj(0, 1);
        DMatrixRMaj lagrangeInequalityMultipliers = new DMatrixRMaj(3, 1);
        int numberOfIterations = solver.solve((DMatrix)solution);
        solver.getLagrangeEqualityConstraintMultipliers(lagrangeEqualityMultipliers);
        solver.getLagrangeInequalityConstraintMultipliers(lagrangeInequalityMultipliers);
        Assertions.assertEquals((int)expectedNumberOfIterations1, (int)numberOfIterations);
        Assertions.assertEquals((int)2, (int)solution.getNumRows());
        Assertions.assertEquals((double)1.0, (double)solution.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)1.0, (double)solution.get(1), (double)1.0E-7);
        Assertions.assertEquals((double)2.0, (double)lagrangeInequalityMultipliers.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)0.0, (double)lagrangeInequalityMultipliers.get(1), (double)1.0E-7);
        Assertions.assertEquals((double)0.0, (double)lagrangeInequalityMultipliers.get(2), (double)1.0E-7);
        solver.clear();
        costQuadraticMatrix = new DMatrixRMaj((double[][])new double[][]{{2.0, 0.0}, {0.0, 2.0}});
        costLinearVector = MatrixTools.createVector((double[])new double[]{0.0, 0.0});
        quadraticCostScalar = 0.0;
        solver.setQuadraticCostFunction((DMatrix)costQuadraticMatrix, (DMatrix)costLinearVector, quadraticCostScalar);
        linearInequalityConstraintsCMatrix = new DMatrixRMaj((double[][])new double[][]{{-10.0, 1.0}, {-1.0, -1.0}, {1.0, -10.0}});
        linearInqualityConstraintsDVector = MatrixTools.createVector((double[])new double[]{-2.0, -2.0, -2.0});
        solver.setLinearInequalityConstraints((DMatrix)linearInequalityConstraintsCMatrix, (DMatrix)linearInqualityConstraintsDVector);
        solution = new DMatrixRMaj(2, 1);
        lagrangeEqualityMultipliers = new DMatrixRMaj(0, 1);
        lagrangeInequalityMultipliers = new DMatrixRMaj(3, 1);
        numberOfIterations = solver.solve((DMatrix)solution);
        solver.getLagrangeEqualityConstraintMultipliers(lagrangeEqualityMultipliers);
        solver.getLagrangeInequalityConstraintMultipliers(lagrangeInequalityMultipliers);
        Assertions.assertEquals((int)expectedNumberOfIterations2, (int)numberOfIterations);
        Assertions.assertEquals((int)2, (int)solution.getNumRows());
        Assertions.assertEquals((double)1.0, (double)solution.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)1.0, (double)solution.get(1), (double)1.0E-7);
        Assertions.assertEquals((double)0.0, (double)lagrangeInequalityMultipliers.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)2.0, (double)lagrangeInequalityMultipliers.get(1), (double)1.0E-7);
        Assertions.assertEquals((double)0.0, (double)lagrangeInequalityMultipliers.get(2), (double)1.0E-7);
    }

    @Test
    public void testChallengingCasesWithPolygonConstraintsCheckFailsWithSimpleSolver() {
        ActiveSetQPSolver solver = this.createSolverToTest();
        solver.setMaxNumberOfIterations(10);
        DMatrixRMaj costQuadraticMatrix = new DMatrixRMaj((double[][])new double[][]{{2.0, 0.0}, {0.0, 2.0}});
        DMatrixRMaj costLinearVector = MatrixTools.createVector((double[])new double[]{0.0, 0.0});
        double quadraticCostScalar = 0.0;
        solver.setQuadraticCostFunction((DMatrix)costQuadraticMatrix, (DMatrix)costLinearVector, quadraticCostScalar);
        DMatrixRMaj linearInequalityConstraintsCMatrix = new DMatrixRMaj((double[][])new double[][]{{-1.0, -1.0}, {-10.0, 1.0}, {1.0, -10.0}});
        DMatrixRMaj linearInqualityConstraintsDVector = MatrixTools.createVector((double[])new double[]{-2.0, -2.0, -2.0});
        solver.setLinearInequalityConstraints((DMatrix)linearInequalityConstraintsCMatrix, (DMatrix)linearInqualityConstraintsDVector);
        DMatrixRMaj solution = new DMatrixRMaj(2, 1);
        DMatrixRMaj lagrangeEqualityMultipliers = new DMatrixRMaj(0, 1);
        DMatrixRMaj lagrangeInequalityMultipliers = new DMatrixRMaj(3, 1);
        solver.solve((DMatrix)solution);
        solver.getLagrangeEqualityConstraintMultipliers(lagrangeEqualityMultipliers);
        solver.getLagrangeInequalityConstraintMultipliers(lagrangeInequalityMultipliers);
        Assertions.assertEquals((int)2, (int)solution.getNumRows());
        Assertions.assertTrue((boolean)Double.isNaN(solution.get(0)));
        Assertions.assertTrue((boolean)Double.isNaN(solution.get(1)));
        Assertions.assertTrue((Double.isInfinite(lagrangeInequalityMultipliers.get(0)) || Double.isNaN(lagrangeInequalityMultipliers.get(0)) ? 1 : 0) != 0);
        Assertions.assertTrue((Double.isInfinite(lagrangeInequalityMultipliers.get(1)) || Double.isNaN(lagrangeInequalityMultipliers.get(1)) ? 1 : 0) != 0);
        Assertions.assertTrue((Double.isInfinite(lagrangeInequalityMultipliers.get(2)) || Double.isNaN(lagrangeInequalityMultipliers.get(2)) ? 1 : 0) != 0);
    }

    @Disabled
    @Test
    public void testCaseWithNoSolution() {
        ActiveSetQPSolver solver = this.createSolverToTest();
        int maxNumberOfIterations = 10;
        solver.setMaxNumberOfIterations(maxNumberOfIterations);
        DMatrixRMaj costQuadraticMatrix = new DMatrixRMaj((double[][])new double[][]{{2.0, 0.0}, {0.0, 2.0}});
        DMatrixRMaj costLinearVector = MatrixTools.createVector((double[])new double[]{0.0, 0.0});
        double quadraticCostScalar = 0.0;
        solver.setQuadraticCostFunction((DMatrix)costQuadraticMatrix, (DMatrix)costLinearVector, quadraticCostScalar);
        DMatrixRMaj linearEqualityConstraintsAMatrix = new DMatrixRMaj((double[][])new double[][]{{1.0, 1.0}});
        DMatrixRMaj linearEqualityConstraintsBVector = MatrixTools.createVector((double[])new double[]{5.0});
        solver.setLinearEqualityConstraints((DMatrix)linearEqualityConstraintsAMatrix, (DMatrix)linearEqualityConstraintsBVector);
        DMatrixRMaj linearInequalityConstraintsCMatrix = new DMatrixRMaj((double[][])new double[][]{{1.0, 1.0}});
        DMatrixRMaj linearInqualityConstraintsDVector = MatrixTools.createVector((double[])new double[]{2.0});
        solver.setLinearInequalityConstraints((DMatrix)linearInequalityConstraintsCMatrix, (DMatrix)linearInqualityConstraintsDVector);
        DMatrixRMaj solution = new DMatrixRMaj(2, 1);
        DMatrixRMaj lagrangeEqualityMultipliers = new DMatrixRMaj(1, 1);
        DMatrixRMaj lagrangeInequalityMultipliers = new DMatrixRMaj(1, 1);
        solver.solve((DMatrix)solution);
        solver.getLagrangeEqualityConstraintMultipliers(lagrangeEqualityMultipliers);
        solver.getLagrangeInequalityConstraintMultipliers(lagrangeInequalityMultipliers);
        Assertions.assertEquals((int)2, (int)solution.getNumRows());
        Assertions.assertEquals((double)Double.NaN, (double)solution.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)Double.NaN, (double)solution.get(1), (double)1.0E-7);
        Assertions.assertTrue((boolean)Double.isInfinite(lagrangeEqualityMultipliers.get(0)));
        Assertions.assertTrue((boolean)Double.isInfinite(lagrangeInequalityMultipliers.get(0)));
    }

    @Test
    public void testLargeRandomProblemWithInequalityConstraints() {
        Random random = new Random(1776L);
        ActiveSetQPSolver solver = this.createSolverToTest();
        int numberOfTests = 100;
        long startTimeMillis = System.currentTimeMillis();
        int maxNumberOfIterations = 0;
        int numberOfVariables = 80;
        int numberOfEqualityConstraints = 10;
        int numberOfInequalityConstraints = 36;
        DMatrixRMaj solution = new DMatrixRMaj(numberOfVariables, 1);
        DMatrixRMaj lagrangeEqualityMultipliers = new DMatrixRMaj(numberOfEqualityConstraints, 1);
        DMatrixRMaj lagrangeInequalityMultipliers = new DMatrixRMaj(numberOfInequalityConstraints, 1);
        double[] solutionWithSmallPerturbation = new double[numberOfVariables];
        DMatrixRMaj augmentedLinearEqualityConstraintsAMatrix = new DMatrixRMaj(0, 0);
        DMatrixRMaj augmentedLinearEqualityConstraintsBVector = new DMatrixRMaj(0, 0);
        for (int testNumber = 0; testNumber < numberOfTests; ++testNumber) {
            solver.clear();
            DMatrixRMaj costQuadraticMatrix = AbstractSimpleActiveSetQPSolverTest.nextDMatrixRMaj(random, numberOfVariables, numberOfVariables);
            DMatrixRMaj identity = CommonOps_DDRM.identity((int)numberOfVariables, (int)numberOfVariables);
            CommonOps_DDRM.scale((double)numberOfVariables, (DMatrixD1)identity);
            CommonOps_DDRM.addEquals((DMatrixD1)costQuadraticMatrix, (DMatrixD1)identity);
            DMatrixRMaj costLinearVector = AbstractSimpleActiveSetQPSolverTest.nextDMatrixRMaj(random, numberOfVariables, 1);
            double quadraticCostScalar = RandomNumbers.nextDouble((Random)random, (double)30.0);
            solver.setQuadraticCostFunction((DMatrix)costQuadraticMatrix, (DMatrix)costLinearVector, quadraticCostScalar);
            DMatrixRMaj linearEqualityConstraintsAMatrix = AbstractSimpleActiveSetQPSolverTest.nextDMatrixRMaj(random, numberOfEqualityConstraints, numberOfVariables);
            DMatrixRMaj linearEqualityConstraintsBVector = AbstractSimpleActiveSetQPSolverTest.nextDMatrixRMaj(random, numberOfEqualityConstraints, 1);
            solver.setLinearEqualityConstraints((DMatrix)linearEqualityConstraintsAMatrix, (DMatrix)linearEqualityConstraintsBVector);
            DMatrixRMaj linearInequalityConstraintsCMatrix = AbstractSimpleActiveSetQPSolverTest.nextDMatrixRMaj(random, numberOfInequalityConstraints, numberOfVariables);
            DMatrixRMaj linearInequalityConstraintsDVector = AbstractSimpleActiveSetQPSolverTest.nextDMatrixRMaj(random, numberOfInequalityConstraints, 1);
            solver.setLinearInequalityConstraints((DMatrix)linearInequalityConstraintsCMatrix, (DMatrix)linearInequalityConstraintsDVector);
            int numberOfIterations = solver.solve((DMatrix)solution);
            solver.getLagrangeEqualityConstraintMultipliers(lagrangeEqualityMultipliers);
            solver.getLagrangeInequalityConstraintMultipliers(lagrangeInequalityMultipliers);
            if (numberOfIterations > maxNumberOfIterations) {
                maxNumberOfIterations = numberOfIterations;
            }
            Assertions.assertEquals((int)numberOfVariables, (int)solution.getNumRows());
            Assertions.assertEquals((int)numberOfEqualityConstraints, (int)lagrangeEqualityMultipliers.getNumRows());
            double objectiveCost = solver.getObjectiveCost(solution);
            this.verifyEqualityConstraintsHold(numberOfEqualityConstraints, linearEqualityConstraintsAMatrix, linearEqualityConstraintsBVector, solution);
            this.verifyInequalityConstraintsHold(numberOfInequalityConstraints, linearInequalityConstraintsCMatrix, linearInequalityConstraintsDVector, solution);
            for (int i = 0; i < numberOfVariables; ++i) {
                solutionWithSmallPerturbation[i] = solution.get(i, 0) + RandomNumbers.nextDouble((Random)random, (double)1.0E-4);
            }
            solution.zero();
            solution.setData(solutionWithSmallPerturbation);
            this.verifyEqualityConstraintsDoNotHold(numberOfEqualityConstraints, linearEqualityConstraintsAMatrix, linearEqualityConstraintsBVector, solution);
            this.verifyInequalityConstraintsDoNotHold(numberOfInequalityConstraints, linearInequalityConstraintsCMatrix, linearInequalityConstraintsDVector, solution);
            int activeSetSize = 0;
            for (int i = 0; i < numberOfInequalityConstraints; ++i) {
                double lagrangeMultiplier = lagrangeInequalityMultipliers.get(i, 0);
                if (lagrangeMultiplier < 0.0) {
                    throw new RuntimeException("Received a negative lagrange multiplier.");
                }
                if (!(lagrangeMultiplier > 0.0)) continue;
                ++activeSetSize;
            }
            augmentedLinearEqualityConstraintsAMatrix.reshape(numberOfEqualityConstraints + activeSetSize, numberOfVariables);
            augmentedLinearEqualityConstraintsBVector.reshape(numberOfEqualityConstraints + activeSetSize, 1);
            CommonOps_DDRM.extract((DMatrix)linearEqualityConstraintsAMatrix, (int)0, (int)numberOfEqualityConstraints, (int)0, (int)numberOfVariables, (DMatrix)augmentedLinearEqualityConstraintsAMatrix, (int)0, (int)0);
            CommonOps_DDRM.extract((DMatrix)linearEqualityConstraintsBVector, (int)0, (int)numberOfEqualityConstraints, (int)0, (int)1, (DMatrix)augmentedLinearEqualityConstraintsBVector, (int)0, (int)0);
            int index = 0;
            for (int i = 0; i < numberOfInequalityConstraints; ++i) {
                double lagrangeMultiplier = lagrangeInequalityMultipliers.get(i, 0);
                if (lagrangeMultiplier < 0.0) {
                    throw new RuntimeException();
                }
                if (!(lagrangeMultiplier > 0.0)) continue;
                CommonOps_DDRM.extract((DMatrix)linearInequalityConstraintsCMatrix, (int)i, (int)(i + 1), (int)0, (int)numberOfVariables, (DMatrix)augmentedLinearEqualityConstraintsAMatrix, (int)(numberOfEqualityConstraints + index), (int)0);
                CommonOps_DDRM.extract((DMatrix)linearInequalityConstraintsDVector, (int)i, (int)(i + 1), (int)0, (int)1, (DMatrix)augmentedLinearEqualityConstraintsBVector, (int)(numberOfEqualityConstraints + index), (int)0);
                ++index;
            }
            DMatrixRMaj solutionMatrixProjectedOntoEqualityConstraints = this.projectOntoEqualityConstraints(solution, augmentedLinearEqualityConstraintsAMatrix, augmentedLinearEqualityConstraintsBVector);
            this.verifyEqualityConstraintsHold(numberOfEqualityConstraints + activeSetSize, augmentedLinearEqualityConstraintsAMatrix, augmentedLinearEqualityConstraintsBVector, solutionMatrixProjectedOntoEqualityConstraints);
            double objectiveCostWithSmallPerturbation = solver.getObjectiveCost(solutionMatrixProjectedOntoEqualityConstraints);
            Assertions.assertTrue((objectiveCostWithSmallPerturbation > objectiveCost ? 1 : 0) != 0, (String)("objectiveCostWithSmallPerturbation = " + objectiveCostWithSmallPerturbation + ", objectiveCost = " + objectiveCost));
        }
        long endTimeMillis = System.currentTimeMillis();
        double timePerTest = (double)(endTimeMillis - startTimeMillis) * 0.001 / (double)numberOfTests;
    }

    @Test
    public void testLargeRandomProblemWithInequalityAndBoundsConstraints() {
        Random random = new Random(1776L);
        ActiveSetQPSolver solver = this.createSolverToTest();
        int numberOfTests = 100;
        long startTimeMillis = System.currentTimeMillis();
        int maxNumberOfIterations = 0;
        int numberOfVariables = 80;
        int numberOfEqualityConstraints = 10;
        int numberOfInequalityConstraints = 36;
        DMatrixRMaj solution = new DMatrixRMaj(0, 1);
        DMatrixRMaj lagrangeEqualityMultipliers = new DMatrixRMaj(0, 1);
        DMatrixRMaj lagrangeInequalityMultipliers = new DMatrixRMaj(0, 1);
        DMatrixRMaj lagrangeLowerBoundMultipliers = new DMatrixRMaj(0, 1);
        DMatrixRMaj lagrangeUpperBoundMultipliers = new DMatrixRMaj(0, 1);
        DMatrixRMaj solutionWithSmallPerturbation = new DMatrixRMaj(numberOfVariables, 1);
        DMatrixRMaj augmentedLinearEqualityConstraintsAMatrix = new DMatrixRMaj(0, 1);
        DMatrixRMaj augmentedLinearEqualityConstraintsBVector = new DMatrixRMaj(0, 1);
        int numberOfNaNSolutions = 0;
        for (int testNumber = 0; testNumber < numberOfTests; ++testNumber) {
            double lagrangeMultiplier;
            int i;
            solver.clear();
            DMatrixRMaj costQuadraticMatrix = AbstractSimpleActiveSetQPSolverTest.nextDMatrixRMaj(random, numberOfVariables, numberOfVariables);
            DMatrixRMaj identity = CommonOps_DDRM.identity((int)numberOfVariables, (int)numberOfVariables);
            CommonOps_DDRM.scale((double)numberOfVariables, (DMatrixD1)identity);
            CommonOps_DDRM.addEquals((DMatrixD1)costQuadraticMatrix, (DMatrixD1)identity);
            DMatrixRMaj costLinearVector = AbstractSimpleActiveSetQPSolverTest.nextDMatrixRMaj(random, numberOfVariables, 1);
            double quadraticCostScalar = RandomNumbers.nextDouble((Random)random, (double)30.0);
            solver.setQuadraticCostFunction((DMatrix)costQuadraticMatrix, (DMatrix)costLinearVector, quadraticCostScalar);
            DMatrixRMaj linearEqualityConstraintsAMatrix = AbstractSimpleActiveSetQPSolverTest.nextDMatrixRMaj(random, numberOfEqualityConstraints, numberOfVariables);
            DMatrixRMaj linearEqualityConstraintsBVector = AbstractSimpleActiveSetQPSolverTest.nextDMatrixRMaj(random, numberOfEqualityConstraints, 1);
            solver.setLinearEqualityConstraints((DMatrix)linearEqualityConstraintsAMatrix, (DMatrix)linearEqualityConstraintsBVector);
            DMatrixRMaj linearInequalityConstraintsCMatrix = AbstractSimpleActiveSetQPSolverTest.nextDMatrixRMaj(random, numberOfInequalityConstraints, numberOfVariables);
            DMatrixRMaj linearInequalityConstraintsDVector = AbstractSimpleActiveSetQPSolverTest.nextDMatrixRMaj(random, numberOfInequalityConstraints, 1);
            solver.setLinearInequalityConstraints((DMatrix)linearInequalityConstraintsCMatrix, (DMatrix)linearInequalityConstraintsDVector);
            DMatrixRMaj variableLowerBounds = AbstractSimpleActiveSetQPSolverTest.nextDMatrixRMaj(random, numberOfVariables, 1, -5.0, -0.01);
            DMatrixRMaj variableUpperBounds = AbstractSimpleActiveSetQPSolverTest.nextDMatrixRMaj(random, numberOfVariables, 1, 0.01, 5.0);
            solver.setVariableBounds((DMatrix)variableLowerBounds, (DMatrix)variableUpperBounds);
            solution.reshape(numberOfVariables, 1);
            int numberOfIterations = solver.solve((DMatrix)solution);
            solver.getLagrangeEqualityConstraintMultipliers(lagrangeEqualityMultipliers);
            solver.getLagrangeInequalityConstraintMultipliers(lagrangeInequalityMultipliers);
            solver.getLagrangeLowerBoundsMultipliers(lagrangeLowerBoundMultipliers);
            solver.getLagrangeUpperBoundsMultipliers(lagrangeUpperBoundMultipliers);
            if (numberOfIterations > maxNumberOfIterations) {
                maxNumberOfIterations = numberOfIterations;
            }
            Assertions.assertEquals((int)numberOfVariables, (int)solution.getNumRows());
            Assertions.assertEquals((int)numberOfEqualityConstraints, (int)lagrangeEqualityMultipliers.getNumRows());
            Assertions.assertEquals((int)numberOfInequalityConstraints, (int)lagrangeInequalityMultipliers.getNumRows());
            Assertions.assertEquals((int)variableLowerBounds.getNumRows(), (int)lagrangeLowerBoundMultipliers.getNumRows());
            Assertions.assertEquals((int)variableUpperBounds.getNumRows(), (int)lagrangeUpperBoundMultipliers.getNumRows());
            if (Double.isNaN(solution.get(0))) {
                ++numberOfNaNSolutions;
                continue;
            }
            double objectiveCost = solver.getObjectiveCost(solution);
            this.verifyEqualityConstraintsHold(numberOfEqualityConstraints, linearEqualityConstraintsAMatrix, linearEqualityConstraintsBVector, solution);
            this.verifyInequalityConstraintsHold(numberOfInequalityConstraints, linearInequalityConstraintsCMatrix, linearInequalityConstraintsDVector, solution);
            this.verifyVariableBoundsHold(testNumber, variableLowerBounds, variableUpperBounds, solution);
            for (int i2 = 0; i2 < numberOfVariables; ++i2) {
                solutionWithSmallPerturbation.set(i2, solution.get(i2, 0) + RandomNumbers.nextDouble((Random)random, (double)0.005));
            }
            solution.zero();
            solution.set((DMatrixD1)solutionWithSmallPerturbation);
            this.verifyEqualityConstraintsDoNotHold(numberOfEqualityConstraints, linearEqualityConstraintsAMatrix, linearEqualityConstraintsBVector, solution);
            this.verifyInequalityConstraintsDoNotHold(numberOfInequalityConstraints, linearInequalityConstraintsCMatrix, linearInequalityConstraintsDVector, solution);
            int activeInequalitiesSize = 0;
            for (int i3 = 0; i3 < numberOfInequalityConstraints; ++i3) {
                double lagrangeMultiplier2 = lagrangeInequalityMultipliers.get(i3, 0);
                if (lagrangeMultiplier2 < 0.0) {
                    throw new RuntimeException("Received a negative lagrange multiplier.");
                }
                if (!(lagrangeMultiplier2 > 0.0)) continue;
                ++activeInequalitiesSize;
            }
            int activeLowerBoundsSize = 0;
            for (int i4 = 0; i4 < variableLowerBounds.getNumRows(); ++i4) {
                double lagrangeMultiplier3 = lagrangeLowerBoundMultipliers.get(i4, 0);
                if (lagrangeMultiplier3 < 0.0) {
                    throw new RuntimeException();
                }
                if (!(lagrangeMultiplier3 > 0.0)) continue;
                ++activeLowerBoundsSize;
            }
            int activeUpperBoundsSize = 0;
            for (int i5 = 0; i5 < variableUpperBounds.getNumRows(); ++i5) {
                double lagrangeMultiplier4 = lagrangeUpperBoundMultipliers.get(i5, 0);
                if (lagrangeMultiplier4 < 0.0) {
                    throw new RuntimeException();
                }
                if (!(lagrangeMultiplier4 > 0.0)) continue;
                ++activeUpperBoundsSize;
            }
            augmentedLinearEqualityConstraintsAMatrix.reshape(numberOfEqualityConstraints + activeInequalitiesSize + activeLowerBoundsSize + activeUpperBoundsSize, numberOfVariables);
            augmentedLinearEqualityConstraintsBVector.reshape(numberOfEqualityConstraints + activeInequalitiesSize + activeLowerBoundsSize + activeUpperBoundsSize, 1);
            augmentedLinearEqualityConstraintsAMatrix.zero();
            augmentedLinearEqualityConstraintsBVector.zero();
            CommonOps_DDRM.extract((DMatrix)linearEqualityConstraintsAMatrix, (int)0, (int)numberOfEqualityConstraints, (int)0, (int)numberOfVariables, (DMatrix)augmentedLinearEqualityConstraintsAMatrix, (int)0, (int)0);
            CommonOps_DDRM.extract((DMatrix)linearEqualityConstraintsBVector, (int)0, (int)numberOfEqualityConstraints, (int)0, (int)1, (DMatrix)augmentedLinearEqualityConstraintsBVector, (int)0, (int)0);
            int index = 0;
            for (i = 0; i < numberOfInequalityConstraints; ++i) {
                lagrangeMultiplier = lagrangeInequalityMultipliers.get(i, 0);
                if (lagrangeMultiplier < 0.0) {
                    throw new RuntimeException();
                }
                if (!(lagrangeMultiplier > 0.0)) continue;
                CommonOps_DDRM.extract((DMatrix)linearInequalityConstraintsCMatrix, (int)i, (int)(i + 1), (int)0, (int)numberOfVariables, (DMatrix)augmentedLinearEqualityConstraintsAMatrix, (int)(numberOfEqualityConstraints + index), (int)0);
                CommonOps_DDRM.extract((DMatrix)linearInequalityConstraintsDVector, (int)i, (int)(i + 1), (int)0, (int)1, (DMatrix)augmentedLinearEqualityConstraintsBVector, (int)(numberOfEqualityConstraints + index), (int)0);
                ++index;
            }
            for (i = 0; i < variableLowerBounds.getNumRows(); ++i) {
                lagrangeMultiplier = lagrangeLowerBoundMultipliers.get(i, 0);
                if (!(lagrangeMultiplier > 0.0)) continue;
                augmentedLinearEqualityConstraintsAMatrix.set(numberOfEqualityConstraints + index, i, -1.0);
                augmentedLinearEqualityConstraintsBVector.set(numberOfEqualityConstraints + index, -variableLowerBounds.get(i));
                ++index;
            }
            for (i = 0; i < variableUpperBounds.getNumRows(); ++i) {
                lagrangeMultiplier = lagrangeUpperBoundMultipliers.get(i, 0);
                if (!(lagrangeMultiplier > 0.0)) continue;
                augmentedLinearEqualityConstraintsAMatrix.set(numberOfEqualityConstraints + index, i, 1.0);
                augmentedLinearEqualityConstraintsBVector.set(numberOfEqualityConstraints + index, variableUpperBounds.get(i));
                ++index;
            }
            Assertions.assertTrue((index == activeInequalitiesSize + activeLowerBoundsSize + activeUpperBoundsSize ? 1 : 0) != 0);
            DMatrixRMaj solutionMatrixProjectedOntoEqualityConstraints = this.projectOntoEqualityConstraints(solution, augmentedLinearEqualityConstraintsAMatrix, augmentedLinearEqualityConstraintsBVector);
            this.verifyEqualityConstraintsHold(numberOfEqualityConstraints + activeInequalitiesSize + activeLowerBoundsSize + activeUpperBoundsSize, augmentedLinearEqualityConstraintsAMatrix, augmentedLinearEqualityConstraintsBVector, solutionMatrixProjectedOntoEqualityConstraints);
            double maxSignedError = this.getMaxInequalityConstraintError(numberOfInequalityConstraints, linearInequalityConstraintsCMatrix, linearInequalityConstraintsDVector, solutionMatrixProjectedOntoEqualityConstraints);
            double objectiveCostWithSmallPerturbation = solver.getObjectiveCost(solutionMatrixProjectedOntoEqualityConstraints);
            if (!(maxSignedError < 1.0E-7)) continue;
            Assertions.assertTrue((objectiveCostWithSmallPerturbation > objectiveCost ? 1 : 0) != 0, (String)("objectiveCostWithSmallPerturbation = " + objectiveCostWithSmallPerturbation + ", objectiveCost = " + objectiveCost));
        }
        Assertions.assertTrue(((double)numberOfNaNSolutions < 0.05 * (double)numberOfTests ? 1 : 0) != 0);
        long endTimeMillis = System.currentTimeMillis();
        double timePerTest = (double)(endTimeMillis - startTimeMillis) * 0.001 / (double)numberOfTests;
    }

    @Test
    public void testFindValidSolutionForDataset20160319() {
        ActualDatasetFrom20160319 dataset = new ActualDatasetFrom20160319();
        ActiveSetQPSolver solver = this.createSolverToTest();
        solver.clear();
        solver.setQuadraticCostFunction((DMatrix)dataset.getCostQuadraticMatrix(), (DMatrix)dataset.getCostLinearVector(), 0.0);
        solver.setVariableBounds((DMatrix)dataset.getVariableLowerBounds(), (DMatrix)dataset.getVariableUpperBounds());
        DMatrixRMaj solution = new DMatrixRMaj(dataset.getProblemSize(), 1);
        solver.solve((DMatrix)solution);
        Assertions.assertFalse((boolean)MatrixTools.containsNaN((DMatrix1Row)solution));
    }

    @Test
    public void testFindValidSolutionForKiwiDataset20170712() {
        ActualDatasetFromKiwi20170712 dataset = new ActualDatasetFromKiwi20170712();
        ActiveSetQPSolver solver = this.createSolverToTest();
        solver.clear();
        solver.setQuadraticCostFunction((DMatrix)dataset.getCostQuadraticMatrix(), (DMatrix)dataset.getCostLinearVector(), 0.0);
        solver.setVariableBounds((DMatrix)dataset.getVariableLowerBounds(), (DMatrix)dataset.getVariableUpperBounds());
        DMatrixRMaj solution = new DMatrixRMaj(dataset.getProblemSize(), 1);
        solver.solve((DMatrix)solution);
        Assertions.assertFalse((boolean)MatrixTools.containsNaN((DMatrix1Row)solution));
    }

    @Test
    public void testFindValidSolutionForKiwiDataset20171013() {
        ActualDatasetFromKiwi20171013 dataset = new ActualDatasetFromKiwi20171013();
        ActiveSetQPSolver solver = this.createSolverToTest();
        solver.clear();
        solver.setQuadraticCostFunction((DMatrix)dataset.getCostQuadraticMatrix(), (DMatrix)dataset.getCostLinearVector(), 0.0);
        solver.setVariableBounds((DMatrix)dataset.getVariableLowerBounds(), (DMatrix)dataset.getVariableUpperBounds());
        DMatrixRMaj solution = new DMatrixRMaj(dataset.getProblemSize(), 1);
        solver.solve((DMatrix)solution);
        Assertions.assertFalse((boolean)MatrixTools.containsNaN((DMatrix1Row)solution));
    }

    @Test
    public void testMaxIterations() {
        this.testMaxIterations(3, true);
    }

    public void testMaxIterations(int maxForSolution, boolean checkLagrangeMultipliers) {
        ActiveSetQPSolver solver = this.createSolverToTest();
        solver.clear();
        DMatrixRMaj costQuadraticMatrix = new DMatrixRMaj((double[][])new double[][]{{2.0, 0.0, 0.0}, {0.0, 2.0, 0.0}, {0.0, 0.0, 2.0}});
        DMatrixRMaj costLinearVector = MatrixTools.createVector((double[])new double[]{0.0, 0.0, 0.0});
        double quadraticCostScalar = 0.0;
        solver.setQuadraticCostFunction((DMatrix)costQuadraticMatrix, (DMatrix)costLinearVector, quadraticCostScalar);
        DMatrixRMaj linearEqualityConstraintsAMatrix = new DMatrixRMaj((double[][])new double[][]{{1.0, 1.0, 0.0}});
        DMatrixRMaj linearEqualityConstraintsBVector = MatrixTools.createVector((double[])new double[]{2.0});
        solver.setLinearEqualityConstraints((DMatrix)linearEqualityConstraintsAMatrix, (DMatrix)linearEqualityConstraintsBVector);
        DMatrixRMaj linearInequalityConstraintsCMatrix = new DMatrixRMaj((double[][])new double[][]{{0.0, 1.0, -1.0}});
        DMatrixRMaj linearInqualityConstraintsDVector = MatrixTools.createVector((double[])new double[]{-8.0});
        solver.setLinearInequalityConstraints((DMatrix)linearInequalityConstraintsCMatrix, (DMatrix)linearInqualityConstraintsDVector);
        solver.setVariableBounds((DMatrix)this.getLowerBounds(), (DMatrix)this.getUpperBounds());
        DMatrixRMaj solution = new DMatrixRMaj(3, 1);
        DMatrixRMaj lagrangeEqualityMultipliers = new DMatrixRMaj(1, 1);
        DMatrixRMaj lagrangeInequalityMultipliers = new DMatrixRMaj(1, 1);
        DMatrixRMaj lagrangeLowerBoundMultipliers = new DMatrixRMaj(3, 1);
        DMatrixRMaj lagrangeUpperBoundMultipliers = new DMatrixRMaj(3, 1);
        solver.setMaxNumberOfIterations(maxForSolution - 1);
        int numberOfIterations = solver.solve((DMatrix)solution);
        solver.getLagrangeEqualityConstraintMultipliers(lagrangeEqualityMultipliers);
        solver.getLagrangeInequalityConstraintMultipliers(lagrangeInequalityMultipliers);
        solver.getLagrangeLowerBoundsMultipliers(lagrangeLowerBoundMultipliers);
        solver.getLagrangeUpperBoundsMultipliers(lagrangeUpperBoundMultipliers);
        Assertions.assertEquals((int)(maxForSolution - 1), (int)numberOfIterations);
        Assertions.assertTrue((boolean)Double.isNaN(solution.get(0)));
        Assertions.assertTrue((boolean)Double.isNaN(solution.get(1)));
        Assertions.assertTrue((boolean)Double.isNaN(solution.get(2)));
        solver.setMaxNumberOfIterations(maxForSolution);
        numberOfIterations = solver.solve((DMatrix)solution);
        solver.getLagrangeEqualityConstraintMultipliers(lagrangeEqualityMultipliers);
        solver.getLagrangeInequalityConstraintMultipliers(lagrangeInequalityMultipliers);
        solver.getLagrangeLowerBoundsMultipliers(lagrangeLowerBoundMultipliers);
        solver.getLagrangeUpperBoundsMultipliers(lagrangeUpperBoundMultipliers);
        Assertions.assertEquals((int)maxForSolution, (int)numberOfIterations);
        Assertions.assertEquals((int)3, (int)solution.getNumRows());
        Assertions.assertEquals((double)-4.0, (double)solution.get(0), (double)1.0E-7);
        Assertions.assertEquals((double)6.0, (double)solution.get(1), (double)1.0E-7);
        Assertions.assertEquals((double)14.0, (double)solution.get(2), (double)1.0E-7);
        if (checkLagrangeMultipliers) {
            Assertions.assertEquals((double)8.0, (double)lagrangeEqualityMultipliers.get(0), (double)1.0E-7);
            Assertions.assertEquals((double)28.0, (double)lagrangeInequalityMultipliers.get(0), (double)1.0E-7);
            Assertions.assertEquals((double)0.0, (double)lagrangeLowerBoundMultipliers.get(0), (double)1.0E-7);
            Assertions.assertEquals((double)48.0, (double)lagrangeLowerBoundMultipliers.get(1), (double)1.0E-7);
            Assertions.assertEquals((double)0.0, (double)lagrangeLowerBoundMultipliers.get(2), (double)1.0E-7);
            Assertions.assertEquals((double)0.0, (double)lagrangeUpperBoundMultipliers.get(0), (double)1.0E-7);
            Assertions.assertEquals((double)0.0, (double)lagrangeUpperBoundMultipliers.get(1), (double)1.0E-7);
            Assertions.assertEquals((double)0.0, (double)lagrangeUpperBoundMultipliers.get(2), (double)1.0E-7);
        }
        DMatrixRMaj solutionMatrix = new DMatrixRMaj(costQuadraticMatrix.getNumRows(), 1);
        solutionMatrix.set((DMatrixD1)solution);
        double objectiveCost = solver.getObjectiveCost(solutionMatrix);
        Assertions.assertEquals((double)248.0, (double)objectiveCost, (double)1.0E-7);
    }

    public DMatrixRMaj getUpperBounds() {
        return MatrixTools.createVector((double[])new double[]{5.0, 10.0, Double.POSITIVE_INFINITY});
    }

    public DMatrixRMaj getLowerBounds() {
        return MatrixTools.createVector((double[])new double[]{-5.0, 6.0, 11.0});
    }

    @Test
    public void testSomeExceptions() {
        ActiveSetQPSolver solver = this.createSolverToTest();
        DMatrixRMaj costQuadraticMatrix = new DMatrixRMaj((double[][])new double[][]{{2.0, 0.0}});
        DMatrixRMaj costLinearVector = MatrixTools.createVector((double[])new double[]{0.0});
        double quadraticCostScalar = 0.0;
        try {
            solver.setQuadraticCostFunction((DMatrix)costQuadraticMatrix, (DMatrix)costLinearVector, quadraticCostScalar);
            Assertions.fail((String)"costQuadraticMatrix needs to be square!");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        costQuadraticMatrix = new DMatrixRMaj((double[][])new double[][]{{2.0, 0.0}, {0.0, 2.0}});
        try {
            solver.setQuadraticCostFunction((DMatrix)costQuadraticMatrix, (DMatrix)costLinearVector, quadraticCostScalar);
            Assertions.fail((String)"costQuadraticMatrix needs to be same length as costLinearVector!");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            DMatrixRMaj costQuadraticMatrix64F = new DMatrixRMaj(2, 2);
            DMatrixRMaj costLinearVector64F = new DMatrixRMaj(1, 2);
            solver.setQuadraticCostFunction((DMatrix)costQuadraticMatrix64F, (DMatrix)costLinearVector64F, quadraticCostScalar);
            Assertions.fail((String)"Wrong size for costLinearVector64F.");
        }
        catch (RuntimeException costQuadraticMatrix64F) {
            // empty catch block
        }
        costLinearVector = MatrixTools.createVector((double[])new double[]{0.0, 0.0});
        solver.setQuadraticCostFunction((DMatrix)costQuadraticMatrix, (DMatrix)costLinearVector, quadraticCostScalar);
        DMatrixRMaj variableLowerBounds = MatrixTools.createVector((double[])new double[]{0.0});
        DMatrixRMaj variableUpperBounds = MatrixTools.createVector((double[])new double[]{0.0, 0.0});
        try {
            solver.setVariableBounds((DMatrix)variableLowerBounds, (DMatrix)variableUpperBounds);
            Assertions.fail((String)"Wrong lower bounds size");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        variableLowerBounds = MatrixTools.createVector((double[])new double[]{0.0, 0.0});
        variableUpperBounds = MatrixTools.createVector((double[])new double[]{0.0});
        try {
            solver.setVariableBounds((DMatrix)variableLowerBounds, (DMatrix)variableUpperBounds);
            Assertions.fail((String)"Wrong upper bounds size");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        variableLowerBounds = MatrixTools.createVector((double[])new double[]{0.0, 0.0});
        variableUpperBounds = MatrixTools.createVector((double[])new double[]{0.0, 0.0});
        solver.setVariableBounds((DMatrix)variableLowerBounds, (DMatrix)variableUpperBounds);
        DMatrixRMaj linearEqualityConstraintsAMatrix = new DMatrixRMaj((double[][])new double[][]{{1.0, 0.0}});
        DMatrixRMaj linearEqualityConstraintsBVector = MatrixTools.createVector((double[])new double[]{1.0, 2.0});
        try {
            solver.setLinearEqualityConstraints((DMatrix)linearEqualityConstraintsAMatrix, (DMatrix)linearEqualityConstraintsBVector);
            Assertions.fail((String)"Wrong size for linearEqualityConstraintsBVector.");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        linearEqualityConstraintsAMatrix = new DMatrixRMaj((double[][])new double[][]{{1.0}});
        linearEqualityConstraintsBVector = MatrixTools.createVector((double[])new double[]{1.0});
        try {
            solver.setLinearEqualityConstraints((DMatrix)linearEqualityConstraintsAMatrix, (DMatrix)linearEqualityConstraintsBVector);
            Assertions.fail((String)"Wrong size for linearEqualityConstraintsBVector.");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            DMatrixRMaj linearEqualityConstraintsAMatrix64F = new DMatrixRMaj(2, 2);
            DMatrixRMaj linearEqualityConstraintsBVector64F = new DMatrixRMaj(1, 2);
            solver.setLinearEqualityConstraints((DMatrix)linearEqualityConstraintsAMatrix64F, (DMatrix)linearEqualityConstraintsBVector64F);
            Assertions.fail((String)"Wrong size for linearEqualityConstraintsBVector.");
        }
        catch (RuntimeException linearEqualityConstraintsAMatrix64F) {
            // empty catch block
        }
        linearEqualityConstraintsAMatrix = new DMatrixRMaj((double[][])new double[][]{{1.0, 0.0}});
        solver.setLinearEqualityConstraints((DMatrix)linearEqualityConstraintsAMatrix, (DMatrix)linearEqualityConstraintsBVector);
        DMatrixRMaj linearInequalityConstraintsCMatrix = new DMatrixRMaj((double[][])new double[][]{{1.0, 0.0}});
        DMatrixRMaj linearInequalityConstraintsDVector = MatrixTools.createVector((double[])new double[]{1.0, 2.0});
        try {
            solver.setLinearInequalityConstraints((DMatrix)linearInequalityConstraintsCMatrix, (DMatrix)linearInequalityConstraintsDVector);
            Assertions.fail((String)"Wrong size for linearInqualityConstraintsDVector.");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        linearInequalityConstraintsCMatrix = new DMatrixRMaj((double[][])new double[][]{{1.0}});
        linearInequalityConstraintsDVector = MatrixTools.createVector((double[])new double[]{1.0});
        try {
            solver.setLinearInequalityConstraints((DMatrix)linearInequalityConstraintsCMatrix, (DMatrix)linearInequalityConstraintsDVector);
            Assertions.fail((String)"Wrong size for linearInqualityConstraintsDVector.");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            DMatrixRMaj linearInequalityConstraintsCMatrix64F = new DMatrixRMaj(2, 2);
            DMatrixRMaj linearInequalityConstraintsDVector64F = new DMatrixRMaj(1, 2);
            solver.setLinearInequalityConstraints((DMatrix)linearInequalityConstraintsCMatrix64F, (DMatrix)linearInequalityConstraintsDVector64F);
            Assertions.fail((String)"Wrong size for linearInequalityConstraintsDVector64F.");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        linearInequalityConstraintsCMatrix = new DMatrixRMaj((double[][])new double[][]{{1.0, 0.0}});
        solver.setLinearInequalityConstraints((DMatrix)linearInequalityConstraintsCMatrix, (DMatrix)linearInequalityConstraintsDVector);
    }

    private void verifyEqualityConstraintsHold(int numberOfEqualityConstraints, DMatrixRMaj linearEqualityConstraintsAMatrix, DMatrixRMaj linearEqualityConstraintsBVector, DMatrixRMaj solutionMatrix) {
        double maxAbsoluteError = this.getMaxEqualityConstraintError(numberOfEqualityConstraints, linearEqualityConstraintsAMatrix, linearEqualityConstraintsBVector, solutionMatrix);
        Assertions.assertEquals((double)0.0, (double)maxAbsoluteError, (double)1.0E-5);
    }

    private void verifyInequalityConstraintsHold(int numberOfEqualityConstraints, DMatrixRMaj linearInequalityConstraintsCMatrix, DMatrixRMaj linearInequalityConstraintsDVector, DMatrixRMaj solutionMatrix) {
        double maxSignedError = this.getMaxInequalityConstraintError(numberOfEqualityConstraints, linearInequalityConstraintsCMatrix, linearInequalityConstraintsDVector, solutionMatrix);
        Assertions.assertTrue((maxSignedError < 1.0E-10 ? 1 : 0) != 0);
    }

    private void verifyEqualityConstraintsDoNotHold(int numberOfEqualityConstraints, DMatrixRMaj linearEqualityConstraintsAMatrix, DMatrixRMaj linearEqualityConstraintsBVector, DMatrixRMaj solutionMatrix) {
        double maxAbsoluteError = this.getMaxEqualityConstraintError(numberOfEqualityConstraints, linearEqualityConstraintsAMatrix, linearEqualityConstraintsBVector, solutionMatrix);
        Assertions.assertTrue((maxAbsoluteError > 1.0E-5 ? 1 : 0) != 0);
    }

    private void verifyInequalityConstraintsDoNotHold(int numberOfInequalityConstraints, DMatrixRMaj linearInequalityConstraintsCMatrix, DMatrixRMaj linearInequalityConstraintsDVector, DMatrixRMaj solutionMatrix) {
        double maxError = this.getMaxInequalityConstraintError(numberOfInequalityConstraints, linearInequalityConstraintsCMatrix, linearInequalityConstraintsDVector, solutionMatrix);
        Assertions.assertTrue((maxError > 1.0E-5 ? 1 : 0) != 0);
    }

    private void verifyVariableBoundsHold(int testNumber, DMatrixRMaj variableLowerBounds, DMatrixRMaj variableUpperBounds, DMatrixRMaj solution) {
        int i;
        for (i = 0; i < variableLowerBounds.getNumRows(); ++i) {
            Assertions.assertTrue((solution.get(i, 0) >= variableLowerBounds.get(i, 0) - 1.0E-7 ? 1 : 0) != 0, (String)("In test number " + testNumber + " the solution " + solution.get(i, 0) + " is less than the lower bound " + variableLowerBounds.get(i, 0)));
        }
        for (i = 0; i < variableUpperBounds.getNumRows(); ++i) {
            Assertions.assertTrue((solution.get(i, 0) <= variableUpperBounds.get(i, 0) + 1.0E-7 ? 1 : 0) != 0);
        }
    }

    private double getMaxEqualityConstraintError(int numberOfEqualityConstraints, DMatrixRMaj linearEqualityConstraintsAMatrix, DMatrixRMaj linearEqualityConstraintsBVector, DMatrixRMaj solutionMatrix) {
        DMatrixRMaj checkMatrix = new DMatrixRMaj(numberOfEqualityConstraints, 1);
        CommonOps_DDRM.mult((DMatrix1Row)linearEqualityConstraintsAMatrix, (DMatrix1Row)solutionMatrix, (DMatrix1Row)checkMatrix);
        CommonOps_DDRM.subtractEquals((DMatrixD1)checkMatrix, (DMatrixD1)linearEqualityConstraintsBVector);
        return this.getMaxAbsoluteDataEntry(checkMatrix);
    }

    private double getMaxInequalityConstraintError(int numberOfInequalityConstraints, DMatrixRMaj linearInequalityConstraintsCMatrix, DMatrixRMaj linearInequalityConstraintsDVector, DMatrixRMaj solutionMatrix) {
        DMatrixRMaj checkMatrix = new DMatrixRMaj(numberOfInequalityConstraints, 1);
        CommonOps_DDRM.mult((DMatrix1Row)linearInequalityConstraintsCMatrix, (DMatrix1Row)solutionMatrix, (DMatrix1Row)checkMatrix);
        CommonOps_DDRM.subtractEquals((DMatrixD1)checkMatrix, (DMatrixD1)linearInequalityConstraintsDVector);
        return this.getMaxSignedDataEntry(checkMatrix);
    }

    private DMatrixRMaj projectOntoEqualityConstraints(DMatrixRMaj solutionMatrix, DMatrixRMaj linearEqualityConstraintsAMatrix, DMatrixRMaj linearEqualityConstraintsBVector) {
        int numberOfVariables = solutionMatrix.getNumRows();
        if (linearEqualityConstraintsAMatrix.getNumCols() != numberOfVariables) {
            throw new RuntimeException();
        }
        int numberOfConstraints = linearEqualityConstraintsAMatrix.getNumRows();
        if (linearEqualityConstraintsBVector.getNumRows() != numberOfConstraints) {
            throw new RuntimeException();
        }
        DMatrixRMaj AZMinusB = new DMatrixRMaj(numberOfConstraints, 1);
        CommonOps_DDRM.mult((DMatrix1Row)linearEqualityConstraintsAMatrix, (DMatrix1Row)solutionMatrix, (DMatrix1Row)AZMinusB);
        CommonOps_DDRM.subtractEquals((DMatrixD1)AZMinusB, (DMatrixD1)linearEqualityConstraintsBVector);
        DMatrixRMaj AATransposeInverse = new DMatrixRMaj(numberOfConstraints, numberOfConstraints);
        DMatrixRMaj linearEqualityConstraintsAMatrixTranspose = new DMatrixRMaj(linearEqualityConstraintsAMatrix);
        CommonOps_DDRM.transpose((DMatrixRMaj)linearEqualityConstraintsAMatrixTranspose);
        CommonOps_DDRM.mult((DMatrix1Row)linearEqualityConstraintsAMatrix, (DMatrix1Row)linearEqualityConstraintsAMatrixTranspose, (DMatrix1Row)AATransposeInverse);
        CommonOps_DDRM.invert((DMatrixRMaj)AATransposeInverse);
        DMatrixRMaj ATransposeAATransposeInverse = new DMatrixRMaj(numberOfVariables, numberOfConstraints);
        CommonOps_DDRM.mult((DMatrix1Row)linearEqualityConstraintsAMatrixTranspose, (DMatrix1Row)AATransposeInverse, (DMatrix1Row)ATransposeAATransposeInverse);
        DMatrixRMaj vectorToSubtract = new DMatrixRMaj(numberOfVariables, 1);
        CommonOps_DDRM.mult((DMatrix1Row)ATransposeAATransposeInverse, (DMatrix1Row)AZMinusB, (DMatrix1Row)vectorToSubtract);
        DMatrixRMaj projectedSolutionMatrix = new DMatrixRMaj(solutionMatrix);
        CommonOps_DDRM.subtractEquals((DMatrixD1)projectedSolutionMatrix, (DMatrixD1)vectorToSubtract);
        return projectedSolutionMatrix;
    }

    private double getMaxAbsoluteDataEntry(DMatrixRMaj matrix) {
        int numberOfRows = matrix.getNumRows();
        int numberOfColumns = matrix.getNumCols();
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < numberOfRows; ++i) {
            for (int j = 0; j < numberOfColumns; ++j) {
                double absoluteValue = Math.abs(matrix.get(i, j));
                if (!(absoluteValue > max)) continue;
                max = absoluteValue;
            }
        }
        return max;
    }

    private double getMaxSignedDataEntry(DMatrixRMaj matrix) {
        int numberOfRows = matrix.getNumRows();
        int numberOfColumns = matrix.getNumCols();
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < numberOfRows; ++i) {
            for (int j = 0; j < numberOfColumns; ++j) {
                double value = matrix.get(i, j);
                if (!(value > max)) continue;
                max = value;
            }
        }
        return max;
    }

    public static DMatrixRMaj nextDMatrixRMaj(Random random, int numberOfRows, int numberOfColumns) {
        return AbstractSimpleActiveSetQPSolverTest.nextDMatrixRMaj(random, numberOfRows, numberOfColumns, 1.0);
    }

    public static DMatrixRMaj nextDMatrixRMaj(Random random, int numberOfRows, int numberOfColumns, double maxAbsoluteValue) {
        return RandomMatrices_DDRM.rectangle((int)numberOfRows, (int)numberOfColumns, (double)(-maxAbsoluteValue), (double)maxAbsoluteValue, (Random)random);
    }

    public static DMatrixRMaj nextDMatrixRMaj(Random random, int numberOfRows, int numberOfColumns, double boundaryOne, double boundaryTwo) {
        return RandomMatrices_DDRM.rectangle((int)numberOfRows, (int)numberOfColumns, (double)boundaryOne, (double)boundaryTwo, (Random)random);
    }
}

