/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.convexOptimization;

import com.joptimizer.functions.ConvexMultivariateRealFunction;
import com.joptimizer.functions.LinearMultivariateRealFunction;
import com.joptimizer.optimizers.JOptimizer;
import com.joptimizer.optimizers.OptimizationRequest;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.ejml.data.DMatrixRMaj;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.yaml.snakeyaml.Yaml;
import us.ihmc.convexOptimization.ConvexOptimizationAdapter;
import us.ihmc.matrixlib.MatrixTools;

public abstract class ConvexOptimizationAdapterTest {
    public abstract ConvexOptimizationAdapter createConvexOptimizationAdapter();

    public abstract double getTestErrorEpsilon();

    @Disabled
    @Test
    public void qpsFileTest() throws IOException {
        DMatrixRMaj beq = new DMatrixRMaj(0, 0);
        DMatrixRMaj Aeq = new DMatrixRMaj(0, 0);
        DMatrixRMaj b = new DMatrixRMaj(0, 0);
        DMatrixRMaj A = new DMatrixRMaj(0, 0);
        DMatrixRMaj H = new DMatrixRMaj(0, 0);
        DMatrixRMaj f = new DMatrixRMaj(0, 0);
        File projectDirectory = new File(new File("").getAbsolutePath());
        File yamlQpProblemDirectory = new File(projectDirectory, "/Matlab/YamlQpProblems");
        File[] yamlQpProblemFileList = yamlQpProblemDirectory.listFiles();
        Yaml yaml = new Yaml();
        for (int i = 0; i < yamlQpProblemFileList.length; ++i) {
            FileInputStream input = new FileInputStream(yamlQpProblemFileList[i]);
            Map object = (Map)yaml.load((InputStream)input);
            System.out.print(object + "\n");
            MatrixTools.yamlFieldToMatrix((DMatrixRMaj)beq, (String)"beq", (Map)object);
            MatrixTools.yamlFieldToMatrix((DMatrixRMaj)Aeq, (String)"Aeq", (Map)object);
            MatrixTools.yamlFieldToMatrix((DMatrixRMaj)A, (String)"A", (Map)object);
            MatrixTools.yamlFieldToMatrix((DMatrixRMaj)b, (String)"b", (Map)object);
            MatrixTools.yamlFieldToMatrix((DMatrixRMaj)H, (String)"H", (Map)object);
            MatrixTools.yamlFieldToMatrix((DMatrixRMaj)f, (String)"f", (Map)object);
        }
    }

    @Test
    public void testASimpleRedundantEqualityCase() {
        ConvexOptimizationAdapter convexOptimizationAdapter = this.createConvexOptimizationAdapter();
        convexOptimizationAdapter.setLinearCostFunctionVector(new double[]{1.0});
        convexOptimizationAdapter.setLinearEqualityConstraintsAMatrix((double[][])new double[][]{{1.0}, {1.0}});
        convexOptimizationAdapter.setLinearEqualityConstraintsBVector(new double[]{2.0, 2.0});
        double[] solution = convexOptimizationAdapter.solve();
        Assertions.assertEquals((int)1, (int)solution.length);
        Assertions.assertEquals((double)2.0, (double)solution[0], (double)this.getTestErrorEpsilon());
    }

    @Test
    public void testASimpleRedundantEqualityCase2d() {
        ConvexOptimizationAdapter convexOptimizationAdapter = this.createConvexOptimizationAdapter();
        convexOptimizationAdapter.setLinearCostFunctionVector(new double[]{1.0, 1.0});
        convexOptimizationAdapter.setLinearEqualityConstraintsAMatrix((double[][])new double[][]{{1.0, 2.0}, {2.0, 4.0}, {3.0, 7.0}});
        convexOptimizationAdapter.setLinearEqualityConstraintsBVector(new double[]{2.0, 4.0, 7.0});
        double[] solution = convexOptimizationAdapter.solve();
        Assertions.assertEquals((int)2, (int)solution.length);
        Assertions.assertEquals((double)0.0, (double)solution[0], (double)this.getTestErrorEpsilon());
        Assertions.assertEquals((double)1.0, (double)solution[1], (double)this.getTestErrorEpsilon());
    }

    @Test
    public void JOptimizerWebpageLPExample() throws Exception {
        double[] qVector = new double[]{-1.0, -1.0};
        double r = 4.0;
        LinearMultivariateRealFunction objectiveFunction = new LinearMultivariateRealFunction(qVector, r);
        ConvexMultivariateRealFunction[] inequalities = new ConvexMultivariateRealFunction[4];
        double[][] G = new double[][]{{1.3333333333333333, -1.0}, {-0.5, 1.0}, {-2.0, -1.0}, {0.3333333333333333, 1.0}};
        double[] h = new double[]{2.0, 0.5, 2.0, 0.5};
        inequalities[0] = new LinearMultivariateRealFunction(G[0], -h[0]);
        inequalities[1] = new LinearMultivariateRealFunction(G[1], -h[1]);
        inequalities[2] = new LinearMultivariateRealFunction(G[2], -h[2]);
        inequalities[3] = new LinearMultivariateRealFunction(G[3], -h[3]);
        OptimizationRequest or = new OptimizationRequest();
        or.setF0((ConvexMultivariateRealFunction)objectiveFunction);
        or.setFi(inequalities);
        or.setToleranceFeas(1.0E-9);
        or.setTolerance(1.0E-9);
        JOptimizer opt = new JOptimizer();
        opt.setOptimizationRequest(or);
        int returnCode = opt.optimize();
        double[] sol = opt.getOptimizationResponse().getSolution();
        Assertions.assertEquals((double)1.5, (double)sol[0], (double)1.0E-7);
        Assertions.assertEquals((double)0.0, (double)sol[1], (double)1.0E-7);
        ConvexOptimizationAdapter convexOptimizationAdapter = this.createConvexOptimizationAdapter();
        convexOptimizationAdapter.setLinearCostFunctionVector(qVector);
        convexOptimizationAdapter.setLinearInequalityConstraints((double[][])G, h);
        double[] sol2 = convexOptimizationAdapter.solve();
        Assertions.assertEquals((int)2, (int)sol2.length);
        Assertions.assertEquals((double)1.5, (double)sol2[0], (double)1.0E-5);
        Assertions.assertEquals((double)0.0, (double)sol2[1], (double)1.0E-5);
    }

    @Test
    public void testASimpleInequalityCase() throws Exception {
        ConvexOptimizationAdapter convexOptimizationAdapter = this.createConvexOptimizationAdapter();
        convexOptimizationAdapter.setLinearCostFunctionVector(new double[]{1.0});
        convexOptimizationAdapter.setLinearInequalityConstraints((double[][])new double[][]{{-1.0}}, new double[]{-2.0});
        double[] solution = convexOptimizationAdapter.solve();
        Assertions.assertEquals((int)1, (int)solution.length);
        Assertions.assertEquals((double)2.0, (double)solution[0], (double)1.0E-7);
    }

    @Test
    public void testASimpleMaximizationInequalityCase() {
        ConvexOptimizationAdapter convexOptimizationAdapter = this.createConvexOptimizationAdapter();
        convexOptimizationAdapter.setLinearCostFunctionVector(new double[]{-1.0});
        convexOptimizationAdapter.setLinearInequalityConstraints((double[][])new double[][]{{1.0}}, new double[]{5.0});
        double[] solution = convexOptimizationAdapter.solve();
        Assertions.assertEquals((double)5.0, (double)solution[0], (double)1.0E-5);
    }

    @Disabled
    @Test
    public void testLinearCostQuadraticInequalityOptimizationProblem() {
        ConvexOptimizationAdapter convexOptimizationAdapter = this.createConvexOptimizationAdapter();
        convexOptimizationAdapter.setLinearCostFunctionVector(new double[]{-1.0, -1.0});
        double[][] PMatrix = new double[][]{{1.0, 0.0}, {0.0, 1.0}};
        double[] qVector = new double[]{0.0, 0.0};
        double r = -2.0;
        convexOptimizationAdapter.addQuadraticInequalities((double[][])PMatrix, qVector, r);
        double[] solution = convexOptimizationAdapter.solve();
        Assertions.assertEquals((double)Math.sqrt(2.0), (double)solution[0], (double)1.0E-5);
        Assertions.assertEquals((double)Math.sqrt(2.0), (double)solution[1], (double)1.0E-5);
    }

    @Test
    public void testLinearCostFullyLinearConstrainedEqualityOptimizationProblem() {
        ConvexOptimizationAdapter convexOptimizationAdapter = this.createConvexOptimizationAdapter();
        convexOptimizationAdapter.setLinearCostFunctionVector(new double[]{1.0, 0.0});
        double[][] equalityAMatrix = new double[][]{{1.0, 1.0}, {1.0, -1.0}};
        double[] equalityBVector = new double[]{4.0, 2.0};
        convexOptimizationAdapter.setLinearEqualityConstraintsAMatrix((double[][])equalityAMatrix);
        convexOptimizationAdapter.setLinearEqualityConstraintsBVector(equalityBVector);
        double[] solution = convexOptimizationAdapter.solve();
        Assertions.assertEquals((double)3.0, (double)solution[0], (double)this.getTestErrorEpsilon());
        Assertions.assertEquals((double)1.0, (double)solution[1], (double)this.getTestErrorEpsilon());
    }

    @Test
    public void testZeroCostLinearEqualityOptimizationProblem() throws Exception {
        ConvexOptimizationAdapter convexOptimizationAdapter = this.createConvexOptimizationAdapter();
        convexOptimizationAdapter.setLinearCostFunctionVector(new double[]{0.0, 0.0});
        double[][] equalityAMatrix = new double[][]{{1.0, 1.0}};
        double[] equalityBVector = new double[]{4.0};
        convexOptimizationAdapter.setLinearEqualityConstraintsAMatrix((double[][])equalityAMatrix);
        convexOptimizationAdapter.setLinearEqualityConstraintsBVector(equalityBVector);
        double[] solution = convexOptimizationAdapter.solve();
        Assertions.assertEquals((double)4.0, (double)(solution[0] + solution[1]), (double)this.getTestErrorEpsilon());
    }

    @Disabled
    @Test
    public void testLinearCostLinearEqualityQuadraticInequalityOptimizationProblem() throws Exception {
        ConvexOptimizationAdapter convexOptimizationAdapter = this.createConvexOptimizationAdapter();
        convexOptimizationAdapter.setLinearCostFunctionVector(new double[]{1.0, 0.0});
        double[][] equalityAMatrix = new double[][]{{1.0, 1.0}};
        double[] equalityBVector = new double[]{4.0};
        convexOptimizationAdapter.setLinearEqualityConstraintsAMatrix((double[][])equalityAMatrix);
        convexOptimizationAdapter.setLinearEqualityConstraintsBVector(equalityBVector);
        double[][] pMatrix = new double[][]{{2.0, 0.0}, {0.0, 0.0}};
        double[] qVector = new double[]{0.0, -1.0};
        double r = 0.0;
        convexOptimizationAdapter.addQuadraticInequalities((double[][])pMatrix, qVector, r);
        double[] solution = convexOptimizationAdapter.solve();
        Assertions.assertEquals((double)(0.5 * (-1.0 - Math.sqrt(17.0))), (double)solution[0], (double)1.0E-5);
        Assertions.assertEquals((double)(0.5 * (9.0 + Math.sqrt(17.0))), (double)solution[1], (double)1.0E-5);
    }

    @Disabled
    @Test
    public void testASecondOrderLorenzConeProblemUsingSOCP() throws Exception {
        ConvexOptimizationAdapter convexOptimizationAdapter = this.createConvexOptimizationAdapter();
        convexOptimizationAdapter.setLinearCostFunctionVector(new double[]{-1.0, -1.0, 0.0});
        double[][] secondOrderConeAMatrix = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 0.0}};
        double[] secondOrderConeBVector = new double[]{0.0, 0.0, 0.0};
        double[] secondOrderConeCVector = new double[]{0.0, 0.0, 1.0};
        double secondOrderConeDScalar = 0.0;
        convexOptimizationAdapter.addSecondOrderConeConstraints((double[][])secondOrderConeAMatrix, secondOrderConeBVector, secondOrderConeCVector, secondOrderConeDScalar);
        convexOptimizationAdapter.setLinearInequalityConstraints((double[][])new double[][]{{0.0, 0.0, 1.0}}, new double[]{Math.sqrt(18.0)});
        double[] solution = convexOptimizationAdapter.solve();
        System.out.println("solution = (" + solution[0] + ", " + solution[1] + ", " + solution[2] + ")");
        Assertions.assertEquals((double)3.0, (double)solution[0], (double)1.0E-5);
        Assertions.assertEquals((double)3.0, (double)solution[1], (double)1.0E-5);
        Assertions.assertEquals((double)Math.sqrt(18.0), (double)solution[2], (double)1.0E-5);
    }
}

