/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.convexOptimization.quadraticProgram;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import us.ihmc.convexOptimization.quadraticProgram.SimpleActiveSetQPSolver;

public class SimpleActiveSetQPSolverTest {
    @Test
    public void testSimpleUnconstrainedOptimization() {
        SimpleActiveSetQPSolver solver = new SimpleActiveSetQPSolver();
        double[][] quadraticCostFunctionPMatrix = new double[][]{{1.0, 0.0}, {0.0, 1.0}};
        double[] quadraticCostFunctionQVector = new double[]{-1.0, -2.0};
        double quadraticCostFunctionR = 0.0;
        solver.setQuadraticCostFunction((double[][])quadraticCostFunctionPMatrix, quadraticCostFunctionQVector, quadraticCostFunctionR);
        double[] solution = solver.solve();
        Assertions.assertEquals((int)2, (int)solution.length);
        Assertions.assertEquals((double)1.0, (double)solution[0], (double)1.0E-7);
        Assertions.assertEquals((double)2.0, (double)solution[1], (double)1.0E-7);
    }

    @Test
    public void testSimpleEqualityConstrainedOptimization() {
        SimpleActiveSetQPSolver solver = new SimpleActiveSetQPSolver();
        double[][] quadraticCostFunctionPMatrix = new double[][]{{1.0, 0.0}, {0.0, 1.0}};
        double[] quadraticCostFunctionQVector = new double[]{0.0, 0.0};
        double quadraticCostFunctionR = 0.0;
        double[][] linearEqualityConstraintsAMatrix = new double[][]{{1.0, 1.0}};
        double[] linearEqualityConstraintsBVector = new double[]{2.0};
        solver.setQuadraticCostFunction((double[][])quadraticCostFunctionPMatrix, quadraticCostFunctionQVector, quadraticCostFunctionR);
        solver.setLinearEqualityConstraints((double[][])linearEqualityConstraintsAMatrix, linearEqualityConstraintsBVector);
        double[] solution = solver.solve();
        Assertions.assertEquals((int)2, (int)solution.length);
        Assertions.assertEquals((double)1.0, (double)solution[0], (double)1.0E-7);
        Assertions.assertEquals((double)1.0, (double)solution[1], (double)1.0E-7);
    }

    @Test
    public void testSimpleInequalityConstrainedOptimizationWithActiveConstraint() {
        SimpleActiveSetQPSolver solver = new SimpleActiveSetQPSolver();
        double[][] quadraticCostFunctionPMatrix = new double[][]{{1.0, 0.0}, {0.0, 1.0}};
        double[] quadraticCostFunctionQVector = new double[]{0.0, 0.0};
        double quadraticCostFunctionR = 0.0;
        double[][] linearInequalityConstraintCVectors = new double[][]{{1.0, 1.0}};
        double[] linearInequalityConstraintFs = new double[]{-2.0};
        solver.setQuadraticCostFunction((double[][])quadraticCostFunctionPMatrix, quadraticCostFunctionQVector, quadraticCostFunctionR);
        solver.setLinearInequalityConstraints((double[][])linearInequalityConstraintCVectors, linearInequalityConstraintFs);
        double[] solution = solver.solve();
        Assertions.assertEquals((int)2, (int)solution.length);
        Assertions.assertEquals((double)-1.0, (double)solution[0], (double)1.0E-7);
        Assertions.assertEquals((double)-1.0, (double)solution[1], (double)1.0E-7);
    }

    @Test
    public void testSimpleInequalityConstrainedOptimizationWithInactiveConstraint() {
        SimpleActiveSetQPSolver solver = new SimpleActiveSetQPSolver();
        double[][] quadraticCostFunctionPMatrix = new double[][]{{1.0, 0.0}, {0.0, 1.0}};
        double[] quadraticCostFunctionQVector = new double[]{-1.0, -2.0};
        double quadraticCostFunctionR = 0.0;
        double[][] linearInequalityConstraintCVectors = new double[][]{{1.0, 1.0}};
        double[] linearInequalityConstraintFs = new double[]{4.0};
        solver.setQuadraticCostFunction((double[][])quadraticCostFunctionPMatrix, quadraticCostFunctionQVector, quadraticCostFunctionR);
        solver.setLinearInequalityConstraints((double[][])linearInequalityConstraintCVectors, linearInequalityConstraintFs);
        double[] solution = solver.solve();
        Assertions.assertEquals((int)2, (int)solution.length);
        Assertions.assertEquals((double)1.0, (double)solution[0], (double)1.0E-7);
        Assertions.assertEquals((double)2.0, (double)solution[1], (double)1.0E-7);
    }

    @Test
    public void testNoValidSolutionDueToNonSolvableEqualityConstraints() {
        SimpleActiveSetQPSolver solver = new SimpleActiveSetQPSolver();
        double[][] quadraticCostFunctionPMatrix = new double[][]{{1.0, 0.0}, {0.0, 1.0}};
        double[] quadraticCostFunctionQVector = new double[]{-1.0, -2.0};
        double quadraticCostFunctionR = 0.0;
        double[][] linearEqualityConstraintsAMatrix = new double[][]{{1.0, 1.0}, {1.0, 1.0}};
        double[] linearEqualityConstraintsBVector = new double[]{1.0, 2.0};
        solver.setQuadraticCostFunction((double[][])quadraticCostFunctionPMatrix, quadraticCostFunctionQVector, quadraticCostFunctionR);
        solver.setLinearEqualityConstraints((double[][])linearEqualityConstraintsAMatrix, linearEqualityConstraintsBVector);
        double[] solution = solver.solve();
        Assertions.assertEquals((int)2, (int)solution.length);
        Assertions.assertTrue((boolean)Double.isNaN(solution[0]));
        Assertions.assertTrue((boolean)Double.isNaN(solution[1]));
    }

    @Disabled
    @Test
    public void testConflictingInequalityAndEqualityConstraintsIfActive() {
        SimpleActiveSetQPSolver solver = new SimpleActiveSetQPSolver();
        double[][] quadraticCostFunctionPMatrix = new double[][]{{1.0, 0.0}, {0.0, 1.0}};
        double[] quadraticCostFunctionQVector = new double[]{-1.0, -2.0};
        double quadraticCostFunctionR = 0.0;
        double[][] linearEqualityConstraintsAMatrix = new double[][]{{1.0, 0.0}};
        double[] linearEqualityConstraintsBVector = new double[]{-4.0};
        double[][] linearInequalityConstraintCVectors = new double[][]{{1.0, 0.0}};
        double[] linearInequalityConstraintFs = new double[]{4.0};
        solver.setQuadraticCostFunction((double[][])quadraticCostFunctionPMatrix, quadraticCostFunctionQVector, quadraticCostFunctionR);
        solver.setLinearEqualityConstraints((double[][])linearEqualityConstraintsAMatrix, linearEqualityConstraintsBVector);
        solver.setLinearInequalityConstraints((double[][])linearInequalityConstraintCVectors, linearInequalityConstraintFs);
        solver.setLinearInequalityActiveSet(new boolean[]{true});
        double[] solution = solver.solve();
        Assertions.assertEquals((int)2, (int)solution.length);
        Assertions.assertEquals((double)-4.0, (double)solution[0], (double)1.0E-7);
        Assertions.assertEquals((double)2.0, (double)solution[1], (double)1.0E-7);
    }
}

