/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.convexOptimization.jOptimizer;

import com.joptimizer.functions.BarrierFunction;
import com.joptimizer.functions.ConvexMultivariateRealFunction;
import com.joptimizer.functions.LinearMultivariateRealFunction;
import com.joptimizer.functions.PSDQuadraticMultivariateRealFunction;
import com.joptimizer.functions.SOCPLogarithmicBarrier;
import com.joptimizer.optimizers.BarrierMethod;
import com.joptimizer.optimizers.JOptimizer;
import com.joptimizer.optimizers.OptimizationRequest;
import com.joptimizer.optimizers.OptimizationResponse;
import java.util.ArrayList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

@Disabled
public class SimpleJOptimizerTest {
    private static final boolean VERBOSE = true;

    @Disabled
    @Test
    public void testReallyReallySimpleOptimizationProblem() throws Exception {
        double[] minimizeF = new double[]{1.0};
        LinearMultivariateRealFunction objectiveFunction = new LinearMultivariateRealFunction(minimizeF, 0.0);
        double[][] equalityAMatrix = new double[][]{{1.0}};
        double[] equalityBVector = new double[]{2.0};
        double[] solution = this.solveOptimizationProblem(objectiveFunction, equalityAMatrix, equalityBVector);
        System.out.println("testReallyReallySimpleOptimizationProblem: solution = (" + solution[0] + ")");
        Assertions.assertEquals((double)2.0, (double)solution[0], (double)1.0E-5);
    }

    @Disabled
    @Test
    public void testASimpleRedundantEqualityCase() throws Exception {
        double[] minimizeF = new double[]{1.0};
        LinearMultivariateRealFunction objectiveFunction = new LinearMultivariateRealFunction(minimizeF, 0.0);
        double[][] equalityAMatrix = new double[][]{{1.0}, {1.0}};
        double[] equalityBVector = new double[]{2.0, 2.0};
        double[] solution = this.solveOptimizationProblem(objectiveFunction, equalityAMatrix, equalityBVector);
        System.out.println("testReallyReallySimpleOptimizationProblem: solution = (" + solution[0] + ")");
        Assertions.assertEquals((double)2.0, (double)solution[0], (double)1.0E-5);
    }

    @Disabled
    @Test
    public void testAnotherReallySimpleOptimizationProblem() throws Exception {
        double[] minimizeF = new double[]{1.0};
        LinearMultivariateRealFunction objectiveFunction = new LinearMultivariateRealFunction(minimizeF, 0.0);
        ConvexMultivariateRealFunction[] inequalities = new ConvexMultivariateRealFunction[]{new LinearMultivariateRealFunction(new double[]{-1.0}, 2.0)};
        double[] solution = this.solveOptimizationProblem((ConvexMultivariateRealFunction)objectiveFunction, inequalities);
        System.out.println("testAnotherReallySimpleOptimizationProblem: solution = (" + solution[0] + ")");
        Assertions.assertEquals((double)2.0, (double)solution[0], (double)1.0E-5);
    }

    @Test
    public void testReallySimpleOptimizationProblem() throws Exception {
        double[] minimizeF = new double[]{-1.0};
        LinearMultivariateRealFunction objectiveFunction = new LinearMultivariateRealFunction(minimizeF, 0.0);
        ConvexMultivariateRealFunction[] inequalities = new ConvexMultivariateRealFunction[]{new LinearMultivariateRealFunction(new double[]{1.0}, -5.0)};
        double[] solution = this.solveOptimizationProblem((ConvexMultivariateRealFunction)objectiveFunction, inequalities);
        System.out.println("testReallySimpleOptimizationProblem: solution = (" + solution[0] + ")");
        Assertions.assertEquals((double)5.0, (double)solution[0], (double)1.0E-5);
    }

    @Test
    public void testLinearCostQuadraticInequalityOptimizationProblem() throws Exception {
        double[] minimizeF = new double[]{-1.0, -1.0};
        LinearMultivariateRealFunction objectiveFunction = new LinearMultivariateRealFunction(minimizeF, 0.0);
        ConvexMultivariateRealFunction[] inequalities = new ConvexMultivariateRealFunction[1];
        double[][] PMatrix = new double[][]{{1.0, 0.0}, {0.0, 1.0}};
        double[] qVector = new double[]{0.0, 0.0};
        double r = -2.0;
        inequalities[0] = new PSDQuadraticMultivariateRealFunction((double[][])PMatrix, qVector, r);
        double[] solution = this.solveOptimizationProblem((ConvexMultivariateRealFunction)objectiveFunction, inequalities);
        System.out.println("solution = (" + solution[0] + ", " + solution[1] + ")");
        Assertions.assertEquals((double)Math.sqrt(2.0), (double)solution[0], (double)1.0E-5);
        Assertions.assertEquals((double)Math.sqrt(2.0), (double)solution[1], (double)1.0E-5);
    }

    @Disabled
    @Test
    public void testLinearCostFullyLinearConstrainedEqualityOptimizationProblem() throws Exception {
        double[] minimizeF = new double[]{1.0, 0.0};
        LinearMultivariateRealFunction objectiveFunction = new LinearMultivariateRealFunction(minimizeF, 0.0);
        double[][] equalityAMatrix = new double[][]{{1.0, 1.0}, {1.0, -1.0}};
        double[] equalityBVector = new double[]{4.0, 2.0};
        double[] solution = this.solveOptimizationProblem(objectiveFunction, equalityAMatrix, equalityBVector);
        System.out.println("solution = (" + solution[0] + ", " + solution[1] + ")");
        Assertions.assertEquals((double)3.0, (double)solution[0], (double)1.0E-5);
        Assertions.assertEquals((double)1.0, (double)solution[1], (double)1.0E-5);
    }

    @Test
    public void testZeroCostLinearEqualityOptimizationProblem() throws Exception {
        double[] minimizeF = new double[]{0.0, 0.0};
        LinearMultivariateRealFunction objectiveFunction = new LinearMultivariateRealFunction(minimizeF, 0.0);
        double[][] equalityAMatrix = new double[][]{{1.0, 1.0}};
        double[] equalityBVector = new double[]{4.0};
        double[] solution = this.solveOptimizationProblem(objectiveFunction, equalityAMatrix, equalityBVector);
        System.out.println("solution = (" + solution[0] + ", " + solution[1] + ")");
        Assertions.assertEquals((double)4.0, (double)(solution[0] + solution[1]), (double)1.0E-5);
    }

    @Test
    public void testLinearCostLinearEqualityQuadraticInequalityOptimizationProblem() throws Exception {
        double[] minimizeF = new double[]{1.0, 0.0};
        LinearMultivariateRealFunction objectiveFunction = new LinearMultivariateRealFunction(minimizeF, 0.0);
        double[][] equalityAMatrix = new double[][]{{1.0, 1.0}};
        double[] equalityBVector = new double[]{4.0};
        ConvexMultivariateRealFunction[] inequalities = new ConvexMultivariateRealFunction[1];
        double[][] PMatrix = new double[][]{{2.0, 0.0}, {0.0, 0.0}};
        double[] qVector = new double[]{0.0, -1.0};
        double r = 0.0;
        inequalities[0] = new PSDQuadraticMultivariateRealFunction((double[][])PMatrix, qVector, r);
        double[] solution = this.solveOptimizationProblem((ConvexMultivariateRealFunction)objectiveFunction, equalityAMatrix, equalityBVector, inequalities);
        System.out.println("solution = (" + solution[0] + ", " + solution[1] + ")");
        Assertions.assertEquals((double)(0.5 * (-1.0 - Math.sqrt(17.0))), (double)solution[0], (double)1.0E-5);
        Assertions.assertEquals((double)(0.5 * (9.0 + Math.sqrt(17.0))), (double)solution[1], (double)1.0E-5);
    }

    @Disabled
    @Test
    public void testQuadraticCostLinearEqualityQuadraticInequalityOptimizationProblem() throws Exception {
        double[][] costPMatrix = new double[][]{{-2.0, 0.0}, {0.0, 0.0}};
        double[] costQVector = new double[]{0.0, 0.0};
        double costR = 0.0;
        PSDQuadraticMultivariateRealFunction objectiveFunction = new PSDQuadraticMultivariateRealFunction((double[][])costPMatrix, costQVector, costR);
        double[][] equalityAMatrix = new double[][]{{1.0, 1.0}};
        double[] equalityBVector = new double[]{4.0};
        ConvexMultivariateRealFunction[] inequalities = new ConvexMultivariateRealFunction[1];
        double[][] PMatrix = new double[][]{{2.0, 0.0}, {0.0, 0.0}};
        double[] qVector = new double[]{0.0, -1.0};
        double r = 0.0;
        inequalities[0] = new PSDQuadraticMultivariateRealFunction((double[][])PMatrix, qVector, r);
        double[] solution = this.solveOptimizationProblem((ConvexMultivariateRealFunction)objectiveFunction, equalityAMatrix, equalityBVector, inequalities);
        System.out.println("solution = (" + solution[0] + ", " + solution[1] + ")");
        Assertions.assertEquals((double)(0.5 * (-1.0 - Math.sqrt(17.0))), (double)solution[0], (double)1.0E-5);
        Assertions.assertEquals((double)(0.5 * (9.0 + Math.sqrt(17.0))), (double)solution[1], (double)1.0E-5);
    }

    private double[] solveOptimizationProblem(LinearMultivariateRealFunction objectiveFunction, double[][] equalityAMatrix, double[] equalityBVector) throws Exception {
        return this.solveOptimizationProblem((ConvexMultivariateRealFunction)objectiveFunction, equalityAMatrix, equalityBVector, null);
    }

    private double[] solveOptimizationProblem(ConvexMultivariateRealFunction objectiveFunction, ConvexMultivariateRealFunction[] inequalities) throws Exception {
        return this.solveOptimizationProblem(objectiveFunction, null, null, inequalities);
    }

    private double[] solveOptimizationProblem(ConvexMultivariateRealFunction objectiveFunction, double[][] equalityAMatrix, double[] equalityBVector, ConvexMultivariateRealFunction[] inequalities) throws Exception {
        OptimizationRequest optimizationRequest = new OptimizationRequest();
        optimizationRequest.setF0(objectiveFunction);
        if (equalityAMatrix != null) {
            optimizationRequest.setA(equalityAMatrix);
        }
        if (equalityBVector != null) {
            optimizationRequest.setB(equalityBVector);
        }
        if (inequalities != null) {
            optimizationRequest.setFi(inequalities);
        }
        optimizationRequest.setToleranceFeas(1.0E-6);
        optimizationRequest.setTolerance(2.0E-6);
        optimizationRequest.setMaxIteration(500);
        JOptimizer optimizer = new JOptimizer();
        optimizer.setOptimizationRequest(optimizationRequest);
        optimizer.optimize();
        OptimizationResponse response = optimizer.getOptimizationResponse();
        double[] solution = response.getSolution();
        return solution;
    }

    @Disabled
    @Test
    public void testASecondOrderLorenzConeProblemUsingSquaring() throws Exception {
        double[] minimizeF = new double[]{-1.0, -1.0, 0.0};
        LinearMultivariateRealFunction objectiveFunction = new LinearMultivariateRealFunction(minimizeF, 0.0);
        ConvexMultivariateRealFunction[] inequalities = new ConvexMultivariateRealFunction[3];
        double[][] PMatrix = new double[][]{{2.0, 0.0, 0.0}, {0.0, 2.0, 0.0}, {0.0, 0.0, -2.0}};
        double[] qVector = new double[]{0.0, 0.0, 0.0};
        double r = 0.0;
        inequalities[0] = new PSDQuadraticMultivariateRealFunction((double[][])PMatrix, qVector, r);
        qVector = new double[]{0.0, 0.0, 1.0};
        r = -Math.sqrt(18.0);
        inequalities[1] = new LinearMultivariateRealFunction(qVector, r);
        qVector = new double[]{0.0, 0.0, -1.0};
        r = 0.0;
        inequalities[2] = new LinearMultivariateRealFunction(qVector, r);
        OptimizationRequest optimizationRequest = new OptimizationRequest();
        optimizationRequest.setF0((ConvexMultivariateRealFunction)objectiveFunction);
        optimizationRequest.setFi(inequalities);
        optimizationRequest.setToleranceFeas(1.0E-6);
        optimizationRequest.setTolerance(2.0E-6);
        optimizationRequest.setMaxIteration(500);
        int numberOfTests = 2000;
        double[] solution = null;
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < numberOfTests; ++i) {
            JOptimizer optimizer = new JOptimizer();
            optimizer.setOptimizationRequest(optimizationRequest);
            optimizer.optimize();
            OptimizationResponse response = optimizer.getOptimizationResponse();
            solution = response.getSolution();
        }
        long endTime = System.currentTimeMillis();
        double totalTime = (double)(endTime - startTime) * 0.001;
        double timePerSolve = totalTime / (double)numberOfTests;
        System.out.println("solution = (" + solution[0] + ", " + solution[1] + ", " + solution[2] + ")");
        System.out.println("timePerSolve = " + timePerSolve * 1000.0 + " milliseconds");
        Assertions.assertEquals((double)3.0, (double)solution[0], (double)1.0E-5);
        Assertions.assertEquals((double)3.0, (double)solution[1], (double)1.0E-5);
        Assertions.assertEquals((double)Math.sqrt(18.0), (double)solution[2], (double)1.0E-5);
    }

    @Disabled
    @Test
    public void testASecondOrderLorenzConeProblemUsingSOCP() throws Exception {
        SOCPLogarithmicBarrier barrierFunction;
        double[] minimizeF = new double[]{-1.0, -1.0, 0.0};
        LinearMultivariateRealFunction objectiveFunction = new LinearMultivariateRealFunction(minimizeF, 0.0);
        double[][] socpAMatrix = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 0.0}};
        double[] socpBVector = new double[]{0.0, 0.0, 0.0};
        double[] socpCVector = new double[]{0.0, 0.0, 1.0};
        double socpDScalar = 0.0;
        int socpConstraintDimension = 1;
        ArrayList<SOCPLogarithmicBarrier.SOCPConstraintParameters> socpConstraintParametersList = new ArrayList<SOCPLogarithmicBarrier.SOCPConstraintParameters>(socpConstraintDimension);
        SOCPLogarithmicBarrier sOCPLogarithmicBarrier = barrierFunction = new SOCPLogarithmicBarrier(socpConstraintParametersList, socpConstraintDimension);
        sOCPLogarithmicBarrier.getClass();
        SOCPLogarithmicBarrier.SOCPConstraintParameters socpConstraintParameters = new SOCPLogarithmicBarrier.SOCPConstraintParameters(sOCPLogarithmicBarrier, (double[][])socpAMatrix, socpBVector, socpCVector, socpDScalar);
        socpConstraintParametersList.add(socpConstraintParameters);
        ConvexMultivariateRealFunction[] inequalities = new ConvexMultivariateRealFunction[]{new LinearMultivariateRealFunction(new double[]{0.0, 0.0, 1.0}, -Math.sqrt(18.0))};
        OptimizationRequest optimizationRequest = new OptimizationRequest();
        optimizationRequest.setF0((ConvexMultivariateRealFunction)objectiveFunction);
        optimizationRequest.setFi(inequalities);
        optimizationRequest.setToleranceFeas(1.0E-6);
        optimizationRequest.setTolerance(2.0E-6);
        optimizationRequest.setMaxIteration(500);
        BarrierMethod optimizer = new BarrierMethod((BarrierFunction)barrierFunction);
        optimizer.setOptimizationRequest(optimizationRequest);
        optimizer.optimize();
        OptimizationResponse response = optimizer.getOptimizationResponse();
        double[] solution = response.getSolution();
        System.out.println("solution = (" + solution[0] + ", " + solution[1] + ", " + solution[2] + ")");
        Assertions.assertEquals((double)3.0, (double)solution[0], (double)1.0E-5);
        Assertions.assertEquals((double)3.0, (double)solution[1], (double)1.0E-5);
        Assertions.assertEquals((double)Math.sqrt(18.0), (double)solution[2], (double)1.0E-5);
    }
}

