/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commons.thread;

import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.exception.ExceptionTools;

public class TypedNotification<T> {
    private volatile T notification = null;
    private T previousValue = null;

    public boolean peekHasValue() {
        return this.notification != null;
    }

    public T peek() {
        return this.notification;
    }

    public synchronized T blockingPeek() {
        return this.blockingPeek(DefaultExceptionHandler.RUNTIME_EXCEPTION);
    }

    public synchronized T blockingPeek(ExceptionHandler exceptionHandler) {
        if (!this.peekHasValue()) {
            ExceptionTools.handle(this::wait, exceptionHandler);
        }
        return this.notification;
    }

    public synchronized boolean poll() {
        this.previousValue = this.notification;
        this.notification = null;
        return this.previousValue != null;
    }

    public T blockingPoll() {
        return this.blockingPoll(DefaultExceptionHandler.RUNTIME_EXCEPTION);
    }

    public synchronized T blockingPoll(ExceptionHandler exceptionHandler) {
        this.blockingPeek(exceptionHandler);
        this.poll();
        return this.previousValue;
    }

    public boolean hasValue() {
        return this.previousValue != null;
    }

    public T read() {
        return this.previousValue;
    }

    public synchronized void set(T value) {
        this.notification = value;
        this.notifyAll();
    }
}

