/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commons.thread;

import us.ihmc.commons.Conversions;
import us.ihmc.commons.RunnableThatThrows;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.exception.ExceptionTools;
import us.ihmc.commons.thread.Throttler;

public class RepeatingTaskThread
extends Thread {
    public static final int REPEAT_INDEFINITELY = -1;
    public static final double UNLIMITED_FREQUENCY = -1.0;
    private final RunnableThatThrows task;
    private final ExceptionHandler exceptionHandler;
    private volatile boolean running = false;
    private final ExecutionState executionState = new ExecutionState();
    private final Throttler throttler = new Throttler();
    private double periodLowerLimit = -1.0;

    public RepeatingTaskThread(String name) {
        this(name, DefaultExceptionHandler.MESSAGE_AND_STACKTRACE);
    }

    public RepeatingTaskThread(String name, ExceptionHandler exceptionHandler) {
        this(name, null, exceptionHandler);
    }

    public RepeatingTaskThread(String name, RunnableThatThrows task) {
        this(name, task, DefaultExceptionHandler.MESSAGE_AND_STACKTRACE);
    }

    public RepeatingTaskThread(String name, RunnableThatThrows task, ExceptionHandler exceptionHandler) {
        super(name);
        this.task = task;
        this.exceptionHandler = exceptionHandler;
    }

    public RepeatingTaskThread setFrequencyLimit(double frequencyLimit) {
        this.periodLowerLimit = Conversions.hertzToSeconds(frequencyLimit);
        return this;
    }

    public void removeFrequencyLimit() {
        this.setFrequencyLimit(-1.0);
    }

    @Override
    public void start() {
        this.running = true;
        super.start();
    }

    public void startRepeating() {
        if (!this.running) {
            this.start();
        }
        this.setRepeating(true);
    }

    public void stopRepeating() {
        this.setRepeating(false);
    }

    public void setRepeating(boolean repeating) {
        if (repeating) {
            this.setScheduled(-1L);
        } else {
            this.setScheduled(0L);
        }
    }

    public void setScheduled(long n) {
        this.executionState.setScheduled(n);
    }

    public void addScheduled(long n) {
        this.executionState.addScheduled(n);
    }

    public long getScheduled() {
        return this.executionState.getScheduled();
    }

    public boolean isExecuting() {
        return this.executionState.isExecuting();
    }

    public boolean isRunning() {
        return this.running;
    }

    public long getCompleted() {
        return this.executionState.getCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean blockUntilNextTaskExecution() {
        ExecutionState executionState = this.executionState;
        synchronized (executionState) {
            do {
                if (!this.executionState.waitForChange()) continue;
                return true;
            } while (!this.executionState.isExecuting());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean blockUntilNextTaskCompletion() {
        ExecutionState executionState = this.executionState;
        synchronized (executionState) {
            long completedBefore = this.executionState.getCompleted();
            while (completedBefore == this.executionState.getCompleted()) {
                if (!this.executionState.waitForChange()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean blockUntilNoScheduledTasks() {
        ExecutionState executionState = this.executionState;
        synchronized (executionState) {
            while (this.executionState.getScheduled() != 0L || this.executionState.isExecuting()) {
                if (!this.executionState.waitForChange()) continue;
                return true;
            }
        }
        return false;
    }

    public void kill() {
        this.running = false;
        this.executionState.setScheduled(0L);
    }

    public boolean blockingKill() {
        this.kill();
        try {
            this.join();
        }
        catch (InterruptedException e) {
            return true;
        }
        return false;
    }

    protected void runTask() throws Throwable {
        if (this.task != null) {
            this.task.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        while (this.running) {
            ExecutionState executionState = this.executionState;
            synchronized (executionState) {
                if (this.executionState.getScheduled() == 0L) {
                    this.executionState.waitForChange();
                    continue;
                }
            }
            if (this.periodLowerLimit > 0.0) {
                this.throttler.waitAndRun(this.periodLowerLimit);
            }
            if (RepeatingTaskThread.interrupted() && (!this.running || this.executionState.getScheduled() == 0L)) continue;
            this.executionState.beforeTaskExecution();
            ExceptionTools.handle(this::runTask, this.exceptionHandler);
            this.executionState.afterTaskExecution();
        }
    }

    private static class ExecutionState {
        private volatile long scheduledRepetitions = 0L;
        private volatile boolean executing = false;
        private volatile long completedRepetitions = 0L;

        private ExecutionState() {
        }

        private synchronized void beforeTaskExecution() {
            if (this.scheduledRepetitions > 0L) {
                --this.scheduledRepetitions;
            }
            this.executing = true;
            this.notifyAll();
        }

        private synchronized void afterTaskExecution() {
            this.executing = false;
            ++this.completedRepetitions;
            this.notifyAll();
        }

        private synchronized void setScheduled(long repetitions) {
            this.scheduledRepetitions = repetitions;
            this.notifyAll();
        }

        private synchronized void addScheduled(long repetitions) {
            if (this.scheduledRepetitions < 0L) {
                return;
            }
            this.scheduledRepetitions = Math.max(this.scheduledRepetitions + repetitions, 0L);
            this.notifyAll();
        }

        private synchronized boolean waitForChange() {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                return true;
            }
            return false;
        }

        private long getScheduled() {
            return this.scheduledRepetitions;
        }

        private boolean isExecuting() {
            return this.executing;
        }

        private long getCompleted() {
            return this.completedRepetitions;
        }
    }
}

