/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commons.lists;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

public class PreallocatedList<T>
implements List<T> {
    private final Class<T> clazz;
    private final T[] values;
    private int pos = -1;

    @Deprecated
    public PreallocatedList() {
        this.clazz = null;
        this.values = null;
    }

    public PreallocatedList(Class<T> clazz, Supplier<T> allocator, int maxSize) {
        this.clazz = clazz;
        this.values = (Object[])Array.newInstance(clazz, maxSize);
        for (int i = 0; i < maxSize; ++i) {
            this.values[i] = allocator.get();
        }
    }

    @Override
    public T[] toArray() {
        Object[] array = (Object[])Array.newInstance(this.clazz, this.size());
        System.arraycopy(this.values, 0, array, 0, this.size());
        return array;
    }

    @Override
    public <S> S[] toArray(S[] dest) {
        int size = this.size();
        if (dest.length < size) {
            return Arrays.copyOf(this.values, size, dest.getClass());
        }
        System.arraycopy(this.values, 0, dest, 0, size);
        if (dest.length > size) {
            dest[size] = null;
        }
        return dest;
    }

    public void resetQuick() {
        this.pos = -1;
    }

    public T add() {
        this.maxCapacityCheck(this.pos + 1);
        return this.values[++this.pos];
    }

    public void remove() {
        this.nonEmptyCheck();
        --this.pos;
    }

    @Override
    public T remove(int i) {
        if (i == this.pos) {
            this.remove();
            return this.values[i];
        }
        this.rangeCheck(i);
        T t = this.values[i];
        while (i < this.pos) {
            this.values[i++] = this.values[i];
        }
        this.values[this.pos] = t;
        --this.pos;
        return t;
    }

    @Override
    public boolean remove(Object o) {
        int index = this.indexOf(o);
        if (index == -1) {
            return false;
        }
        this.remove(index);
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        Objects.requireNonNull(c);
        return this.filterList(c, true);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Objects.requireNonNull(c);
        return this.filterList(c, false);
    }

    private boolean filterList(Collection<?> c, boolean removeIfPresent) {
        boolean listModified = false;
        int i = 0;
        while (i < this.size()) {
            if (c.contains(this.values[i]) == removeIfPresent) {
                this.remove(i);
                listModified = true;
                continue;
            }
            ++i;
        }
        return listModified;
    }

    @Override
    public int indexOf(Object o) {
        for (int i = 0; i < this.size(); ++i) {
            if (!this.values[i].equals(o)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        for (int i = this.pos; i >= 0; --i) {
            if (!this.values[i].equals(o)) continue;
            return i;
        }
        return -1;
    }

    public void swap(int i, int j) {
        this.rangeCheck(i);
        this.rangeCheck(j);
        if (i == j) {
            return;
        }
        this.unsafeSwap(i, j);
    }

    @Override
    public void sort(Comparator<? super T> comparator) {
        if (this.size() == 0) {
            return;
        }
        Arrays.sort(this.values, 0, this.size(), comparator);
    }

    private void unsafeSwap(int i, int j) {
        T t = this.values[i];
        this.values[i] = this.values[j];
        this.values[j] = t;
    }

    @Override
    public T get(int i) {
        this.rangeCheck(i);
        return this.values[i];
    }

    @Override
    public T getFirst() {
        if (this.isEmpty()) {
            return null;
        }
        return this.values[0];
    }

    @Override
    public T getLast() {
        if (this.isEmpty()) {
            return null;
        }
        return this.values[this.pos];
    }

    @Override
    public void clear() {
        this.resetQuick();
    }

    @Override
    public int size() {
        return this.pos + 1;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int capacity() {
        return this.values.length;
    }

    public int remaining() {
        return this.capacity() - this.size();
    }

    private void nonEmptyCheck() {
        if (this.pos < 0) {
            throw new ArrayIndexOutOfBoundsException("List is empty");
        }
    }

    private void rangeCheck(int i) {
        if (i < 0 || i > this.pos) {
            throw new ArrayIndexOutOfBoundsException("Position is not valid in the list, size is " + this.size() + ", requested element is " + i);
        }
    }

    private void maxCapacityCheck(int newSize) {
        if (newSize >= this.values.length) {
            throw new ArrayIndexOutOfBoundsException("Cannot add element to sequence, max size is violated");
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.pos;
        result = 31 * result + 1237;
        result = 31 * result + Arrays.hashCode(this.values);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof List)) {
            return false;
        }
        List other = (List)obj;
        if (this.size() != other.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.values[i].equals(other.get(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        Object s = "";
        s = (String)s + this.clazz.getSimpleName();
        s = (String)s + " pos: " + this.pos;
        s = (String)s + " [";
        for (int i = 0; i < this.size(); ++i) {
            if (i > 0) {
                s = (String)s + ", ";
            }
            s = (String)s + this.values[i].toString();
        }
        s = (String)s + "]";
        return s;
    }

    @Override
    public boolean contains(Object o) {
        for (int i = 0; i < this.size(); ++i) {
            if (!this.values[i].equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public T set(int index, T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(T t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replaceAll(UnaryOperator<T> operator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<T> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<T> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }
}

