/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commons.allocations;

import com.google.monitoring.runtime.instrumentation.AllocationRecorder;
import java.util.Arrays;
import java.util.List;

public class AllocationRecord {
    private final String description;
    private final Object allocatedObject;
    private final long size;
    private final StackTraceElement[] stackTrace;

    public AllocationRecord(String description, Object allocatedObject, long size) {
        this.description = description;
        this.allocatedObject = allocatedObject;
        this.size = size;
        this.stackTrace = this.getCleanedStackTace();
    }

    private StackTraceElement[] getCleanedStackTace() {
        List<StackTraceElement> stackTrace = Arrays.asList(Thread.currentThread().getStackTrace());
        int skip = 0;
        while (!stackTrace.get(skip).toString().contains(AllocationRecorder.class.getName())) {
            ++skip;
        }
        while (stackTrace.get(skip).toString().contains(AllocationRecorder.class.getName())) {
            ++skip;
        }
        return stackTrace.subList(skip, stackTrace.size()).toArray(new StackTraceElement[0]);
    }

    public String toString() {
        String s = "AllocationRecord: " + this.description + " : " + this.allocatedObject.getClass().getName() + " : size " + this.size + "\n";
        for (StackTraceElement e : this.stackTrace) {
            s = s + "\tat " + e.toString() + "\n";
        }
        return s;
    }

    public String getDescription() {
        return this.description;
    }

    public Object getAllocatedObject() {
        return this.allocatedObject;
    }

    public long getSize() {
        return this.size;
    }

    public StackTraceElement[] getStackTrace() {
        return this.stackTrace;
    }
}

