/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commons.allocations;

import com.google.monitoring.runtime.instrumentation.AllocationRecorder;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import us.ihmc.commons.RunnableThatThrows;
import us.ihmc.commons.allocations.AllocationRecord;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;

public class AllocationProfiler {
    private boolean recording = false;
    private final Queue<AllocationRecord> allocations = new ConcurrentLinkedQueue<AllocationRecord>();
    private boolean includeAllAllocations;
    private final Set<String> excludeAllocationsInsideTheseMethods = new HashSet<String>();
    private final Set<String> includeAllocationsInsideTheseMethods = new HashSet<String>();
    private final Set<String> excludeAllocationsInsideTheseClasses = new HashSet<String>();
    private final Set<String> includeAllocationsInsideTheseClasses = new HashSet<String>();
    private final Set<String> excludeAllocationsOfTheseClasses = new HashSet<String>();
    private final Set<String> includeAllocationsOfTheseClasses = new HashSet<String>();
    private final Set<String> includeAllocationsWhoseTracesContainTheseKeywords = new HashSet<String>();
    private final Set<String> excludeAllocationsWhoseTracesContainTheseKeywords = new HashSet<String>();

    public AllocationProfiler() {
        this.reset();
    }

    public void startRecordingAllocations() {
        AllocationProfiler.checkInstrumentation();
        this.recording = true;
        AllocationRecorder.addSampler(this::sampleAllocation);
    }

    public void stopRecordingAllocations() {
        this.recording = false;
        AllocationRecorder.removeSampler(this::sampleAllocation);
    }

    public List<AllocationRecord> pollAllocations() {
        return AllocationProfiler.removeDuplicateRecords(this.pollAllocationsIncludingDuplicates());
    }

    public static List<AllocationRecord> removeDuplicateRecords(List<AllocationRecord> allocations) {
        HashMap map = new HashMap();
        allocations.forEach(t -> map.put(t.toString(), t));
        return new ArrayList<AllocationRecord>(map.values());
    }

    public List<AllocationRecord> pollAllocationsIncludingDuplicates() {
        AllocationRecord allocation;
        ArrayList<AllocationRecord> allocations = new ArrayList<AllocationRecord>();
        while ((allocation = this.allocations.poll()) != null) {
            allocations.add(allocation);
        }
        return allocations;
    }

    public List<AllocationRecord> recordAllocations(Runnable runnable) {
        return this.recordAllocations(() -> runnable.run(), DefaultExceptionHandler.PROCEED_SILENTLY);
    }

    public List<AllocationRecord> recordAllocations(RunnableThatThrows runnable, ExceptionHandler exceptionHandler) {
        this.startRecordingAllocations();
        try {
            runnable.run();
        }
        catch (Throwable e) {
            exceptionHandler.handleException(e);
        }
        this.stopRecordingAllocations();
        return this.pollAllocations();
    }

    public static void checkInstrumentation() {
        try {
            Method method = AllocationRecorder.class.getDeclaredMethod("getInstrumentation", new Class[0]);
            method.setAccessible(true);
            if (method.invoke(null, new Object[0]) == null) {
                throw new RuntimeException(AllocationRecorder.class.getSimpleName() + " has no instrumentation. Please add VM arg -javaagent:/path/to/java-allocation-instrumenter-X.X.X.jar");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void sampleAllocation(int count, String description, Object newObject, long size) {
        AllocationRecord record;
        if (this.recording && this.isIncluded(record = new AllocationRecord(description, newObject, size)) && !this.isExcluded(record)) {
            this.allocations.add(record);
        }
    }

    private boolean isIncluded(AllocationRecord record) {
        boolean isIncluded = false;
        if (this.includeAllAllocations) {
            isIncluded = true;
        } else if (this.includeAllocationsOfTheseClasses.stream().anyMatch(className -> record.getAllocatedObject().getClass().getName().startsWith((String)className))) {
            isIncluded = true;
        } else {
            for (StackTraceElement traceElement : record.getStackTrace()) {
                if (this.includeAllocationsInsideTheseMethods.contains(traceElement.getClassName() + "." + traceElement.getMethodName())) {
                    isIncluded = true;
                    continue;
                }
                if (this.includeAllocationsWhoseTracesContainTheseKeywords.stream().anyMatch(keyword -> traceElement.toString().contains((CharSequence)keyword))) {
                    isIncluded = true;
                    continue;
                }
                if (!this.includeAllocationsInsideTheseClasses.stream().anyMatch(className -> traceElement.getClassName().startsWith((String)className))) continue;
                isIncluded = true;
            }
        }
        return isIncluded;
    }

    private boolean isExcluded(AllocationRecord record) {
        boolean isExcluded = false;
        if (this.excludeAllocationsOfTheseClasses.stream().anyMatch(className -> record.getAllocatedObject().getClass().getName().startsWith((String)className))) {
            isExcluded = true;
        } else {
            for (StackTraceElement traceElement : record.getStackTrace()) {
                if (this.excludeAllocationsInsideTheseMethods.contains(traceElement.getClassName() + "." + traceElement.getMethodName())) {
                    isExcluded = true;
                    continue;
                }
                if (this.excludeAllocationsWhoseTracesContainTheseKeywords.stream().anyMatch(keyword -> traceElement.toString().contains((CharSequence)keyword))) {
                    isExcluded = true;
                    continue;
                }
                if (!this.excludeAllocationsInsideTheseClasses.stream().anyMatch(className -> traceElement.getClassName().startsWith((String)className))) continue;
                isExcluded = true;
            }
        }
        return isExcluded;
    }

    public void setIncludeAllAllocations(boolean includeAllAllocations) {
        this.includeAllAllocations = includeAllAllocations;
    }

    public void includeAllocationsInsideClass(String className) {
        this.setIncludeAllAllocations(false);
        this.includeAllocationsInsideTheseClasses.add(className);
    }

    public void excludeAllocationsInsideClass(String className) {
        this.excludeAllocationsInsideTheseClasses.add(className);
    }

    public void includeAllocationsOfClass(String className) {
        this.setIncludeAllAllocations(false);
        this.includeAllocationsOfTheseClasses.add(className);
    }

    public void excludeAllocationsOfClass(String className) {
        this.excludeAllocationsOfTheseClasses.add(className);
    }

    public void includeAllocationsInsideMethod(String qualifiedMethodName) {
        this.setIncludeAllAllocations(false);
        this.includeAllocationsInsideTheseMethods.add(qualifiedMethodName);
    }

    public void excludeAllocationsInsideMethod(String qualifiedMethodName) {
        this.excludeAllocationsInsideTheseMethods.add(qualifiedMethodName);
    }

    public void includeAllocationsContainingKeyword(String keyword) {
        this.setIncludeAllAllocations(false);
        this.includeAllocationsWhoseTracesContainTheseKeywords.add(keyword);
    }

    public void excludeAllocationsContainingKeyword(String keyword) {
        this.excludeAllocationsWhoseTracesContainTheseKeywords.add(keyword);
    }

    public void setRecordConstructorAllocations(boolean recordConstructorAllocations) {
        if (recordConstructorAllocations) {
            this.excludeAllocationsWhoseTracesContainTheseKeywords.remove("<init>");
        } else {
            this.excludeAllocationsWhoseTracesContainTheseKeywords.add("<init>");
        }
    }

    public void setRecordStaticMemberInitialization(boolean recordStaticMemberInitialization) {
        if (recordStaticMemberInitialization) {
            this.excludeAllocationsWhoseTracesContainTheseKeywords.remove("<clinit>");
        } else {
            this.excludeAllocationsWhoseTracesContainTheseKeywords.add("<clinit>");
        }
    }

    public void setRecordClassLoader(boolean recordClassLoader) {
        if (recordClassLoader) {
            this.excludeAllocationsInsideTheseClasses.remove(ClassLoader.class.getName());
        } else {
            this.excludeAllocationsInsideTheseClasses.add(ClassLoader.class.getName());
        }
    }

    public void setRecordSelf(boolean recordSelf) {
        if (recordSelf) {
            this.excludeAllocationsInsideTheseClasses.remove(AllocationRecorder.class.getName());
            this.excludeAllocationsInsideTheseMethods.remove("us.ihmc.commons.allocations.AllocationProfiler.startRecordingAllocations");
            this.excludeAllocationsInsideTheseMethods.remove("java.util.concurrent.FutureTask.awaitDone");
            this.excludeAllocationsWhoseTracesContainTheseKeywords.remove("org.gradle.internal");
        } else {
            this.excludeAllocationsInsideTheseClasses.add(AllocationRecorder.class.getName());
            this.excludeAllocationsInsideTheseMethods.add("us.ihmc.commons.allocations.AllocationProfiler.startRecordingAllocations");
            this.excludeAllocationsInsideTheseMethods.add("java.util.concurrent.FutureTask.awaitDone");
            this.excludeAllocationsWhoseTracesContainTheseKeywords.add("org.gradle.internal");
        }
    }

    public void reset() {
        if (this.recording) {
            this.stopRecordingAllocations();
        }
        this.includeAllAllocations = true;
        this.excludeAllocationsInsideTheseMethods.clear();
        this.includeAllocationsInsideTheseMethods.clear();
        this.excludeAllocationsInsideTheseClasses.clear();
        this.includeAllocationsInsideTheseClasses.clear();
        this.excludeAllocationsOfTheseClasses.clear();
        this.includeAllocationsOfTheseClasses.clear();
        this.includeAllocationsWhoseTracesContainTheseKeywords.clear();
        this.excludeAllocationsWhoseTracesContainTheseKeywords.clear();
        this.setRecordConstructorAllocations(false);
        this.setRecordStaticMemberInitialization(false);
        this.setRecordClassLoader(false);
        this.setRecordSelf(false);
        this.allocations.clear();
    }
}

