/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commons;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import us.ihmc.commons.RunnableThatThrows;

public class Assertions {
    public static void assertExceptionThrown(Class<? extends Throwable> exceptionType, RunnableThatThrows methodToRun) {
        boolean thrown = false;
        try {
            methodToRun.run();
        }
        catch (Throwable throwable) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)exceptionType.getName().equals(throwable.getClass().getName()), (String)("Exception type mismatch: Expected: " + exceptionType.getName() + " Actual: " + throwable.getClass().getName()));
            thrown = true;
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)thrown, (String)"Exception not thrown");
    }

    public static void assertSerializable(Serializable serializable) {
        Assertions.assertSerializable(serializable, false);
    }

    public static void assertSerializable(Serializable serializable, boolean assertEqual) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(serializable);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            Object object = objectInputStream.readObject();
            if (assertEqual) {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)object.equals(serializable));
            }
        }
        catch (IOException e) {
            org.junit.jupiter.api.Assertions.fail((String)"Object not serializable");
        }
        catch (ClassNotFoundException ce) {
            org.junit.jupiter.api.Assertions.fail((String)"Object not serializable: class not found");
        }
    }
}

