/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commons.lists;

import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import org.apache.commons.lang3.mutable.MutableInt;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.MutationTestFacilitator;
import us.ihmc.commons.lists.RecyclingIterator;
import us.ihmc.commons.lists.RecyclingLinkedList;

public class RecyclingLinkedListTest {
    @Test
    public void testOperations() {
        RecyclingLinkedList linkedList = new RecyclingLinkedList(MutableInt::new, MutableInt::setValue);
        this.doOperationsAndAsserts((RecyclingLinkedList<MutableInt>)linkedList, true);
        this.doOperationsAndAsserts((RecyclingLinkedList<MutableInt>)linkedList, false);
        this.doOperationsAndAsserts((RecyclingLinkedList<MutableInt>)linkedList, true);
        this.doOperationsAndAsserts((RecyclingLinkedList<MutableInt>)linkedList, false);
    }

    public void doOperationsAndAsserts(RecyclingLinkedList<MutableInt> linkedList, boolean reverse) {
        Assertions.assertEquals((int)0, (int)linkedList.size());
        Assertions.assertTrue((boolean)linkedList.isEmpty());
        MutableInt element = new MutableInt();
        RecyclingIterator forwardIterator = linkedList.createForwardIterator();
        RecyclingIterator backwardIterator = linkedList.createBackwardIterator();
        Assertions.assertFalse((boolean)forwardIterator.hasNext());
        if (reverse) {
            this.addElementsToBack(linkedList, (RecyclingIterator<MutableInt>)forwardIterator, (RecyclingIterator<MutableInt>)backwardIterator);
            Assertions.assertEquals((int)5, (int)linkedList.size());
            this.addElementsToFront(linkedList, (RecyclingIterator<MutableInt>)forwardIterator, (RecyclingIterator<MutableInt>)backwardIterator);
            Assertions.assertEquals((int)10, (int)linkedList.size());
        } else {
            this.addElementsToFront(linkedList, (RecyclingIterator<MutableInt>)forwardIterator, (RecyclingIterator<MutableInt>)backwardIterator);
            Assertions.assertEquals((int)5, (int)linkedList.size());
            this.addElementsToBack(linkedList, (RecyclingIterator<MutableInt>)forwardIterator, (RecyclingIterator<MutableInt>)backwardIterator);
            Assertions.assertEquals((int)10, (int)linkedList.size());
        }
        Assertions.assertFalse((boolean)linkedList.isEmpty());
        linkedList.peekFirst((Object)element);
        Assertions.assertEquals((int)0, (int)element.intValue());
        linkedList.peekLast((Object)element);
        Assertions.assertEquals((int)9, (int)element.intValue());
        int expected = 0;
        forwardIterator.reset();
        while (forwardIterator.hasNext()) {
            if (expected > 9) {
                Assertions.fail((String)"Iterator should have stopped.");
            }
            forwardIterator.next((Object)element);
            Assertions.assertEquals((int)expected++, (int)element.intValue());
        }
        Assertions.assertEquals((int)expected, (int)10);
        forwardIterator.reset();
        expected = 9;
        backwardIterator.reset();
        while (backwardIterator.hasNext()) {
            if (expected < 0) {
                Assertions.fail((String)"Iterator should have stopped.");
            }
            backwardIterator.next((Object)element);
            Assertions.assertEquals((int)expected--, (int)element.intValue());
        }
        Assertions.assertEquals((int)expected, (int)-1);
        backwardIterator.reset();
        if (reverse) {
            this.removeFromBack(linkedList, element, (RecyclingIterator<MutableInt>)forwardIterator, (RecyclingIterator<MutableInt>)backwardIterator);
            this.removeFromFront(linkedList, element, (RecyclingIterator<MutableInt>)forwardIterator, (RecyclingIterator<MutableInt>)backwardIterator);
        } else {
            this.removeFromFront(linkedList, element, (RecyclingIterator<MutableInt>)forwardIterator, (RecyclingIterator<MutableInt>)backwardIterator);
            this.removeFromBack(linkedList, element, (RecyclingIterator<MutableInt>)forwardIterator, (RecyclingIterator<MutableInt>)backwardIterator);
        }
        forwardIterator.reset();
        expected = 4;
        while (forwardIterator.hasNext()) {
            if (expected > 7) {
                Assertions.fail((String)"Iterator should have stopped.");
            }
            forwardIterator.next((Object)element);
            Assertions.assertEquals((int)expected++, (int)element.intValue());
        }
        Assertions.assertEquals((int)expected, (int)8);
        backwardIterator.reset();
        expected = 7;
        while (backwardIterator.hasNext()) {
            if (expected < 4) {
                Assertions.fail((String)"Iterator should have stopped.");
            }
            backwardIterator.next((Object)element);
            Assertions.assertEquals((int)expected--, (int)element.intValue());
        }
        Assertions.assertEquals((int)expected, (int)3);
        try {
            forwardIterator.next((Object)element);
            Assertions.fail((String)("Iterator should have thrown a " + NoSuchElementException.class.getSimpleName() + "."));
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        try {
            backwardIterator.next((Object)element);
            Assertions.fail((String)("Iterator should have thrown a " + NoSuchElementException.class.getSimpleName() + "."));
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        linkedList.peekLast((Object)element);
        int valueToAdd = element.intValue();
        while (++valueToAdd <= 20) {
            element.setValue(valueToAdd);
            linkedList.addLast((Object)element);
        }
        linkedList.peekFirst((Object)element);
        valueToAdd = element.intValue();
        while (--valueToAdd >= -20) {
            element.setValue(valueToAdd);
            linkedList.addFirst((Object)element);
        }
        forwardIterator.reset();
        expected = -20;
        while (forwardIterator.hasNext()) {
            if (expected > 20) {
                Assertions.fail((String)"Iterator should have stopped.");
            }
            forwardIterator.next();
            ++expected;
        }
        Assertions.assertEquals((int)expected, (int)21);
        backwardIterator.reset();
        expected = 20;
        while (backwardIterator.hasNext()) {
            if (expected < -20) {
                Assertions.fail((String)"Iterator should have stopped.");
            }
            backwardIterator.next();
            --expected;
        }
        Assertions.assertEquals((int)expected, (int)-21);
        if (reverse) {
            for (int i = -20; i <= 20; ++i) {
                if (i % 2 == 0) {
                    linkedList.removeFirst((Object)element);
                    Assertions.assertEquals((int)i, (int)element.intValue());
                    continue;
                }
                linkedList.removeFirst();
            }
        } else {
            for (int i = 20; i >= -20; --i) {
                if (i % 2 == 0) {
                    linkedList.removeLast((Object)element);
                    Assertions.assertEquals((int)i, (int)element.intValue());
                    continue;
                }
                linkedList.removeLast();
            }
        }
        Assertions.assertTrue((boolean)linkedList.isEmpty());
        try {
            linkedList.peekFirst((Object)element);
            Assertions.fail((String)("Iterator should have thrown a " + NoSuchElementException.class.getSimpleName() + "."));
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        try {
            linkedList.peekLast((Object)element);
            Assertions.fail((String)("Iterator should have thrown a " + NoSuchElementException.class.getSimpleName() + "."));
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        try {
            linkedList.removeFirst((Object)element);
            Assertions.fail((String)("Iterator should have thrown a " + NoSuchElementException.class.getSimpleName() + "."));
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        try {
            linkedList.removeLast((Object)element);
            Assertions.fail((String)("Iterator should have thrown a " + NoSuchElementException.class.getSimpleName() + "."));
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    private void removeFromBack(RecyclingLinkedList<MutableInt> linkedList, MutableInt element, RecyclingIterator<MutableInt> forwardIterator, RecyclingIterator<MutableInt> backwardIterator) {
        linkedList.removeLast((Object)element);
        Assertions.assertEquals((int)9, (int)element.intValue());
        linkedList.removeLast((Object)element);
        Assertions.assertEquals((int)8, (int)element.intValue());
        try {
            forwardIterator.hasNext();
            Assertions.fail((String)("Iterator should have thrown a " + ConcurrentModificationException.class.getSimpleName() + "."));
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        forwardIterator.reset();
        try {
            backwardIterator.hasNext();
            Assertions.fail((String)("Iterator should have thrown a " + ConcurrentModificationException.class.getSimpleName() + "."));
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        backwardIterator.reset();
    }

    private void removeFromFront(RecyclingLinkedList<MutableInt> linkedList, MutableInt element, RecyclingIterator<MutableInt> forwardIterator, RecyclingIterator<MutableInt> backwardIterator) {
        linkedList.removeFirst((Object)element);
        Assertions.assertEquals((int)0, (int)element.intValue());
        linkedList.removeFirst((Object)element);
        Assertions.assertEquals((int)1, (int)element.intValue());
        linkedList.removeFirst((Object)element);
        Assertions.assertEquals((int)2, (int)element.intValue());
        linkedList.removeFirst((Object)element);
        Assertions.assertEquals((int)3, (int)element.intValue());
        try {
            forwardIterator.hasNext();
            Assertions.fail((String)("Iterator should have thrown a " + ConcurrentModificationException.class.getSimpleName() + "."));
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        forwardIterator.reset();
        try {
            backwardIterator.hasNext();
            Assertions.fail((String)("Iterator should have thrown a " + ConcurrentModificationException.class.getSimpleName() + "."));
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        backwardIterator.reset();
    }

    private void addElementsToBack(RecyclingLinkedList<MutableInt> linkedList, RecyclingIterator<MutableInt> forwardIterator, RecyclingIterator<MutableInt> backwardIterator) {
        linkedList.addLast((Object)new MutableInt(5));
        linkedList.addLast((Object)new MutableInt(6));
        linkedList.addLast((Object)new MutableInt(7));
        linkedList.addLast((Object)new MutableInt(8));
        linkedList.addLast((Object)new MutableInt(9));
        try {
            forwardIterator.hasNext();
            Assertions.fail((String)("Iterator should have thrown a " + ConcurrentModificationException.class.getSimpleName() + "."));
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        forwardIterator.reset();
        try {
            backwardIterator.hasNext();
            Assertions.fail((String)("Iterator should have thrown a " + ConcurrentModificationException.class.getSimpleName() + "."));
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        backwardIterator.reset();
    }

    private void addElementsToFront(RecyclingLinkedList<MutableInt> linkedList, RecyclingIterator<MutableInt> forwardIterator, RecyclingIterator<MutableInt> backwardIterator) {
        linkedList.addFirst((Object)new MutableInt(4));
        linkedList.addFirst((Object)new MutableInt(3));
        linkedList.addFirst((Object)new MutableInt(2));
        linkedList.addFirst((Object)new MutableInt(1));
        linkedList.addFirst((Object)new MutableInt(0));
        try {
            forwardIterator.hasNext();
            Assertions.fail((String)("Iterator should have thrown a " + ConcurrentModificationException.class.getSimpleName() + "."));
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        forwardIterator.reset();
        try {
            backwardIterator.hasNext();
            Assertions.fail((String)("Iterator should have thrown a " + ConcurrentModificationException.class.getSimpleName() + "."));
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        backwardIterator.reset();
    }

    @Test
    public void testConstructors() {
        new RecyclingLinkedList(MutableInt::new, MutableInt::setValue);
        new RecyclingLinkedList(MutableInt.class, MutableInt::setValue);
        new RecyclingLinkedList(0, MutableInt::new, MutableInt::setValue);
        new RecyclingLinkedList(0, MutableInt.class, MutableInt::setValue);
        new RecyclingLinkedList(100, MutableInt::new, MutableInt::setValue);
        new RecyclingLinkedList(100, MutableInt.class, MutableInt::setValue);
    }

    public static void main(String[] args) {
        MutationTestFacilitator.facilitateMutationTestForClass(RecyclingLinkedList.class, RecyclingLinkedListTest.class);
    }
}

