/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commons;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UnitConversionsTest {
    private static final double EPS = 1.0E-12;

    @Test
    public void inchToMeter() {
        Random rand = new Random();
        for (int i = 0; i < 1000; ++i) {
            double inches = rand.nextFloat();
            double meter = inches * 0.0254;
            Assertions.assertEquals((double)meter, (double)(inches * 0.0254), (double)1.0E-12);
        }
    }

    @Test
    public void squareInchToSquareMeter() {
        Random rand = new Random();
        for (int i = 0; i < 1000; ++i) {
            double sideAInInches = rand.nextDouble();
            double sideBInInches = rand.nextDouble();
            double areaInInches = sideAInInches * sideBInInches;
            double areaInMeters = sideAInInches * 0.0254 * (sideBInInches * 0.0254);
            Assertions.assertEquals((double)(areaInInches * 6.4516E-4), (double)areaInMeters, (double)1.0E-12);
        }
    }

    @Test
    public void cubicInchToCubicMeter() {
        Random rand = new Random();
        for (int i = 0; i < 1000; ++i) {
            double sideAInInches = rand.nextDouble();
            double sideBInInches = rand.nextDouble();
            double sideCInInches = rand.nextDouble();
            double volumeInInches = sideAInInches * sideBInInches * sideCInInches;
            double volumeInMeters = sideAInInches * 0.0254 * (sideBInInches * 0.0254) * (sideCInInches * 0.0254);
            Assertions.assertEquals((double)(volumeInInches * 1.6387064E-5), (double)volumeInMeters, (double)1.0E-12);
        }
    }

    @Test
    public void degreesToRadians() {
        Random rand = new Random();
        for (int i = 0; i < 360; ++i) {
            double degrees = rand.nextDouble();
            Assertions.assertEquals((double)(degrees * (Math.PI / 180)), (double)Math.toRadians(degrees), (double)1.0E-12);
        }
    }

    @Test
    public void psiToPascals() {
        Random rand = new Random();
        for (int i = 0; i < 1000; ++i) {
            double psi = rand.nextDouble();
            Assertions.assertEquals((double)(psi * 6894.75729), (double)(psi * 6894.75729), (double)1.0E-12);
        }
    }
}

