/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commons;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.time.LocalDate;
import java.time.LocalTime;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import us.ihmc.commons.FormattingTools;
import us.ihmc.commons.MutationTestFacilitator;
import us.ihmc.log.LogTools;

@Execution(value=ExecutionMode.SAME_THREAD)
public class FormattingToolsTest {
    @Test
    public void testGetFormattedDecimal3D() {
        String resultingFormattedString = FormattingTools.getFormattedDecimal3D((double)1.2345678);
        Assertions.assertTrue((boolean)resultingFormattedString.equals("1.235"));
        resultingFormattedString = FormattingTools.getFormattedDecimal3D((double)0.1234);
        Assertions.assertTrue((boolean)resultingFormattedString.equals("0.123"));
        resultingFormattedString = FormattingTools.getFormattedDecimal3D((double)-0.1234);
        Assertions.assertTrue((boolean)resultingFormattedString.equals("-0.123"));
        resultingFormattedString = FormattingTools.getFormattedDecimal3D((double)0.0234);
        Assertions.assertTrue((boolean)resultingFormattedString.equals("0.023"));
        resultingFormattedString = FormattingTools.getFormattedDecimal3D((double)-0.0234);
        Assertions.assertTrue((boolean)resultingFormattedString.equals("-0.023"));
        resultingFormattedString = FormattingTools.getFormattedDecimal3D((double)22.0234);
        Assertions.assertTrue((boolean)resultingFormattedString.equals("22.023"));
        resultingFormattedString = FormattingTools.getFormattedDecimal3D((double)-22.0234);
        Assertions.assertTrue((boolean)resultingFormattedString.equals("-22.023"));
    }

    @Test
    public void testCapitalizeFirstLetter() {
        String resultingString = StringUtils.capitalize((String)"capital");
        Assertions.assertTrue((boolean)resultingString.equals("Capital"));
        resultingString = StringUtils.uncapitalize((String)resultingString);
        Assertions.assertTrue((boolean)resultingString.equals("capital"));
        resultingString = StringUtils.capitalize((String)"robot");
        Assertions.assertTrue((boolean)resultingString.equals("Robot"));
        resultingString = StringUtils.uncapitalize((String)resultingString);
        Assertions.assertTrue((boolean)resultingString.equals("robot"));
        resultingString = StringUtils.capitalize((String)"Robot");
        Assertions.assertTrue((boolean)resultingString.equals("Robot"));
        resultingString = StringUtils.uncapitalize((String)resultingString);
        Assertions.assertTrue((boolean)resultingString.equals("robot"));
        resultingString = StringUtils.uncapitalize((String)resultingString);
        Assertions.assertTrue((boolean)resultingString.equals("robot"));
    }

    @Test
    public void testUnderScoredToCamelCase() {
        Assertions.assertEquals((Object)"TestAbcdDefg", (Object)FormattingTools.underscoredToCamelCase((String)"TEST_ABCD_DEFG", (boolean)true));
        Assertions.assertEquals((Object)"testAbcdDefg", (Object)FormattingTools.underscoredToCamelCase((String)"TEST_ABCD_DEFG", (boolean)false));
        Assertions.assertEquals((Object)"1234@$%Bcdf", (Object)FormattingTools.underscoredToCamelCase((String)"1234_@$%_BCDF", (boolean)true));
    }

    @Test
    public void testTitleToKebabCase() {
        Assertions.assertEquals((Object)"hello", (Object)FormattingTools.titleToKebabCase((String)"Hello"));
        Assertions.assertEquals((Object)"hello123", (Object)FormattingTools.titleToKebabCase((String)"Hello123 "));
        Assertions.assertEquals((Object)"hello-123", (Object)FormattingTools.titleToKebabCase((String)"Hello 123"));
        Assertions.assertEquals((Object)"hello-123-multi", (Object)FormattingTools.titleToKebabCase((String)"Hello 123 Multi"));
        Assertions.assertEquals((Object)"hello-123-multi", (Object)FormattingTools.titleToKebabCase((String)" -Hello 123 Multi"));
        Assertions.assertEquals((Object)"hello-123-multi", (Object)FormattingTools.titleToKebabCase((String)"Hello 123 Multi-"));
        Assertions.assertEquals((Object)"123hello", (Object)FormattingTools.titleToKebabCase((String)"123Hello"));
    }

    @Test
    public void testTitleToPascalCase() {
        Assertions.assertEquals((Object)"Hello", (Object)FormattingTools.titleToPascalCase((String)"Hello"));
        Assertions.assertEquals((Object)"Hello123", (Object)FormattingTools.titleToPascalCase((String)"Hello123"));
        Assertions.assertEquals((Object)"Hello123", (Object)FormattingTools.titleToPascalCase((String)"Hello 123"));
        Assertions.assertEquals((Object)"Hello123Multi", (Object)FormattingTools.titleToPascalCase((String)"Hello 123 Multi "));
        Assertions.assertEquals((Object)"Hello123Multi", (Object)FormattingTools.titleToPascalCase((String)"-Hello 123 Multi"));
        Assertions.assertEquals((Object)"Hello123Multi", (Object)FormattingTools.titleToPascalCase((String)"Hello 123 Multi- "));
        Assertions.assertEquals((Object)"123Hello", (Object)FormattingTools.titleToPascalCase((String)"123Hello"));
        Assertions.assertEquals((Object)"HiThere", (Object)FormattingTools.titleToPascalCase((String)"Hi There"));
        Assertions.assertEquals((Object)"HiThere", (Object)FormattingTools.titleToPascalCase((String)"Hi there"));
    }

    @Test
    public void testKebabToPascalCase() {
        Assertions.assertEquals((Object)"Hello", (Object)FormattingTools.kebabToPascalCase((String)"hello "));
        Assertions.assertEquals((Object)"HelloThere", (Object)FormattingTools.kebabToPascalCase((String)" hello-there"));
        Assertions.assertEquals((Object)"HelloThere123", (Object)FormattingTools.kebabToPascalCase((String)"  -hello-there-123-"));
        Assertions.assertEquals((Object)"HelloThere123", (Object)FormattingTools.kebabToPascalCase((String)"-hello-there-123"));
        Assertions.assertEquals((Object)"HelloThere123", (Object)FormattingTools.kebabToPascalCase((String)"hello-there-123- "));
    }

    @Test
    public void testKebabToCamelCase() {
        Assertions.assertEquals((Object)"hello", (Object)FormattingTools.kebabToCamelCase((String)"hello "));
        Assertions.assertEquals((Object)"helloThere", (Object)FormattingTools.kebabToCamelCase((String)" hello-there"));
        Assertions.assertEquals((Object)"helloThere123", (Object)FormattingTools.kebabToCamelCase((String)"  -hello-there-123-"));
        Assertions.assertEquals((Object)"helloThere123", (Object)FormattingTools.kebabToCamelCase((String)"-hello-there-123"));
        Assertions.assertEquals((Object)"helloThere123", (Object)FormattingTools.kebabToCamelCase((String)"hello-there-123- "));
    }

    @Test
    public void testToKebabCased() {
        Assertions.assertEquals((Object)"hello", (Object)FormattingTools.toKebabCased((String)"hello "));
        Assertions.assertEquals((Object)"hello-there", (Object)FormattingTools.toKebabCased((String)" hello-there"));
        Assertions.assertEquals((Object)"hello-there-1-2-3", (Object)FormattingTools.toKebabCased((String)"  -hello-there-123-"));
        Assertions.assertEquals((Object)"hello-there-1-2-3", (Object)FormattingTools.toKebabCased((String)"-hello-there-123"));
        Assertions.assertEquals((Object)"hello-there-1-2-3", (Object)FormattingTools.toKebabCased((String)"hello-there-123- "));
        Assertions.assertEquals((Object)"hello", (Object)FormattingTools.toKebabCased((String)"Hello"));
        Assertions.assertEquals((Object)"hello-1-2-3", (Object)FormattingTools.toKebabCased((String)"Hello123"));
    }

    @Test
    public void testFormatToSignificantFigures() {
        this.testFormatToPrecision(123.45, 0.01, 1, "100");
        this.testFormatToPrecision(123.45, 0.01, 2, "120");
        this.testFormatToPrecision(0.01000000000001, 0.01, 2, "0.01");
        this.testFormatToPrecision(-8000000.0000000065, 999999.999999999, 2, "-8000000");
    }

    private void testFormatToPrecision(double value, double precision, int significantFigures, String expectedString) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream systemOut = System.out;
        System.setOut(new PrintStream(byteArrayOutputStream));
        System.out.println(FormattingTools.getFormattedToPrecision((double)value, (double)precision, (int)significantFigures));
        System.out.flush();
        System.setOut(systemOut);
        System.out.println("ByteArrayOutputStream.toString(): " + byteArrayOutputStream.toString());
        Assertions.assertEquals((Object)(expectedString + System.lineSeparator()), (Object)byteArrayOutputStream.toString(), (String)"FormattingTools.getFormattedToSignificantFigures didn't work.");
    }

    @Test
    public void testGetDateString() {
        String dateToolsDateString = FormattingTools.getDateString();
        StringBuilder dateBuilder = new StringBuilder();
        LocalDate now = LocalDate.now();
        int year = now.getYear();
        int month = now.getMonthValue();
        int day = now.getDayOfMonth();
        dateBuilder.append(year);
        if (month / 10 < 1) {
            dateBuilder.append("0" + month);
        } else {
            dateBuilder.append(month);
        }
        if (day / 10 < 1) {
            dateBuilder.append("0" + day);
        } else {
            dateBuilder.append(day);
        }
        Assertions.assertEquals((Object)dateBuilder.toString(), (Object)dateToolsDateString);
        LogTools.debug((String)FormattingTools.getDateString());
    }

    @Disabled
    @Test
    public void testGetTimeString() {
        StringBuilder timeBuilder = new StringBuilder();
        LocalTime now = LocalTime.now();
        int hours = now.getHour();
        int minutes = now.getMinute();
        int seconds = now.getSecond();
        String timeString = FormattingTools.getTimeString();
        String timeSecondsString = FormattingTools.getTimeStringWithSeconds();
        if (hours / 10 < 1) {
            timeBuilder.append("0" + hours);
        } else {
            timeBuilder.append(hours);
        }
        if (minutes / 10 < 1) {
            timeBuilder.append("0" + minutes);
        } else {
            timeBuilder.append(minutes);
        }
        Assertions.assertEquals((Object)timeBuilder.toString(), (Object)timeString);
        LogTools.debug((String)FormattingTools.getTimeString());
        if (seconds / 10 < 1) {
            timeBuilder.append("0" + seconds);
        } else {
            timeBuilder.append(seconds);
        }
        Assertions.assertEquals((Object)timeBuilder.toString(), (Object)timeSecondsString);
        LogTools.debug((String)FormattingTools.getTimeStringWithSeconds());
    }

    public static void main(String[] args) {
        MutationTestFacilitator.facilitateMutationTestForClass(FormattingTools.class, FormattingToolsTest.class);
    }
}

