/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commons;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.DeadbandTools;
import us.ihmc.commons.RandomNumbers;

public class DeadbandToolsTest {
    private static final double epsilon = 1.0E-9;
    private static final int iters = 100;

    @Test
    public void testScalar() {
        Random random = new Random(1738L);
        for (int iter = 0; iter < 100; ++iter) {
            double value = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)100.0);
            double noPassDeadband = RandomNumbers.nextDouble((Random)random, (double)(Math.abs(value) + 1.0E-8), (double)100.0);
            double somePassDeadband = RandomNumbers.nextDouble((Random)random, (double)(Math.abs(value) - 1.0E-8));
            double offset = RandomNumbers.nextDouble((Random)random, (double)100.0);
            Assertions.assertEquals((double)0.0, (double)DeadbandTools.applyDeadband((double)noPassDeadband, (double)value), (double)1.0E-9, (String)("iter = " + iter));
            Assertions.assertEquals((double)0.0, (double)DeadbandTools.applyDeadband((double)noPassDeadband, (double)(-value)), (double)1.0E-9, (String)("iter = " + iter));
            Assertions.assertEquals((double)offset, (double)DeadbandTools.applyDeadband((double)noPassDeadband, (double)offset, (double)(offset + value)), (String)("iter = " + iter));
            Assertions.assertEquals((double)offset, (double)DeadbandTools.applyDeadband((double)noPassDeadband, (double)offset, (double)(offset - value)), (String)("iter = " + iter));
            Assertions.assertEquals((double)(value - somePassDeadband), (double)DeadbandTools.applyDeadband((double)somePassDeadband, (double)value), (double)1.0E-9, (String)("Deadband = " + somePassDeadband + ", value = " + value));
            Assertions.assertEquals((double)(-value + somePassDeadband), (double)DeadbandTools.applyDeadband((double)somePassDeadband, (double)(-value)), (double)1.0E-9, (String)("Deadband = " + somePassDeadband + ", value = " + -value));
            Assertions.assertEquals((double)(offset + value - somePassDeadband), (double)DeadbandTools.applyDeadband((double)somePassDeadband, (double)offset, (double)(offset + value)), (double)1.0E-9, (String)("Center = " + offset + ", deadband = " + somePassDeadband + ", value = " + (offset + value)));
            Assertions.assertEquals((double)(offset - value + somePassDeadband), (double)DeadbandTools.applyDeadband((double)somePassDeadband, (double)offset, (double)(offset - value)), (double)1.0E-9, (String)("Center = " + offset + ", deadband = " + somePassDeadband + ", value = " + (offset - value)));
        }
    }
}

