/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commons.thread;

import java.time.Duration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.Conversions;
import us.ihmc.commons.thread.Notification;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.log.LogTools;

public class NotificationTest {
    @Test
    public void testNotified() {
        Notification notification = new Notification();
        Assertions.assertFalse((boolean)notification.peek());
        Assertions.assertFalse((boolean)notification.poll());
        Assertions.assertFalse((boolean)notification.peek());
        Assertions.assertFalse((boolean)notification.peek());
        Assertions.assertFalse((boolean)notification.read());
        Assertions.assertFalse((boolean)notification.read());
        Assertions.assertFalse((boolean)notification.peek());
        Assertions.assertFalse((boolean)notification.read());
        notification.set();
        Assertions.assertTrue((boolean)notification.peek());
        Assertions.assertTrue((boolean)notification.peek());
        Assertions.assertTrue((boolean)notification.poll());
        Assertions.assertFalse((boolean)notification.peek());
        Assertions.assertFalse((boolean)notification.peek());
        Assertions.assertTrue((boolean)notification.read());
        Assertions.assertTrue((boolean)notification.read());
        Assertions.assertFalse((boolean)notification.peek());
        Assertions.assertTrue((boolean)notification.read());
        Assertions.assertFalse((boolean)notification.poll());
        Assertions.assertFalse((boolean)notification.peek());
        Assertions.assertFalse((boolean)notification.peek());
        Assertions.assertFalse((boolean)notification.read());
        Assertions.assertFalse((boolean)notification.read());
        Assertions.assertFalse((boolean)notification.peek());
        Assertions.assertFalse((boolean)notification.read());
        notification.set();
        Assertions.assertTrue((boolean)notification.peek());
        Assertions.assertTrue((boolean)notification.poll());
        notification.set();
        notification.set();
        Assertions.assertTrue((boolean)notification.peek());
        Assertions.assertTrue((boolean)notification.poll());
    }

    @Test
    public void testClear() {
        Notification notification = new Notification();
        Assertions.assertFalse((boolean)notification.poll());
        Assertions.assertFalse((boolean)notification.read());
        notification.set();
        Assertions.assertTrue((boolean)notification.poll());
        Assertions.assertTrue((boolean)notification.read());
        notification.set();
        notification.clear();
        Assertions.assertFalse((boolean)notification.poll());
        Assertions.assertFalse((boolean)notification.read());
    }

    @Test
    public void testNotifiedBeforeBlockingPollCalled() {
        Notification notification = new Notification();
        notification.set();
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(1L), () -> notification.blockingPoll());
        Assertions.assertTrue((boolean)notification.read());
    }

    @Test
    public void testNotifiedBeforeBlockingPeekCalled() {
        Notification notification = new Notification();
        notification.set();
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(1L), () -> notification.blockingPeek());
        Assertions.assertTrue((boolean)notification.peek());
        Assertions.assertFalse((boolean)notification.read());
        Assertions.assertTrue((boolean)notification.poll());
        Assertions.assertTrue((boolean)notification.read());
    }

    @Test
    public void testNotificationFromThread() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(1L), () -> {
            Notification notification = new Notification();
            Assertions.assertFalse((boolean)notification.poll());
            Assertions.assertFalse((boolean)notification.read());
            long before = System.nanoTime();
            ThreadTools.startAThread(() -> {
                ThreadTools.sleep((long)200L);
                notification.set();
            }, (String)"SetterThread");
            notification.blockingPoll();
            long after = System.nanoTime();
            Assertions.assertTrue((Conversions.nanosecondsToMilliseconds((long)(after - before)) >= 200L ? 1 : 0) != 0);
            Assertions.assertTrue((boolean)notification.read());
        });
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(1L), () -> {
            boolean condition;
            Notification notification = new Notification();
            Assertions.assertFalse((boolean)notification.poll());
            Assertions.assertFalse((boolean)notification.read());
            long before = System.nanoTime();
            ThreadTools.startAThread(() -> {
                ThreadTools.sleep((long)200L);
                notification.set();
            }, (String)"SetterThread");
            notification.blockingPeek();
            long after = System.nanoTime();
            boolean bl = condition = Conversions.nanosecondsToMilliseconds((long)(after - before)) >= 200L;
            if (!condition) {
                LogTools.info((String)"Time taken: {}", (Object)Conversions.nanosecondsToMilliseconds((long)(after - before)));
            }
            Assertions.assertTrue((boolean)condition);
            Assertions.assertTrue((boolean)notification.peek());
            Assertions.assertFalse((boolean)notification.read());
            Assertions.assertTrue((boolean)notification.poll());
            Assertions.assertTrue((boolean)notification.read());
        });
    }
}

