/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commons.robotics.robotSide;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.robotics.robotSide.RobotSide;
import us.ihmc.commons.robotics.robotSide.SegmentDependentList;
import us.ihmc.commons.robotics.robotSide.SideDependentList;

public class SideDependentListTest {
    @Test
    public void testCommonUse() {
        double leftFavoriteNumber = Math.PI;
        double rightFavoriteNumber = Math.E;
        SideDependentList sideDependentList = new SideDependentList();
        sideDependentList.set((Enum)RobotSide.LEFT, (Object)leftFavoriteNumber);
        sideDependentList.set((Enum)RobotSide.RIGHT, (Object)rightFavoriteNumber);
        double epsilon = 0.0;
        Assertions.assertEquals((double)leftFavoriteNumber, (double)((Double)sideDependentList.get((Enum)RobotSide.LEFT)), (double)epsilon);
        Assertions.assertEquals((double)rightFavoriteNumber, (double)((Double)sideDependentList.get((Enum)RobotSide.RIGHT)), (double)epsilon);
        double sum = 0.0;
        for (Double doubleValue : sideDependentList) {
            sum += doubleValue.doubleValue();
        }
        epsilon = 1.0E-14;
        Assertions.assertEquals((double)(leftFavoriteNumber + rightFavoriteNumber), (double)sum, (double)epsilon);
        System.out.println(sideDependentList);
    }

    @Test
    public void testWitGenericObjects() {
        ArrayList leftObject = new ArrayList();
        LinkedList rightObject = new LinkedList();
        SideDependentList sideDependentList = new SideDependentList(leftObject, rightObject);
        Assertions.assertTrue((leftObject == sideDependentList.get((Enum)RobotSide.LEFT) ? 1 : 0) != 0);
        Assertions.assertTrue((rightObject == sideDependentList.get((Enum)RobotSide.RIGHT) ? 1 : 0) != 0);
    }

    @Test
    public void testCopyConstructor() {
        Object leftObject = new Object();
        Object rightObject = new Object();
        SideDependentList sideDependentList = new SideDependentList(leftObject, rightObject);
        SideDependentList sideDependentListCopy = new SideDependentList((SegmentDependentList)sideDependentList);
        Assertions.assertTrue((sideDependentList.get((Enum)RobotSide.LEFT) == leftObject ? 1 : 0) != 0);
        Assertions.assertTrue((sideDependentList.get((Enum)RobotSide.RIGHT) == rightObject ? 1 : 0) != 0);
        Assertions.assertTrue((sideDependentList.get((Enum)RobotSide.LEFT) == sideDependentListCopy.get((Enum)RobotSide.LEFT) ? 1 : 0) != 0);
        Assertions.assertTrue((sideDependentList.get((Enum)RobotSide.RIGHT) == sideDependentListCopy.get((Enum)RobotSide.RIGHT) ? 1 : 0) != 0);
        Assertions.assertTrue((sideDependentList.get((Enum)RobotSide.LEFT) != sideDependentListCopy.get((Enum)RobotSide.RIGHT) ? 1 : 0) != 0);
        Assertions.assertTrue((sideDependentList.get((Enum)RobotSide.RIGHT) != sideDependentListCopy.get((Enum)RobotSide.LEFT) ? 1 : 0) != 0);
    }

    @Test
    public void testIndexOutOfBoundsException() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> {
            Object leftObject = new Object();
            Object rightObject = new Object();
            SideDependentList sideDependentList = new SideDependentList(leftObject, rightObject);
            Iterator iterator = sideDependentList.iterator();
            while (iterator.hasNext()) {
                iterator.next();
            }
            iterator.next();
        });
    }

    @Test
    public void testIteratorCannotRemove() {
        Object leftObject = new Object();
        Object rightObject = new Object();
        SideDependentList sideDependentList = new SideDependentList(leftObject, rightObject);
        Iterator iterator = sideDependentList.iterator();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> iterator.remove());
    }

    @Test
    public void testSet() {
        Object leftObject = new Object();
        Object rightObject = new Object();
        SideDependentList sideDependentList = new SideDependentList(leftObject, rightObject);
        SideDependentList sideDependentListCopy = new SideDependentList();
        sideDependentListCopy.set(sideDependentList);
        Assertions.assertTrue((sideDependentList.get((Enum)RobotSide.LEFT) == sideDependentListCopy.get((Enum)RobotSide.LEFT) ? 1 : 0) != 0);
        Assertions.assertTrue((sideDependentList.get((Enum)RobotSide.RIGHT) == sideDependentListCopy.get((Enum)RobotSide.RIGHT) ? 1 : 0) != 0);
        Assertions.assertTrue((leftObject == sideDependentListCopy.get((Enum)RobotSide.LEFT) ? 1 : 0) != 0);
        Assertions.assertTrue((rightObject == sideDependentListCopy.get((Enum)RobotSide.RIGHT) ? 1 : 0) != 0);
    }

    @Test
    public void testCreateListOfHashMaps() {
        SideDependentList sideDependentList = SideDependentList.createListOfHashMaps();
        LinkedHashMap<Double, String> leftHashMap = new LinkedHashMap<Double, String>();
        LinkedHashMap<Double, String> rightHashMap = new LinkedHashMap<Double, String>();
        leftHashMap.put(1.0, "1.0");
        leftHashMap.put(2.0, "2.0");
        rightHashMap.put(3.0, "3.0");
        rightHashMap.put(4.0, "4.0");
        sideDependentList.set((Enum)RobotSide.LEFT, leftHashMap);
        sideDependentList.set((Enum)RobotSide.RIGHT, rightHashMap);
        Assertions.assertEquals(((Map)sideDependentList.get((Enum)RobotSide.LEFT)).get(1.0), (Object)"1.0");
        Assertions.assertEquals(((Map)sideDependentList.get((Enum)RobotSide.LEFT)).get(2.0), (Object)"2.0");
        Assertions.assertEquals(((Map)sideDependentList.get((Enum)RobotSide.RIGHT)).get(3.0), (Object)"3.0");
        Assertions.assertEquals(((Map)sideDependentList.get((Enum)RobotSide.RIGHT)).get(4.0), (Object)"4.0");
    }

    @Test
    public void testCreateListOfEnumMaps() {
        SideDependentList sideDependentList = SideDependentList.createListOfEnumMaps(IceCreamFlavor.class);
        EnumMap<IceCreamFlavor, String> leftEnumMap = new EnumMap<IceCreamFlavor, String>(IceCreamFlavor.class);
        EnumMap<IceCreamFlavor, String> rightEnumMap = new EnumMap<IceCreamFlavor, String>(IceCreamFlavor.class);
        leftEnumMap.put(IceCreamFlavor.CHOCOLATE, "YummyChocolate");
        leftEnumMap.put(IceCreamFlavor.VANILLA, "YummyVanilla");
        leftEnumMap.put(IceCreamFlavor.TOOTYFRUITY, "YummyTootyFruity");
        rightEnumMap.put(IceCreamFlavor.CHOCOLATE, "ChocolateWow");
        sideDependentList.put((Enum)RobotSide.LEFT, leftEnumMap);
        sideDependentList.put((Enum)RobotSide.RIGHT, rightEnumMap);
        Assertions.assertEquals((Object)"YummyChocolate", ((EnumMap)sideDependentList.get((Enum)RobotSide.LEFT)).get((Object)IceCreamFlavor.CHOCOLATE));
        Assertions.assertEquals((Object)"YummyVanilla", ((EnumMap)sideDependentList.get((Enum)RobotSide.LEFT)).get((Object)IceCreamFlavor.VANILLA));
        Assertions.assertEquals((Object)"YummyTootyFruity", ((EnumMap)sideDependentList.get((Enum)RobotSide.LEFT)).get((Object)IceCreamFlavor.TOOTYFRUITY));
        Assertions.assertEquals((Object)"ChocolateWow", ((EnumMap)sideDependentList.get((Enum)RobotSide.RIGHT)).get((Object)IceCreamFlavor.CHOCOLATE));
        Assertions.assertEquals(null, ((EnumMap)sideDependentList.get((Enum)RobotSide.RIGHT)).get((Object)IceCreamFlavor.VANILLA));
        Assertions.assertEquals(null, ((EnumMap)sideDependentList.get((Enum)RobotSide.RIGHT)).get((Object)IceCreamFlavor.TOOTYFRUITY));
    }

    private static enum IceCreamFlavor {
        CHOCOLATE,
        VANILLA,
        TOOTYFRUITY;

    }
}

