/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commons.robotics.robotSide;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.robotics.robotSide.RobotSide;

public class RobotSideTest {
    @Test
    public void testRobotSide() {
        RobotSide leftRobotSide = RobotSide.LEFT;
        RobotSide rightRobotSide = RobotSide.RIGHT;
        Assertions.assertEquals((Object)rightRobotSide, (Object)leftRobotSide.getOppositeSide());
        Assertions.assertEquals((Object)leftRobotSide, (Object)rightRobotSide.getOppositeSide());
        Assertions.assertEquals((Object)"r", (Object)rightRobotSide.getShortLowerCaseName());
        Assertions.assertEquals((Object)"l", (Object)leftRobotSide.getShortLowerCaseName());
        Assertions.assertEquals((Object)"right", (Object)rightRobotSide.getCamelCaseNameForStartOfExpression());
        Assertions.assertEquals((Object)"left", (Object)leftRobotSide.getCamelCaseNameForStartOfExpression());
        Assertions.assertEquals((Object)"Right", (Object)rightRobotSide.getCamelCaseNameForMiddleOfExpression());
        Assertions.assertEquals((Object)"Left", (Object)leftRobotSide.getCamelCaseNameForMiddleOfExpression());
        Assertions.assertEquals((Object)"right", (Object)rightRobotSide.getLowerCaseName());
        Assertions.assertEquals((Object)"left", (Object)leftRobotSide.getLowerCaseName());
        Assertions.assertEquals((Object)"RIGHT", (Object)rightRobotSide.getSideNameInAllCaps());
        Assertions.assertEquals((Object)"LEFT", (Object)leftRobotSide.getSideNameInAllCaps());
        Assertions.assertEquals((Object)"R", (Object)rightRobotSide.getSideNameFirstLetter());
        Assertions.assertEquals((Object)"L", (Object)leftRobotSide.getSideNameFirstLetter());
        Assertions.assertEquals((Object)"/right_leg", (Object)rightRobotSide.getSideStringInRobonetFormat());
        Assertions.assertEquals((Object)"/left_leg", (Object)leftRobotSide.getSideStringInRobonetFormat());
        Assertions.assertEquals((Object)"right_leg", (Object)rightRobotSide.getSideStringInRobonetFormatWithoutSlash());
        Assertions.assertEquals((Object)"left_leg", (Object)leftRobotSide.getSideStringInRobonetFormatWithoutSlash());
        Assertions.assertEquals((Object)rightRobotSide, (Object)RobotSide.getSideFromString((String)"R"));
        Assertions.assertEquals((Object)rightRobotSide, (Object)RobotSide.getSideFromString((String)"Right"));
        Assertions.assertEquals((Object)rightRobotSide, (Object)RobotSide.getSideFromString((String)"right"));
        Assertions.assertEquals((Object)rightRobotSide, (Object)RobotSide.getSideFromString((String)"r"));
        Assertions.assertEquals((Object)leftRobotSide, (Object)RobotSide.getSideFromString((String)"L"));
        Assertions.assertEquals((Object)leftRobotSide, (Object)RobotSide.getSideFromString((String)"Left"));
        Assertions.assertEquals((Object)leftRobotSide, (Object)RobotSide.getSideFromString((String)"left"));
        Assertions.assertEquals((Object)leftRobotSide, (Object)RobotSide.getSideFromString((String)"l"));
        double numberToTest = 34.33;
        Assertions.assertEquals((double)numberToTest, (double)rightRobotSide.negateIfLeftSide(numberToTest), (double)1.0E-7);
        Assertions.assertEquals((double)(-numberToTest), (double)leftRobotSide.negateIfLeftSide(numberToTest), (double)1.0E-7);
        numberToTest = 74.99;
        Assertions.assertEquals((double)(-numberToTest), (double)rightRobotSide.negateIfRightSide(numberToTest), (double)1.0E-7);
        Assertions.assertEquals((double)numberToTest, (double)leftRobotSide.negateIfRightSide(numberToTest), (double)1.0E-7);
    }

    @Test
    public void testCheckRobotSideMatch() {
        RobotSide leftRobotSide = RobotSide.LEFT;
        RobotSide rightRobotSide = RobotSide.RIGHT;
        RobotSide nullRobotSide = null;
        leftRobotSide.checkRobotSideMatch(RobotSide.LEFT);
        rightRobotSide.checkRobotSideMatch(RobotSide.RIGHT);
        try {
            leftRobotSide.checkRobotSideMatch(RobotSide.RIGHT);
            Assertions.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            rightRobotSide.checkRobotSideMatch(RobotSide.LEFT);
            Assertions.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            leftRobotSide.checkRobotSideMatch(nullRobotSide);
            Assertions.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            rightRobotSide.checkRobotSideMatch(nullRobotSide);
            Assertions.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

