/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commons.robotics.robotSide;

import java.util.ArrayList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.robotics.robotSide.RobotQuadrant;

public class RobotQuadrantTest {
    private RobotQuadrant frontLeft = RobotQuadrant.FRONT_LEFT;
    private RobotQuadrant frontRight = RobotQuadrant.FRONT_RIGHT;
    private RobotQuadrant hindRight = RobotQuadrant.HIND_RIGHT;
    private RobotQuadrant hindLeft = RobotQuadrant.HIND_LEFT;

    @Test
    public void testGetAcrossBodyLeg() {
        Assertions.assertEquals((Object)this.frontLeft, (Object)this.frontRight.getAcrossBodyQuadrant());
        Assertions.assertEquals((Object)this.frontRight, (Object)this.frontLeft.getAcrossBodyQuadrant());
        Assertions.assertEquals((Object)this.hindLeft, (Object)this.hindRight.getAcrossBodyQuadrant());
        Assertions.assertEquals((Object)this.hindRight, (Object)this.hindLeft.getAcrossBodyQuadrant());
    }

    @Test
    public void testGetAllLegs() {
        ArrayList actualReturn = RobotQuadrant.getAllQuadrants();
        Assertions.assertEquals((int)4, (int)actualReturn.size(), (String)"Number of legs");
        Assertions.assertEquals((Object)this.frontLeft, actualReturn.get(0));
        Assertions.assertEquals((Object)this.frontRight, actualReturn.get(1));
        Assertions.assertEquals((Object)this.hindRight, actualReturn.get(2));
        Assertions.assertEquals((Object)this.hindLeft, actualReturn.get(3));
    }

    @Test
    public void testGetDiagonalOppositeLeg() {
        Assertions.assertEquals((Object)this.hindRight, (Object)this.frontLeft.getDiagonalOppositeQuadrant());
        Assertions.assertEquals((Object)this.hindLeft, (Object)this.frontRight.getDiagonalOppositeQuadrant());
        Assertions.assertEquals((Object)this.frontLeft, (Object)this.hindRight.getDiagonalOppositeQuadrant());
        Assertions.assertEquals((Object)this.frontRight, (Object)this.hindLeft.getDiagonalOppositeQuadrant());
    }

    @Test
    public void testGetLegName() {
        Assertions.assertEquals((Object)this.frontLeft, (Object)RobotQuadrant.getQuadrantName((String)"FRONT_LEFT"));
        Assertions.assertEquals((Object)this.frontRight, (Object)RobotQuadrant.getQuadrantName((String)"FRONT_RIGHT"));
        Assertions.assertEquals((Object)this.hindLeft, (Object)RobotQuadrant.getQuadrantName((String)"HIND_LEFT"));
        Assertions.assertEquals((Object)this.hindRight, (Object)RobotQuadrant.getQuadrantName((String)"HIND_RIGHT"));
    }

    @Test
    public void testGetLegName1() {
        Assertions.assertEquals((Object)this.frontLeft, (Object)RobotQuadrant.getQuadrantNameFromOrdinal((int)0));
        Assertions.assertEquals((Object)this.frontRight, (Object)RobotQuadrant.getQuadrantNameFromOrdinal((int)1));
        Assertions.assertEquals((Object)this.hindRight, (Object)RobotQuadrant.getQuadrantNameFromOrdinal((int)2));
        Assertions.assertEquals((Object)this.hindLeft, (Object)RobotQuadrant.getQuadrantNameFromOrdinal((int)3));
    }

    @Test
    public void testGetSameSideLeg() {
        Assertions.assertEquals((Object)this.hindLeft, (Object)this.frontLeft.getSameSideQuadrant());
        Assertions.assertEquals((Object)this.hindRight, (Object)this.frontRight.getSameSideQuadrant());
        Assertions.assertEquals((Object)this.frontRight, (Object)this.hindRight.getSameSideQuadrant());
        Assertions.assertEquals((Object)this.frontLeft, (Object)this.hindLeft.getSameSideQuadrant());
    }

    @Test
    public void testGetShortName() {
        Assertions.assertEquals((Object)"FL", (Object)this.frontLeft.getShortName());
        Assertions.assertEquals((Object)"FR", (Object)this.frontRight.getShortName());
        Assertions.assertEquals((Object)"HR", (Object)this.hindRight.getShortName());
        Assertions.assertEquals((Object)"HL", (Object)this.hindLeft.getShortName());
    }

    @Test
    public void testIsLegAFrontLeg() {
        Assertions.assertTrue((boolean)this.frontLeft.isQuadrantInFront());
        Assertions.assertTrue((boolean)this.frontRight.isQuadrantInFront());
        Assertions.assertFalse((boolean)this.hindRight.isQuadrantInFront());
        Assertions.assertFalse((boolean)this.hindLeft.isQuadrantInFront());
    }

    @Test
    public void testIsLegAHindLeg() {
        Assertions.assertFalse((boolean)this.frontLeft.isQuadrantInHind());
        Assertions.assertFalse((boolean)this.frontRight.isQuadrantInHind());
        Assertions.assertTrue((boolean)this.hindRight.isQuadrantInHind());
        Assertions.assertTrue((boolean)this.hindLeft.isQuadrantInHind());
    }

    @Test
    public void testIsLegALeftSideLeg() {
        Assertions.assertTrue((boolean)this.frontLeft.isQuadrantOnLeftSide());
        Assertions.assertFalse((boolean)this.frontRight.isQuadrantOnLeftSide());
        Assertions.assertFalse((boolean)this.hindRight.isQuadrantOnLeftSide());
        Assertions.assertTrue((boolean)this.hindLeft.isQuadrantOnLeftSide());
    }

    @Test
    public void testIsLegARightSideLeg() {
        Assertions.assertFalse((boolean)this.frontLeft.isQuadrantOnRightSide());
        Assertions.assertTrue((boolean)this.frontRight.isQuadrantOnRightSide());
        Assertions.assertTrue((boolean)this.hindRight.isQuadrantOnRightSide());
        Assertions.assertFalse((boolean)this.hindLeft.isQuadrantOnRightSide());
    }
}

