/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commons.robotics.robotSide;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.robotics.robotSide.RecyclingQuadrantDependentList;
import us.ihmc.commons.robotics.robotSide.RobotQuadrant;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;

public class RecyclingQuadrantDependentListTest {
    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void testBasicMethods() {
        RecyclingQuadrantDependentList recyclingQuadrantDependentList = new RecyclingQuadrantDependentList(FramePoint3D.class);
        FramePoint3D zeroPoint = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 0.0, 0.0);
        for (RobotQuadrant robotQuadrant : RobotQuadrant.values) {
            recyclingQuadrantDependentList.add(robotQuadrant);
            Assertions.assertTrue((boolean)zeroPoint.epsilonEquals((EuclidFrameGeometry)recyclingQuadrantDependentList.get((Enum)robotQuadrant), 1.0E-7), (String)"not equal");
        }
        FramePoint3D framePoint = (FramePoint3D)recyclingQuadrantDependentList.get((Enum)RobotQuadrant.FRONT_LEFT);
        recyclingQuadrantDependentList.remove(RobotQuadrant.FRONT_LEFT);
        Assertions.assertEquals((int)3, (int)recyclingQuadrantDependentList.size(), (String)"not size 3");
        recyclingQuadrantDependentList.add(RobotQuadrant.FRONT_LEFT);
        FramePoint3D framePoint2 = (FramePoint3D)recyclingQuadrantDependentList.get((Enum)RobotQuadrant.FRONT_LEFT);
        Assertions.assertTrue((boolean)framePoint2.epsilonEquals((EuclidFrameGeometry)framePoint, 1.0E-7), (String)"not equal");
        Assertions.assertTrue((framePoint2 == framePoint ? 1 : 0) != 0, (String)"ref not equal");
        for (int i = 0; i < 4; ++i) {
            ((FramePoint3D)recyclingQuadrantDependentList.get((Enum)RobotQuadrant.values[i])).add((double)i, 0.0, 0.0);
        }
        for (int j = 0; j < ((FramePoint3D[])recyclingQuadrantDependentList.keys()).length; ++j) {
            RobotQuadrant[] framePoint3 = ((FramePoint3D[])recyclingQuadrantDependentList.keys())[j];
            Assertions.assertEquals((double)j, (double)framePoint3.getX(), (double)1.0E-7, (String)"not equal");
        }
        recyclingQuadrantDependentList.remove(RobotQuadrant.FRONT_LEFT);
        int k = 0;
        for (RobotQuadrant quadrant : recyclingQuadrantDependentList.quadrants()) {
            ((FramePoint3D)recyclingQuadrantDependentList.get((Enum)quadrant)).set((double)(k - 6), 0.0, 0.0);
            ++k;
        }
        for (int j = 0; j < ((FramePoint3D[])recyclingQuadrantDependentList.keys()).length; ++j) {
            FramePoint3D framePoint3 = ((FramePoint3D[])recyclingQuadrantDependentList.keys())[j];
            Assertions.assertEquals((double)(j - 6), (double)framePoint3.getX(), (double)1.0E-7, (String)"not equal");
        }
    }
}

