/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commons.robotics.outputData;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.robotics.outputData.JointDesiredControlMode;
import us.ihmc.commons.robotics.outputData.JointDesiredOutput;
import us.ihmc.commons.robotics.outputData.JointDesiredOutputReadOnly;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;

public class JointDesiredOutputTest {
    private static final int ITERATIONS = 1000;
    private static List<String> doubleFieldNames = JointDesiredOutputTest.getDoubleFieldNames(true);

    private static List<String> getDoubleFieldNames(boolean capitalize) {
        Stream<String> nameStream = Stream.of(JointDesiredOutputReadOnly.class.getDeclaredMethods()).filter(m -> m.getReturnType() == Double.TYPE && m.getParameterCount() == 0 && m.getName().startsWith("get")).map(m -> m.getName().substring("get".length()));
        nameStream = capitalize ? nameStream.map(n -> StringUtils.capitalize((String)n)) : nameStream.map(n -> StringUtils.uncapitalize((String)n));
        return nameStream.collect(Collectors.toList());
    }

    @Test
    public void testConstructorsAndBasicAPI() throws Exception {
        JointDesiredOutput jointDesiredOutput = new JointDesiredOutput();
        Assertions.assertFalse((boolean)jointDesiredOutput.hasControlMode());
        Assertions.assertFalse((boolean)jointDesiredOutput.peekResetIntegratorsRequest());
        Assertions.assertFalse((boolean)jointDesiredOutput.pollResetIntegratorsRequest());
        for (String doubleFieldName : doubleFieldNames) {
            Method has = JointDesiredOutput.class.getMethod("has" + doubleFieldName, new Class[0]);
            Method get = JointDesiredOutput.class.getMethod("get" + doubleFieldName, new Class[0]);
            Assertions.assertFalse((boolean)((Boolean)has.invoke((Object)jointDesiredOutput, new Object[0])));
            Assertions.assertEquals((double)Double.NaN, (double)((Double)get.invoke((Object)jointDesiredOutput, new Object[0])));
        }
        Random random = new Random(7853L);
        JointDesiredControlMode controlMode = (JointDesiredControlMode)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])JointDesiredControlMode.values);
        jointDesiredOutput.setControlMode(controlMode);
        Assertions.assertTrue((boolean)jointDesiredOutput.hasControlMode());
        Assertions.assertEquals((Object)controlMode, (Object)jointDesiredOutput.getControlMode());
        jointDesiredOutput.setResetIntegrators(true);
        Assertions.assertTrue((boolean)jointDesiredOutput.peekResetIntegratorsRequest());
        Assertions.assertTrue((boolean)jointDesiredOutput.pollResetIntegratorsRequest());
        Assertions.assertFalse((boolean)jointDesiredOutput.pollResetIntegratorsRequest());
        jointDesiredOutput.setResetIntegrators(true);
        for (String doubleFieldName : doubleFieldNames) {
            double input = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            Method has = JointDesiredOutput.class.getMethod("has" + doubleFieldName, new Class[0]);
            Method get = JointDesiredOutput.class.getMethod("get" + doubleFieldName, new Class[0]);
            Method set = JointDesiredOutput.class.getMethod("set" + doubleFieldName, Double.TYPE);
            Assertions.assertFalse((boolean)((Boolean)has.invoke((Object)jointDesiredOutput, new Object[0])));
            set.invoke((Object)jointDesiredOutput, input);
            Assertions.assertTrue((boolean)((Boolean)has.invoke((Object)jointDesiredOutput, new Object[0])));
            Assertions.assertEquals((double)input, (double)((Double)get.invoke((Object)jointDesiredOutput, new Object[0])));
        }
        jointDesiredOutput.clear();
        Assertions.assertFalse((boolean)jointDesiredOutput.hasControlMode());
        Assertions.assertFalse((boolean)jointDesiredOutput.peekResetIntegratorsRequest());
        Assertions.assertFalse((boolean)jointDesiredOutput.pollResetIntegratorsRequest());
        for (String doubleFieldName : doubleFieldNames) {
            Method has = JointDesiredOutput.class.getMethod("has" + doubleFieldName, new Class[0]);
            Method get = JointDesiredOutput.class.getMethod("get" + doubleFieldName, new Class[0]);
            Assertions.assertFalse((boolean)((Boolean)has.invoke((Object)jointDesiredOutput, new Object[0])));
            Assertions.assertEquals((double)Double.NaN, (double)((Double)get.invoke((Object)jointDesiredOutput, new Object[0])));
        }
    }

    @Test
    public void testSet() throws Exception {
        Random random = new Random(3564564L);
        for (int i = 0; i < 1000; ++i) {
            JointDesiredOutput output1 = JointDesiredOutputTest.nextJointDesiredOutput(random);
            JointDesiredOutput output2 = JointDesiredOutputTest.nextJointDesiredOutput(random);
            Assertions.assertNotEquals((Object)output1, (Object)output2);
            output1.set(output2);
            Assertions.assertEquals((Object)output1, (Object)output2);
            Assertions.assertEquals((Object)output1.getControlMode(), (Object)output2.getControlMode());
            Assertions.assertEquals((Object)output1.peekResetIntegratorsRequest(), (Object)output2.peekResetIntegratorsRequest());
            for (String doubleFieldName : doubleFieldNames) {
                Method get = JointDesiredOutput.class.getMethod("get" + doubleFieldName, new Class[0]);
                Assertions.assertEquals((Object)get.invoke((Object)output1, new Object[0]), (Object)get.invoke((Object)output2, new Object[0]));
            }
        }
    }

    @Test
    public void testEquals() throws Exception {
        Random random = new Random(4534657L);
        for (int i = 0; i < 1000; ++i) {
            JointDesiredOutput output1 = JointDesiredOutputTest.nextJointDesiredOutput(random);
            JointDesiredOutput output2 = new JointDesiredOutput();
            output2.set(output1);
            Assertions.assertEquals((Object)output1, (Object)output2);
            while (output2.getControlMode() == output1.getControlMode()) {
                output2.setControlMode((JointDesiredControlMode)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])JointDesiredControlMode.values));
            }
            Assertions.assertNotEquals((Object)output1, (Object)output2);
            output2.set(output1);
            Assertions.assertEquals((Object)output1, (Object)output2);
            output2.setResetIntegrators(!output2.peekResetIntegratorsRequest());
            Assertions.assertNotEquals((Object)output1, (Object)output2);
            for (String doubleFieldName : doubleFieldNames) {
                Method set = JointDesiredOutput.class.getMethod("set" + doubleFieldName, Double.TYPE);
                output2.set(output1);
                Assertions.assertEquals((Object)output1, (Object)output2);
                set.invoke((Object)output2, EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
                Assertions.assertNotEquals((Object)output1, (Object)output2);
            }
        }
    }

    @Test
    public void testCompleteWith() throws Exception {
        Random random = new Random(3242362L);
        JointDesiredOutput destination = new JointDesiredOutput();
        JointDesiredOutput source = JointDesiredOutputTest.nextJointDesiredOutput(random);
        destination.completeWith((JointDesiredOutputReadOnly)source);
        Assertions.assertEquals((Object)source, (Object)destination);
        for (int i = 0; i < 1000; ++i) {
            destination.clear();
            JointDesiredOutput destinationOriginal = JointDesiredOutputTest.nextJointDesiredOutput(random);
            destination.set(destinationOriginal);
            destination.completeWith((JointDesiredOutputReadOnly)source);
            Assertions.assertNotEquals((Object)source, (Object)destination);
            Assertions.assertEquals((Object)destinationOriginal, (Object)destination);
            destination.clear();
            JointDesiredControlMode controlMode = (JointDesiredControlMode)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])JointDesiredControlMode.values);
            destination.setControlMode(controlMode);
            destination.completeWith((JointDesiredOutputReadOnly)source);
            Assertions.assertEquals((Object)controlMode, (Object)destination.getControlMode());
            destination.setControlMode(source.getControlMode());
            Assertions.assertEquals((Object)source, (Object)destination);
            destination.clear();
            destination.setResetIntegrators(true);
            destination.completeWith((JointDesiredOutputReadOnly)source);
            Assertions.assertTrue((boolean)destination.peekResetIntegratorsRequest());
            destination.setResetIntegrators(source.peekResetIntegratorsRequest());
            Assertions.assertEquals((Object)source, (Object)destination);
            for (String doubleFieldName : doubleFieldNames) {
                Method get = JointDesiredOutput.class.getMethod("get" + doubleFieldName, new Class[0]);
                Method set = JointDesiredOutput.class.getMethod("set" + doubleFieldName, Double.TYPE);
                destination.clear();
                double input = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
                set.invoke((Object)destination, input);
                destination.completeWith((JointDesiredOutputReadOnly)source);
                Assertions.assertEquals((Object)input, (Object)get.invoke((Object)destination, new Object[0]));
                set.invoke((Object)destination, get.invoke((Object)source, new Object[0]));
                Assertions.assertEquals((Object)source, (Object)destination);
            }
        }
    }

    @Test
    public void testClampedDesiredPosition() {
        Random random = new Random(456474L);
        JointDesiredOutput jointDesiredOutput = new JointDesiredOutput();
        for (int i = 0; i < 1000; ++i) {
            double q = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            double errMax = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            double q_d_min = q - errMax;
            double q_d_max = q + errMax;
            jointDesiredOutput.setPositionFeedbackMaxError(errMax);
            double q_d = EuclidCoreRandomTools.nextDouble((Random)random, (double)q_d_min, (double)q_d_max);
            jointDesiredOutput.setDesiredPosition(q_d);
            Assertions.assertEquals((double)q_d, (double)jointDesiredOutput.getClampedDesiredPosition(q));
            q_d = q_d_max + EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            jointDesiredOutput.setDesiredPosition(q_d);
            Assertions.assertEquals((double)q_d_max, (double)jointDesiredOutput.getClampedDesiredPosition(q));
            q_d = q_d_min - EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            jointDesiredOutput.setDesiredPosition(q_d);
            Assertions.assertEquals((double)q_d_min, (double)jointDesiredOutput.getClampedDesiredPosition(q));
        }
    }

    @Test
    public void testClampedDesiredVelocity() {
        Random random = new Random(456474L);
        JointDesiredOutput jointDesiredOutput = new JointDesiredOutput();
        for (int i = 0; i < 1000; ++i) {
            double qd = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            double errMax = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            double qd_d_min = qd - errMax;
            double qd_d_max = qd + errMax;
            jointDesiredOutput.setVelocityFeedbackMaxError(errMax);
            double qd_d = EuclidCoreRandomTools.nextDouble((Random)random, (double)qd_d_min, (double)qd_d_max);
            jointDesiredOutput.setDesiredVelocity(qd_d);
            Assertions.assertEquals((double)qd_d, (double)jointDesiredOutput.getClampedDesiredVelocity(qd));
            qd_d = qd_d_max + EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            jointDesiredOutput.setDesiredVelocity(qd_d);
            Assertions.assertEquals((double)qd_d_max, (double)jointDesiredOutput.getClampedDesiredVelocity(qd));
            qd_d = qd_d_min - EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            jointDesiredOutput.setDesiredVelocity(qd_d);
            Assertions.assertEquals((double)qd_d_min, (double)jointDesiredOutput.getClampedDesiredVelocity(qd));
        }
    }

    private static JointDesiredOutput nextJointDesiredOutput(Random random) throws Exception {
        JointDesiredOutput next = new JointDesiredOutput();
        next.setControlMode((JointDesiredControlMode)EuclidCoreRandomTools.nextElementIn((Random)random, (Object[])JointDesiredControlMode.values));
        next.setResetIntegrators(random.nextBoolean());
        for (String doubleFieldName : doubleFieldNames) {
            double input = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            Method set = JointDesiredOutput.class.getMethod("set" + doubleFieldName, Double.TYPE);
            set.invoke((Object)next, input);
        }
        return next;
    }
}

