/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commons.lists;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang3.mutable.MutableInt;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.commons.lists.RingBuffer;

public class RingBufferTest {
    private static final int ITERATIONS = 1000;

    @Test
    public void testSimpleApplication() {
        Random random = new Random(43584756L);
        for (int i = 0; i < 1000; ++i) {
            int j;
            RingBuffer buffer = new RingBuffer(random.nextInt(1500) + 1, MutableInt::new, MutableInt::setValue);
            ArrayList<MutableInt> elementsAdded = new ArrayList<MutableInt>();
            int j2 = 0;
            while ((double)j2 < 2.0 * (double)buffer.capacity() + 100.0) {
                MutableInt newElement = new MutableInt(j2);
                elementsAdded.add(newElement);
                buffer.add((Object)newElement);
                Assertions.assertEquals((Object)newElement, (Object)buffer.getLast());
                Assertions.assertEquals((Object)(j2 >= buffer.capacity() ? 1 : 0), (Object)buffer.isBufferFull());
                if (!buffer.isBufferFull()) {
                    Assertions.assertEquals(elementsAdded.get(0), (Object)buffer.getFirst());
                } else {
                    Assertions.assertEquals(elementsAdded.get(j2 - buffer.capacity() + 1), (Object)buffer.getFirst());
                }
                ++j2;
            }
            List ringBufferList = elementsAdded.subList(elementsAdded.size() - buffer.capacity(), elementsAdded.size());
            for (j = 0; j < buffer.capacity(); ++j) {
                Assertions.assertEquals(ringBufferList.get(j), (Object)buffer.getFromFirst(j));
            }
            Collections.reverse(ringBufferList);
            for (j = 0; j < buffer.capacity(); ++j) {
                Assertions.assertEquals(ringBufferList.get(j), (Object)buffer.getFromLast(j));
            }
            Assertions.assertEquals((Object)buffer.getFirst(), (Object)buffer.getFromFirst(0));
            Assertions.assertEquals((Object)buffer.getLast(), (Object)buffer.getFromFirst(buffer.capacity() - 1));
            Assertions.assertEquals((Object)buffer.getLast(), (Object)buffer.getFromLast(0));
            Assertions.assertEquals((Object)buffer.getFirst(), (Object)buffer.getFromLast(buffer.capacity() - 1));
        }
    }

    @Test
    public void testExampleWithPartiallyFilledBuffer() {
        Random random = new Random(8975L);
        for (int i = 0; i < 1000; ++i) {
            int j;
            RingBuffer buffer = new RingBuffer(random.nextInt(1500) + 1, MutableInt::new, MutableInt::setValue);
            ArrayList<MutableInt> elementsAdded = new ArrayList<MutableInt>();
            int numberOfElements = random.nextInt(buffer.capacity());
            for (j = 0; j < numberOfElements; ++j) {
                MutableInt newElement = new MutableInt(j);
                elementsAdded.add(newElement);
                buffer.add((Object)newElement);
                Assertions.assertEquals((Object)newElement, (Object)buffer.getLast());
                Assertions.assertFalse((boolean)buffer.isBufferFull());
                Assertions.assertEquals(elementsAdded.get(0), (Object)buffer.getFirst());
                Assertions.assertEquals((int)(j + 1), (int)buffer.size());
            }
            for (j = 0; j < buffer.capacity(); ++j) {
                if (j < buffer.size()) {
                    Assertions.assertEquals(elementsAdded.get(j), (Object)buffer.getFromFirst(j));
                    continue;
                }
                int indexFinal = j;
                Assertions.assertThrows(IndexOutOfBoundsException.class, () -> buffer.getFromFirst(indexFinal));
            }
            Collections.reverse(elementsAdded);
            for (j = 0; j < buffer.capacity(); ++j) {
                if (j < buffer.size()) {
                    Assertions.assertEquals(elementsAdded.get(j), (Object)buffer.getFromLast(j));
                    continue;
                }
                int indexFinal = j;
                Assertions.assertThrows(IndexOutOfBoundsException.class, () -> buffer.getFromLast(indexFinal));
            }
        }
    }

    @Test
    public void testToArray() {
        Random random = new Random(8975L);
        for (int i = 0; i < 1000; ++i) {
            RingBuffer buffer = new RingBuffer(random.nextInt(1500) + 1, MutableInt::new, MutableInt::setValue);
            ArrayList<MutableInt> elementsAdded = new ArrayList<MutableInt>();
            int numberOfElements = random.nextInt(2 * buffer.capacity());
            for (int j = 0; j < numberOfElements; ++j) {
                MutableInt newElement = new MutableInt(j);
                elementsAdded.add(newElement);
                buffer.add((Object)newElement);
            }
            List<Object> elementsInBuffer = buffer.isBufferFull() ? elementsAdded.subList(elementsAdded.size() - buffer.capacity(), elementsAdded.size()) : elementsAdded;
            Object[] expected = elementsInBuffer.toArray(new MutableInt[0]);
            Object[] actual = (MutableInt[])buffer.toArrayFromFirstToLast();
            Assertions.assertArrayEquals((Object[])expected, (Object[])actual);
            Collections.reverse(Arrays.asList(expected));
            actual = (MutableInt[])buffer.toArrayFromLastToFirst();
            Assertions.assertArrayEquals((Object[])expected, (Object[])actual);
        }
    }

    @Test
    public void testChangeCapacity() {
        Object[] actual;
        int newCapacity;
        Object[] expected;
        int sizeBeforeChangeCapacity;
        MutableInt newElement;
        int j;
        int numberOfElements;
        RingBuffer buffer;
        int initialCapacity;
        int i;
        Random random = new Random(5645676L);
        for (i = 0; i < 1000; ++i) {
            initialCapacity = random.nextInt(1500) + 1;
            buffer = new RingBuffer(initialCapacity, MutableInt::new, MutableInt::setValue);
            numberOfElements = random.nextInt(2 * buffer.capacity());
            for (j = 0; j < numberOfElements; ++j) {
                newElement = new MutableInt(j);
                buffer.add((Object)newElement);
            }
            sizeBeforeChangeCapacity = buffer.size();
            expected = (MutableInt[])buffer.toArrayFromFirstToLast();
            newCapacity = RandomNumbers.nextInt((Random)random, (int)(initialCapacity + 1), (int)(3 * initialCapacity));
            buffer.changeCapacity(newCapacity);
            Assertions.assertFalse((boolean)buffer.isBufferFull());
            Assertions.assertEquals((int)newCapacity, (int)buffer.capacity());
            Assertions.assertEquals((int)sizeBeforeChangeCapacity, (int)buffer.size());
            actual = (MutableInt[])buffer.toArrayFromFirstToLast();
            Assertions.assertArrayEquals((Object[])expected, (Object[])actual);
        }
        for (i = 0; i < 1000; ++i) {
            initialCapacity = random.nextInt(1500) + 1;
            buffer = new RingBuffer(initialCapacity, MutableInt::new, MutableInt::setValue);
            numberOfElements = random.nextInt(2 * buffer.capacity());
            for (j = 0; j < numberOfElements; ++j) {
                newElement = new MutableInt(j);
                buffer.add((Object)newElement);
            }
            sizeBeforeChangeCapacity = buffer.size();
            expected = (MutableInt[])buffer.toArrayFromFirstToLast();
            newCapacity = RandomNumbers.nextInt((Random)random, (int)1, (int)(initialCapacity - 1));
            buffer.changeCapacity(newCapacity);
            Assertions.assertEquals((Object)(sizeBeforeChangeCapacity >= newCapacity ? 1 : 0), (Object)buffer.isBufferFull());
            Assertions.assertEquals((int)newCapacity, (int)buffer.capacity());
            Assertions.assertEquals((int)Math.min(sizeBeforeChangeCapacity, newCapacity), (int)buffer.size());
            expected = (MutableInt[])Arrays.copyOfRange(expected, expected.length - Math.min(sizeBeforeChangeCapacity, newCapacity), expected.length);
            actual = (MutableInt[])buffer.toArrayFromFirstToLast();
            Assertions.assertArrayEquals((Object[])expected, (Object[])actual);
        }
    }
}

