/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commons;

import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.commons.robotics.EuclidDeadbandTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class EuclidDeadbandToolsTest {
    private static final double epsilon = 1.0E-9;
    private static final int iters = 100;

    @Test
    public void testVector() {
        Random random = new Random(1738L);
        for (int iter = 0; iter < 100; ++iter) {
            Vector2D value2D = EuclidCoreRandomTools.nextVector2D((Random)random, (Tuple2DReadOnly)new Vector2D(10.0, 10.0));
            Vector3D value3D = EuclidCoreRandomTools.nextVector3D((Random)random, (Tuple3DReadOnly)new Vector3D(10.0, 10.0, 10.0));
            double noPassDeadband2D = RandomNumbers.nextDouble((Random)random, (double)(value2D.norm() + 1.0E-8), (double)100.0);
            double noPassDeadband3D = RandomNumbers.nextDouble((Random)random, (double)(value3D.norm() + 1.0E-8), (double)100.0);
            double somePassDeadband2D = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)(value2D.norm() - 1.0E-8));
            double somePassDeadband3D = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)(value3D.norm() - 1.0E-8));
            Vector2D output2D = new Vector2D();
            Vector3D output3D = new Vector3D();
            output2D.set((Tuple2DReadOnly)value2D);
            output3D.set((Tuple3DReadOnly)value3D);
            EuclidDeadbandTools.applyDeadband((Vector2DBasics)output2D, (double)noPassDeadband2D);
            EuclidDeadbandTools.applyDeadband((Vector3DBasics)output3D, (double)noPassDeadband3D);
            EuclidCoreTestTools.assertVector2DGeometricallyEquals((Vector2DReadOnly)new Vector2D(), (Vector2DReadOnly)output2D, (double)1.0E-9);
            EuclidCoreTestTools.assertVector3DGeometricallyEquals((Vector3DReadOnly)new Vector3D(), (Vector3DReadOnly)output3D, (double)1.0E-9);
            output2D.set((Tuple2DReadOnly)value2D);
            output3D.set((Tuple3DReadOnly)value3D);
            output2D.negate();
            output3D.negate();
            EuclidDeadbandTools.applyDeadband((Vector2DBasics)output2D, (double)noPassDeadband2D);
            EuclidDeadbandTools.applyDeadband((Vector3DBasics)output3D, (double)noPassDeadband3D);
            EuclidCoreTestTools.assertVector2DGeometricallyEquals((Vector2DReadOnly)new Vector2D(), (Vector2DReadOnly)output2D, (double)1.0E-9);
            EuclidCoreTestTools.assertVector3DGeometricallyEquals((Vector3DReadOnly)new Vector3D(), (Vector3DReadOnly)output3D, (double)1.0E-9);
            output2D.set((Tuple2DReadOnly)value2D);
            EuclidDeadbandTools.applyDeadband((Vector2DBasics)output2D, (double)somePassDeadband2D);
            Vector2D output2DExpected = new Vector2D((Tuple2DReadOnly)value2D);
            output2DExpected.normalize();
            output2DExpected.scale(-somePassDeadband2D);
            output2DExpected.add((Tuple2DReadOnly)value2D);
            EuclidCoreTestTools.assertVector2DGeometricallyEquals((Vector2DReadOnly)output2DExpected, (Vector2DReadOnly)output2D, (double)1.0E-9);
            output3D.set((Tuple3DReadOnly)value3D);
            EuclidDeadbandTools.applyDeadband((Vector3DBasics)output3D, (double)somePassDeadband3D);
            Vector3D output3DExpected = new Vector3D((Tuple3DReadOnly)value3D);
            output3DExpected.normalize();
            output3DExpected.scale(-somePassDeadband3D);
            output3DExpected.add((Tuple3DReadOnly)value3D);
            EuclidCoreTestTools.assertVector3DGeometricallyEquals((Vector3DReadOnly)output3DExpected, (Vector3DReadOnly)output3D, (double)1.0E-9);
        }
    }

    @Test
    public void testPoint() {
        Random random = new Random(1738L);
        for (int iter = 0; iter < 100; ++iter) {
            Point2D value2D = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Point2D center2D = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            Point3D value3D = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            Point3D center3D = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            double noPassDeadband2D = RandomNumbers.nextDouble((Random)random, (double)(value2D.distance((Point2DReadOnly)center2D) + 1.0000000000000002E-6), (double)200.0);
            double noPassDeadband3D = RandomNumbers.nextDouble((Random)random, (double)(value3D.distance((Point3DReadOnly)center3D) + 1.0000000000000002E-6), (double)200.0);
            double somePassDeadband2D = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)(value2D.distance((Point2DReadOnly)center2D) - 1.0000000000000001E-7));
            double somePassDeadband3D = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)(value3D.distance((Point3DReadOnly)center3D) - 1.0000000000000001E-7));
            Point2D output2D = new Point2D();
            Point3D output3D = new Point3D();
            output2D.set((Tuple2DReadOnly)value2D);
            output3D.set((Tuple3DReadOnly)value3D);
            EuclidDeadbandTools.applyDeadband((Point2DBasics)output2D, (Point2DReadOnly)center2D, (double)noPassDeadband2D);
            EuclidDeadbandTools.applyDeadband((Point3DBasics)output3D, (Point3DReadOnly)center3D, (double)noPassDeadband3D);
            EuclidCoreTestTools.assertPoint2DGeometricallyEquals((String)("iter = " + iter), (Point2DReadOnly)center2D, (Point2DReadOnly)output2D, (double)1.0E-9);
            EuclidCoreTestTools.assertPoint3DGeometricallyEquals((String)("iter = " + iter), (Point3DReadOnly)center3D, (Point3DReadOnly)output3D, (double)1.0E-9);
            output2D.set((Tuple2DReadOnly)value2D);
            EuclidDeadbandTools.applyDeadband((Point2DBasics)output2D, (Point2DReadOnly)center2D, (double)somePassDeadband2D);
            Vector2D deadband2DVector = new Vector2D((Tuple2DReadOnly)value2D);
            deadband2DVector.sub((Tuple2DReadOnly)center2D);
            deadband2DVector.normalize();
            deadband2DVector.scale(-somePassDeadband2D);
            Point2D output2DExpected = new Point2D((Tuple2DReadOnly)value2D);
            output2DExpected.add((Tuple2DReadOnly)deadband2DVector);
            EuclidCoreTestTools.assertPoint2DGeometricallyEquals((String)("iter = " + iter), (Point2DReadOnly)output2DExpected, (Point2DReadOnly)output2D, (double)1.0E-9);
            output3D.set((Tuple3DReadOnly)value3D);
            EuclidDeadbandTools.applyDeadband((Point3DBasics)output3D, (Point3DReadOnly)center3D, (double)somePassDeadband3D);
            Vector3D deadband3DVector = new Vector3D((Tuple3DReadOnly)value3D);
            deadband3DVector.sub((Tuple3DReadOnly)center3D);
            deadband3DVector.normalize();
            deadband3DVector.scale(-somePassDeadband3D);
            Point3D output3DExpected = new Point3D((Tuple3DReadOnly)value3D);
            output3DExpected.add((Tuple3DReadOnly)deadband3DVector);
            EuclidCoreTestTools.assertPoint3DGeometricallyEquals((String)("iter = " + iter), (Point3DReadOnly)output3DExpected, (Point3DReadOnly)output3D, (double)1.0E-9);
        }
    }
}

