/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commons.lists;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Random;
import org.apache.commons.lang3.mutable.MutableInt;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.commons.lists.RecyclingArrayList;

@Execution(value=ExecutionMode.SAME_THREAD)
public class RecyclingArrayListTest {
    @Test
    public void testConstructors() {
        RecyclingArrayList list = new RecyclingArrayList(Object.class);
        Assertions.assertTrue((boolean)list.isEmpty());
        Assertions.assertTrue((list.size() == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((list.getLast() == null ? 1 : 0) != 0);
        list = new RecyclingArrayList(Object::new);
        Assertions.assertTrue((boolean)list.isEmpty());
        Assertions.assertTrue((list.size() == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((list.getLast() == null ? 1 : 0) != 0);
        int capacity = 10;
        list = new RecyclingArrayList(capacity, Object.class);
        Assertions.assertTrue((boolean)list.isEmpty());
        Assertions.assertTrue((list.size() == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((list.getLast() == null ? 1 : 0) != 0);
        list = new RecyclingArrayList(capacity, Object::new);
        Assertions.assertTrue((boolean)list.isEmpty());
        Assertions.assertTrue((list.size() == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((list.getLast() == null ? 1 : 0) != 0);
    }

    @Test
    public void testAddAndGet() {
        int i;
        Object lastObject;
        int i2;
        RecyclingArrayList list = new RecyclingArrayList(0, Object::new);
        ArrayList<Object> expectedList = new ArrayList<Object>();
        int finalSize = 10;
        for (i2 = 0; i2 < finalSize; ++i2) {
            lastObject = list.add();
            expectedList.add(lastObject);
        }
        Assertions.assertFalse((boolean)list.isEmpty());
        Assertions.assertTrue((list.size() == finalSize ? 1 : 0) != 0);
        for (i2 = 0; i2 < finalSize; ++i2) {
            Assertions.assertTrue((list.get(i2) == expectedList.get(i2) ? 1 : 0) != 0);
        }
        Assertions.assertTrue((list.getLast() == expectedList.get(finalSize - 1) ? 1 : 0) != 0);
        try {
            list.get(finalSize);
            Assertions.fail();
        }
        catch (IndexOutOfBoundsException i3) {
            // empty catch block
        }
        list.clear();
        expectedList.clear();
        Assertions.assertTrue((list.getLast() == null ? 1 : 0) != 0);
        finalSize = 8;
        for (i = 0; i < finalSize; ++i) {
            lastObject = list.add();
            expectedList.add(lastObject);
        }
        Assertions.assertFalse((boolean)list.isEmpty());
        Assertions.assertTrue((list.size() == finalSize ? 1 : 0) != 0);
        for (i = 0; i < finalSize; ++i) {
            Assertions.assertTrue((list.get(i) == expectedList.get(i) ? 1 : 0) != 0);
        }
        Assertions.assertTrue((list.getLast() == expectedList.get(finalSize - 1) ? 1 : 0) != 0);
        list.clear();
        expectedList.clear();
        Assertions.assertTrue((list.getLast() == null ? 1 : 0) != 0);
        finalSize = 20;
        for (i = 0; i < finalSize; ++i) {
            lastObject = list.add();
            expectedList.add(lastObject);
        }
        Assertions.assertFalse((boolean)list.isEmpty());
        Assertions.assertTrue((list.size() == finalSize ? 1 : 0) != 0);
        for (i = 0; i < finalSize; ++i) {
            Assertions.assertTrue((list.get(i) == expectedList.get(i) ? 1 : 0) != 0);
        }
        Assertions.assertTrue((list.getLast() == expectedList.get(finalSize - 1) ? 1 : 0) != 0);
    }

    @Test
    public void testGetAndGrowIfNeeded() {
        int i;
        RecyclingArrayList list = new RecyclingArrayList(0, Object::new);
        Assertions.assertTrue((boolean)list.isEmpty());
        Assertions.assertTrue((list.size() == 0 ? 1 : 0) != 0);
        int newSize = 10;
        Object lastObject = list.getAndGrowIfNeeded(newSize - 1);
        Assertions.assertFalse((boolean)list.isEmpty());
        Assertions.assertTrue((list.size() == newSize ? 1 : 0) != 0);
        for (int i2 = 0; i2 < newSize; ++i2) {
            Assertions.assertTrue((list.get(i2) != null ? 1 : 0) != 0);
            Assertions.assertTrue((boolean)(list.get(i2) instanceof Object));
        }
        Assertions.assertTrue((list.get(newSize - 1) == lastObject ? 1 : 0) != 0);
        Assertions.assertTrue((list.getLast() == lastObject ? 1 : 0) != 0);
        int previousSize = newSize;
        newSize = 3;
        lastObject = list.getAndGrowIfNeeded(newSize - 1);
        Assertions.assertFalse((boolean)list.isEmpty());
        Assertions.assertTrue((list.size() == previousSize ? 1 : 0) != 0);
        for (i = 0; i < newSize; ++i) {
            Assertions.assertTrue((list.get(i) != null ? 1 : 0) != 0);
            Assertions.assertTrue((boolean)(list.get(i) instanceof Object));
        }
        Assertions.assertTrue((list.get(newSize - 1) == lastObject ? 1 : 0) != 0);
        Assertions.assertTrue((list.getLast() == list.get(previousSize - 1) ? 1 : 0) != 0);
        newSize = 13;
        lastObject = list.getAndGrowIfNeeded(newSize - 1);
        Assertions.assertFalse((boolean)list.isEmpty());
        Assertions.assertTrue((list.size() == newSize ? 1 : 0) != 0);
        for (i = 0; i < newSize; ++i) {
            Assertions.assertTrue((list.get(i) != null ? 1 : 0) != 0);
            Assertions.assertTrue((boolean)(list.get(i) instanceof Object));
        }
        Assertions.assertTrue((list.get(newSize - 1) == lastObject ? 1 : 0) != 0);
        Assertions.assertTrue((list.getLast() == lastObject ? 1 : 0) != 0);
    }

    @Test
    public void testFastRemove() {
        int currentSize = 10;
        RecyclingArrayList list = new RecyclingArrayList(currentSize, Object::new);
        for (int i = 0; i < currentSize; ++i) {
            list.add();
        }
        Assertions.assertTrue((list.size() == currentSize ? 1 : 0) != 0);
        ArrayList<Object> savedList = new ArrayList<Object>();
        for (int i = 0; i < currentSize; ++i) {
            savedList.add(list.get(i));
        }
        int indexOfRemovedOject = 3;
        list.fastRemove(indexOfRemovedOject);
        Assertions.assertTrue((list.size() == --currentSize ? 1 : 0) != 0);
        for (int i = 0; i < currentSize; ++i) {
            if (i == indexOfRemovedOject) {
                Assertions.assertTrue((list.get(i) == savedList.get(savedList.size() - 1) ? 1 : 0) != 0);
                continue;
            }
            Assertions.assertTrue((list.get(i) == savedList.get(i) ? 1 : 0) != 0);
        }
        try {
            list.fastRemove(currentSize);
            Assertions.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testRemove() {
        int i;
        int currentSize = 10;
        RecyclingArrayList list = new RecyclingArrayList(currentSize, MutableInt::new);
        for (int i2 = 0; i2 < currentSize; ++i2) {
            ((MutableInt)list.add()).setValue(10 + i2);
        }
        Assertions.assertTrue((list.size() == currentSize ? 1 : 0) != 0);
        ArrayList<Object> expectedList = new ArrayList<Object>();
        for (int i3 = 0; i3 < currentSize; ++i3) {
            expectedList.add(list.get(i3));
        }
        int indexOfRemovedOject = 3;
        list.remove(indexOfRemovedOject);
        expectedList.remove(indexOfRemovedOject);
        Assertions.assertTrue((list.size() == --currentSize ? 1 : 0) != 0);
        for (i = 0; i < currentSize; ++i) {
            Assertions.assertTrue((list.get(i) == expectedList.get(i) ? 1 : 0) != 0);
        }
        indexOfRemovedOject = currentSize - 1;
        list.remove(indexOfRemovedOject);
        expectedList.remove(indexOfRemovedOject);
        Assertions.assertTrue((list.size() == --currentSize ? 1 : 0) != 0);
        for (i = 0; i < currentSize; ++i) {
            Assertions.assertTrue((list.get(i) == expectedList.get(i) ? 1 : 0) != 0);
        }
        try {
            list.remove(currentSize);
            Assertions.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testSwap() {
        Random rand = new Random(541964L);
        int currentSize = 10;
        RecyclingArrayList list = new RecyclingArrayList(currentSize, MutableInt::new);
        for (int i = 0; i < currentSize; ++i) {
            ((MutableInt)list.add()).setValue(10 + i);
        }
        Assertions.assertTrue((list.size() == currentSize ? 1 : 0) != 0);
        ArrayList<Object> expectedList = new ArrayList<Object>();
        for (int i = 0; i < currentSize; ++i) {
            expectedList.add(list.get(i));
        }
        for (int k = 0; k < 20; ++k) {
            int indexA = RandomNumbers.nextInt((Random)rand, (int)0, (int)(currentSize - 1));
            int indexB = RandomNumbers.nextInt((Random)rand, (int)0, (int)(currentSize - 1));
            list.swap(indexA, indexB);
            Collections.swap(expectedList, indexA, indexB);
            Assertions.assertTrue((list.size() == currentSize ? 1 : 0) != 0);
            for (int i = 0; i < currentSize; ++i) {
                Assertions.assertTrue((list.get(i) == expectedList.get(i) ? 1 : 0) != 0);
            }
        }
        try {
            list.swap(0, currentSize);
            Assertions.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            list.swap(currentSize, 0);
            Assertions.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testInsertAtIndex() {
        Random rand = new Random(541964L);
        int currentSize = 10;
        RecyclingArrayList list = new RecyclingArrayList(currentSize, MutableInt::new);
        for (int i = 0; i < currentSize; ++i) {
            ((MutableInt)list.add()).setValue(10 + i);
        }
        Assertions.assertTrue((list.size() == currentSize ? 1 : 0) != 0);
        ArrayList<Object> expectedList = new ArrayList<Object>();
        for (int i = 0; i < currentSize; ++i) {
            expectedList.add(list.get(i));
        }
        for (int k = 0; k < 20; ++k) {
            int randomIndex = RandomNumbers.nextInt((Random)rand, (int)0, (int)currentSize);
            if (k == 5) {
                randomIndex = currentSize;
            }
            int newRandomValue = RandomNumbers.nextInt((Random)rand, (int)0, (int)52161);
            MutableInt newObject = (MutableInt)list.insertAtIndex(randomIndex);
            newObject.setValue(newRandomValue);
            expectedList.add(randomIndex, newObject);
            Assertions.assertTrue((list.size() == ++currentSize ? 1 : 0) != 0);
            for (int i = 0; i < currentSize; ++i) {
                Assertions.assertTrue((list.get(i) == expectedList.get(i) ? 1 : 0) != 0);
            }
        }
        try {
            list.insertAtIndex(currentSize + 1);
            Assertions.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testShuffle() {
        Random random = new Random(541964L);
        int currentSize = 100;
        RecyclingArrayList list = new RecyclingArrayList(currentSize, MutableInt::new);
        for (int i = 0; i < currentSize; ++i) {
            ((MutableInt)list.add()).setValue(10 + i);
        }
        Assertions.assertTrue((list.size() == currentSize ? 1 : 0) != 0);
        int sumBefore = 0;
        for (int i = 0; i < list.size(); ++i) {
            MutableInt value = (MutableInt)list.get(i);
            sumBefore += value.intValue();
        }
        Assertions.assertTrue((sumBefore > 0 ? 1 : 0) != 0);
        list.shuffle(random);
        Assertions.assertTrue((list.size() == currentSize ? 1 : 0) != 0);
        int sumAfter = 0;
        for (int i = 0; i < list.size(); ++i) {
            MutableInt value = (MutableInt)list.get(i);
            sumAfter += value.intValue();
        }
        Assertions.assertEquals((int)sumBefore, (int)sumAfter);
    }

    @Test
    public void testIteratorHasNext() {
        RecyclingArrayList list = new RecyclingArrayList(0, Object::new);
        Assertions.assertFalse((boolean)list.iterator().hasNext());
        int size = 10;
        for (int i = 0; i < size; ++i) {
            list.add();
        }
        Iterator iterator = list.iterator();
        for (int i = 0; i < size; ++i) {
            Assertions.assertTrue((boolean)iterator.hasNext());
            iterator.next();
        }
        Assertions.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testIteratorNext() {
        int size = 15;
        RecyclingArrayList list = new RecyclingArrayList(size, MutableInt::new);
        for (int i = 0; i < size; ++i) {
            ((MutableInt)list.add()).setValue(i);
        }
        Iterator iterator = list.iterator();
        for (int i = 0; i < size; ++i) {
            Assertions.assertTrue((((MutableInt)iterator.next()).getValue() == i ? 1 : 0) != 0);
        }
    }

    @Test
    public void testIteratorRemove() {
        int i;
        int initialSize = 8;
        RecyclingArrayList list = new RecyclingArrayList(initialSize, MutableInt::new);
        for (int i2 = 0; i2 < initialSize; ++i2) {
            ((MutableInt)list.add()).setValue(i2);
        }
        Iterator iterator = list.iterator();
        try {
            iterator.remove();
            Assertions.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assertions.assertTrue((list.size() == initialSize ? 1 : 0) != 0);
        iterator.next();
        iterator.remove();
        Assertions.assertTrue((list.size() == initialSize - 1 ? 1 : 0) != 0);
        for (i = 0; i < initialSize - 1; ++i) {
            Assertions.assertTrue((((MutableInt)list.get(i)).getValue() == i + 1 ? 1 : 0) != 0);
        }
        for (i = 0; i < initialSize - 1; ++i) {
            iterator.next();
            iterator.remove();
            Assertions.assertTrue((list.size() == initialSize - (i + 2) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testIteratorForEachRemaining() {
        int i;
        int initialSize = 10;
        RecyclingArrayList list = new RecyclingArrayList(initialSize, MutableInt::new);
        for (int i2 = 0; i2 < initialSize; ++i2) {
            list.add();
        }
        int testIndex = 5;
        Iterator iterator = list.iterator();
        for (i = 0; i < testIndex; ++i) {
            iterator.next();
        }
        iterator.forEachRemaining(value -> value.setValue(100));
        for (i = 0; i < initialSize; ++i) {
            int value2 = ((MutableInt)list.get(i)).getValue();
            if (i < testIndex) {
                Assertions.assertTrue((value2 == 0 ? 1 : 0) != 0);
                continue;
            }
            Assertions.assertTrue((value2 == 100 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testEmptyConstructor() {
        new RecyclingArrayList();
    }

    @Test
    public void testSort() {
        int i;
        RecyclingArrayList list = new RecyclingArrayList(10, MutableInt::new);
        for (i = 0; i < list.size(); ++i) {
            ((MutableInt)list.get(i)).setValue(i);
        }
        list.shuffle(new Random(239032L));
        list.sort(MutableInt::compareTo);
        for (i = 0; i < list.size(); ++i) {
            Assertions.assertTrue((((MutableInt)list.get(i)).getValue() == i ? 1 : 0) != 0);
        }
    }
}

