/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.wholeBodyHardwareControl;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.util.Precision;
import us.ihmc.affinity.Processor;
import us.ihmc.avatar.AvatarControllerThread;
import us.ihmc.avatar.AvatarEstimatorThread;
import us.ihmc.avatar.AvatarStepGeneratorThread;
import us.ihmc.avatar.ControllerTask;
import us.ihmc.avatar.StepGeneratorTask;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.factory.BarrierScheduledRobotController;
import us.ihmc.avatar.factory.DisposableRobotController;
import us.ihmc.avatar.factory.HumanoidRobotControlTask;
import us.ihmc.avatar.factory.SingleThreadedRobotController;
import us.ihmc.avatar.wholeBodyHardwareControl.AvatarAffinityInterface;
import us.ihmc.avatar.wholeBodyHardwareControl.AvatarLowLevelOutputProcessor;
import us.ihmc.avatar.wholeBodyHardwareControl.HardwareCommunicationInterface;
import us.ihmc.commonWalkingControlModules.barrierScheduler.context.HumanoidRobotContextData;
import us.ihmc.commons.Conversions;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.exception.ExceptionTools;
import us.ihmc.commons.thread.RepeatingTaskThread;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.commons.time.FrequencyCalculator;
import us.ihmc.concurrent.runtime.barrierScheduler.implicitContext.BarrierScheduler;
import us.ihmc.realtime.MonotonicTime;
import us.ihmc.realtime.PeriodicParameters;
import us.ihmc.realtime.RealtimeThread;
import us.ihmc.robotDataLogger.YoVariableServer;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputListReadOnly;
import us.ihmc.tools.TimestampProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoLong;

public class AvatarMultiThreadingManager {
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final YoRegistry rootRegistry;
    private final YoVariableServer yoVariableServer;
    private final YoBoolean isPaused = new YoBoolean("isPaused", this.registry);
    private final double masterThreadDt;
    private final YoLong threadSchedulerComputeTime = new YoLong("threadSchedulerComputeTime", this.registry);
    private final YoDouble masterThreadUpdateRate = new YoDouble("masterThreadUpdateRate", this.registry);
    private final FrequencyCalculator masterThreadFrequencyCalculator = new FrequencyCalculator(false);
    private final YoDouble estimatorThreadUpdateRate = new YoDouble("estimatorThreadUpdateRate", this.registry);
    private final FrequencyCalculator estimatorThreadFrequencyCalculator = new FrequencyCalculator(false);
    private final YoLong estimatorThreadComputeTime = new YoLong("estimatorThreadComputeTime", this.registry);
    private final YoDouble controllerThreadUpdateRate = new YoDouble("controllerThreadUpdateRate", this.registry);
    private final FrequencyCalculator controllerThreadFrequencyCalculator = new FrequencyCalculator(false);
    private final YoDouble stepGeneratorThreadUpdateRate = new YoDouble("stepGeneratorThreadUpdateRate", this.registry);
    private final FrequencyCalculator stepGeneratorThreadFrequencyCalculator = new FrequencyCalculator(false);
    private final DisposableRobotController threadScheduler;
    private final PeriodicParameters periodicParameters;
    private final Runnable masterThread;
    private final List<Runnable> childThreads = new ArrayList<Runnable>();
    private final AvatarEstimatorThread estimatorThread;
    private final List<Runnable> preEstimatorThreadRunnables = new ArrayList<Runnable>();
    private final List<Runnable> postEstimatorThreadRunnables = new ArrayList<Runnable>();
    private ControllerTask controllerTask;
    private StepGeneratorTask stepGeneratorTask;
    private final AvatarAffinityInterface affinity;
    private final HumanoidRobotContextData masterContext;
    private final HardwareCommunicationInterface hardwareCommunicationInterface;
    private final TimestampProvider monotonicTimeProvider;
    private final boolean useRealtimeThreads;
    private final boolean useMultiThreading;
    private final AvatarLowLevelOutputProcessor lowLevelOutputProcessor;
    private volatile boolean running = false;

    public AvatarMultiThreadingManager(String prefix, DRCRobotModel robotModel, HumanoidRobotContextData masterContext, FullHumanoidRobotModel masterFullRobotModel, HardwareCommunicationInterface hardwareCommunicationInterface, AvatarLowLevelOutputProcessor lowLevelOutputProcessor, AvatarEstimatorThread estimatorThread, AvatarControllerThread controllerThread, AvatarStepGeneratorThread stepGeneratorThread, AvatarAffinityInterface affinity, double masterThreadDt, MonotonicTime period, TimestampProvider monotonicTimeProvider, boolean useRealtimeThreads, boolean useMultiThreading, YoVariableServer yoVariableServer, YoRegistry rootRegistry) {
        this.masterContext = masterContext;
        this.hardwareCommunicationInterface = hardwareCommunicationInterface;
        this.lowLevelOutputProcessor = lowLevelOutputProcessor;
        this.estimatorThread = estimatorThread;
        this.affinity = affinity;
        this.masterThreadDt = masterThreadDt;
        this.monotonicTimeProvider = monotonicTimeProvider;
        this.useRealtimeThreads = useRealtimeThreads;
        this.useMultiThreading = useMultiThreading;
        this.rootRegistry = rootRegistry;
        this.yoVariableServer = yoVariableServer;
        ArrayList<HumanoidRobotControlTask> tasks = new ArrayList<HumanoidRobotControlTask>();
        if (controllerThread != null) {
            tasks.add(this.setupControllerTaskAndThread(robotModel, controllerThread, masterFullRobotModel, yoVariableServer));
        }
        if (stepGeneratorThread != null) {
            tasks.add(this.setupStepGeneratorTaskAndThread(robotModel, stepGeneratorThread, masterFullRobotModel, yoVariableServer));
        }
        this.threadScheduler = useMultiThreading ? new BarrierScheduledRobotController(prefix + "ThreadScheduler", tasks, masterContext, BarrierScheduler.TaskOverrunBehavior.SKIP_SCHEDULER_TICK, masterThreadDt) : new SingleThreadedRobotController<HumanoidRobotContextData>(prefix + "ThreadScheduler", tasks, masterContext);
        this.threadScheduler.initialize();
        this.periodicParameters = new PeriodicParameters(period);
        if (useRealtimeThreads) {
            this.masterThread = new RealtimeThread(affinity.getMasterThreadPriority(), this.periodicParameters, this::runRealtime, prefix + "-master-thread");
            ((RealtimeThread)this.masterThread).setAffinity(new Processor[]{affinity.getMasterThreadProcessor()});
        } else {
            this.masterThread = new RepeatingTaskThread(prefix + "-master-thread", this::run, DefaultExceptionHandler.MESSAGE_AND_STACKTRACE);
        }
        hardwareCommunicationInterface.addFaultListener(change -> {
            if (hardwareCommunicationInterface.hasRobotFaulted()) {
                lowLevelOutputProcessor.unservoRobotQuickly();
            }
        });
        hardwareCommunicationInterface.addSoftEStopListener(change -> lowLevelOutputProcessor.unservoRobotQuickly());
        this.registry.addChild(this.threadScheduler.getYoRegistry());
        rootRegistry.addChild(this.registry);
    }

    private HumanoidRobotControlTask setupControllerTaskAndThread(DRCRobotModel robotModel, AvatarControllerThread controllerThread, FullHumanoidRobotModel masterFullRobotModel, YoVariableServer yoVariableServer) {
        int controllerDivisor = (int)Math.round(robotModel.getControllerDT() / this.masterThreadDt);
        if (!Precision.equals((double)(robotModel.getControllerDT() / this.masterThreadDt), (double)controllerDivisor)) {
            throw new RuntimeException("Controller DT must be multiple of master thread DT.");
        }
        this.controllerTask = new ControllerTask("Controller", controllerThread, controllerDivisor, this.masterThreadDt, masterFullRobotModel);
        if (yoVariableServer != null) {
            this.controllerTask.addCallbackPostTask(() -> yoVariableServer.update(controllerThread.getHumanoidRobotContextData().getTimestamp(), controllerThread.getYoVariableRegistry()));
        }
        this.controllerTask.addCallbackPostTask(() -> {
            this.controllerThreadFrequencyCalculator.ping();
            this.controllerThreadUpdateRate.set(this.controllerThreadFrequencyCalculator.getFrequency());
        });
        if (this.useRealtimeThreads && this.useMultiThreading) {
            RealtimeThread controllerRealtimeThread = new RealtimeThread(this.affinity.getControllerThreadPriority(), (Runnable)((Object)this.controllerTask), ((Object)((Object)this.controllerTask)).getClass().getSimpleName() + "Thread");
            controllerRealtimeThread.setAffinity(new Processor[]{this.affinity.getControllerThreadProcessor()});
            controllerRealtimeThread.start();
            this.childThreads.add((Runnable)controllerRealtimeThread);
        } else if (!this.useRealtimeThreads && this.useMultiThreading) {
            Thread controllerNonRealtimeThread = new Thread((Runnable)((Object)this.controllerTask), ((Object)((Object)this.controllerTask)).getClass().getSimpleName() + "Thread");
            controllerNonRealtimeThread.start();
            this.childThreads.add(controllerNonRealtimeThread);
        }
        return this.controllerTask;
    }

    private HumanoidRobotControlTask setupStepGeneratorTaskAndThread(DRCRobotModel robotModel, AvatarStepGeneratorThread stepGeneratorThread, FullHumanoidRobotModel masterFullRobotModel, YoVariableServer yoVariableServer) {
        int stepGeneratorDivisor = (int)Math.round(robotModel.getStepGeneratorDT() / this.masterThreadDt);
        if (!Precision.equals((double)(robotModel.getStepGeneratorDT() / this.masterThreadDt), (double)stepGeneratorDivisor)) {
            throw new RuntimeException("Step generator DT must be multiple of master thread DT.");
        }
        this.stepGeneratorTask = new StepGeneratorTask("StepGenerator", stepGeneratorThread, stepGeneratorDivisor, this.masterThreadDt, masterFullRobotModel);
        if (yoVariableServer != null) {
            this.stepGeneratorTask.addCallbackPostTask(() -> yoVariableServer.update(stepGeneratorThread.getHumanoidRobotContextData().getTimestamp(), stepGeneratorThread.getYoVariableRegistry()));
        }
        this.stepGeneratorTask.addCallbackPostTask(() -> {
            this.stepGeneratorThreadFrequencyCalculator.ping();
            this.stepGeneratorThreadUpdateRate.set(this.stepGeneratorThreadFrequencyCalculator.getFrequency());
        });
        if (this.useRealtimeThreads && this.useMultiThreading) {
            RealtimeThread stepGeneratorRealtimeThread = new RealtimeThread(this.affinity.getStepGeneratorThreadPriority(), (Runnable)((Object)this.stepGeneratorTask), ((Object)((Object)this.stepGeneratorTask)).getClass().getSimpleName() + "Thread");
            stepGeneratorRealtimeThread.setAffinity(new Processor[]{this.affinity.getStepGeneratorThreadProcessor()});
            stepGeneratorRealtimeThread.start();
            this.childThreads.add((Runnable)stepGeneratorRealtimeThread);
        } else if (!this.useRealtimeThreads && this.useMultiThreading) {
            Thread stepGeneratorNonRealtimeThread = new Thread((Runnable)((Object)this.stepGeneratorTask), ((Object)((Object)this.stepGeneratorTask)).getClass().getSimpleName() + "Thread");
            stepGeneratorNonRealtimeThread.start();
            this.childThreads.add(stepGeneratorNonRealtimeThread);
        }
        return this.stepGeneratorTask;
    }

    public void start() {
        if (this.useRealtimeThreads) {
            this.running = true;
            ((RealtimeThread)this.masterThread).start();
        } else {
            ((RepeatingTaskThread)this.masterThread).setFrequencyLimit(Conversions.secondsToHertz((double)this.masterThreadDt));
            ((RepeatingTaskThread)this.masterThread).startRepeating();
        }
    }

    public void join() {
        if (this.useRealtimeThreads) {
            ((RealtimeThread)this.masterThread).join();
        } else {
            ExceptionTools.handle(() -> ((RepeatingTaskThread)this.masterThread).join(), (ExceptionHandler)DefaultExceptionHandler.MESSAGE_AND_STACKTRACE);
        }
    }

    public void stop() {
        this.hardwareCommunicationInterface.stop();
    }

    public void destroy() {
        this.hardwareCommunicationInterface.destroy();
        ThreadTools.sleep((long)500L);
        if (this.yoVariableServer != null) {
            this.yoVariableServer.close();
        }
        this.running = false;
        if (this.useRealtimeThreads) {
            for (int i = 0; i < this.childThreads.size(); ++i) {
                ((RealtimeThread)this.childThreads.get(i)).finalize();
            }
            ((RealtimeThread)this.masterThread).join();
            ((RealtimeThread)this.masterThread).finalize();
        } else {
            for (int i = 0; i < this.childThreads.size(); ++i) {
                ((RepeatingTaskThread)this.childThreads.get(i)).stopRepeating();
            }
            ((RepeatingTaskThread)this.masterThread).stopRepeating();
        }
        ThreadTools.sleep((long)1000L);
        System.out.println("MASTER THREAD SHUTDOWN COMPLETE -- EXITING");
    }

    public void pause() {
        this.isPaused.set(true);
    }

    public void resume() {
        this.isPaused.set(false);
    }

    private void runRealtime() {
        while (this.running) {
            long idleTime = ((RealtimeThread)this.masterThread).waitForNextPeriod();
            if (idleTime <= 0L) continue;
            this.run();
        }
    }

    private void run() {
        if (this.isPaused.getBooleanValue()) {
            return;
        }
        this.masterThreadFrequencyCalculator.ping();
        this.masterThreadUpdateRate.set(this.masterThreadFrequencyCalculator.getFrequency());
        this.hardwareCommunicationInterface.read(this.masterContext.getSensorDataContext());
        if (this.hardwareCommunicationInterface.hasReceivedFirstState()) {
            this.masterContext.setTimestamp(this.monotonicTimeProvider.getTimestamp());
            for (int i = 0; i < this.preEstimatorThreadRunnables.size(); ++i) {
                this.preEstimatorThreadRunnables.get(i).run();
            }
            long estimatorThreadStartTime = System.nanoTime();
            this.estimatorThread.run();
            this.estimatorThreadComputeTime.set(System.nanoTime() - estimatorThreadStartTime);
            this.estimatorThreadFrequencyCalculator.ping();
            this.estimatorThreadUpdateRate.set(this.estimatorThreadFrequencyCalculator.getFrequency());
            for (int i = 0; i < this.postEstimatorThreadRunnables.size(); ++i) {
                this.postEstimatorThreadRunnables.get(i).run();
            }
            long barrierSchedulerStartTime = System.nanoTime();
            this.threadScheduler.doControl();
            this.threadSchedulerComputeTime.set(System.nanoTime() - barrierSchedulerStartTime);
            this.lowLevelOutputProcessor.update((JointDesiredOutputListReadOnly)this.masterContext.getJointDesiredOutputList());
            this.hardwareCommunicationInterface.write(this.lowLevelOutputProcessor.getProcessedDesiredOutput(), this.lowLevelOutputProcessor.getMasterGain().getValue());
        }
        this.updateYoVariableServer();
    }

    public void addPreEstimatorThreadRunnable(Runnable runnable) {
        this.preEstimatorThreadRunnables.add(runnable);
    }

    public void addPostEstimatorThreadRunnable(Runnable runnable) {
        this.postEstimatorThreadRunnables.add(runnable);
    }

    public void addPreControllerThreadRunnable(Runnable runnable) {
        this.controllerTask.addCallbackPreTask(runnable);
    }

    public void addPostControllerThreadRunnable(Runnable runnable) {
        this.controllerTask.addCallbackPostTask(runnable);
    }

    public void addPreStepGeneratorThreadRunnable(Runnable runnable) {
        this.stepGeneratorTask.addCallbackPreTask(runnable);
    }

    public void addPostStepGeneratorThreadRunnable(Runnable runnable) {
        this.stepGeneratorTask.addCallbackPostTask(runnable);
    }

    private void updateYoVariableServer() {
        if (this.yoVariableServer == null) {
            return;
        }
        this.yoVariableServer.update(this.monotonicTimeProvider.getTimestamp(), this.rootRegistry);
    }
}

