/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.wholeBodyHardwareControl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.function.Consumer;
import us.ihmc.avatar.AvatarControllerThread;
import us.ihmc.avatar.AvatarEstimatorThread;
import us.ihmc.avatar.AvatarEstimatorThreadFactory;
import us.ihmc.avatar.AvatarStepGeneratorThread;
import us.ihmc.avatar.HumanoidSteppingPluginEnvironmentalConstraints;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.wholeBodyHardwareControl.AvatarAffinityInterface;
import us.ihmc.avatar.wholeBodyHardwareControl.AvatarLowLevelOutputProcessor;
import us.ihmc.avatar.wholeBodyHardwareControl.AvatarMultiThreadingManager;
import us.ihmc.avatar.wholeBodyHardwareControl.HardwareCommunicationInterface;
import us.ihmc.commonWalkingControlModules.barrierScheduler.context.HumanoidRobotContextDataFactory;
import us.ihmc.commonWalkingControlModules.configurations.HighLevelControllerParameters;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commonWalkingControlModules.controllers.Updatable;
import us.ihmc.commonWalkingControlModules.desiredFootStep.footstepGenerator.FootstepValidityIndicator;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning.CoPTrajectoryParameters;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.HighLevelControllerFactoryHelper;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.ContactableBodiesFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.ControllerStateTransitionFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.HighLevelControllerStateFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.HighLevelHumanoidControllerFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.plugin.HighLevelHumanoidControllerPluginFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.plugin.HumanoidSteppingPluginFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.plugin.JoystickBasedSteppingPluginFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.stateTransitions.FeetLoadedToWalkingStandTransition;
import us.ihmc.commonWalkingControlModules.momentumBasedController.HighLevelHumanoidControllerToolbox;
import us.ihmc.communication.controllerAPI.CommandInputManager;
import us.ihmc.communication.controllerAPI.command.Command;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.HighLevelControllerStateCommand;
import us.ihmc.humanoidRobotics.communication.packets.dataobjects.HighLevelControllerName;
import us.ihmc.humanoidRobotics.communication.packets.sensing.StateEstimatorMode;
import us.ihmc.log.LogTools;
import us.ihmc.realtime.MonotonicTime;
import us.ihmc.realtime.PriorityParameters;
import us.ihmc.robotDataLogger.YoVariableServer;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.robotics.sensors.ForceSensorDataHolderReadOnly;
import us.ihmc.robotics.stateMachine.core.State;
import us.ihmc.robotics.stateMachine.core.StateTransition;
import us.ihmc.robotics.stateMachine.core.StateTransitionCondition;
import us.ihmc.ros2.ROS2NodeBuilder;
import us.ihmc.ros2.RealtimeROS2Node;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicGroupDefinition;
import us.ihmc.sensorProcessing.parameters.HumanoidRobotSensorInformation;
import us.ihmc.sensorProcessing.simulatedSensors.SensorReaderFactory;
import us.ihmc.stateEstimation.humanoid.StateEstimatorController;
import us.ihmc.tools.TimestampProvider;
import us.ihmc.tools.factories.RequiredFactoryField;
import us.ihmc.util.PeriodicNonRealtimeThreadSchedulerFactory;
import us.ihmc.util.PeriodicRealtimeThreadSchedulerFactory;
import us.ihmc.util.PeriodicThreadSchedulerFactory;
import us.ihmc.wholeBodyController.RobotContactPointParameters;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoEnum;

public class AvatarMultiThreadingFactory {
    private static final double GRAVITY = -9.81;
    public static final boolean RUN_AUTO_DIAGNOSTIC = false;
    private static final int ROS2_PRIORITY = 25;
    private final YoRegistry rootRegistry;
    private final DRCRobotModel robotModel;
    private final HardwareCommunicationInterface hardwareCommunicationInterface;
    public final String IHMC_ROS_STATE_ESTIMATOR_NODE_NAME;
    public final String IHMC_ROS_CONTROLLER_NODE_NAME;
    private final RealtimeROS2Node estimatorRealtimeROS2Node;
    private final RealtimeROS2Node controllerRealtimeROS2Node;
    private final AvatarEstimatorThreadFactory estimatorThreadFactory;
    private final HighLevelHumanoidControllerFactory controllerFactory;
    private final RequiredFactoryField<AvatarEstimatorThread> estimatorThread = new RequiredFactoryField("AvatarEstimatorThread");
    private final RequiredFactoryField<AvatarControllerThread> controllerThread = new RequiredFactoryField("AvatarControllerThread");
    private final RequiredFactoryField<AvatarStepGeneratorThread> stepGeneratorThread = new RequiredFactoryField("AvatarStepGeneratorThread");
    private final RequiredFactoryField<AvatarMultiThreadingManager> threadingManager = new RequiredFactoryField("AvatarMultiThreadingManager");
    private final AvatarLowLevelOutputProcessor lowLevelOutputProcessor;
    private final MonotonicTime period;
    private final double masterThreadDt;
    private final TimestampProvider monotonicTimeProvider;
    private final AvatarAffinityInterface affinity;
    private final boolean createStepGeneratorThread;
    private final boolean createIKStreamingThread;
    private final boolean useRealtimeThreads;
    private final boolean useMultiThreading;
    private final YoVariableServer yoVariableServer;

    public AvatarMultiThreadingFactory(DRCRobotModel robotModel, FullHumanoidRobotModel fullRobotModel, HardwareCommunicationInterface hardwareCommunicationInterface, SensorReaderFactory sensorReaderFactory, HighLevelControllerStateFactory standPrepStateFactory, HighLevelControllerStateFactory freezeStateFactory, AvatarAffinityInterface affinity, boolean createStepGeneratorThread, boolean createIKStreamingThread, boolean useRealtimeThreads, boolean useMultiThreading, MonotonicTime period, double masterThreadDt, TimestampProvider monotonicTimeProvider, YoRegistry registry, YoVariableServer yoVariableServer) {
        this.robotModel = robotModel;
        this.period = period;
        this.masterThreadDt = masterThreadDt;
        this.monotonicTimeProvider = monotonicTimeProvider;
        this.hardwareCommunicationInterface = hardwareCommunicationInterface;
        this.affinity = affinity;
        this.createStepGeneratorThread = createStepGeneratorThread;
        this.createIKStreamingThread = createIKStreamingThread;
        this.useRealtimeThreads = useRealtimeThreads;
        this.useMultiThreading = useMultiThreading;
        this.rootRegistry = registry;
        this.yoVariableServer = yoVariableServer;
        this.IHMC_ROS_STATE_ESTIMATOR_NODE_NAME = robotModel.getSimpleRobotName().toLowerCase() + "_ihmc_state_estimator";
        this.IHMC_ROS_CONTROLLER_NODE_NAME = robotModel.getSimpleRobotName().toLowerCase() + "_humanoid_control";
        Object ros2ThreadFactory = useRealtimeThreads ? new PeriodicRealtimeThreadSchedulerFactory(new PriorityParameters(25)) : new PeriodicNonRealtimeThreadSchedulerFactory();
        this.estimatorRealtimeROS2Node = new ROS2NodeBuilder().buildRealtime(this.IHMC_ROS_STATE_ESTIMATOR_NODE_NAME, (PeriodicThreadSchedulerFactory)ros2ThreadFactory);
        this.controllerRealtimeROS2Node = new ROS2NodeBuilder().buildRealtime(this.IHMC_ROS_CONTROLLER_NODE_NAME, (PeriodicThreadSchedulerFactory)ros2ThreadFactory);
        this.lowLevelOutputProcessor = new AvatarLowLevelOutputProcessor(robotModel.getSimpleRobotName().toLowerCase(), fullRobotModel.getControllableOneDoFJoints(), masterThreadDt, registry);
        this.estimatorThreadFactory = this.createStateEstimatorFactory(robotModel, fullRobotModel, sensorReaderFactory);
        this.controllerFactory = this.createHighLevelControllerFactory(robotModel, this.controllerRealtimeROS2Node, this.lowLevelOutputProcessor, standPrepStateFactory, freezeStateFactory);
    }

    public void start() {
        this.estimatorRealtimeROS2Node.spin();
        this.controllerRealtimeROS2Node.spin();
        this.hardwareCommunicationInterface.start();
        ((AvatarMultiThreadingManager)this.threadingManager.get()).start();
    }

    public void join() {
        ((AvatarMultiThreadingManager)this.threadingManager.get()).join();
    }

    public void stop() {
        System.out.println("Calling stop in the multi-threading factory");
        this.estimatorRealtimeROS2Node.stopSpinning();
        this.controllerRealtimeROS2Node.stopSpinning();
        this.hardwareCommunicationInterface.stop();
        ((AvatarMultiThreadingManager)this.threadingManager.get()).stop();
    }

    public void destroy() {
        this.stop();
        System.out.println("Calling destroy in the multi-threading factory");
        this.estimatorRealtimeROS2Node.destroy();
        System.out.println("Estimator node has been destroyed");
        this.controllerRealtimeROS2Node.destroy();
        System.out.println("Controller node has been destroyed");
        this.hardwareCommunicationInterface.destroy();
        System.out.println("Hardware communication node has been destroyed");
        ((AvatarMultiThreadingManager)this.threadingManager.get()).destroy();
    }

    public AvatarMultiThreadingManager buildThreadsAndThreadingManager() {
        this.estimatorThread.set((Object)this.estimatorThreadFactory.createAvatarEstimatorThread());
        HashMap<HighLevelControllerName, StateEstimatorMode> stateModeMap = new HashMap<HighLevelControllerName, StateEstimatorMode>();
        Arrays.stream(HighLevelControllerName.values).forEach(name -> stateModeMap.put((HighLevelControllerName)name, StateEstimatorMode.FROZEN));
        stateModeMap.put(HighLevelControllerName.STAND_TRANSITION_STATE, StateEstimatorMode.NORMAL);
        stateModeMap.put(HighLevelControllerName.EXIT_WALKING, StateEstimatorMode.NORMAL);
        stateModeMap.put(HighLevelControllerName.WALKING, StateEstimatorMode.NORMAL);
        ((AvatarEstimatorThread)((Object)this.estimatorThread.get())).setupHighLevelControllerCallback(this.controllerFactory, stateModeMap);
        HumanoidRobotContextDataFactory controllerContextFactory = new HumanoidRobotContextDataFactory();
        this.controllerThread.set((Object)new AvatarControllerThread(this.robotModel.getSimpleRobotName().toLowerCase(), this.robotModel, null, this.robotModel.getSensorInformation(), this.controllerFactory, controllerContextFactory, null, this.controllerRealtimeROS2Node, -9.81, false));
        this.stepGeneratorThread.set((Object)this.createStepGeneratorThread(this.robotModel, (AvatarControllerThread)this.controllerThread.get(), controllerContextFactory, this.controllerFactory));
        this.rootRegistry.addChild(((AvatarEstimatorThread)((Object)this.estimatorThread.get())).getYoRegistry());
        this.yoVariableServer.setMainRegistry(this.rootRegistry, ((AvatarEstimatorThread)((Object)this.estimatorThread.get())).getFullRobotModel().getRootJoint().subtreeList(), ((AvatarEstimatorThread)((Object)this.estimatorThread.get())).getSCS1YoGraphicsListRegistry());
        this.yoVariableServer.addRegistry(((AvatarControllerThread)this.controllerThread.get()).getYoVariableRegistry(), ((AvatarControllerThread)this.controllerThread.get()).getSCS1YoGraphicsListRegistry());
        if (this.createStepGeneratorThread) {
            this.yoVariableServer.addRegistry(((AvatarStepGeneratorThread)this.stepGeneratorThread.get()).getYoVariableRegistry(), ((AvatarStepGeneratorThread)this.stepGeneratorThread.get()).getSCS1YoGraphicsListRegistry());
        }
        this.threadingManager.set((Object)new AvatarMultiThreadingManager(this.robotModel.getSimpleRobotName().toLowerCase(), this.robotModel, ((AvatarEstimatorThread)((Object)this.estimatorThread.get())).getHumanoidRobotContextData(), ((AvatarEstimatorThread)((Object)this.estimatorThread.get())).getFullRobotModel(), this.hardwareCommunicationInterface, this.lowLevelOutputProcessor, (AvatarEstimatorThread)((Object)this.estimatorThread.get()), (AvatarControllerThread)this.controllerThread.get(), (AvatarStepGeneratorThread)this.stepGeneratorThread.get(), this.affinity, this.masterThreadDt, this.period, this.monotonicTimeProvider, this.useRealtimeThreads, this.useMultiThreading, this.yoVariableServer, this.rootRegistry));
        return (AvatarMultiThreadingManager)this.threadingManager.get();
    }

    private AvatarEstimatorThreadFactory createStateEstimatorFactory(DRCRobotModel robotModel, FullHumanoidRobotModel fullRobotModel, SensorReaderFactory sensorReaderFactory) {
        LogTools.info((String)"The Squirrel estimates the number of acorns he needs for winter. Not many in Florida he thinks");
        HumanoidRobotContextDataFactory estimatorContextDataFactory = new HumanoidRobotContextDataFactory();
        AvatarEstimatorThreadFactory avatarEstimatorThreadFactory = new AvatarEstimatorThreadFactory();
        avatarEstimatorThreadFactory.setROS2Info(this.estimatorRealtimeROS2Node, robotModel.getSimpleRobotName());
        avatarEstimatorThreadFactory.configureWithWholeBodyControllerParameters(robotModel);
        avatarEstimatorThreadFactory.setEstimatorFullRobotModel(fullRobotModel);
        avatarEstimatorThreadFactory.setSensorReaderFactory(sensorReaderFactory);
        avatarEstimatorThreadFactory.setHumanoidRobotContextDataFactory(estimatorContextDataFactory);
        avatarEstimatorThreadFactory.setGravity(-9.81);
        StateEstimatorController stateEstimator = avatarEstimatorThreadFactory.getMainStateEstimator();
        return avatarEstimatorThreadFactory;
    }

    private HighLevelHumanoidControllerFactory createHighLevelControllerFactory(DRCRobotModel robotModel, RealtimeROS2Node ros2Node, AvatarLowLevelOutputProcessor lowLevelOutputProcessor, HighLevelControllerStateFactory standPrepStateFactory, HighLevelControllerStateFactory freezeStateFactory) {
        HumanoidRobotSensorInformation sensorInformation = robotModel.getSensorInformation();
        RobotContactPointParameters contactPointParameters = robotModel.getContactPointParameters();
        ArrayList additionalContactRigidBodyNames = contactPointParameters.getAdditionalContactRigidBodyNames();
        ArrayList additionalContactNames = contactPointParameters.getAdditionalContactNames();
        ArrayList additionalContactTransforms = contactPointParameters.getAdditionalContactTransforms();
        ContactableBodiesFactory contactableBodiesFactory = new ContactableBodiesFactory();
        contactableBodiesFactory.setFootContactPoints(contactPointParameters.getFootContactPoints());
        contactableBodiesFactory.setToeContactParameters(contactPointParameters.getControllerToeContactPoints(), contactPointParameters.getControllerToeContactLines());
        for (int i = 0; i < contactPointParameters.getAdditionalContactNames().size(); ++i) {
            contactableBodiesFactory.addAdditionalContactPoint((String)additionalContactRigidBodyNames.get(i), (String)additionalContactNames.get(i), (RigidBodyTransform)additionalContactTransforms.get(i));
        }
        WalkingControllerParameters walkingControllerParameters = robotModel.getWalkingControllerParameters();
        HighLevelControllerParameters highLevelControllerParameters = robotModel.getHighLevelControllerParameters();
        CoPTrajectoryParameters copTrajectoryParameters = robotModel.getCoPTrajectoryParameters();
        SideDependentList feetForceSensorNames = sensorInformation.getFeetForceSensorNames();
        SideDependentList wristForceSensorNames = sensorInformation.getWristForceSensorNames();
        HighLevelHumanoidControllerFactory controllerFactory = new HighLevelHumanoidControllerFactory(contactableBodiesFactory, feetForceSensorNames, wristForceSensorNames, highLevelControllerParameters, walkingControllerParameters, copTrajectoryParameters, robotModel.getSplitFractionCalculatorParameters());
        controllerFactory.createControllerNetworkSubscriber(robotModel.getSimpleRobotName(), ros2Node);
        controllerFactory.setInitialState(highLevelControllerParameters.getDefaultInitialControllerState());
        controllerFactory.addCustomControlState(standPrepStateFactory);
        controllerFactory.addCustomControlState(freezeStateFactory);
        controllerFactory.useDefaultStandTransitionControlState(HighLevelControllerName.STAND_PREP_STATE, HighLevelControllerName.WALKING);
        controllerFactory.useDefaultWalkingControlState();
        controllerFactory.useDefaultDoNothingControlState();
        controllerFactory.useDefaultExitWalkingTransitionControlState(HighLevelControllerName.STAND_PREP_STATE);
        HighLevelControllerName fallbackControllerState = highLevelControllerParameters.getFallbackControllerState();
        controllerFactory.addRequestableTransition(HighLevelControllerName.STAND_PREP_STATE, HighLevelControllerName.STAND_TRANSITION_STATE);
        controllerFactory.addRequestableTransition(HighLevelControllerName.STAND_TRANSITION_STATE, HighLevelControllerName.STAND_PREP_STATE);
        controllerFactory.addRequestableTransition(HighLevelControllerName.FREEZE_STATE, HighLevelControllerName.STAND_PREP_STATE);
        controllerFactory.addRequestableTransition(HighLevelControllerName.WALKING, HighLevelControllerName.EXIT_WALKING);
        for (HighLevelControllerName highLevelControllerName : HighLevelControllerName.values) {
            if (highLevelControllerName == HighLevelControllerName.FREEZE_STATE) continue;
            controllerFactory.addRequestableTransition(highLevelControllerName, HighLevelControllerName.FREEZE_STATE);
            controllerFactory.addControllerFailureTransition(highLevelControllerName, fallbackControllerState);
        }
        for (HighLevelControllerName highLevelControllerName : HighLevelControllerName.values) {
            if (highLevelControllerName == HighLevelControllerName.DO_NOTHING_BEHAVIOR) continue;
            controllerFactory.addRequestableTransition(highLevelControllerName, HighLevelControllerName.DO_NOTHING_BEHAVIOR);
        }
        controllerFactory.addFinishedTransition(HighLevelControllerName.STAND_TRANSITION_STATE, HighLevelControllerName.WALKING, false);
        controllerFactory.addFinishedTransition(HighLevelControllerName.EXIT_WALKING, HighLevelControllerName.FREEZE_STATE);
        controllerFactory.addCustomStateTransition(AvatarMultiThreadingFactory.createStandTransitionState(controllerFactory, (SideDependentList<String>)feetForceSensorNames));
        HighLevelControllerStateCommand transitionToDoNothingCommand = new HighLevelControllerStateCommand();
        CommandInputManager controllerCommandInputManager = controllerFactory.getCommandInputManager();
        this.hardwareCommunicationInterface.addFaultListener(change -> {
            if (this.hardwareCommunicationInterface.hasRobotFaulted()) {
                transitionToDoNothingCommand.setHighLevelControllerName(HighLevelControllerName.DO_NOTHING_BEHAVIOR);
                controllerCommandInputManager.submitCommand((Command)transitionToDoNothingCommand);
            }
        });
        controllerFactory.setListenToHighLevelStatePackets(true);
        return controllerFactory;
    }

    private AvatarStepGeneratorThread createStepGeneratorThread(DRCRobotModel robotModel, AvatarControllerThread controllerThread, HumanoidRobotContextDataFactory controllerContextFactory, HighLevelHumanoidControllerFactory controllerFactory) {
        AvatarStepGeneratorThread stepGeneratorThread = null;
        YoGraphicsListRegistry stepGeneratorGraphics = null;
        LogTools.info((String)("create step generator = " + this.createStepGeneratorThread));
        HumanoidSteppingPluginEnvironmentalConstraints environmentalConstraints = new HumanoidSteppingPluginEnvironmentalConstraints((RobotContactPointParameters<RobotSide>)robotModel.getContactPointParameters(), robotModel.getWalkingControllerParameters().getSteppingParameters(), robotModel.getSteppingEnvironmentalConstraintParameters());
        controllerFactory.setListenToHighLevelStatePackets(true);
        JoystickBasedSteppingPluginFactory pluginFactory = new JoystickBasedSteppingPluginFactory();
        if (this.createStepGeneratorThread) {
            stepGeneratorGraphics = new YoGraphicsListRegistry();
            stepGeneratorThread = new AvatarStepGeneratorThread((HumanoidSteppingPluginFactory)pluginFactory, controllerContextFactory, controllerFactory.getStatusOutputManager(), controllerFactory.getCommandInputManager(), robotModel, environmentalConstraints, this.controllerRealtimeROS2Node);
        } else {
            pluginFactory.addPlanarRegionsListCommandConsumer((Consumer)environmentalConstraints);
            pluginFactory.setFootStepPlanAdjustment(environmentalConstraints.getFootstepPlanAdjustment());
            for (FootstepValidityIndicator footstepValidityIndicator : environmentalConstraints.getFootstepValidityIndicators()) {
                pluginFactory.addFootstepValidityIndicator(footstepValidityIndicator);
            }
            pluginFactory.addUpdatable((Updatable)environmentalConstraints);
            pluginFactory.createStepGeneratorNetworkSubscriber(robotModel.getSimpleRobotName().toLowerCase(), this.controllerRealtimeROS2Node);
            controllerFactory.addControllerPlugin((HighLevelHumanoidControllerPluginFactory)pluginFactory);
            controllerThread.getYoVariableRegistry().addChild(environmentalConstraints.getRegistry());
            ArrayList artifactLists = new ArrayList();
            environmentalConstraints.getGraphicsListRegistry().getRegisteredArtifactLists(artifactLists);
            controllerThread.getSCS1YoGraphicsListRegistry().registerYoGraphicsLists(environmentalConstraints.getGraphicsListRegistry().getYoGraphicsLists());
            controllerThread.getSCS1YoGraphicsListRegistry().registerArtifactLists(artifactLists);
        }
        return stepGeneratorThread;
    }

    private static ControllerStateTransitionFactory<HighLevelControllerName> createStandTransitionState(final HighLevelHumanoidControllerFactory controllerFactory, final SideDependentList<String> feetForceSensorNames) {
        return new ControllerStateTransitionFactory<HighLevelControllerName>(){

            public HighLevelControllerName getStateToAttachEnum() {
                return HighLevelControllerName.STAND_PREP_STATE;
            }

            public StateTransition<HighLevelControllerName> getOrCreateStateTransition(EnumMap<HighLevelControllerName, ? extends State> stateMap, HighLevelControllerFactoryHelper controllerFactoryHelper, YoRegistry parentRegistry) {
                HighLevelHumanoidControllerToolbox controllerToolbox = controllerFactory.getHighLevelHumanoidControllerToolbox();
                double totalMass = controllerToolbox.getFullRobotModel().getTotalMass();
                double gravityZ = controllerToolbox.getGravityZ();
                double controlDT = controllerToolbox.getControlDT();
                YoEnum requestedState = controllerFactory.getRequestedControlStateEnum();
                ForceSensorDataHolderReadOnly forceSensorDataHolder = controllerFactoryHelper.getForceSensorDataHolder();
                HighLevelControllerParameters highLevelControllerParameters = controllerFactoryHelper.getHighLevelControllerParameters();
                FeetLoadedToWalkingStandTransition feetLoadedTransition = new FeetLoadedToWalkingStandTransition(HighLevelControllerName.STAND_TRANSITION_STATE, requestedState, forceSensorDataHolder, feetForceSensorNames, controlDT, totalMass, gravityZ, highLevelControllerParameters, parentRegistry);
                final State standPrepState = stateMap.get(HighLevelControllerName.STAND_PREP_STATE);
                StateTransitionCondition condition = new StateTransitionCondition(){
                    final /* synthetic */ StateTransitionCondition val$feetLoadedTransition;
                    {
                        this.val$feetLoadedTransition = stateTransitionCondition;
                    }

                    public boolean testCondition(double timeInCurrentState) {
                        if (!standPrepState.isDone(timeInCurrentState)) {
                            return false;
                        }
                        return this.val$feetLoadedTransition.testCondition(timeInCurrentState);
                    }

                    public boolean performOnEntry() {
                        return true;
                    }
                };
                return new StateTransition((Enum)HighLevelControllerName.STAND_TRANSITION_STATE, condition);
            }
        };
    }

    public void addCustomControlState(HighLevelControllerStateFactory customControllerStateFactory) {
        this.controllerFactory.addCustomControlState(customControllerStateFactory);
    }

    public void addRequestableTransition(HighLevelControllerName currentControlStateEnum, HighLevelControllerName nextControlStateEnum) {
        this.controllerFactory.addRequestableTransition(currentControlStateEnum, nextControlStateEnum);
    }

    public YoRegistry getEstimatorRegistry() {
        return ((AvatarEstimatorThread)((Object)this.estimatorThread.get())).getYoRegistry();
    }

    public YoGraphicGroupDefinition getEstimatorYoGraphics() {
        return ((AvatarEstimatorThread)((Object)this.estimatorThread.get())).getSCS2YoGraphics();
    }

    public YoRegistry getControllerRegistry() {
        return ((AvatarControllerThread)this.controllerThread.get()).getYoVariableRegistry();
    }

    public YoGraphicGroupDefinition getControllerYoGraphics() {
        return ((AvatarControllerThread)this.controllerThread.get()).getSCS2YoGraphics();
    }

    public YoRegistry getStepGeneratorRegistry() {
        return ((AvatarStepGeneratorThread)this.stepGeneratorThread.get()).getYoVariableRegistry();
    }

    public YoGraphicGroupDefinition getStepGeneratorYoGraphics() {
        return ((AvatarStepGeneratorThread)this.stepGeneratorThread.get()).getSCS2YoGraphics();
    }

    public AvatarMultiThreadingManager getThreadingManager() {
        return (AvatarMultiThreadingManager)this.threadingManager.get();
    }
}

