/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.wholeBodyHardwareControl;

import us.ihmc.commonWalkingControlModules.controllerCore.command.lowLevel.YoLowLevelOneDoFJointDesiredDataHolder;
import us.ihmc.commons.InterpolationTools;
import us.ihmc.commons.MathTools;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputListReadOnly;
import us.ihmc.yoVariables.listener.YoVariableChangedListener;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class AvatarLowLevelOutputProcessor {
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private static final double DEFAULT_SERVO_DURATION = 5.0;
    private static final double LOW_MASTER_GAIN = 0.0;
    private static final double HIGH_MASTER_GAIN = 1.0;
    private final double updateDt;
    private final YoBoolean servo = new YoBoolean("servoRobot", this.registry);
    private final YoBoolean unservoQuickly = new YoBoolean("unservoQuickly", this.registry);
    private final YoBoolean isServoing = new YoBoolean("isServoing", this.registry);
    private final YoBoolean isUnservoing = new YoBoolean("isUnservoing", this.registry);
    private final YoBoolean isServod = new YoBoolean("isRobotServod", this.registry);
    private final YoDouble servoDuration = new YoDouble("servoDuration", this.registry);
    private final YoDouble servoTime = new YoDouble("servoTime", this.registry);
    private final YoDouble masterGain = new YoDouble("masterGain", this.registry);
    private final YoLowLevelOneDoFJointDesiredDataHolder unprocessedDesireds;
    private final YoLowLevelOneDoFJointDesiredDataHolder processedDesireds;
    private double servoStartGain = 0.0;
    private double unservoStartGain = 0.0;

    public AvatarLowLevelOutputProcessor(String robotName, OneDoFJointBasics[] controlledJoints, double updateDt, YoRegistry parentRegistry) {
        this.updateDt = updateDt;
        this.unprocessedDesireds = new YoLowLevelOneDoFJointDesiredDataHolder(robotName, (OneDoFJointReadOnly[])controlledJoints, this.registry);
        this.processedDesireds = new YoLowLevelOneDoFJointDesiredDataHolder(robotName + "Processed", (OneDoFJointReadOnly[])controlledJoints, this.registry);
        this.servoDuration.set(5.0);
        this.addServoListener(change -> {
            if (this.servo.getBooleanValue()) {
                this.servoStartGain = this.masterGain.getDoubleValue();
                this.servoTime.set(0.0);
                this.isServoing.set(true);
                this.isUnservoing.set(false);
            } else {
                this.unservoStartGain = this.masterGain.getDoubleValue();
                this.servoTime.set(0.0);
                this.isUnservoing.set(true);
                this.isServoing.set(false);
            }
        });
        this.unservoQuickly.addListener(change -> {
            if (this.unservoQuickly.getBooleanValue()) {
                this.servo.set(false);
                this.isServoing.set(false);
                this.isUnservoing.set(false);
                this.masterGain.set(0.0);
                this.unservoQuickly.set(false, false);
            }
        });
        parentRegistry.addChild(this.registry);
    }

    public void update(JointDesiredOutputListReadOnly unprocessedDesireds) {
        this.unprocessedDesireds.overwriteWith(unprocessedDesireds);
        this.processedDesireds.overwriteWith(unprocessedDesireds);
        if (this.isServoing.getBooleanValue()) {
            this.computeMasterGainForServo();
        }
        if (this.isUnservoing.getBooleanValue()) {
            this.computeMasterGainForUnservo();
        }
        for (int i = 0; i < this.processedDesireds.getNumberOfJointsWithDesiredOutput(); ++i) {
            this.processedDesireds.getJointDesiredOutput(i).setMasterGain(this.masterGain.getDoubleValue());
        }
    }

    private void computeMasterGainForServo() {
        if (this.servoTime.getDoubleValue() < this.servoDuration.getDoubleValue()) {
            this.servoTime.add(this.updateDt);
            this.masterGain.set(AvatarLowLevelOutputProcessor.computeMasterGain(this.servoTime.getDoubleValue(), this.servoDuration.getDoubleValue(), this.servoStartGain, 1.0));
        } else {
            this.isServod.set(true);
            this.isServoing.set(false);
            this.servoTime.set(0.0);
        }
    }

    private void computeMasterGainForUnservo() {
        if (this.servoTime.getDoubleValue() < this.servoDuration.getDoubleValue()) {
            this.servoTime.add(this.updateDt);
            this.masterGain.set(AvatarLowLevelOutputProcessor.computeMasterGain(this.servoTime.getDoubleValue(), this.servoDuration.getDoubleValue(), this.unservoStartGain, 0.0));
        } else {
            this.isServod.set(false);
            this.isUnservoing.set(false);
            this.servoTime.set(0.0);
        }
    }

    public void servoRobot() {
        this.servo.set(true);
    }

    public void unservoRobot() {
        this.servo.set(false);
    }

    public void unservoRobotQuickly() {
        this.unservoQuickly.set(true);
    }

    public void addServoListener(YoVariableChangedListener listener) {
        this.servo.addListener(listener);
    }

    private static double computeMasterGain(double servoTime, double servoDuration, double startGain, double endGain) {
        double alpha = servoTime / servoDuration;
        double masterGain = InterpolationTools.linearInterpolate((double)startGain, (double)endGain, (double)alpha);
        return MathTools.clamp((double)masterGain, (double)0.0, (double)1.0);
    }

    public JointDesiredOutputListReadOnly getProcessedDesiredOutput() {
        return this.processedDesireds;
    }

    public DoubleProvider getMasterGain() {
        return this.masterGain;
    }
}

