/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.warmup;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.avatar.AvatarControllerThread;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commonWalkingControlModules.controlModules.foot.FootControlModule;
import us.ihmc.commonWalkingControlModules.controlModules.pelvis.PelvisHeightControlState;
import us.ihmc.commonWalkingControlModules.controllerCore.command.lowLevel.RootJointDesiredConfigurationDataReadOnly;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning.CoPTrajectoryParameters;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.ContactableBodiesFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.ControllerAPIDefinition;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.HighLevelControlManagerFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.WholeBodyControllerCoreFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.WalkingControllerState;
import us.ihmc.commonWalkingControlModules.messageHandlers.WalkingMessageHandler;
import us.ihmc.commonWalkingControlModules.momentumBasedController.HighLevelHumanoidControllerToolbox;
import us.ihmc.commonWalkingControlModules.sensors.footSwitch.KinematicsBasedFootSwitch;
import us.ihmc.communication.controllerAPI.CommandConversionInterface;
import us.ihmc.communication.controllerAPI.CommandInputManager;
import us.ihmc.communication.controllerAPI.StatusMessageOutputManager;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.humanoidRobotics.bipedSupportPolygons.ContactableFoot;
import us.ihmc.humanoidRobotics.communication.controllerAPI.converter.FrameMessageCommandConverter;
import us.ihmc.humanoidRobotics.frames.HumanoidReferenceFrames;
import us.ihmc.humanoidRobotics.model.CenterOfMassStateProvider;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullLeggedRobotModel;
import us.ihmc.robotModels.FullRobotModel;
import us.ihmc.robotics.MultiBodySystemMissingTools;
import us.ihmc.robotics.contactable.ContactablePlaneBody;
import us.ihmc.robotics.geometry.RotationTools;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.robotics.sensors.FootSwitchInterface;
import us.ihmc.sensorProcessing.frames.CommonHumanoidReferenceFrames;
import us.ihmc.sensorProcessing.frames.CommonLeggedReferenceFrames;
import us.ihmc.sensorProcessing.frames.ReferenceFrameHashCodeResolver;
import us.ihmc.sensorProcessing.frames.ReferenceFrames;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputReadOnly;
import us.ihmc.wholeBodyController.RobotContactPointParameters;
import us.ihmc.wholeBodyController.parameters.ParameterLoaderHelper;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;
import us.ihmc.yoVariables.variable.YoVariable;

public abstract class HumanoidControllerWarmup {
    private static final double gravityZ = 9.81;
    private static final double velocityDecay = 0.98;
    private final DRCRobotModel robotModel;
    private final double controlDT;
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final YoGraphicsListRegistry yoGraphicsListRegistry = new YoGraphicsListRegistry();
    private final YoDouble yoTime = new YoDouble("time", this.registry);
    private final StatusMessageOutputManager statusOutputManager = new StatusMessageOutputManager(ControllerAPIDefinition.getControllerSupportedStatusMessages());
    private final CommandInputManager commandInputManager = new CommandInputManager(ControllerAPIDefinition.getControllerSupportedCommands());
    private final List<ContactablePlaneBody> contactableBodies = new ArrayList<ContactablePlaneBody>();
    private final SideDependentList<YoEnum<FootControlModule.ConstraintType>> footStates = new SideDependentList();
    private FullHumanoidRobotModel fullRobotModel;
    private CenterOfMassStateProvider centerOfMassStateProvider;
    private HumanoidReferenceFrames referenceFrames;
    private OneDoFJointBasics[] oneDoFJoints;
    private HighLevelControlManagerFactory managerFactory;
    private WholeBodyControllerCoreFactory controllerCoreFactory;
    private HighLevelHumanoidControllerToolbox controllerToolbox;
    private WalkingControllerState walkingControllerState;
    private final List<Runnable> tickListeners = new ArrayList<Runnable>();
    private final Quaternion newOrientation = new Quaternion();
    private final Quaternion orientation = new Quaternion();
    private final Vector3D newAngularVelocity = new Vector3D();
    private final Vector3D angularVelocity = new Vector3D();
    private final Vector3D desiredAngularAcceleration = new Vector3D();
    private final Point3D position = new Point3D();
    private final Point3D newPosition = new Point3D();
    private final Vector3D linearVelocity = new Vector3D();
    private final Vector3D newLinearVelocity = new Vector3D();
    private final Vector3D desiredLinearAcceleration = new Vector3D();
    private final FrameVector3D frameLinearVelocity = new FrameVector3D();
    private final FrameVector3D frameAngularVelocity = new FrameVector3D();
    private final Twist rootJointTwist = new Twist();

    public HumanoidControllerWarmup(DRCRobotModel robotModel) {
        this.robotModel = robotModel;
        this.controlDT = robotModel.getControllerDT();
        this.setupController();
        this.controllerToolbox.initialize();
        this.walkingControllerState.initialize();
    }

    protected abstract void runWarmup();

    public void addTickListener(Runnable listener) {
        this.tickListeners.add(listener);
    }

    protected void simulate(double time) {
        double startTime = this.yoTime.getDoubleValue();
        while (this.yoTime.getDoubleValue() - startTime < time) {
            this.doSingleTimeUpdate();
            for (Runnable listener : this.tickListeners) {
                listener.run();
            }
        }
    }

    protected <M extends Settable<M>> void submitMessage(M message) {
        this.commandInputManager.submitMessage(message);
    }

    protected HumanoidReferenceFrames getReferenceFrames() {
        return this.referenceFrames;
    }

    public YoVariable getYoVariable(String name) {
        return this.registry.findVariable(name);
    }

    private void doSingleTimeUpdate() {
        this.controllerToolbox.update();
        this.walkingControllerState.doAction(Double.NaN);
        this.integrate();
        this.fullRobotModel.updateFrames();
        this.referenceFrames.updateFrames();
        this.yoTime.add(this.robotModel.getControllerDT());
    }

    private void integrate() {
        for (int i = 0; i < this.oneDoFJoints.length; ++i) {
            OneDoFJointBasics joint = this.oneDoFJoints[i];
            JointDesiredOutputReadOnly jointDesireds = this.walkingControllerState.getOutputForLowLevelController().getJointDesiredOutput((OneDoFJointReadOnly)joint);
            if (jointDesireds == null || !jointDesireds.hasDesiredAcceleration()) continue;
            double q = joint.getQ();
            double qd = joint.getQd();
            double qdd = jointDesireds.getDesiredAcceleration();
            double qNew = q + this.controlDT * qd + 0.5 * this.controlDT * this.controlDT * qdd;
            double qdNew = qd + this.controlDT * qdd;
            joint.setQ(qNew);
            joint.setQd(0.98 * qdNew);
        }
        RootJointDesiredConfigurationDataReadOnly rootJointOutput = this.walkingControllerState.getOutputForRootJoint();
        DMatrixRMaj desiredAcceleration = rootJointOutput.getDesiredAcceleration();
        this.desiredAngularAcceleration.set(desiredAcceleration.get(0), desiredAcceleration.get(1), desiredAcceleration.get(2));
        this.desiredLinearAcceleration.set(desiredAcceleration.get(3), desiredAcceleration.get(4), desiredAcceleration.get(5));
        FloatingJointBasics rootJoint = this.fullRobotModel.getRootJoint();
        this.position.set((Tuple3DReadOnly)rootJoint.getJointPose().getPosition());
        this.linearVelocity.set((Tuple3DReadOnly)rootJoint.getJointTwist().getLinearPart());
        this.newPosition.set((Tuple3DReadOnly)this.desiredLinearAcceleration);
        this.newPosition.scale(0.5 * this.controlDT);
        this.newPosition.add((Tuple3DReadOnly)this.linearVelocity);
        this.newPosition.scale(this.controlDT);
        this.newPosition.add((Tuple3DReadOnly)this.position);
        this.newLinearVelocity.set(this.desiredLinearAcceleration);
        this.newLinearVelocity.scale(this.controlDT);
        this.newLinearVelocity.add((Tuple3DReadOnly)this.linearVelocity);
        RotationTools.integrateAngularVelocity((Vector3DReadOnly)this.angularVelocity, (double)this.controlDT, (QuaternionBasics)this.newOrientation);
        this.newOrientation.preMultiply((QuaternionReadOnly)this.orientation);
        this.newAngularVelocity.set(this.desiredAngularAcceleration);
        this.newAngularVelocity.scale(this.controlDT);
        this.newAngularVelocity.add((Tuple3DReadOnly)this.angularVelocity);
        rootJoint.setJointOrientation((Orientation3DReadOnly)this.newOrientation);
        rootJoint.setJointPosition((Tuple3DReadOnly)this.newPosition);
        rootJoint.updateFramesRecursively();
        this.frameLinearVelocity.setIncludingFrame(ReferenceFrame.getWorldFrame(), (Tuple3DReadOnly)this.newLinearVelocity);
        this.frameAngularVelocity.setIncludingFrame(ReferenceFrame.getWorldFrame(), (Tuple3DReadOnly)this.newAngularVelocity);
        this.frameLinearVelocity.scale(0.98);
        this.frameAngularVelocity.scale(0.98);
        this.frameLinearVelocity.changeFrame((ReferenceFrame)rootJoint.getFrameAfterJoint());
        this.frameAngularVelocity.changeFrame((ReferenceFrame)rootJoint.getFrameAfterJoint());
        this.rootJointTwist.setIncludingFrame((ReferenceFrame)rootJoint.getFrameAfterJoint(), (ReferenceFrame)rootJoint.getFrameBeforeJoint(), (ReferenceFrame)rootJoint.getFrameAfterJoint(), (Vector3DReadOnly)this.frameAngularVelocity, (Vector3DReadOnly)this.frameLinearVelocity);
        rootJoint.setJointTwist((TwistReadOnly)this.rootJointTwist);
    }

    private void createWalkingControllerAndSetUpManagerFactory(YoRegistry managerFactoryParent) {
        WalkingControllerParameters walkingControllerParameters = this.robotModel.getWalkingControllerParameters();
        CoPTrajectoryParameters copTrajectoryParameters = this.robotModel.getCoPTrajectoryParameters();
        ReferenceFrameHashCodeResolver referenceFrameHashCodeResolver = new ReferenceFrameHashCodeResolver((FullRobotModel)this.fullRobotModel, (ReferenceFrames)this.referenceFrames);
        FrameMessageCommandConverter commandConversionHelper = new FrameMessageCommandConverter(referenceFrameHashCodeResolver);
        this.commandInputManager.registerConversionHelper((CommandConversionInterface)commandConversionHelper);
        double omega0 = walkingControllerParameters.getOmega0();
        RobotContactPointParameters contactPointParameters = this.robotModel.getContactPointParameters();
        ArrayList additionalContactRigidBodyNames = contactPointParameters.getAdditionalContactRigidBodyNames();
        ArrayList additionalContactNames = contactPointParameters.getAdditionalContactNames();
        ArrayList additionalContactTransforms = contactPointParameters.getAdditionalContactTransforms();
        ContactableBodiesFactory contactableBodiesFactory = new ContactableBodiesFactory();
        contactableBodiesFactory.setFootContactPoints(contactPointParameters.getFootContactPoints());
        contactableBodiesFactory.setToeContactParameters(contactPointParameters.getControllerToeContactPoints(), contactPointParameters.getControllerToeContactLines());
        for (int i = 0; i < contactPointParameters.getAdditionalContactNames().size(); ++i) {
            contactableBodiesFactory.addAdditionalContactPoint((String)additionalContactRigidBodyNames.get(i), (String)additionalContactNames.get(i), (RigidBodyTransform)additionalContactTransforms.get(i));
        }
        contactableBodiesFactory.setFullRobotModel((FullLeggedRobotModel)this.fullRobotModel);
        contactableBodiesFactory.setReferenceFrames((CommonLeggedReferenceFrames)this.referenceFrames);
        SideDependentList feet = new SideDependentList(contactableBodiesFactory.createFootContactableFeet());
        List additionalContacts = contactableBodiesFactory.createAdditionalContactPoints();
        contactableBodiesFactory.disposeFactory();
        for (RobotSide robotSide : RobotSide.values) {
            this.contactableBodies.add((ContactablePlaneBody)feet.get((Enum)robotSide));
        }
        this.contactableBodies.addAll(additionalContacts);
        double totalRobotWeight = MultiBodySystemMissingTools.computeSubTreeMass((RigidBodyReadOnly)this.fullRobotModel.getElevator()) * 9.81;
        SideDependentList<FootSwitchInterface> footSwitches = this.createFootSwitches((SideDependentList<ContactableFoot>)feet, totalRobotWeight, (SideDependentList<? extends ReferenceFrame>)this.referenceFrames.getSoleZUpFrames());
        JointBasics[] jointsToIgnore = AvatarControllerThread.createListOfJointsToIgnore(this.fullRobotModel, this.robotModel, this.robotModel.getSensorInformation());
        this.controllerToolbox = new HighLevelHumanoidControllerToolbox(this.fullRobotModel, this.centerOfMassStateProvider, (CommonHumanoidReferenceFrames)this.referenceFrames, footSwitches, null, this.yoTime, 9.81, omega0, feet, this.controlDT, false, null, this.contactableBodies, this.yoGraphicsListRegistry, jointsToIgnore);
        double defaultTransferTime = walkingControllerParameters.getDefaultTransferTime();
        double defaultSwingTime = walkingControllerParameters.getDefaultSwingTime();
        double defaultInitialTransferTime = walkingControllerParameters.getDefaultInitialTransferTime();
        double defaultFinalTransferTime = walkingControllerParameters.getDefaultFinalTransferTime();
        WalkingMessageHandler walkingMessageHandler = new WalkingMessageHandler(defaultTransferTime, defaultSwingTime, defaultInitialTransferTime, defaultFinalTransferTime, feet, this.statusOutputManager, this.yoTime, this.yoGraphicsListRegistry, this.controllerToolbox.getYoVariableRegistry());
        this.controllerToolbox.setWalkingMessageHandler(walkingMessageHandler);
        this.managerFactory = new HighLevelControlManagerFactory(managerFactoryParent);
        this.managerFactory.setHighLevelHumanoidControllerToolbox(this.controllerToolbox);
        this.managerFactory.setWalkingControllerParameters(walkingControllerParameters);
        this.managerFactory.setCopTrajectoryParameters(copTrajectoryParameters);
        this.controllerCoreFactory = new WholeBodyControllerCoreFactory(managerFactoryParent);
        this.controllerCoreFactory.setHighLevelHumanoidControllerToolbox(this.controllerToolbox);
        this.controllerCoreFactory.setWalkingControllerParameters(walkingControllerParameters);
        this.walkingControllerState = new WalkingControllerState(this.commandInputManager, this.statusOutputManager, this.managerFactory, this.controllerCoreFactory, this.controllerToolbox, this.robotModel.getHighLevelControllerParameters(), this.robotModel.getWalkingControllerParameters());
    }

    public void setupController() {
        this.fullRobotModel = this.robotModel.createFullRobotModel();
        this.centerOfMassStateProvider = CenterOfMassStateProvider.createJacobianBasedStateCalculator((RigidBodyReadOnly)this.fullRobotModel.getElevator(), (ReferenceFrame)ReferenceFrame.getWorldFrame());
        this.referenceFrames = new HumanoidReferenceFrames(this.fullRobotModel, this.centerOfMassStateProvider, null);
        this.oneDoFJoints = this.fullRobotModel.getOneDoFJoints();
        YoRegistry drcControllerThread = new YoRegistry("DRCControllerThread");
        YoRegistry drcMomentumBasedController = new YoRegistry("DRCMomentumBasedController");
        YoRegistry humanoidHighLevelControllerManager = new YoRegistry("HumanoidHighLevelControllerManager");
        YoRegistry highLevelHumanoidControllerFactory = new YoRegistry("HighLevelHumanoidControllerFactory");
        this.registry.addChild(drcControllerThread);
        drcControllerThread.addChild(drcMomentumBasedController);
        drcMomentumBasedController.addChild(humanoidHighLevelControllerManager);
        humanoidHighLevelControllerManager.addChild(highLevelHumanoidControllerFactory);
        this.createWalkingControllerAndSetUpManagerFactory(highLevelHumanoidControllerFactory);
        humanoidHighLevelControllerManager.addChild(this.walkingControllerState.getYoRegistry());
        humanoidHighLevelControllerManager.addChild(this.controllerToolbox.getYoVariableRegistry());
        Object name = "FootAssumeCopOnEdge";
        YoBoolean variable = (YoBoolean)this.registry.findVariable((String)name);
        variable.set(true);
        name = "FootAssumeFootBarelyLoaded";
        variable = (YoBoolean)this.registry.findVariable((String)name);
        variable.set(true);
        for (RobotSide robotSide : RobotSide.values) {
            name = robotSide.getCamelCaseNameForStartOfExpression() + "FootCurrentState";
            YoEnum footState = (YoEnum)this.registry.findVariable((String)name);
            this.footStates.put((Enum)robotSide, (Object)footState);
        }
        ParameterLoaderHelper.loadParameters((Object)this, (InputStream)this.robotModel.getWholeBodyControllerParametersFile(), (YoRegistry)drcControllerThread);
        YoVariable defaultHeight = this.registry.findVariable(PelvisHeightControlState.class.getSimpleName(), PelvisHeightControlState.class.getSimpleName() + "DefaultHeight");
        if (Double.isNaN(defaultHeight.getValueAsDouble())) {
            throw new RuntimeException("Need to load a default height.");
        }
    }

    private SideDependentList<FootSwitchInterface> createFootSwitches(SideDependentList<ContactableFoot> feet, double totalRobotWeight, SideDependentList<? extends ReferenceFrame> soleZupFrames) {
        SideDependentList ret = new SideDependentList();
        for (RobotSide robotSide : RobotSide.values) {
            KinematicsBasedFootSwitch footSwitch = new KinematicsBasedFootSwitch(((ContactableFoot)feet.get((Enum)robotSide)).getName(), feet, () -> 0.0, totalRobotWeight, robotSide, this.registry);
            ret.put((Enum)robotSide, (Object)footSwitch);
        }
        return ret;
    }

    public DoubleProvider getTimeProvider() {
        return this.yoTime;
    }

    public FullHumanoidRobotModel getFullRobotModel() {
        return this.fullRobotModel;
    }

    public YoGraphicsListRegistry getYoGraphicsListRegistry() {
        return this.yoGraphicsListRegistry;
    }

    public YoRegistry getRegistry() {
        return this.registry;
    }

    public DRCRobotModel getRobotModel() {
        return this.robotModel;
    }
}

