/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.visualization;

import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.simulationConstructionSetTools.util.inputdevices.SliderBoardConfigurationManager;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.util.CommonNames;
import us.ihmc.yoVariables.listener.YoVariableChangedListener;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.registry.YoVariableHolder;
import us.ihmc.yoVariables.variable.YoEnum;
import us.ihmc.yoVariables.variable.YoVariable;

public class WalkControllerSliderBoard {
    private static double MIN_COM_OFFSET_ABOVE_GROUND = 0.0;
    private static double MAX_COM_OFFSET_ABOVE_GROUND = 0.2;

    public WalkControllerSliderBoard(SimulationConstructionSet scs, YoRegistry registry, DRCRobotModel drcRobotModel) {
        final YoEnum sliderBoardMode = new YoEnum("sliderBoardMode", registry, SliderBoardMode.class);
        final SliderBoardConfigurationManager sliderBoardConfigurationManager = new SliderBoardConfigurationManager(scs);
        boolean DEBUG_WITH_SLIDERBOARD = false;
        if (DEBUG_WITH_SLIDERBOARD) {
            sliderBoardConfigurationManager.setSlider(1, "captureKpParallel", (YoVariableHolder)registry, 0.0, 2.0);
            sliderBoardConfigurationManager.setKnob(1, "captureKpOrthogonal", (YoVariableHolder)registry, 0.0, 2.0);
            sliderBoardConfigurationManager.setSlider(2, "kp_comHeight", (YoVariableHolder)registry, 0.0, 40.0);
            sliderBoardConfigurationManager.setKnob(2, "kd_comHeight", (YoVariableHolder)registry, 0.0, 13.0);
            sliderBoardConfigurationManager.setSlider(3, "kpPelvisOrientation", (YoVariableHolder)registry, 0.0, 100.0);
            sliderBoardConfigurationManager.setKnob(3, "zetaPelvisOrientation", (YoVariableHolder)registry, 0.0, 1.0);
            sliderBoardConfigurationManager.setSlider(4, "kpUpperBody", (YoVariableHolder)registry, 0.0, 200.0);
            sliderBoardConfigurationManager.setKnob(4, "zetaUpperBody", (YoVariableHolder)registry, 0.0, 1.0);
            sliderBoardConfigurationManager.setSlider(5, "kpAllArmJointsL", (YoVariableHolder)registry, 0.0, 120.0);
            sliderBoardConfigurationManager.setKnob(5, "zetaAllArmJointsL", (YoVariableHolder)registry, 0.0, 1.0);
            sliderBoardConfigurationManager.setSlider(6, "kpAllArmJointsR", (YoVariableHolder)registry, 0.0, 120.0);
            sliderBoardConfigurationManager.setKnob(6, "zetaAllArmJointsR", (YoVariableHolder)registry, 0.0, 1.0);
        } else {
            System.out.println("Only claiming sliders 7 and 8 (for tuning change DEBUG_WITH_SLIDERBOARD to true in WalkControllerSliderBoard.java");
        }
        sliderBoardConfigurationManager.setSlider(7, CommonNames.doIHMCControlRatio.toString(), (YoVariableHolder)registry, 0.0, 1.0);
        sliderBoardConfigurationManager.setSlider(8, "offsetHeightAboveGround", (YoVariableHolder)registry, MIN_COM_OFFSET_ABOVE_GROUND, MAX_COM_OFFSET_ABOVE_GROUND);
        sliderBoardConfigurationManager.saveConfiguration(SliderBoardMode.WalkingGains.toString());
        sliderBoardConfigurationManager.clearControls();
        sliderBoardConfigurationManager.setButton(1, registry.findVariable("PelvisICPBasedTranslationManager", "manualModeICPOffset"));
        sliderBoardConfigurationManager.setSlider(1, "desiredICPOffsetX", (YoVariableHolder)registry, -0.3, 0.3);
        sliderBoardConfigurationManager.setKnob(1, "desiredICPOffsetY", (YoVariableHolder)registry, -0.3, 0.3);
        sliderBoardConfigurationManager.setButton(2, "userUpdateDesiredPelvisPose", (YoVariableHolder)registry);
        sliderBoardConfigurationManager.setButton(3, "userStreamPelvisOrientation", (YoVariableHolder)registry);
        sliderBoardConfigurationManager.setSlider(2, "userDesiredPelvisPoseYaw", (YoVariableHolder)registry, -0.8, 0.8);
        sliderBoardConfigurationManager.setSlider(3, "userDesiredPelvisPosePitch", (YoVariableHolder)registry, -0.4, 0.4);
        sliderBoardConfigurationManager.setSlider(4, "userDesiredPelvisPoseRoll", (YoVariableHolder)registry, -0.3, 0.3);
        sliderBoardConfigurationManager.setSlider(5, "userDesiredChestYaw", (YoVariableHolder)registry, -0.8, 0.8);
        sliderBoardConfigurationManager.setKnob(5, "userDesiredHeadYaw", (YoVariableHolder)registry, -0.8, 0.8);
        sliderBoardConfigurationManager.setSlider(6, "userDesiredChestPitch", (YoVariableHolder)registry, -0.8, 0.8);
        sliderBoardConfigurationManager.setKnob(6, "userDesiredHeadPitch", (YoVariableHolder)registry, -0.5, 0.5);
        sliderBoardConfigurationManager.setSlider(7, "userDesiredChestRoll", (YoVariableHolder)registry, -0.5, 0.5);
        sliderBoardConfigurationManager.setKnob(7, "userDesiredHeadRoll", (YoVariableHolder)registry, -0.8, 0.8);
        sliderBoardConfigurationManager.setSlider(8, "offsetHeightAboveGround", (YoVariableHolder)registry, 0.0, 0.2);
        sliderBoardConfigurationManager.setKnob(8, "gainScaleFactor", (YoVariableHolder)registry, 0.0, 1.0, 3.5, 0.0);
        sliderBoardConfigurationManager.saveConfiguration(SliderBoardMode.WalkingDesireds.toString());
        sliderBoardConfigurationManager.clearControls();
        sliderBoardConfigurationManager.setButton(1, registry.findVariable("PelvisICPBasedTranslationManager", "manualModeICPOffset"));
        sliderBoardConfigurationManager.setSlider(1, "desiredICPOffsetX", (YoVariableHolder)registry, -0.6, 0.6);
        sliderBoardConfigurationManager.setKnob(1, "desiredICPOffsetY", (YoVariableHolder)registry, -0.6, 0.6);
        sliderBoardConfigurationManager.setSlider(2, "ChestComOffsetX", (YoVariableHolder)registry, -0.5, 0.5);
        sliderBoardConfigurationManager.setKnob(2, "ChestComOffsetY", (YoVariableHolder)registry, -0.5, 0.5);
        sliderBoardConfigurationManager.setSlider(3, "ChestComOffsetZ", (YoVariableHolder)registry, 0.0, 0.5);
        sliderBoardConfigurationManager.setKnob(9, "desiredICPEccentricity", (YoVariableHolder)registry, 0.0, 0.9);
        sliderBoardConfigurationManager.setKnob(10, "desiredICPAngle", (YoVariableHolder)registry, -Math.PI, Math.PI);
        sliderBoardConfigurationManager.saveConfiguration(SliderBoardMode.ICPAndCoPFun.toString());
        sliderBoardConfigurationManager.clearControls();
        sliderBoardConfigurationManager.setSlider(1, "footCoPOffsetX", (YoVariableHolder)registry, -0.2, 0.2);
        sliderBoardConfigurationManager.setSlider(2, "footCoPOffsetY", (YoVariableHolder)registry, -0.1, 0.1);
        sliderBoardConfigurationManager.setSlider(3, "captureKpParallel", (YoVariableHolder)registry, 0.0, 2.0);
        sliderBoardConfigurationManager.setSlider(4, "captureKpOrthogonal", (YoVariableHolder)registry, 0.0, 2.0);
        sliderBoardConfigurationManager.setSlider(8, "offsetHeightAboveGround", (YoVariableHolder)registry, -0.2, 0.2);
        sliderBoardConfigurationManager.setButton(1, registry.findVariable("MomentumBasedController", "FeetCoPControlIsActive"));
        sliderBoardConfigurationManager.saveConfiguration(SliderBoardMode.TerrainExploration.toString());
        sliderBoardConfigurationManager.clearControls();
        sliderBoardMode.set((Enum)SliderBoardMode.WalkingGains);
        YoVariableChangedListener listener = new YoVariableChangedListener(){

            public void changed(YoVariable v) {
                System.out.println("SliderBoardMode: " + ((SliderBoardMode)sliderBoardMode.getEnumValue()).toString());
                sliderBoardConfigurationManager.loadConfiguration(((SliderBoardMode)sliderBoardMode.getEnumValue()).toString());
            }
        };
        sliderBoardMode.addListener(listener);
        listener.changed(null);
    }

    private static enum SliderBoardMode {
        WalkingGains,
        WalkingDesireds,
        ICPAndCoPFun,
        TerrainExploration,
        HeadJointControl,
        LeftHandGrasping,
        RightHandGrasping;

    }
}

