/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.stepAdjustment;

import java.awt.Color;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import us.ihmc.avatar.stepAdjustment.ReachabilityConstraintCalculator;
import us.ihmc.avatar.stepAdjustment.SimpleStep;
import us.ihmc.avatar.stepAdjustment.StepAdjustmentCalculator;
import us.ihmc.commonWalkingControlModules.capturePoint.stepAdjustment.CapturabilityBasedPlanarRegionDecider;
import us.ihmc.commonWalkingControlModules.captureRegion.OneStepCaptureRegionCalculator;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DBasics;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.referenceFrame.FrameConvexPolygon2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVertex2DSupplier;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPosition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.graphicsDescription.yoGraphics.plotting.YoArtifactPolygon;
import us.ihmc.humanoidRobotics.bipedSupportPolygons.StepConstraintRegion;
import us.ihmc.humanoidRobotics.footstep.FootstepUtils;
import us.ihmc.robotics.geometry.ConvexPolygonTools;
import us.ihmc.robotics.geometry.PlanarRegionsList;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameConvexPolygon2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePose3D;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class StepConstraintCalculator {
    private final StepAdjustmentCalculator stepAdjustmentCalculator;
    private final OneStepCaptureRegionCalculator captureRegionCalculator;
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final YoGraphicsListRegistry graphicsListRegistry = new YoGraphicsListRegistry();
    private final DoubleProvider timeProvider;
    private final CapturabilityBasedPlanarRegionDecider planarRegionDecider;
    private final ReachabilityConstraintCalculator reachabilityConstraintCalculator;
    private final FrameConvexPolygon2D reachabilityRegionInConstraintPlane = new FrameConvexPolygon2D();
    private final YoFrameConvexPolygon2D yoReachabilityRegion = new YoFrameConvexPolygon2D("reachabilityPolygon", FootstepUtils.worldFrame, 10, this.registry);
    private static final double defaultMinimumTimeRemainingForSwitch = 0.05;
    private final YoDouble minimumTimeRemainingForSwitch = new YoDouble("minimumTimeRemainingForSwitch", this.registry);
    private final YoDouble timeRemainingInState = new YoDouble("timeRemainingInState", this.registry);
    private final YoFrameConvexPolygon2D supportPolygon = new YoFrameConvexPolygon2D("supportPolygon", FootstepUtils.worldFrame, 6, this.registry);
    private final YoFramePose3D supportPose = new YoFramePose3D("supportPose", FootstepUtils.worldFrame, this.registry);
    private final YoFramePoint2D capturePoint = new YoFramePoint2D("capturePoint", FootstepUtils.worldFrame, this.registry);
    private final SideDependentList<FrameConvexPolygon2D> supportPolygons = new SideDependentList((Object)new FrameConvexPolygon2D(), (Object)new FrameConvexPolygon2D());
    private final SideDependentList<? extends ReferenceFrame> soleZUpFrames;
    private final AtomicReference<PlanarRegionsList> planarRegionsList = new AtomicReference();
    private SimpleStep currentStep;
    private StepConstraintRegion stepConstraintRegion = null;
    private double omega = 3.0;
    private final ConvexPolygonTools convexPolygonTools = new ConvexPolygonTools();

    public StepConstraintCalculator(WalkingControllerParameters walkingControllerParameters, SideDependentList<? extends ReferenceFrame> soleZUpFrames, DoubleProvider timeProvider) {
        this(soleZUpFrames, walkingControllerParameters.getSteppingParameters().getFootLength(), walkingControllerParameters.getSteppingParameters().getFootWidth(), walkingControllerParameters.getSteppingParameters().getMaxStepLength(), walkingControllerParameters.getSteppingParameters().getMaxBackwardStepLength(), walkingControllerParameters.getSteppingParameters().getMinStepWidth(), walkingControllerParameters.getSteppingParameters().getMaxStepWidth(), timeProvider);
    }

    public StepConstraintCalculator(SideDependentList<? extends ReferenceFrame> soleZUpFrames, double footLength, double footWidth, double kinematicStepRange, double maxBackwardStepLength, double minStepWidth, double maxStepWidth, DoubleProvider timeProvider) {
        this.timeProvider = timeProvider;
        this.soleZUpFrames = soleZUpFrames;
        this.stepAdjustmentCalculator = new StepAdjustmentCalculator(kinematicStepRange, this.registry);
        this.captureRegionCalculator = new OneStepCaptureRegionCalculator(footWidth, kinematicStepRange, soleZUpFrames, this.registry, this.graphicsListRegistry);
        this.planarRegionDecider = new CapturabilityBasedPlanarRegionDecider(this.registry, this.graphicsListRegistry);
        this.reachabilityConstraintCalculator = new ReachabilityConstraintCalculator(soleZUpFrames, footLength, footWidth, kinematicStepRange, maxBackwardStepLength, minStepWidth, maxStepWidth, this.registry);
        this.minimumTimeRemainingForSwitch.set(0.05);
        YoGraphicPosition capturePointViz = new YoGraphicPosition("CapturePoint", this.capturePoint, 0.02, YoAppearance.Yellow(), YoGraphicPosition.GraphicType.BALL_WITH_CROSS);
        YoArtifactPolygon supportPolygonArtifact = new YoArtifactPolygon("SupportPolygon", this.supportPolygon, Color.GREEN, false);
        YoArtifactPolygon reachabilityArtifact = new YoArtifactPolygon("ReachabilityPolygon", this.yoReachabilityRegion, Color.BLUE, false);
        this.graphicsListRegistry.registerYoGraphic("Constraint Calculator", (YoGraphic)capturePointViz);
        this.graphicsListRegistry.registerArtifact("Constraint Calculator", (Artifact)capturePointViz.createArtifact());
        this.graphicsListRegistry.registerArtifact("Constraint Calculator", (Artifact)supportPolygonArtifact);
        this.graphicsListRegistry.registerArtifact("Constraint Calculator", (Artifact)reachabilityArtifact);
    }

    public YoRegistry getYoVariableRegistry() {
        return this.registry;
    }

    public YoGraphicsListRegistry getYoGraphicsListRegistry() {
        return this.graphicsListRegistry;
    }

    public void setLeftFootSupportPolygon(List<? extends Point3DReadOnly> footVertices) {
        this.setFootSupportPolygon(RobotSide.LEFT, footVertices);
    }

    public void setRightFootSupportPolygon(List<? extends Point3DReadOnly> footVertices) {
        this.setFootSupportPolygon(RobotSide.RIGHT, footVertices);
    }

    public void setFootSupportPolygon(RobotSide supportSide, List<? extends Point3DReadOnly> footVertices) {
        FrameConvexPolygon2DBasics supportPolygon = (FrameConvexPolygon2DBasics)this.supportPolygons.get((Enum)supportSide);
        supportPolygon.clear();
        footVertices.forEach(arg_0 -> ((FrameConvexPolygon2DBasics)supportPolygon).addVertex(arg_0));
        supportPolygon.update();
    }

    public void setOmega(double omega) {
        this.omega = omega;
    }

    public void setCapturePoint(Point3DReadOnly capturePointInWorld) {
        this.capturePoint.set((Tuple3DReadOnly)capturePointInWorld);
    }

    public void setCurrentStep(SimpleStep simpleStep) {
        this.currentStep = simpleStep;
    }

    public void setPlanarRegions(PlanarRegionsList planarRegions) {
        this.planarRegionsList.set(planarRegions);
    }

    public void setSwitchPlanarRegionConstraintsAutomatically(boolean switchAutomatically) {
        this.planarRegionDecider.setSwitchPlanarRegionConstraintsAutomatically(switchAutomatically);
    }

    public void reset() {
        this.currentStep = null;
        this.planarRegionDecider.reset();
        this.supportPolygon.clearAndUpdate();
        this.capturePoint.setToNaN();
        this.supportPose.setToNaN();
    }

    public void update() {
        if (this.currentStep == null) {
            this.captureRegionCalculator.hideCaptureRegion();
            this.stepConstraintRegion = null;
        } else {
            this.updateCaptureRegion(this.currentStep);
            this.stepAdjustmentCalculator.setPlanarRegions(this.planarRegionsList.get().getPlanarRegionsAsList());
            FramePoint3D supportFoot = new FramePoint3D((ReferenceFrame)this.soleZUpFrames.get((Enum)this.currentStep.getSwingSide().getOppositeSide()));
            supportFoot.changeFrame(FootstepUtils.worldFrame);
            this.supportPose.setToZero();
            this.supportPose.getPosition().set((FrameTuple3DReadOnly)supportFoot);
            this.stepAdjustmentCalculator.setStanceFootPosition((FramePoint3DReadOnly)supportFoot);
            List<StepConstraintRegion> steppableRegions = this.stepAdjustmentCalculator.computeSteppableRegions();
            this.updateReachabilityRegion(this.currentStep.getSwingSide().getOppositeSide());
            if (this.timeRemainingInState.getDoubleValue() < this.minimumTimeRemainingForSwitch.getDoubleValue()) {
                return;
            }
            this.planarRegionDecider.setConstraintRegions(steppableRegions);
            this.planarRegionDecider.setCaptureRegion((FrameConvexPolygon2DReadOnly)this.captureRegionCalculator.getCaptureRegion());
            this.planarRegionDecider.updatePlanarRegionConstraintForStep(this.currentStep.getStepPose(), (ConvexPolygon2DReadOnly)this.yoReachabilityRegion);
            this.updateReachabilityRegionInControlPlane();
            this.stepConstraintRegion = this.computeConstraintRegion();
        }
    }

    private void updateCaptureRegion(SimpleStep simpleStep) {
        double timeInState = this.timeProvider.getValue() - simpleStep.getStartTime();
        double timeRemaining = simpleStep.getSwingDuration() - timeInState;
        this.timeRemainingInState.set(timeRemaining);
        RobotSide swingSide = simpleStep.getSwingSide();
        this.supportPolygon.set((FrameVertex2DSupplier)this.supportPolygons.get((Enum)swingSide.getOppositeSide()));
        this.captureRegionCalculator.calculateCaptureRegion(swingSide, timeRemaining, (FramePoint2DReadOnly)this.capturePoint, this.omega, (FrameConvexPolygon2DReadOnly)this.supportPolygons.get((Enum)swingSide.getOppositeSide()));
    }

    public void updateReachabilityRegion(RobotSide supportSide) {
        FrameConvexPolygon2DReadOnly reachabilityRegion = this.reachabilityConstraintCalculator.getReachabilityPolygon(supportSide);
        this.reachabilityRegionInConstraintPlane.clear();
        this.reachabilityRegionInConstraintPlane.setIncludingFrame((FrameVertex2DSupplier)reachabilityRegion);
        this.reachabilityRegionInConstraintPlane.changeFrame(FootstepUtils.worldFrame);
        this.yoReachabilityRegion.set((FrameVertex2DSupplier)this.reachabilityRegionInConstraintPlane);
    }

    public void updateReachabilityRegionInControlPlane() {
        StepConstraintRegion stepConstraintRegion = this.planarRegionDecider.getConstraintRegion();
        if (stepConstraintRegion == null) {
            return;
        }
        this.reachabilityRegionInConstraintPlane.set((FrameVertex2DSupplier)this.yoReachabilityRegion);
        this.reachabilityRegionInConstraintPlane.applyTransform((Transform)stepConstraintRegion.getTransformToLocal(), false);
    }

    private StepConstraintRegion computeConstraintRegion() {
        StepConstraintRegion planarRegionForConstraint = this.planarRegionDecider.getConstraintRegion();
        if (planarRegionForConstraint == null) {
            return null;
        }
        ConvexPolygon2D constraintConvexHull = new ConvexPolygon2D();
        this.convexPolygonTools.computeIntersectionOfPolygons(planarRegionForConstraint.getConvexHullInConstraintRegion(), (ConvexPolygon2DReadOnly)this.reachabilityRegionInConstraintPlane, (ConvexPolygon2DBasics)constraintConvexHull);
        return new StepConstraintRegion(planarRegionForConstraint.getTransformToWorld(), (Vertex2DSupplier)constraintConvexHull);
    }

    public boolean constraintRegionChanged() {
        return this.planarRegionDecider.constraintRegionChanged();
    }

    public StepConstraintRegion getConstraintRegion() {
        return this.stepConstraintRegion;
    }

    public StepConstraintRegion pollStepConstraintRegion() {
        if (this.planarRegionDecider.constraintRegionChanged()) {
            StepConstraintRegion regionToReturn = this.stepConstraintRegion;
            this.planarRegionDecider.setConstraintRegionChanged(false);
            this.stepConstraintRegion = null;
            return regionToReturn;
        }
        return null;
    }
}

