/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.stepAdjustment;

import java.util.List;
import us.ihmc.avatar.stepAdjustment.SteppableRegionsProvider;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.footstepPlanning.simplePlanners.SnapAndWiggleSingleStepParameters;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.PlanarRegionCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.PlanarRegionsListCommand;
import us.ihmc.robotics.geometry.PlanarRegion;
import us.ihmc.yoVariables.providers.DoubleProvider;

public class SimpleSteppableRegionsCalculator
implements SteppableRegionsProvider {
    private final DoubleProvider minRegionArea;
    private final DoubleProvider maxNormalAngle;
    private final RecyclingArrayList<PlanarRegion> steppableRegionsList = new RecyclingArrayList(PlanarRegion::new);
    private final ConvexPolygon2D convexHullOfAllThePlanarRegions = new ConvexPolygon2D();
    private final FramePoint2D tempPoint = new FramePoint2D();

    public SimpleSteppableRegionsCalculator() {
        this(new SnapAndWiggleSingleStepParameters());
    }

    public SimpleSteppableRegionsCalculator(SnapAndWiggleSingleStepParameters parameters) {
        this(() -> ((SnapAndWiggleSingleStepParameters)parameters).getMinPlanarRegionArea(), () -> ((SnapAndWiggleSingleStepParameters)parameters).getMaxPlanarRegionAngle());
    }

    public SimpleSteppableRegionsCalculator(DoubleProvider minRegionArea, DoubleProvider maxNormalAngle) {
        this.minRegionArea = minRegionArea;
        this.maxNormalAngle = maxNormalAngle;
    }

    @Override
    public void consume(PlanarRegionsListCommand planarRegions) {
        this.steppableRegionsList.clear();
        for (int i = 0; i < planarRegions.getNumberOfPlanarRegions(); ++i) {
            PlanarRegionCommand candidateRegion = planarRegions.getPlanarRegionCommand(i);
            double polygonArea = 0.0;
            for (int regionIdx = 0; regionIdx < candidateRegion.getConvexPolygons().size(); ++regionIdx) {
                polygonArea += ((ConvexPolygon2D)candidateRegion.getConvexPolygons().get(regionIdx)).getArea();
            }
            if (polygonArea < this.minRegionArea.getValue() || Math.abs(candidateRegion.getTransformToWorld().getM22()) < Math.cos(this.maxNormalAngle.getValue())) continue;
            PlanarRegion planarRegion = (PlanarRegion)this.steppableRegionsList.add();
            planarRegion.set((RigidBodyTransformReadOnly)candidateRegion.getTransformToWorld(), (List)candidateRegion.getConvexPolygons(), (List)candidateRegion.getConcaveHullsVertices(), candidateRegion.getRegionId());
        }
        this.computeBoundaryOfPlanarRegions((List<PlanarRegion>)this.steppableRegionsList);
    }

    private void computeBoundaryOfPlanarRegions(List<PlanarRegion> planarRegionsList) {
        this.convexHullOfAllThePlanarRegions.clear();
        for (int i = 0; i < planarRegionsList.size(); ++i) {
            PlanarRegion region = planarRegionsList.get(i);
            for (int j = 0; j < region.getConcaveHullSize(); ++j) {
                region.getTransformToWorld().transform(region.getConcaveHullVertex(j), (Point2DBasics)this.tempPoint, false);
                this.convexHullOfAllThePlanarRegions.addVertex((Point2DReadOnly)this.tempPoint);
            }
        }
        this.convexHullOfAllThePlanarRegions.update();
    }

    @Override
    public List<PlanarRegion> getSteppableRegions() {
        return this.steppableRegionsList;
    }

    @Override
    public ConvexPolygon2DReadOnly getConvexHullOfAllRegions() {
        return this.convexHullOfAllThePlanarRegions;
    }
}

