/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.stepAdjustment;

import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPolygon;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.robotics.geometry.PlanarRegion;
import us.ihmc.yoVariables.euclid.YoVector3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameConvexPolygon2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePose3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoInteger;

public class PlanarRegionSnapVisualizer {
    private static final int numberOfStepsToVisualize = 5;
    private static final int maximumVertices = 60;
    private final FootholdData[] footholdData = new FootholdData[5];
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final YoInteger stepsVisualized = new YoInteger("stepsVisualized", this.registry);

    public PlanarRegionSnapVisualizer(YoRegistry parentRegistry, YoGraphicsListRegistry graphicsListRegistry) {
        for (int i = 0; i < 5; ++i) {
            this.footholdData[i] = new FootholdData("" + i, this.registry, graphicsListRegistry);
        }
        parentRegistry.addChild(this.registry);
    }

    public void reset() {
        this.stepsVisualized.set(-1);
    }

    public void setFootIndex(int index) {
        this.stepsVisualized.set(index);
        if (index < this.footholdData.length) {
            this.footholdData[index].reset();
        }
    }

    public void recordUnadjustedFootstep(FramePose3DReadOnly footPose, ConvexPolygon2DReadOnly foothold) {
        int i = this.stepsVisualized.getIntegerValue();
        if (i >= 5) {
            return;
        }
        this.footholdData[i].unsnappedFootstepPolygon.set((Vertex2DSupplier)foothold);
        this.footholdData[i].unsnappedFootstepPose.set(footPose);
    }

    public void recordFootPoseIsOnBoundary() {
        if (this.stepsVisualized.getIntegerValue() >= 5) {
            return;
        }
        this.footholdData[this.stepsVisualized.getIntegerValue()].footPoseIsOnBoundaryOfWorld.set(true);
    }

    public void recordSnapTransform(int regionsUnderFoot, RigidBodyTransformReadOnly snapTransform, PlanarRegion regionSnappedTo) {
        int i = this.stepsVisualized.getIntegerValue();
        if (i >= 5) {
            return;
        }
        this.footholdData[i].regionsUnderFoot.set(regionsUnderFoot);
        this.footholdData[i].footWasSnapped.set(true);
        this.footholdData[i].footSnapTranslation.set(snapTransform.getTranslation());
        if (regionSnappedTo != null) {
            this.footholdData[i].footHadRegion.set(true);
            this.footholdData[i].concaveRegionHull.clear();
            for (int vertex = 0; vertex < Math.min(60, regionSnappedTo.getConcaveHull().size()); ++vertex) {
                this.footholdData[i].concaveRegionHull.addVertex(regionSnappedTo.getConcaveHullVertex(vertex));
            }
            this.footholdData[i].concaveRegionHull.update();
            this.footholdData[i].concaveRegionPose.set(regionSnappedTo.getTransformToWorld());
            this.footholdData[i].concaveRegionPose.prependTranslation(0.0, 0.0, 0.001);
        } else {
            this.footholdData[i].concaveRegionHull.clear();
            this.footholdData[i].concaveRegionPose.setToNaN();
        }
    }

    public void recordWiggleTransform(int wiggleIterations, RigidBodyTransformReadOnly wiggleTransform) {
        int i = this.stepsVisualized.getIntegerValue();
        if (i >= 5) {
            return;
        }
        this.footholdData[i].footWasWiggled.set(true);
        this.footholdData[i].footWiggleTranslation.set(wiggleTransform.getTranslation());
        this.footholdData[i].wiggleIterations.set(wiggleIterations);
    }

    private static class FootholdData {
        private final YoFrameConvexPolygon2D concaveRegionHull;
        private final YoFramePose3D concaveRegionPose;
        private final YoFramePose3D unsnappedFootstepPose;
        private final YoFrameConvexPolygon2D unsnappedFootstepPolygon;
        private final YoBoolean footWasWiggled;
        private final YoBoolean footWasSnapped;
        private final YoBoolean footHadRegion;
        private final YoBoolean footPoseIsOnBoundaryOfWorld;
        private final YoInteger regionsUnderFoot;
        private final YoInteger wiggleIterations;
        private final YoVector3D footSnapTranslation;
        private final YoVector3D footWiggleTranslation;

        public FootholdData(String suffix, YoRegistry registry, YoGraphicsListRegistry graphicsListRegistry) {
            this.unsnappedFootstepPose = new YoFramePose3D("unsnappedFootstepPose" + suffix, ReferenceFrame.getWorldFrame(), registry);
            this.unsnappedFootstepPolygon = new YoFrameConvexPolygon2D("unsnappedFootstepPolygon" + suffix, ReferenceFrame.getWorldFrame(), 4, registry);
            this.concaveRegionHull = new YoFrameConvexPolygon2D("concaveRegionHull" + suffix, ReferenceFrame.getWorldFrame(), 60, registry);
            this.concaveRegionPose = new YoFramePose3D("concaveRegionPose" + suffix, ReferenceFrame.getWorldFrame(), registry);
            this.footWasWiggled = new YoBoolean("footWasWiggled" + suffix, registry);
            this.footWasSnapped = new YoBoolean("footWasSnapped" + suffix, registry);
            this.footHadRegion = new YoBoolean("footHadRegion" + suffix, registry);
            this.regionsUnderFoot = new YoInteger("regionsUnderFoot" + suffix, registry);
            this.footPoseIsOnBoundaryOfWorld = new YoBoolean("footPoseIsOnBoundaryOfWorld" + suffix, registry);
            this.footSnapTranslation = new YoVector3D("footSnapTranslation" + suffix, registry);
            this.footWiggleTranslation = new YoVector3D("footWiggleTranslation" + suffix, registry);
            this.wiggleIterations = new YoInteger("wiggleIterations" + suffix, registry);
            AppearanceDefinition regionAppearance = YoAppearance.Green();
            regionAppearance.setTransparency(0.75);
            YoGraphicPolygon regionGraphic = new YoGraphicPolygon("concave Region Hull " + suffix, this.concaveRegionHull, this.concaveRegionPose, 1.0, regionAppearance);
            AppearanceDefinition footAppearance = YoAppearance.Blue();
            footAppearance.setTransparency(0.5);
            YoGraphicPolygon unsnappedGraphic = new YoGraphicPolygon("unsnapped Graphic " + suffix, this.unsnappedFootstepPolygon, this.unsnappedFootstepPose, 1.0, footAppearance);
            graphicsListRegistry.registerYoGraphic("Foot Snap Data", (YoGraphic)regionGraphic);
            graphicsListRegistry.registerYoGraphic("Foot Snap Data", (YoGraphic)unsnappedGraphic);
        }

        public void reset() {
            this.unsnappedFootstepPose.setToNaN();
            this.unsnappedFootstepPolygon.clear();
            this.concaveRegionHull.clear();
            this.concaveRegionPose.setToNaN();
            this.footSnapTranslation.setToNaN();
            this.footWiggleTranslation.setToNaN();
            this.footWasWiggled.set(false);
            this.footWasSnapped.set(false);
            this.footHadRegion.set(false);
            this.regionsUnderFoot.set(-1);
            this.wiggleIterations.set(-1);
            this.footPoseIsOnBoundaryOfWorld.set(false);
        }
    }
}

