/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.stepAdjustment;

import controller_msgs.msg.dds.FootstepDataMessage;
import controller_msgs.msg.dds.StepConstraintsListMessage;
import gnu.trove.list.array.TDoubleArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import us.ihmc.avatar.stepAdjustment.PlanarRegionSnapVisualizer;
import us.ihmc.avatar.stepAdjustment.SteppableRegionsProvider;
import us.ihmc.commonWalkingControlModules.capturePoint.stepAdjustment.ConstraintOptimizerParametersReadOnly;
import us.ihmc.commonWalkingControlModules.capturePoint.stepAdjustment.ConvexStepConstraintOptimizer;
import us.ihmc.commonWalkingControlModules.configurations.SteppingEnvironmentalConstraintParameters;
import us.ihmc.commonWalkingControlModules.desiredFootStep.footstepGenerator.FootstepAdjustment;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DBasics;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.footstepPlanning.polygonSnapping.GarbageFreePlanarRegionListPolygonSnapper;
import us.ihmc.humanoidRobotics.bipedSupportPolygons.StepConstraintListConverter;
import us.ihmc.humanoidRobotics.bipedSupportPolygons.StepConstraintMessageConverter;
import us.ihmc.humanoidRobotics.bipedSupportPolygons.StepConstraintRegion;
import us.ihmc.robotics.geometry.ConvexPolygonTools;
import us.ihmc.robotics.geometry.PlanarRegion;
import us.ihmc.robotics.geometry.PlanarRegionTools;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.yoVariables.registry.YoRegistry;

public class PlanarRegionFootstepSnapper
implements FootstepAdjustment {
    private static final boolean onlyTrustProprioceptionWhenOffRegion = true;
    private final SteppableRegionsProvider steppableRegionsProvider;
    private final FramePose3D footstepAtSameHeightAsStanceFoot = new FramePose3D();
    private final FramePose3D adjustedFootstepPose = new FramePose3D();
    private final ConvexPolygonTools convexPolygonTools = new ConvexPolygonTools();
    private final GarbageFreePlanarRegionListPolygonSnapper snapper = new GarbageFreePlanarRegionListPolygonSnapper();
    private final SideDependentList<? extends ConvexPolygon2DReadOnly> footPolygons;
    private final SteppingEnvironmentalConstraintParameters environmentalConstraintParameters;
    private final ConstraintOptimizerParametersReadOnly wiggleParameters;
    private final ConvexStepConstraintOptimizer stepConstraintOptimizer;
    private PlanarRegionSnapVisualizer planarRegionSnapVisualizer;
    private final List<PlanarRegion> regionsIntersectingFoothold = new ArrayList<PlanarRegion>();
    private final TDoubleArrayList intersectAreas = new TDoubleArrayList();
    private final PoseReferenceFrame soleFrameBeforeSnapping = new PoseReferenceFrame("SoleFrameBeforeSnapping", ReferenceFrame.getWorldFrame());
    private final PoseReferenceFrame soleFrameAfterSnapAndBeforeWiggle = new PoseReferenceFrame("SoleFrameAfterSnapAndBeforeWiggle", ReferenceFrame.getWorldFrame());
    private final PoseReferenceFrame soleFrameAfterWiggle = new PoseReferenceFrame("SoleFrameAfterWiggle", ReferenceFrame.getWorldFrame());
    private final PoseReferenceFrame planarRegionFrame = new PoseReferenceFrame("PlanarRegionFrame", ReferenceFrame.getWorldFrame());
    private final RigidBodyTransform snapTransform = new RigidBodyTransform();
    private final PlanarRegion regionToSnapTo = new PlanarRegion();
    private final StepConstraintRegion constraintRegion = new StepConstraintRegion();
    private final List<StepConstraintRegion> constraintRegionList = Collections.singletonList(this.constraintRegion);
    private final ConvexPolygon2D unsnappedFootstepPolygonInWorld = new ConvexPolygon2D();
    private final ConvexPolygon2D snappedAndWiggledFootstepPolygon = new ConvexPolygon2D();
    private final RigidBodyTransform transformFromSoleToRegion = new RigidBodyTransform();
    private final ConvexPolygon2D footPolygonInRegionFrame = new ConvexPolygon2D();
    private final StepConstraintsListMessage stepConstraint = new StepConstraintsListMessage();

    public PlanarRegionFootstepSnapper(SideDependentList<ConvexPolygon2D> footPolygons, SteppableRegionsProvider steppableRegionsProvider, SteppingEnvironmentalConstraintParameters constraintParameters, YoRegistry parentRegistry) {
        this.steppableRegionsProvider = steppableRegionsProvider;
        YoRegistry registry = new YoRegistry("PlanarRegionFootstepSnapper");
        this.environmentalConstraintParameters = constraintParameters;
        this.wiggleParameters = constraintParameters.getConstraintOptimizerParameters();
        this.stepConstraintOptimizer = new ConvexStepConstraintOptimizer(registry);
        this.footPolygons = footPolygons;
        this.stepConstraintOptimizer.setWarmStart(false);
        parentRegistry.addChild(registry);
    }

    public void attachPlanarRegionSnapVisualizer(PlanarRegionSnapVisualizer planarRegionSnapperCallback) {
        this.planarRegionSnapVisualizer = planarRegionSnapperCallback;
    }

    public boolean adjustFootstep(FramePose3DReadOnly stanceFootPose, FramePose2DReadOnly footstepPoseToAdjust, RobotSide footSide, FootstepDataMessage adjustedPoseToPack) {
        boolean snapFailed;
        this.footstepAtSameHeightAsStanceFoot.getPosition().set((FrameTuple2DReadOnly)footstepPoseToAdjust.getPosition());
        this.footstepAtSameHeightAsStanceFoot.setZ(stanceFootPose.getZ());
        this.footstepAtSameHeightAsStanceFoot.getOrientation().set(footstepPoseToAdjust.getOrientation());
        PlanarRegionFootstepSnapper.resetStepConstrainingRegionMessage(this.stepConstraint);
        if (this.steppableRegionsProvider == null || this.steppableRegionsProvider.getSteppableRegions().isEmpty()) {
            adjustedPoseToPack.getLocation().set((Tuple3DReadOnly)this.footstepAtSameHeightAsStanceFoot.getPosition());
            adjustedPoseToPack.getOrientation().set((QuaternionReadOnly)this.footstepAtSameHeightAsStanceFoot.getOrientation());
            return true;
        }
        this.adjustedFootstepPose.set(this.footstepAtSameHeightAsStanceFoot);
        ConvexPolygon2DReadOnly footPolygonToWiggle = (ConvexPolygon2DReadOnly)this.footPolygons.get((Enum)footSide);
        if (this.planarRegionSnapVisualizer != null) {
            this.planarRegionSnapVisualizer.recordUnadjustedFootstep((FramePose3DReadOnly)this.adjustedFootstepPose, footPolygonToWiggle);
        }
        try {
            if (this.environmentalConstraintParameters.useSimpleSnapping()) {
                this.snapTheFootStraightDown(stanceFootPose, (FramePose3DBasics)this.adjustedFootstepPose, footPolygonToWiggle);
            } else {
                this.snapTheFootToRegionsAndWiggleInside(stanceFootPose, (FramePose3DBasics)this.adjustedFootstepPose, footPolygonToWiggle);
            }
            snapFailed = this.adjustedFootstepPose.containsNaN();
        }
        catch (RuntimeException e) {
            snapFailed = false;
        }
        if (snapFailed) {
            adjustedPoseToPack.getLocation().set((Tuple3DReadOnly)this.footstepAtSameHeightAsStanceFoot.getPosition());
            adjustedPoseToPack.getOrientation().set((QuaternionReadOnly)this.footstepAtSameHeightAsStanceFoot.getOrientation());
        } else {
            adjustedPoseToPack.getLocation().set((Tuple3DReadOnly)this.adjustedFootstepPose.getPosition());
            adjustedPoseToPack.getOrientation().set((QuaternionReadOnly)this.adjustedFootstepPose.getOrientation());
            if (this.stepConstraint.getRegionOrigin().size() > 0) {
                adjustedPoseToPack.getStepConstraints().set(this.stepConstraint);
            }
        }
        return !snapFailed;
    }

    private void snapTheFootStraightDown(FramePose3DReadOnly stanceFootPose, FramePose3DBasics solePoseToSnap, ConvexPolygon2DReadOnly footStepPolygonInSoleFrame) {
        this.soleFrameBeforeSnapping.setPoseAndUpdate((FramePose3DReadOnly)solePoseToSnap);
        this.unsnappedFootstepPolygonInWorld.set((Vertex2DSupplier)footStepPolygonInSoleFrame);
        this.unsnappedFootstepPolygonInWorld.applyTransform((Transform)solePoseToSnap, false);
        this.snapFootExtrapolatingHeight(stanceFootPose, (ConvexPolygon2DReadOnly)this.unsnappedFootstepPolygonInWorld, solePoseToSnap);
    }

    private void snapTheFootToRegionsAndWiggleInside(FramePose3DReadOnly stanceFootPose, FramePose3DBasics solePose, ConvexPolygon2DReadOnly footStepPolygonInSoleFrame) {
        this.soleFrameBeforeSnapping.setPoseAndUpdate((FramePose3DReadOnly)solePose);
        this.unsnappedFootstepPolygonInWorld.set((Vertex2DSupplier)footStepPolygonInSoleFrame);
        this.unsnappedFootstepPolygonInWorld.applyTransform((Transform)solePose, false);
        if (this.isFootPolygonOnBoundaryOfPlanarRegions((ConvexPolygon2DReadOnly)this.unsnappedFootstepPolygonInWorld)) {
            this.snapFootExtrapolatingHeight(stanceFootPose, (ConvexPolygon2DReadOnly)this.unsnappedFootstepPolygonInWorld, solePose);
            if (this.planarRegionSnapVisualizer != null) {
                this.planarRegionSnapVisualizer.recordFootPoseIsOnBoundary();
            }
            return;
        }
        this.findRegionsUnderFoot((ConvexPolygon2DReadOnly)this.unsnappedFootstepPolygonInWorld, this.regionsIntersectingFoothold);
        this.snapFootstepToPlanarRegionEnvironment(this.regionsIntersectingFoothold, solePose, this.regionToSnapTo, (ConvexPolygon2DReadOnly)this.unsnappedFootstepPolygonInWorld);
        this.wiggleFootstepIntoPlanarRegion(solePose, footStepPolygonInSoleFrame, this.regionToSnapTo);
        if (!solePose.containsNaN()) {
            StepConstraintListConverter.convertPlanarRegionToStepConstraintRegion((PlanarRegion)this.regionToSnapTo, (StepConstraintRegion)this.constraintRegion);
            StepConstraintMessageConverter.convertToStepConstraintsListMessage(this.constraintRegionList, (StepConstraintsListMessage)this.stepConstraint);
        }
    }

    private void snapFootExtrapolatingHeight(FramePose3DReadOnly stanceFootPose, ConvexPolygon2DReadOnly footPolygonInWorld, FramePose3DBasics solePoseToSnap) {
        this.findRegionsUnderFoot(footPolygonInWorld, this.regionsIntersectingFoothold);
        FixedFramePoint3DBasics footPosition = solePoseToSnap.getPosition();
        if (this.regionsIntersectingFoothold.size() == 0) {
            this.regionToSnapTo.set(PlanarRegionFootstepSnapper.findClosestPlanarRegionToPointByProjectionOntoXYPlane(footPosition.getX(), footPosition.getY(), this.steppableRegionsProvider.getSteppableRegions()));
            double distanceToStance = stanceFootPose.getPosition().distanceXY((FramePoint3DReadOnly)footPosition);
            boolean shouldUseProprioceptiveEstimate = distanceToStance < this.environmentalConstraintParameters.getDistanceFromStanceToTrustEnvironment();
            shouldUseProprioceptiveEstimate |= distanceToStance < this.regionToSnapTo.distanceToPointByProjectionOntoXYPlane(footPosition.getX(), footPosition.getY());
            solePoseToSnap.setZ(this.footstepAtSameHeightAsStanceFoot.getZ());
        } else {
            if (!this.snapper.snapPolygonToRegionsUnderFoot(footPolygonInWorld, this.regionsIntersectingFoothold, Double.POSITIVE_INFINITY, this.regionToSnapTo, this.snapTransform)) {
                throw new RuntimeException("Snapping failed");
            }
            footPosition.setZ(0.0);
            footPosition.applyTransform((Transform)this.snapTransform);
        }
        if (this.planarRegionSnapVisualizer != null) {
            this.snapTransform.setToZero();
            this.snapTransform.getTranslation().setZ(footPosition.getZ());
            this.planarRegionSnapVisualizer.recordSnapTransform(this.regionsIntersectingFoothold.size(), (RigidBodyTransformReadOnly)this.snapTransform, this.regionToSnapTo);
        }
    }

    private void findRegionsUnderFoot(ConvexPolygon2DReadOnly footPolygonInWorld, List<PlanarRegion> regionsUnderFootToPack) {
        regionsUnderFootToPack.clear();
        this.intersectAreas.reset();
        PlanarRegionTools.findPlanarRegionsIntersectingPolygon((ConvexPolygon2DReadOnly)footPolygonInWorld, this.steppableRegionsProvider.getSteppableRegions(), regionsUnderFootToPack, (TDoubleArrayList)this.intersectAreas);
        for (int idx = this.regionsIntersectingFoothold.size() - 1; idx >= 0; --idx) {
            if (!(this.intersectAreas.get(idx) < this.environmentalConstraintParameters.getSmallIntersectionAreaToFilter())) continue;
            regionsUnderFootToPack.remove(idx);
        }
    }

    private void snapFootstepToPlanarRegionEnvironment(List<PlanarRegion> regionsIntersectingFoothold, FramePose3DBasics solePoseToSnap, PlanarRegion regionToPack, ConvexPolygon2DReadOnly footPolygonInWorld) {
        if (!this.snapper.snapPolygonToRegionsUnderFoot(footPolygonInWorld, regionsIntersectingFoothold, Double.POSITIVE_INFINITY, regionToPack, this.snapTransform)) {
            throw new RuntimeException("Snapping failed");
        }
        solePoseToSnap.setZ(0.0);
        solePoseToSnap.applyTransform((Transform)this.snapTransform);
        if (this.planarRegionSnapVisualizer != null) {
            this.planarRegionSnapVisualizer.recordSnapTransform(regionsIntersectingFoothold.size(), (RigidBodyTransformReadOnly)this.snapTransform, regionToPack);
        }
    }

    private void wiggleFootstepIntoPlanarRegion(FramePose3DBasics solePoseToWiggle, ConvexPolygon2DReadOnly footStepPolygonInSoleFrame, PlanarRegion planarRegionToWiggleInside) {
        if (!this.wiggleParameters.shouldPerformOptimization()) {
            return;
        }
        this.planarRegionFrame.setPoseAndUpdate(planarRegionToWiggleInside.getTransformToWorld());
        this.soleFrameAfterSnapAndBeforeWiggle.setPoseAndUpdate((FramePose3DReadOnly)solePoseToWiggle);
        this.soleFrameAfterSnapAndBeforeWiggle.getTransformToDesiredFrame(this.transformFromSoleToRegion, (ReferenceFrame)this.planarRegionFrame);
        this.footPolygonInRegionFrame.set((Vertex2DSupplier)footStepPolygonInSoleFrame);
        this.footPolygonInRegionFrame.applyTransform((Transform)this.transformFromSoleToRegion, false);
        this.stepConstraintOptimizer.reset();
        RigidBodyTransformReadOnly wiggleTransform = this.stepConstraintOptimizer.findConstraintTransform((ConvexPolygon2DReadOnly)this.footPolygonInRegionFrame, (ConvexPolygon2DReadOnly)planarRegionToWiggleInside.getConvexHull(), this.wiggleParameters);
        if (wiggleTransform == null) {
            solePoseToWiggle.setToNaN();
        } else {
            solePoseToWiggle.changeFrame((ReferenceFrame)this.planarRegionFrame);
            solePoseToWiggle.applyTransform((Transform)wiggleTransform);
            this.footPolygonInRegionFrame.applyTransform((Transform)wiggleTransform);
            solePoseToWiggle.changeFrame(ReferenceFrame.getWorldFrame());
            if (this.planarRegionSnapVisualizer != null) {
                this.planarRegionSnapVisualizer.recordWiggleTransform(this.stepConstraintOptimizer.getIterationsInOptimization(), wiggleTransform);
            }
        }
    }

    private void cropFootholdToMatchRegion(FramePose3DReadOnly solePose, ConvexPolygon2DReadOnly footStepPolygonInSoleFrame, PlanarRegion planarRegionSnappedTo, ConvexPolygon2DBasics snappedFootholdInSoleToPack) {
        if (this.wiggleParameters.shouldPerformOptimization() && this.wiggleParameters.getDesiredDistanceInside() < 0.0) {
            this.soleFrameAfterWiggle.setPoseAndUpdate(solePose);
            this.soleFrameAfterWiggle.getTransformToDesiredFrame(this.transformFromSoleToRegion, (ReferenceFrame)this.planarRegionFrame);
            this.footPolygonInRegionFrame.set((Vertex2DSupplier)footStepPolygonInSoleFrame);
            this.footPolygonInRegionFrame.applyTransform((Transform)this.transformFromSoleToRegion, false);
            this.convexPolygonTools.computeIntersectionOfPolygons((ConvexPolygon2DReadOnly)planarRegionSnappedTo.getConvexHull(), (ConvexPolygon2DReadOnly)this.footPolygonInRegionFrame, snappedFootholdInSoleToPack);
            snappedFootholdInSoleToPack.applyInverseTransform((Transform)this.transformFromSoleToRegion, false);
        } else {
            snappedFootholdInSoleToPack.set((Vertex2DSupplier)footStepPolygonInSoleFrame);
        }
    }

    private boolean isFootPolygonOnBoundaryOfPlanarRegions(ConvexPolygon2DReadOnly footPolygonInWorld) {
        for (int i = 0; i < footPolygonInWorld.getNumberOfVertices(); ++i) {
            if (this.steppableRegionsProvider.getConvexHullOfAllRegions().isPointInside(footPolygonInWorld.getVertex(i))) continue;
            return true;
        }
        return false;
    }

    private static PlanarRegion findClosestPlanarRegionToPointByProjectionOntoXYPlane(double x, double y, List<PlanarRegion> regionsToCheck) {
        double shortestDistanceToPoint = Double.POSITIVE_INFINITY;
        PlanarRegion closestRegion = null;
        for (int i = 0; i < regionsToCheck.size(); ++i) {
            PlanarRegion candidateRegion = regionsToCheck.get(i);
            double distanceToRegion = candidateRegion.distanceToPointByProjectionOntoXYPlane(x, y);
            if (!(distanceToRegion < shortestDistanceToPoint)) continue;
            shortestDistanceToPoint = distanceToRegion;
            closestRegion = candidateRegion;
        }
        return closestRegion;
    }

    private PlanarRegion findHighestPlanarRegionAtPoint(double x, double y, List<PlanarRegion> regionsBelowPoint) {
        double highestPoint = Double.NEGATIVE_INFINITY;
        PlanarRegion highestRegion = null;
        for (int i = 0; i < regionsBelowPoint.size(); ++i) {
            PlanarRegion candidateRegion = regionsBelowPoint.get(i);
            double heightAtPoint = candidateRegion.getPlaneZGivenXY(x, y);
            if (!(heightAtPoint > highestPoint)) continue;
            highestPoint = heightAtPoint;
            highestRegion = candidateRegion;
        }
        return highestRegion;
    }

    private static void resetStepConstrainingRegionMessage(StepConstraintsListMessage constraintsListMessage) {
        constraintsListMessage.setSequenceId(-1L);
        constraintsListMessage.getRegionNormal().clear();
        constraintsListMessage.getRegionOrigin().clear();
        constraintsListMessage.getRegionOrientation().clear();
        constraintsListMessage.getConcaveHullsSize().reset();
        constraintsListMessage.getNumberOfHolesInRegion().reset();
        constraintsListMessage.getHolePolygonsSize().reset();
        constraintsListMessage.getVertexBuffer().clear();
    }
}

