/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.simulationStarter;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.fxml.FXMLLoader;
import us.ihmc.avatar.DRCStartingLocation;
import us.ihmc.avatar.networkProcessor.HumanoidNetworkProcessorParameters;
import us.ihmc.avatar.simulationStarter.SimulationSelectorStageController;
import us.ihmc.avatar.simulationStarter.SimulationStarterInterface;
import us.ihmc.commons.FormattingTools;
import us.ihmc.javaFXToolkit.JavaFXTools;
import us.ihmc.robotEnvironmentAwareness.LidarBasedREAStandaloneLauncher;
import us.ihmc.robotEnvironmentAwareness.RemoteLidarBasedREAUILauncher;
import us.ihmc.tools.processManagement.JavaProcessSpawner;

public abstract class DRCSimulationTools {
    public static <T extends DRCStartingLocation, Enum> void startSimulationWithGraphicSelector(SimulationStarterInterface simulationStarter, Class<?> operatorInterfaceClass, String[] operatorInterfaceArgs, T ... possibleStartingLocations) {
        ArrayList<Modules> modulesToStart = new ArrayList<Modules>();
        DRCStartingLocation startingLocation = DRCSimulationTools.showSelectorWithStartingLocation(modulesToStart, possibleStartingLocations);
        DRCSimulationTools.startSimulation(simulationStarter, operatorInterfaceClass, operatorInterfaceArgs, startingLocation, modulesToStart);
    }

    public static <T extends DRCStartingLocation, Enum> void startSimulation(SimulationStarterInterface simulationStarter, Class<?> operatorInterfaceClass, String[] operatorInterfaceArgs, DRCStartingLocation startingLocation, List<Modules> modulesToStart) {
        if (startingLocation != null) {
            simulationStarter.setStartingLocation(startingLocation);
        }
        if (modulesToStart.isEmpty()) {
            return;
        }
        boolean automaticallyStartSimulation = true;
        HumanoidNetworkProcessorParameters networkProcessorParameters = DRCSimulationTools.createNetworkProcessorParameters(modulesToStart);
        if (modulesToStart.contains((Object)Modules.SIMULATION)) {
            simulationStarter.startSimulation(networkProcessorParameters, automaticallyStartSimulation);
        }
        if (modulesToStart.contains((Object)Modules.OPERATOR_INTERFACE)) {
            if (modulesToStart.contains((Object)Modules.SIMULATION)) {
                DRCSimulationTools.startOpertorInterfaceUsingProcessSpawner(operatorInterfaceClass, operatorInterfaceArgs);
            } else {
                DRCSimulationTools.startOpertorInterface(operatorInterfaceClass, operatorInterfaceArgs);
            }
        }
        if (modulesToStart.contains((Object)Modules.BEHAVIOR_VISUALIZER)) {
            simulationStarter.startBehaviorVisualizer();
        }
        boolean startREAModule = modulesToStart.contains((Object)Modules.REA_MODULE);
        boolean startREAUI = modulesToStart.contains((Object)Modules.REA_UI);
        if (startREAModule && startREAUI) {
            new JavaProcessSpawner(true, true).spawn(LidarBasedREAStandaloneLauncher.class);
        } else if (startREAUI) {
            new JavaProcessSpawner(true, true).spawn(RemoteLidarBasedREAUILauncher.class);
        }
    }

    public static HumanoidNetworkProcessorParameters createNetworkProcessorParameters(List<Modules> modulesToStart) {
        HumanoidNetworkProcessorParameters networkProcessorParameters;
        if (modulesToStart.contains((Object)Modules.NETWORK_PROCESSOR)) {
            networkProcessorParameters = new HumanoidNetworkProcessorParameters();
            networkProcessorParameters.setUseSensorModule(modulesToStart.contains((Object)Modules.SENSOR_MODULE));
            networkProcessorParameters.setUseZeroPoseRobotConfigurationPublisherModule(modulesToStart.contains((Object)Modules.ZERO_POSE_PRODUCER));
            networkProcessorParameters.setUseROSModule(modulesToStart.contains((Object)Modules.ROS_MODULE));
            networkProcessorParameters.setUseKinematicsToolboxModule(modulesToStart.contains((Object)Modules.KINEMATICS_TOOLBOX));
            networkProcessorParameters.setUseKinematicsStreamingToolboxModule(modulesToStart.contains((Object)Modules.KINEMATICS_TOOLBOX));
            networkProcessorParameters.setUseFootstepPlanningToolboxModule(modulesToStart.contains((Object)Modules.FOOTSTEP_PLANNING_TOOLBOX));
            networkProcessorParameters.setUseWholeBodyTrajectoryToolboxModule(modulesToStart.contains((Object)Modules.WHOLE_BODY_TRAJECTORY_TOOLBOX));
            networkProcessorParameters.setUseKinematicsPlanningToolboxModule(modulesToStart.contains((Object)Modules.KINEMATICS_PLANNING_TOOLBOX));
            boolean startREAModule = modulesToStart.contains((Object)Modules.REA_MODULE) && !modulesToStart.contains((Object)Modules.REA_UI);
            networkProcessorParameters.setUseRobotEnvironmentAwerenessModule(startREAModule);
            networkProcessorParameters.setUseBipedalSupportPlanarRegionPublisherModule(modulesToStart.contains((Object)Modules.SENSOR_MODULE));
            networkProcessorParameters.setUseFiducialDetectorToolboxModule(modulesToStart.contains((Object)Modules.FIDUCIAL_DETECTOR));
            networkProcessorParameters.setUseObjectDetectorToolboxModule(modulesToStart.contains((Object)Modules.OBJECT_DETECTOR));
            networkProcessorParameters.setUseDirectionalControlModule(modulesToStart.contains((Object)Modules.DIRECTIONAL_CONTROL_TOOLBOX));
        } else {
            networkProcessorParameters = null;
        }
        return networkProcessorParameters;
    }

    public static <T extends DRCStartingLocation, Enum> DRCStartingLocation showSelectorWithStartingLocation(List<Modules> modulesToStartListToPack, T ... possibleStartingLocations) {
        Platform.setImplicitExit((boolean)false);
        JavaFXTools.startup();
        return (DRCStartingLocation)JavaFXTools.runAndWait(() -> {
            SimulationSelectorStageController controller;
            try {
                FXMLLoader loader = new FXMLLoader(DRCSimulationTools.class.getResource("SimulationSelectorStage.fxml"));
                loader.load();
                controller = (SimulationSelectorStageController)loader.getController();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            DRCStartingLocation startingLocation = controller.showAndWait(possibleStartingLocations);
            modulesToStartListToPack.addAll(controller.getModulesToStart());
            return startingLocation;
        });
    }

    public static void startOpertorInterfaceUsingProcessSpawner(Class<?> operatorInterfaceClass, String[] operatorInterfaceArgs) {
        JavaProcessSpawner spawner = new JavaProcessSpawner(true, true);
        if (operatorInterfaceClass == null) {
            return;
        }
        spawner.spawn(operatorInterfaceClass, operatorInterfaceArgs);
    }

    public static void startOpertorInterface(Class<?> operatorInterfaceClass, String[] operatorInterfaceArgs) {
        if (operatorInterfaceClass == null) {
            return;
        }
        try {
            Method mainMethod = operatorInterfaceClass.getDeclaredMethod("main", String[].class);
            Object[] args = new Object[]{operatorInterfaceArgs};
            mainMethod.invoke(null, args);
        }
        catch (NoSuchMethodException | SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static enum Modules {
        SIMULATION,
        OPERATOR_INTERFACE,
        BEHAVIOR_VISUALIZER,
        NETWORK_PROCESSOR,
        SENSOR_MODULE,
        ROS_MODULE,
        ZERO_POSE_PRODUCER,
        REA_MODULE,
        REA_UI,
        KINEMATICS_TOOLBOX,
        KINEMATICS_PLANNING_TOOLBOX,
        FOOTSTEP_PLANNING_TOOLBOX,
        WHOLE_BODY_TRAJECTORY_TOOLBOX,
        FIDUCIAL_DETECTOR,
        OBJECT_DETECTOR,
        DIRECTIONAL_CONTROL_TOOLBOX;


        public String getPropertyNameForEnable() {
            return "enable" + FormattingTools.underscoredToCamelCase((String)this.toString(), (boolean)true);
        }

        public String getPropertyNameForSelected() {
            return "select" + FormattingTools.underscoredToCamelCase((String)this.toString(), (boolean)true);
        }

        public boolean isAlwaysEnabled() {
            return this == SIMULATION || this == OPERATOR_INTERFACE || this == BEHAVIOR_VISUALIZER;
        }

        public boolean getDefaultValueForEnable() {
            return true;
        }

        public boolean getDefaultValueForSelected() {
            return this == SIMULATION || this == OPERATOR_INTERFACE || this == NETWORK_PROCESSOR || this == SENSOR_MODULE;
        }

        public String getName() {
            return FormattingTools.underscoredToCamelCase((String)this.toString(), (boolean)true);
        }
    }
}

