/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.simulationStarter;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import us.ihmc.avatar.DRCLidar;
import us.ihmc.avatar.DRCStartingLocation;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.drcRobot.SimulatedDRCRobotTimeProvider;
import us.ihmc.avatar.factory.AvatarSimulation;
import us.ihmc.avatar.factory.AvatarSimulationFactory;
import us.ihmc.avatar.initialSetup.DRCGuiInitialSetup;
import us.ihmc.avatar.initialSetup.DRCSCSInitialSetup;
import us.ihmc.avatar.initialSetup.OffsetAndYawRobotInitialSetup;
import us.ihmc.avatar.initialSetup.RobotInitialSetup;
import us.ihmc.avatar.networkProcessor.HumanoidNetworkProcessor;
import us.ihmc.avatar.networkProcessor.HumanoidNetworkProcessorParameters;
import us.ihmc.avatar.scriptCommandGenerator.ScriptBasedControllerCommandGenerator;
import us.ihmc.avatar.simulationStarter.SimulationStarterInterface;
import us.ihmc.commonWalkingControlModules.capturePoint.splitFractionCalculation.SplitFractionCalculatorParametersReadOnly;
import us.ihmc.commonWalkingControlModules.configurations.HighLevelControllerParameters;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commonWalkingControlModules.desiredFootStep.footstepGenerator.FootstepAdjustment;
import us.ihmc.commonWalkingControlModules.desiredFootStep.footstepGenerator.HeadingAndVelocityEvaluationScriptParameters;
import us.ihmc.commonWalkingControlModules.desiredFootStep.footstepGenerator.HeightMapBasedFootstepAdjustment;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning.CoPTrajectoryParameters;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.ContactableBodiesFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.ControllerStateTransitionFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.HighLevelControllerStateFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.HighLevelHumanoidControllerFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.plugin.HighLevelHumanoidControllerPluginFactory;
import us.ihmc.commonWalkingControlModules.momentumBasedController.HighLevelHumanoidControllerToolbox;
import us.ihmc.communication.controllerAPI.command.Command;
import us.ihmc.communication.net.LocalObjectCommunicator;
import us.ihmc.communication.net.ObjectCommunicator;
import us.ihmc.communication.producers.VideoDataServer;
import us.ihmc.communication.producers.VideoDataServerImageCallback;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.graphicsDescription.image.ImageCallback;
import us.ihmc.humanoidRobotics.communication.packets.dataobjects.HighLevelControllerName;
import us.ihmc.humanoidRobotics.communication.producers.RawVideoDataServer;
import us.ihmc.humanoidRobotics.communication.subscribers.PelvisPoseCorrectionCommunicatorInterface;
import us.ihmc.jMonkeyEngineToolkit.Graphics3DAdapter;
import us.ihmc.jMonkeyEngineToolkit.GroundProfile3D;
import us.ihmc.jMonkeyEngineToolkit.camera.CameraConfiguration;
import us.ihmc.log.LogTools;
import us.ihmc.robotDataVisualizer.logger.BehaviorVisualizer;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotics.controllers.ControllerFailureListener;
import us.ihmc.robotics.partNames.HumanoidJointNameMap;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.ros2.ROS2NodeBuilder;
import us.ihmc.ros2.RealtimeROS2Node;
import us.ihmc.sensorProcessing.parameters.AvatarRobotCameraParameters;
import us.ihmc.sensorProcessing.parameters.AvatarRobotLidarParameters;
import us.ihmc.sensorProcessing.parameters.HumanoidRobotSensorInformation;
import us.ihmc.simulationConstructionSetTools.util.HumanoidFloatingRootJointRobot;
import us.ihmc.simulationConstructionSetTools.util.environments.CommonAvatarEnvironmentInterface;
import us.ihmc.simulationconstructionset.FloatingRootJointRobot;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.tools.TimestampProvider;
import us.ihmc.tools.processManagement.JavaProcessSpawner;
import us.ihmc.wholeBodyController.RobotContactPointParameters;

public class DRCSimulationStarter
implements SimulationStarterInterface {
    private static final String IHMC_SIMULATION_STARTER_NODE_NAME = "ihmc_simulation_starter";
    private final DRCRobotModel robotModel;
    private final CommonAvatarEnvironmentInterface environment;
    private final DRCSCSInitialSetup scsInitialSetup;
    private DRCGuiInitialSetup guiInitialSetup;
    private RobotInitialSetup<HumanoidFloatingRootJointRobot> robotInitialSetup;
    private HumanoidFloatingRootJointRobot sdfRobot;
    private HighLevelHumanoidControllerFactory controllerFactory;
    private AvatarSimulation avatarSimulation;
    protected HumanoidNetworkProcessor networkProcessor;
    private SimulationConstructionSet simulationConstructionSet;
    private ScriptBasedControllerCommandGenerator scriptBasedControllerCommandGenerator;
    private boolean createSCSSimulatedSensors;
    private boolean logToFile = false;
    private boolean addFootstepMessageGenerator = false;
    private boolean useHeadingAndVelocityScript = false;
    private boolean cheatWithGroundHeightAtForFootstep = false;
    private boolean createYoVariableServer = false;
    private PelvisPoseCorrectionCommunicatorInterface externalPelvisCorrectorSubscriber;
    private HeadingAndVelocityEvaluationScriptParameters walkingScriptParameters;
    private Consumer<HumanoidFloatingRootJointRobot> robotGraphicsMutator;
    private RealtimeROS2Node realtimeROS2Node;
    private LocalObjectCommunicator scsSensorOutputPacketCommunicator;
    private boolean setupControllerNetworkSubscriber = true;
    private final HighLevelControllerParameters highLevelControllerParameters;
    private final WalkingControllerParameters walkingControllerParameters;
    private final CoPTrajectoryParameters copTrajectoryParameters;
    private final SplitFractionCalculatorParametersReadOnly splitFractionParameters;
    private final RobotContactPointParameters<RobotSide> contactPointParameters;
    private final Point3D scsCameraPosition = new Point3D(6.0, -2.0, 4.5);
    private final Point3D scsCameraFix = new Point3D(-0.44, -0.17, 0.75);
    private HighLevelControllerName initialStateEnum = HighLevelControllerName.WALKING;
    private final List<HighLevelControllerStateFactory> highLevelControllerFactories = new ArrayList<HighLevelControllerStateFactory>();
    private final List<ControllerStateTransitionFactory<HighLevelControllerName>> controllerTransitionFactories = new ArrayList<ControllerStateTransitionFactory<HighLevelControllerName>>();
    private final ArrayList<ControllerFailureListener> controllerFailureListeners = new ArrayList();
    private final List<HighLevelHumanoidControllerPluginFactory> highLevelControllerPluginFactories = new ArrayList<HighLevelHumanoidControllerPluginFactory>();
    private final ConcurrentLinkedQueue<Command<?, ?>> controllerCommands = new ConcurrentLinkedQueue();
    private boolean alreadyCreatedCommunicator = false;

    public DRCSimulationStarter(DRCRobotModel robotModel, GroundProfile3D groundProfile3D) {
        this(robotModel, null, groundProfile3D);
    }

    public DRCSimulationStarter(DRCRobotModel robotModel, CommonAvatarEnvironmentInterface environment) {
        this(robotModel, environment, (GroundProfile3D)environment.getTerrainObject3D());
    }

    private DRCSimulationStarter(DRCRobotModel robotModel, CommonAvatarEnvironmentInterface environment, GroundProfile3D groundProfile3D) {
        this.robotModel = robotModel;
        this.environment = environment;
        this.guiInitialSetup = new DRCGuiInitialSetup(false, false);
        this.robotInitialSetup = robotModel.getDefaultRobotInitialSetup(0.0, 0.0);
        this.createSCSSimulatedSensors = true;
        this.scsInitialSetup = new DRCSCSInitialSetup(groundProfile3D, robotModel.getSimulateDT());
        this.scsInitialSetup.setDrawGroundProfile(environment == null);
        this.scsInitialSetup.setInitializeEstimatorToActual(false);
        this.scsInitialSetup.setTimePerRecordTick(robotModel.getControllerDT());
        this.scsInitialSetup.setRunMultiThreaded(true);
        this.highLevelControllerParameters = robotModel.getHighLevelControllerParameters();
        this.walkingControllerParameters = robotModel.getWalkingControllerParameters();
        this.copTrajectoryParameters = robotModel.getCoPTrajectoryParameters();
        this.splitFractionParameters = robotModel.getSplitFractionCalculatorParameters();
        this.contactPointParameters = robotModel.getContactPointParameters();
    }

    public CommonAvatarEnvironmentInterface getEnvironment() {
        return this.environment;
    }

    public void setInitialStateEnum(HighLevelControllerName initialStateEnum) {
        this.checkIfSimulationIsAlreadyCreated();
        this.initialStateEnum = initialStateEnum;
    }

    public void registerHighLevelControllerState(HighLevelControllerStateFactory controllerFactory) {
        this.checkIfSimulationIsAlreadyCreated();
        this.highLevelControllerFactories.add(controllerFactory);
    }

    public void registerControllerStateTransition(ControllerStateTransitionFactory<HighLevelControllerName> controllerStateTransitionFactory) {
        this.checkIfSimulationIsAlreadyCreated();
        this.controllerTransitionFactories.add(controllerStateTransitionFactory);
    }

    public void registerHighLevelControllerPlugin(HighLevelHumanoidControllerPluginFactory pluginFactory) {
        this.checkIfSimulationIsAlreadyCreated();
        this.highLevelControllerPluginFactories.add(pluginFactory);
    }

    public void disableSCSSimulatedSensors() {
        this.createSCSSimulatedSensors = false;
    }

    public void attachControllerFailureListener(ControllerFailureListener listener) {
        if (this.controllerFactory == null) {
            this.controllerFailureListeners.add(listener);
        } else {
            this.controllerFactory.attachControllerFailureListener(listener);
        }
    }

    public DRCSCSInitialSetup getSCSInitialSetup() {
        return this.scsInitialSetup;
    }

    public DRCGuiInitialSetup getGuiInitialSetup() {
        return this.guiInitialSetup;
    }

    public void setRunMultiThreaded(boolean runMultiThreaded) {
        this.checkIfSimulationIsAlreadyCreated();
        this.scsInitialSetup.setRunMultiThreaded(runMultiThreaded);
    }

    public void setupControllerNetworkSubscriber(boolean setup) {
        this.checkIfSimulationIsAlreadyCreated();
        this.setupControllerNetworkSubscriber = setup;
    }

    public void setUsePerfectSensors(boolean usePerfectSensors) {
        this.checkIfSimulationIsAlreadyCreated();
        this.scsInitialSetup.setUsePerfectSensors(usePerfectSensors);
    }

    public void setInitializeEstimatorToActual(boolean initializeEstimatorToActual) {
        this.checkIfSimulationIsAlreadyCreated();
        this.scsInitialSetup.setInitializeEstimatorToActual(initializeEstimatorToActual);
    }

    public void setExternalPelvisCorrectorSubscriber(PelvisPoseCorrectionCommunicatorInterface externalPelvisCorrectorSubscriber) {
        this.checkIfSimulationIsAlreadyCreated();
        this.externalPelvisCorrectorSubscriber = externalPelvisCorrectorSubscriber;
    }

    public void setRobotGraphicsMutator(Consumer<HumanoidFloatingRootJointRobot> robotGraphicsMutator) {
        this.checkIfSimulationIsAlreadyCreated();
        this.robotGraphicsMutator = robotGraphicsMutator;
    }

    public void setGuiInitialSetup(DRCGuiInitialSetup guiInitialSetup) {
        this.checkIfSimulationIsAlreadyCreated();
        this.guiInitialSetup = guiInitialSetup;
    }

    public void setCreateYoVariableServer(boolean createYoVariableServer) {
        this.checkIfSimulationIsAlreadyCreated();
        this.createYoVariableServer = createYoVariableServer;
    }

    public void setRobotInitialSetup(RobotInitialSetup<HumanoidFloatingRootJointRobot> robotInitialSetup) {
        this.checkIfSimulationIsAlreadyCreated();
        this.robotInitialSetup = robotInitialSetup;
    }

    public void setLogToFile(boolean logToFile) {
        this.logToFile = logToFile;
    }

    @Override
    public void setStartingLocation(DRCStartingLocation startingLocation) {
        this.checkIfSimulationIsAlreadyCreated();
        this.setStartingLocationOffset(startingLocation.getStartingLocationOffset());
    }

    public void setStartingLocationOffset(OffsetAndYawRobotInitialSetup startingLocationOffset) {
        this.checkIfSimulationIsAlreadyCreated();
        this.robotInitialSetup.setInitialYaw(startingLocationOffset.getYaw());
        this.robotInitialSetup.setInitialGroundHeight(startingLocationOffset.getGroundHeight());
        this.robotInitialSetup.setOffset((Tuple3DReadOnly)startingLocationOffset.getAdditionalOffset());
    }

    public void setStartingLocationOffset(Tuple3DReadOnly robotInitialPosition, double yaw) {
        this.checkIfSimulationIsAlreadyCreated();
        this.setStartingLocationOffset(new OffsetAndYawRobotInitialSetup(robotInitialPosition, yaw));
    }

    public void setSCSCameraPosition(double positionX, double positionY, double positionZ) {
        this.checkIfSimulationIsAlreadyCreated();
        this.scsCameraPosition.set(positionX, positionY, positionZ);
    }

    public void setSCSCameraFix(double fixX, double fixY, double fixZ) {
        this.checkIfSimulationIsAlreadyCreated();
        this.scsCameraFix.set(fixX, fixY, fixZ);
    }

    private void createControllerCommunicator() {
        if (this.alreadyCreatedCommunicator) {
            return;
        }
        this.alreadyCreatedCommunicator = true;
        this.realtimeROS2Node = new ROS2NodeBuilder().buildRealtime(IHMC_SIMULATION_STARTER_NODE_NAME);
    }

    @Override
    public void startBehaviorVisualizer() {
        JavaProcessSpawner spawner = new JavaProcessSpawner(true, true);
        spawner.spawn(BehaviorVisualizer.class);
    }

    @Override
    public void startSimulation(HumanoidNetworkProcessorParameters networkParameters, boolean automaticallySimulate) {
        this.createSimulation(networkParameters, true, automaticallySimulate);
    }

    public void createSimulation(HumanoidNetworkProcessorParameters networkParameters, boolean automaticallySpawnSimulation, boolean automaticallySimulate) {
        if (networkParameters != null || this.setupControllerNetworkSubscriber) {
            this.createControllerCommunicator();
        }
        this.avatarSimulation = this.createAvatarSimulation();
        if (automaticallySpawnSimulation) {
            this.avatarSimulation.start();
        }
        if (this.realtimeROS2Node != null) {
            this.realtimeROS2Node.spin();
        }
        if (automaticallySpawnSimulation && automaticallySimulate) {
            this.avatarSimulation.simulate();
        }
        if (networkParameters != null) {
            this.startNetworkProcessor(networkParameters);
        }
    }

    public ScriptBasedControllerCommandGenerator getScriptBasedControllerCommandGenerator() {
        return this.scriptBasedControllerCommandGenerator;
    }

    public void setFlatGroundWalkingScriptParameters(HeadingAndVelocityEvaluationScriptParameters walkingScriptParameters) {
        this.checkIfSimulationIsAlreadyCreated();
        this.walkingScriptParameters = walkingScriptParameters;
    }

    private AvatarSimulation createAvatarSimulation() {
        int i;
        ContactableBodiesFactory contactableBodiesFactory = new ContactableBodiesFactory();
        ArrayList additionalContactRigidBodyNames = this.contactPointParameters.getAdditionalContactRigidBodyNames();
        ArrayList additionaContactNames = this.contactPointParameters.getAdditionalContactNames();
        ArrayList additionalContactTransforms = this.contactPointParameters.getAdditionalContactTransforms();
        contactableBodiesFactory.setFootContactPoints(this.contactPointParameters.getFootContactPoints());
        contactableBodiesFactory.setToeContactParameters(this.contactPointParameters.getControllerToeContactPoints(), this.contactPointParameters.getControllerToeContactLines());
        for (int i2 = 0; i2 < this.contactPointParameters.getAdditionalContactNames().size(); ++i2) {
            contactableBodiesFactory.addAdditionalContactPoint((String)additionalContactRigidBodyNames.get(i2), (String)additionaContactNames.get(i2), (RigidBodyTransform)additionalContactTransforms.get(i2));
        }
        HumanoidRobotSensorInformation sensorInformation = this.robotModel.getSensorInformation();
        SideDependentList feetForceSensorNames = sensorInformation.getFeetForceSensorNames();
        SideDependentList wristForceSensorNames = sensorInformation.getWristForceSensorNames();
        this.controllerFactory = new HighLevelHumanoidControllerFactory(contactableBodiesFactory, feetForceSensorNames, wristForceSensorNames, this.highLevelControllerParameters, this.walkingControllerParameters, this.copTrajectoryParameters, this.splitFractionParameters);
        this.setupHighLevelStates(this.controllerFactory);
        this.controllerFactory.attachControllerFailureListeners(this.controllerFailureListeners);
        if (this.setupControllerNetworkSubscriber) {
            this.controllerFactory.createControllerNetworkSubscriber(this.robotModel.getSimpleRobotName(), this.realtimeROS2Node);
        }
        for (i = 0; i < this.highLevelControllerFactories.size(); ++i) {
            this.controllerFactory.addCustomControlState(this.highLevelControllerFactories.get(i));
        }
        for (i = 0; i < this.controllerTransitionFactories.size(); ++i) {
            this.controllerFactory.addCustomStateTransition(this.controllerTransitionFactories.get(i));
        }
        for (i = 0; i < this.highLevelControllerPluginFactories.size(); ++i) {
            this.controllerFactory.addControllerPlugin(this.highLevelControllerPluginFactories.get(i));
        }
        this.controllerFactory.setInitialState(this.initialStateEnum);
        this.controllerFactory.createQueuedControllerCommandGenerator(this.controllerCommands);
        this.controllerFactory.createUserDesiredControllerCommandGenerator();
        AvatarSimulationFactory avatarSimulationFactory = new AvatarSimulationFactory();
        if (this.addFootstepMessageGenerator && this.cheatWithGroundHeightAtForFootstep) {
            avatarSimulationFactory.setComponentBasedFootstepDataMessageGeneratorParameters(this.useHeadingAndVelocityScript, (FootstepAdjustment)new HeightMapBasedFootstepAdjustment(this.scsInitialSetup.getHeightMap()), this.walkingScriptParameters);
        } else if (this.addFootstepMessageGenerator) {
            avatarSimulationFactory.setComponentBasedFootstepDataMessageGeneratorParameters(this.useHeadingAndVelocityScript, this.walkingScriptParameters);
        }
        avatarSimulationFactory.setRobotModel(this.robotModel);
        avatarSimulationFactory.setShapeCollisionSettings(this.robotModel.getShapeCollisionSettings());
        avatarSimulationFactory.setHighLevelHumanoidControllerFactory(this.controllerFactory);
        avatarSimulationFactory.setCommonAvatarEnvironment(this.environment);
        avatarSimulationFactory.setRobotInitialSetup(this.robotInitialSetup);
        avatarSimulationFactory.setSCSInitialSetup(this.scsInitialSetup);
        avatarSimulationFactory.setGuiInitialSetup(this.guiInitialSetup);
        avatarSimulationFactory.setRealtimeROS2Node(this.realtimeROS2Node);
        avatarSimulationFactory.setCreateYoVariableServer(this.createYoVariableServer);
        avatarSimulationFactory.setLogToFile(this.logToFile);
        if (this.externalPelvisCorrectorSubscriber != null) {
            avatarSimulationFactory.setExternalPelvisCorrectorSubscriber(this.externalPelvisCorrectorSubscriber);
        }
        if (this.robotGraphicsMutator != null) {
            avatarSimulationFactory.setRobotGraphicsMutator(this.robotGraphicsMutator);
        }
        AvatarSimulation avatarSimulation = avatarSimulationFactory.createAvatarSimulation();
        HighLevelHumanoidControllerToolbox highLevelHumanoidControllerToolbox = this.controllerFactory.getHighLevelHumanoidControllerToolbox();
        FullHumanoidRobotModel fullRobotModel = highLevelHumanoidControllerToolbox.getFullRobotModel();
        this.scriptBasedControllerCommandGenerator = new ScriptBasedControllerCommandGenerator(this.controllerCommands, fullRobotModel);
        this.simulationConstructionSet = avatarSimulation.getSimulationConstructionSet();
        this.sdfRobot = avatarSimulation.getHumanoidFloatingRootJointRobot();
        this.simulationConstructionSet.setCameraPosition(this.scsCameraPosition.getX(), this.scsCameraPosition.getY(), this.scsCameraPosition.getZ());
        this.simulationConstructionSet.setCameraFix(this.scsCameraFix.getX(), this.scsCameraFix.getY(), this.scsCameraFix.getZ());
        return avatarSimulation;
    }

    private void checkIfSimulationIsAlreadyCreated() {
        if (this.avatarSimulation != null) {
            throw new RuntimeException("Too bad - you are late. Try again.");
        }
    }

    public void setupHighLevelStates(HighLevelHumanoidControllerFactory controllerFactory) {
        controllerFactory.useDefaultDoNothingControlState();
        controllerFactory.useDefaultWalkingControlState();
        controllerFactory.addRequestableTransition(HighLevelControllerName.DO_NOTHING_BEHAVIOR, HighLevelControllerName.WALKING);
        controllerFactory.addRequestableTransition(HighLevelControllerName.WALKING, HighLevelControllerName.DO_NOTHING_BEHAVIOR);
    }

    public ConcurrentLinkedQueue<Command<?, ?>> getQueuedControllerCommands() {
        return this.controllerCommands;
    }

    public LocalObjectCommunicator createSimulatedSensorsPacketCommunicator() {
        this.scsSensorOutputPacketCommunicator = new LocalObjectCommunicator();
        if (this.createSCSSimulatedSensors) {
            HumanoidRobotSensorInformation sensorInformation = this.robotModel.getSensorInformation();
            HumanoidJointNameMap jointMap = this.robotModel.getJointMap();
            SimulatedDRCRobotTimeProvider timeStampProvider = this.avatarSimulation.getSimulatedRobotTimeProvider();
            HumanoidFloatingRootJointRobot robot = this.avatarSimulation.getHumanoidFloatingRootJointRobot();
            Graphics3DAdapter graphics3dAdapter = this.simulationConstructionSet.getGraphics3dAdapter();
            LogTools.info((String)"Streaming SCS Video");
            AvatarRobotCameraParameters cameraParameters = sensorInformation.getCameraParameters(0);
            if (cameraParameters != null) {
                String cameraName = cameraParameters.getSensorNameInSdf();
                int width = this.sdfRobot.getCameraMount(cameraName).getImageWidth();
                int height = this.sdfRobot.getCameraMount(cameraName).getImageHeight();
                CameraConfiguration cameraConfiguration = new CameraConfiguration(cameraName);
                cameraConfiguration.setCameraMount(cameraName);
                int framesPerSecond = 25;
                RawVideoDataServer drcRenderedSceneVideoHandler = new RawVideoDataServer((ObjectCommunicator)this.scsSensorOutputPacketCommunicator);
                this.simulationConstructionSet.startStreamingVideoData(cameraConfiguration, width, height, (ImageCallback)new VideoDataServerImageCallback((VideoDataServer)drcRenderedSceneVideoHandler), (TimestampProvider)timeStampProvider, framesPerSecond);
            }
            if (sensorInformation.getLidarParameters() != null) {
                for (AvatarRobotLidarParameters lidarParams : sensorInformation.getLidarParameters()) {
                    DRCLidar.setupDRCRobotLidar((FloatingRootJointRobot)robot, graphics3dAdapter, this.scsSensorOutputPacketCommunicator, jointMap, lidarParams, (TimestampProvider)timeStampProvider, true);
                }
            }
        }
        return this.scsSensorOutputPacketCommunicator;
    }

    protected void startNetworkProcessor(HumanoidNetworkProcessorParameters networkModuleParams) {
        if (networkModuleParams.isUseROSModule() || networkModuleParams.isUseSensorModule()) {
            LocalObjectCommunicator simulatedSensorCommunicator = this.createSimulatedSensorsPacketCommunicator();
            networkModuleParams.setSimulatedSensorCommunicator(simulatedSensorCommunicator);
        }
        this.networkProcessor = HumanoidNetworkProcessor.newFromParameters(this.robotModel, networkModuleParams);
        this.networkProcessor.start();
    }

    public AvatarSimulation getAvatarSimulation() {
        return this.avatarSimulation;
    }

    public SimulationConstructionSet getSimulationConstructionSet() {
        return this.simulationConstructionSet;
    }

    public HumanoidFloatingRootJointRobot getSDFRobot() {
        return this.sdfRobot;
    }

    public LocalObjectCommunicator getSimulatedSensorsPacketCommunicator() {
        if (this.scsSensorOutputPacketCommunicator == null) {
            this.createSimulatedSensorsPacketCommunicator();
        }
        return this.scsSensorOutputPacketCommunicator;
    }

    @Override
    public void close() {
        if (this.realtimeROS2Node != null) {
            this.realtimeROS2Node.destroy();
            this.realtimeROS2Node = null;
        }
        if (this.networkProcessor != null) {
            this.networkProcessor.closeAndDispose();
            this.networkProcessor = null;
        }
    }

    public void addFootstepMessageGenerator(boolean useHeadingAndVelocityScript, boolean cheatWithGroundHeightAtForFootstep) {
        this.addFootstepMessageGenerator = true;
        this.useHeadingAndVelocityScript = useHeadingAndVelocityScript;
        this.cheatWithGroundHeightAtForFootstep = cheatWithGroundHeightAtForFootstep;
    }
}

