/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.sensors.realsense;

import controller_msgs.msg.dds.StereoVisionPointCloudMessage;
import java.net.URI;
import perception_msgs.msg.dds.VideoPacket;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.sensors.realsense.MapSensePlanarRegionROS1Bridge;
import us.ihmc.avatar.sensors.realsense.RealsensePointCloudROS1Bridge;
import us.ihmc.avatar.sensors.realsense.RealsenseVideoROS1Bridge;
import us.ihmc.communication.PerceptionAPI;
import us.ihmc.communication.configuration.NetworkParameters;
import us.ihmc.log.LogTools;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2NodeBuilder;
import us.ihmc.ros2.ROS2Topic;
import us.ihmc.utilities.ros.RosMainNode;

public class RealsenseROS1Bridge {
    private final RealsenseVideoROS1Bridge d435VideoBridge;
    private final RealsenseVideoROS1Bridge l515VideoBridge;
    private final RealsensePointCloudROS1Bridge d435PointCloudBridge;
    private final RealsensePointCloudROS1Bridge l515PointCloudBridge;
    private final MapSensePlanarRegionROS1Bridge l515PlanarRegionBridge;

    public RealsenseROS1Bridge(DRCRobotModel robotModel) {
        URI masterURI = NetworkParameters.getROSURI();
        LogTools.info((String)"Connecting to ROS 1 master URI: {}", (Object)masterURI);
        RosMainNode ros1Node = new RosMainNode(masterURI, "ImagePublisher", true);
        ROS2Node ros2Node = new ROS2NodeBuilder().build("imagePublisherNode");
        this.d435VideoBridge = new RealsenseVideoROS1Bridge(ros1Node, ros2Node, "/camera/color/image_raw", (ROS2Topic<VideoPacket>)PerceptionAPI.D435_VIDEO, 25.0);
        this.l515VideoBridge = new RealsenseVideoROS1Bridge(ros1Node, ros2Node, "/chest_l515/color/image_raw", (ROS2Topic<VideoPacket>)PerceptionAPI.L515_VIDEO, 25.0);
        this.d435PointCloudBridge = new RealsensePointCloudROS1Bridge(robotModel, ros1Node, ros2Node, "/camera/depth/color/points", (ROS2Topic<StereoVisionPointCloudMessage>)PerceptionAPI.D435_POINT_CLOUD);
        this.l515PointCloudBridge = new RealsensePointCloudROS1Bridge(robotModel, ros1Node, ros2Node, "/chest_l515/depth/color/points", (ROS2Topic<StereoVisionPointCloudMessage>)PerceptionAPI.L515_POINT_CLOUD);
        this.l515PlanarRegionBridge = new MapSensePlanarRegionROS1Bridge(robotModel, ros1Node, ros2Node);
        ros1Node.execute();
    }
}

