/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.sensors.realsense;

import controller_msgs.msg.dds.StereoVisionPointCloudMessage;
import java.util.ArrayList;
import sensor_msgs.PointCloud2;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.drcRobot.ROS2SyncedRobotModel;
import us.ihmc.commons.UnitConversions;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.log.LogTools;
import us.ihmc.perception.depthData.PointCloudData;
import us.ihmc.robotEnvironmentAwareness.communication.converters.PointCloudMessageTools;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2Publisher;
import us.ihmc.ros2.ROS2Topic;
import us.ihmc.tools.Timer;
import us.ihmc.tools.thread.MissingThreadTools;
import us.ihmc.tools.thread.ResettableExceptionHandlingExecutorService;
import us.ihmc.utilities.ros.RosMainNode;
import us.ihmc.utilities.ros.subscriber.AbstractRosTopicSubscriber;
import us.ihmc.utilities.ros.subscriber.RosTopicSubscriberInterface;

public class RealsensePointCloudROS1Bridge
extends AbstractRosTopicSubscriber<PointCloud2> {
    private static final int MAX_POINTS = 5000;
    private static final double MIN_PUBLISH_PERIOD = UnitConversions.hertzToSeconds((double)10.0);
    private final ROS2Publisher<StereoVisionPointCloudMessage> publisher;
    private final ROS2SyncedRobotModel syncedRobot;
    private final FramePose3D tempSensorFramePose = new FramePose3D();
    private final Timer throttleTimer = new Timer();
    private final ResettableExceptionHandlingExecutorService executor = MissingThreadTools.newSingleThreadExecutor((String)((Object)((Object)this)).getClass().getSimpleName(), (boolean)true, (int)1);

    public RealsensePointCloudROS1Bridge(DRCRobotModel robotModel, RosMainNode ros1Node, ROS2Node ros2Node, String ros1InputTopic, ROS2Topic<StereoVisionPointCloudMessage> ros2OutputTopic) {
        super("sensor_msgs/PointCloud2");
        this.syncedRobot = new ROS2SyncedRobotModel(robotModel, ros2Node);
        LogTools.info((String)"Subscribing ROS 1: {}", (Object)ros1InputTopic);
        ros1Node.attachSubscriber(ros1InputTopic, (RosTopicSubscriberInterface)this);
        LogTools.info((String)"Publishing ROS 2: {}", (Object)ros2OutputTopic.getName());
        this.publisher = ros2Node.createPublisher(ros2OutputTopic);
    }

    public void onNewMessage(PointCloud2 ros1PointCloud) {
        this.executor.clearQueueAndExecute(() -> this.waitThenAct(ros1PointCloud));
    }

    private void waitThenAct(PointCloud2 ros1PointCloud) {
        this.throttleTimer.sleepUntilExpiration(MIN_PUBLISH_PERIOD);
        this.throttleTimer.reset();
        this.compute(ros1PointCloud);
    }

    private void compute(PointCloud2 ros1PointCloud) {
        try {
            boolean hasColors = true;
            PointCloudData pointCloudData = new PointCloudData(ros1PointCloud, 5000, hasColors);
            pointCloudData.flipToZUp();
            this.syncedRobot.update();
            pointCloudData.applyTransform(this.syncedRobot.getReferenceFrames().getSteppingCameraFrame().getTransformToWorldFrame());
            ArrayList<Point3D> pointCloud = new ArrayList<Point3D>();
            for (int i = 0; i < pointCloudData.getNumberOfPoints(); ++i) {
                pointCloud.add(new Point3D((Tuple3DReadOnly)pointCloudData.getPointCloud()[i]));
            }
            this.tempSensorFramePose.setToZero(this.syncedRobot.getReferenceFrames().getSteppingCameraFrame());
            this.tempSensorFramePose.changeFrame(ReferenceFrame.getWorldFrame());
            StereoVisionPointCloudMessage message = PointCloudMessageTools.toStereoVisionPointCloudMessage(pointCloud, (Pose3DReadOnly)this.tempSensorFramePose);
            this.publisher.publish((Object)message);
        }
        catch (Exception e) {
            LogTools.error((String)e.getMessage());
            e.printStackTrace();
        }
    }
}

