/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.sensors.realsense;

import java.util.function.Consumer;
import map_sense.RawGPUPlanarRegionList;
import org.apache.commons.lang3.tuple.Pair;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.sensors.realsense.DelayFixedPlanarRegionsSubscription;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.robotics.geometry.PlanarRegionsList;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.utilities.ros.RosNodeInterface;
import us.ihmc.utilities.ros.subscriber.AbstractRosTopicSubscriber;
import us.ihmc.utilities.ros.subscriber.RosTopicSubscriberInterface;

public class MapsenseTools {
    private static final RigidBodyTransform zForwardXRightToZUpXForward = new RigidBodyTransform();

    public static DelayFixedPlanarRegionsSubscription subscribeToPlanarRegionsWithDelayCompensation(ROS2Node ros2Node, DRCRobotModel robotModel, Consumer<Pair<Long, PlanarRegionsList>> callback) {
        return MapsenseTools.subscribeToPlanarRegionsWithDelayCompensation(ros2Node, robotModel, "/mapsense/planar_regions", callback);
    }

    public static DelayFixedPlanarRegionsSubscription subscribeToPlanarRegionsWithDelayCompensation(ROS2Node ros2Node, DRCRobotModel robotModel, String topic, Consumer<Pair<Long, PlanarRegionsList>> callback) {
        return new DelayFixedPlanarRegionsSubscription(ros2Node, robotModel, topic, callback);
    }

    public static AbstractRosTopicSubscriber<RawGPUPlanarRegionList> createROS1Callback(RosNodeInterface ros1Node, Consumer<RawGPUPlanarRegionList> callback) {
        return MapsenseTools.createROS1Callback("/mapsense/planar_regions", ros1Node, callback);
    }

    public static AbstractRosTopicSubscriber<RawGPUPlanarRegionList> createROS1Callback(String topic, RosNodeInterface ros1Node, final Consumer<RawGPUPlanarRegionList> callback) {
        AbstractRosTopicSubscriber<RawGPUPlanarRegionList> subscriber = new AbstractRosTopicSubscriber<RawGPUPlanarRegionList>("map_sense/RawGPUPlanarRegionList"){

            public void onNewMessage(RawGPUPlanarRegionList rawGPUPlanarRegionList) {
                callback.accept(rawGPUPlanarRegionList);
            }
        };
        ros1Node.attachSubscriber(topic, (RosTopicSubscriberInterface)subscriber);
        return subscriber;
    }

    public static RigidBodyTransformReadOnly getTransformFromCameraToWorld() {
        return zForwardXRightToZUpXForward;
    }

    static {
        zForwardXRightToZUpXForward.appendPitchRotation(1.5707963267948966);
        zForwardXRightToZUpXForward.appendYawRotation(-1.5707963267948966);
    }
}

